/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceUseDatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="customMetadataProfileRow", children={"customMetadataProfileEnabled", "customMetadataProfile"}), @FormFieldRow(name="exportDocIdsRow", children={"exportDocIdsEnabled", "productionSetName"}), @FormFieldRow(name="trimBodyTextRow", children={"trimBodyTextEnabled", "trimBodyTextAt"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"})})
@OperationMetadata(alias=OperationAlias.LOAD_ITEMS_TO_BRAINSPACE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "BRAINSPACE"}), @OperationTag(name="Category", value={"EXPORT", "LOAD"})})
@OperationParameter(label="queryRetrieveFailedItems", parameter="tag:\"{last_failed_items_tag_name}\"")
@OperationLicenseModule(module=ModuleType.BRAINSPACE_REVIEW)
public class BrainspaceLoadItemsOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    public static final String METADATA_FIELD_ID = "Nuix GUID";
    @FormField(required=false)
    public String scope = "path-guid:{last_evidence_guid} AND flag:audited";
    @FormField
    public boolean exportStandardMetadata = true;
    @FormField
    public boolean customMetadataProfileEnabled = false;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES, enableOn={@OnField(name="customMetadataProfileEnabled")})
    @ExcludeFromPrintableOptions
    public String customMetadataProfile = "Default";
    @FormField(enableOn={@OnField(name="customMetadataProfileEnabled")})
    @ExcludeFromPrintableOptions
    public String customMetadataMappingFile = "";
    @FormField
    public boolean exportDocIdsEnabled = false;
    @FormField(enableOn={@OnField(name="exportDocIdsEnabled")})
    @ExcludeFromPrintableOptions
    public String productionSetName = "{last_production_set_name}";
    @FormField
    public boolean trimBodyTextEnabled = true;
    @FormField(min=100.0, enableOn={@OnField(name="trimBodyTextEnabled")}, positionLabel=@PositionLabel(right="characters"))
    @ExcludeFromPrintableOptions
    public int trimBodyTextAt = 1000000;
    @FormField
    @ExcludeFromPrintableOptions
    public Boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|Load to Brainspace";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public Boolean untagSuccessfulItems = true;

    public boolean getDisplayMetadataProfile() {
        return this.customMetadataProfileEnabled;
    }

    public boolean getDisplayCustomMetadataMappingFile() {
        return this.customMetadataProfileEnabled;
    }

    public boolean getDisplayProductionSetName() {
        return this.exportDocIdsEnabled;
    }

    public boolean getDisplayTrimBodyTextAt() {
        return this.trimBodyTextEnabled;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("BrainspaceLoadItems.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.LOAD_ITEMS_TO_BRAINSPACE;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedBrainspaceDatasetOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof BrainspaceUseDatasetOperation) {
                detectedBrainspaceDatasetOperation = true;
                break;
            }
            if (o == this) break;
        }
        if (!detectedBrainspaceDatasetOperation) {
            prerequisites.add(this.iu.getString("BrainspaceBuildDataset.Prerequisites.MissingBrainspaceDatasetOperation"));
        }
        if (this.customMetadataProfileEnabled && this.customMetadataMappingFile.trim().length() == 0) {
            prerequisites.add(this.iu.getString("BrainspaceBuildDataset.Prerequisites.MissingCustomMappingFile"));
        }
        if (!this.exportStandardMetadata && !this.customMetadataProfileEnabled) {
            prerequisites.add(this.iu.getString("BrainspaceBuildDataset.Prerequisites.NoMetadataOptionSelected"));
        }
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && this.executionContext.nuixVersion.compareTo(new Version("8.0.0")) < 0) {
            prerequisites.add(this.iu.getString("BrainspaceLoadItems.Prerequisites.UpdateNuixVersionEightOrNewer"));
        }
        return prerequisites;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return this.scope;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OTHER_EXPORT;
    }

    @Override
    public Activity getActivity() {
        return Activity.EXPORT;
    }
}

