/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceLoadItemsOperation;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceFieldMapping;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceFieldsMapping;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceRestClient;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProductionSet;
import org.apache.commons.io.IOUtils;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class BrainspaceLoadItemsOperationImplementation
extends BrainspaceLoadItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceLoadItemsOperation.class);
    private static final String METADATA_FIELD_DOCUMENT_ID = "Document ID";
    private static final String MAP_TO_EXACT = "EXACT";
    private static final String METADATA_FIELD_BODY = "Body";
    private static final String METADATA_FIELD_TEXT_TRIMMED = "Text Trimmed";
    private static final String MAP_TO_BODY = "BODY_TEXT";
    private static final String METADATA_FIELD_PARENT = "Nuix Visible Parent GUID";
    public static final String METADATA_FIELD_ID = "Nuix GUID";
    private final Set<String> uniqueMapToFields = new HashSet<String>(Arrays.asList("FROM", "TO", "CC", "BCC", "ID", "PARENT_ID", "FILE_SIZE"));
    private transient String stageName;
    private transient double percentageComplete;
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient int stageCount;
    private transient int stageId;
    private transient int maxItemsCount = 100000;
    private transient long maxTotalBodySize = 100000000L;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient Path standardMetadataProfilePath = null;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                try {
                    Integer wfn_brainspace_load_max_items_count = this.executionContext.evalIntParameter("{wfn_brainspace_load_max_items_count}", this);
                    if (wfn_brainspace_load_max_items_count != null) {
                        this.maxItemsCount = wfn_brainspace_load_max_items_count;
                        LOGGER.info("Brainspace load max items count: " + this.maxItemsCount);
                    }
                }
                catch (ParameterException wfn_brainspace_load_max_items_count) {
                    // empty catch block
                }
                try {
                    Long wfn_brainspace_load_max_text_size = this.executionContext.evalLongParameter("{wfn_brainspace_load_max_text_size}", this);
                    if (wfn_brainspace_load_max_text_size != null) {
                        this.maxTotalBodySize = wfn_brainspace_load_max_text_size;
                        LOGGER.info("Brainspace load max body size: " + this.maxTotalBodySize);
                    }
                }
                catch (ParameterException wfn_brainspace_load_max_text_size) {
                    // empty catch block
                }
                String apiUrl = this.executionContext.evalParameters("{wfn_brainspace_api_url}", this);
                String apiKey = this.executionContext.evalProtectedParameter("{wfn_brainspace_api_key_protected}");
                String certificateFingerprint = this.executionContext.evalParameters("{wfn_brainspace_api_certificate_fingerprint}", this);
                Integer datasetId = this.executionContext.evalIntParameter("{brainspace_dataset_id}", this);
                BrainspaceRestClient brainspaceRestClient = new BrainspaceRestClient(apiUrl, apiKey, certificateFingerprint);
                this.percentageComplete = 0.01;
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.addExecutionLog(this.iu.getFormattedString("BrainspaceLoadItems.Log.ScopeQuery", (Object)this.scope));
                this.stageId = 0;
                this.stageCount = 1;
                List<Object> standardMetadataItems = null;
                List customMetadataItems = null;
                BrainspaceFieldsMapping standardMapping = null;
                BrainspaceFieldsMapping customMapping = null;
                ArrayList<MetadataItem> metadataItems = null;
                BrainspaceFieldsMapping fieldsMapping = null;
                if (this.exportStandardMetadata) {
                    String mappingText;
                    this.addExecutionLog(this.iu.getString("BrainspaceLoadItems.Log.StandardProfile"));
                    String profileName = "Automate-Temp-Brainspace-Export";
                    try (InputStream stream = this.getClass().getResourceAsStream("/profiles/brainspace/metadata.profile");){
                        String profileText = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        this.standardMetadataProfilePath = this.executionContext.nuixCase.getLocation().toPath().resolve("Stores/User Data/Metadata Profiles/" + profileName + ".profile");
                        this.deleteTempMetadataProfile();
                        LOGGER.info("Creating temporary standard metadata profile " + String.valueOf(this.standardMetadataProfilePath));
                        Path profilesFolder = this.standardMetadataProfilePath.getParent();
                        if (!Files.exists(profilesFolder, new LinkOption[0])) {
                            LOGGER.info("Creating folder " + String.valueOf(profilesFolder));
                            try {
                                Files.createDirectories(profilesFolder, new FileAttribute[0]);
                            }
                            catch (IOException ex) {
                                LOGGER.error("Cannot create metadata profiles folder", (Throwable)ex);
                            }
                        }
                        FileUtils.writeToFile((String)profileText, (Path)this.standardMetadataProfilePath);
                    }
                    catch (IOException e) {
                        throw new IOException("Cannot write metadata profile", e);
                    }
                    MetadataProfile metadataProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, profileName);
                    standardMetadataItems = metadataProfile.getMetadata();
                    try (InputStream stream = this.getClass().getResourceAsStream("/profiles/brainspace/fieldmapping.json");){
                        mappingText = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new IOException("Cannot read standard field mapping", e);
                    }
                    standardMapping = (BrainspaceFieldsMapping)SerializationUtils.fromJson((String)mappingText, BrainspaceFieldsMapping.class);
                }
                if (this.customMetadataProfileEnabled) {
                    this.customMetadataProfile = this.executionContext.evalParameters(this.customMetadataProfile, this);
                    this.customMetadataMappingFile = this.executionContext.evalParameters(this.customMetadataMappingFile, this);
                    this.addExecutionLog(this.iu.getFormattedString("BrainspaceLoadItems.Log.CustomProfile", (Object)this.customMetadataProfile));
                    MetadataProfile customNuixMetadataProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.customMetadataProfile);
                    if (customNuixMetadataProfile == null) {
                        // empty if block
                    }
                    customMetadataItems = customNuixMetadataProfile.getMetadata();
                    this.addExecutionLog(this.iu.getFormattedString("BrainspaceLoadItems.Log.CustomMapping", (Object)this.customMetadataMappingFile));
                    customMapping = (BrainspaceFieldsMapping)SerializationUtils.fromJson((String)FileUtils.readFileWithAutodetectEncoding((File)new File(this.customMetadataMappingFile)), BrainspaceFieldsMapping.class);
                }
                if (this.exportStandardMetadata && !this.customMetadataProfileEnabled) {
                    metadataItems = standardMetadataItems;
                    fieldsMapping = standardMapping;
                } else if (this.customMetadataProfileEnabled) {
                    metadataItems = new ArrayList<MetadataItem>();
                    fieldsMapping = new BrainspaceFieldsMapping("Custom Mapping");
                    HashSet<String> customNuixMetadataMappedNames = new HashSet<String>();
                    HashSet<String> customNuixMetadataProfileNames = new HashSet<String>();
                    HashSet<String> customBrainspaceFieldNames = new HashSet<String>();
                    for (Object customMetadataItem : customMetadataItems) {
                        customNuixMetadataProfileNames.add(customMetadataItem.getName());
                    }
                    for (BrainspaceFieldMapping fieldMapping : customMapping.getFields()) {
                        if (fieldMapping == null) continue;
                        if (customNuixMetadataProfileNames.contains(fieldMapping.getName())) {
                            if (this.uniqueMapToFields.contains(fieldMapping.getMapTo())) {
                                customBrainspaceFieldNames.add(fieldMapping.getMapTo());
                            }
                            customNuixMetadataMappedNames.add(fieldMapping.getName());
                            fieldsMapping.getFields().add(fieldMapping);
                            continue;
                        }
                        this.addWarning(this.iu.getFormattedString("BrainspaceLoadItems.Warning.CustomMappingFieldNotInProfile", (Object)fieldMapping.getName()));
                    }
                    for (Object customMetadataItem : customMetadataItems) {
                        if (customNuixMetadataMappedNames.contains(customMetadataItem.getName())) {
                            metadataItems.add((MetadataItem)customMetadataItem);
                            continue;
                        }
                        this.addWarning(this.iu.getFormattedString("BrainspaceLoadItems.Warning.CustomProfileFieldNotInMapping", (Object)customMetadataItem.getName()));
                    }
                    if (this.exportStandardMetadata) {
                        HashSet<String> overwrittenFieldNames = new HashSet<String>();
                        for (BrainspaceFieldMapping brainspaceFieldMapping : standardMapping.getFields()) {
                            if (customNuixMetadataMappedNames.contains(brainspaceFieldMapping.getName())) {
                                LOGGER.info("Skipping standard metadata field " + brainspaceFieldMapping.getName() + " because it is defined in the custom mapping");
                                overwrittenFieldNames.add(brainspaceFieldMapping.getName());
                                continue;
                            }
                            if (customBrainspaceFieldNames.contains(brainspaceFieldMapping.getMapTo())) {
                                LOGGER.info("Skipping standard metadata field " + brainspaceFieldMapping.getName() + " because the map to value " + brainspaceFieldMapping.getMapTo() + " is defined in the custom mapping");
                                overwrittenFieldNames.add(brainspaceFieldMapping.getName());
                                continue;
                            }
                            fieldsMapping.getFields().add(brainspaceFieldMapping);
                        }
                        for (MetadataItem metadataItem : standardMetadataItems) {
                            if (overwrittenFieldNames.contains(metadataItem.getName())) continue;
                            metadataItems.add(metadataItem);
                        }
                    }
                }
                if (this.exportDocIdsEnabled) {
                    fieldsMapping.getFields().add(new BrainspaceFieldMapping(METADATA_FIELD_DOCUMENT_ID, MAP_TO_EXACT, true));
                }
                fieldsMapping.getFields().add(new BrainspaceFieldMapping(METADATA_FIELD_BODY, MAP_TO_BODY));
                if (this.trimBodyTextEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("BrainspaceLoadItems.Log.TrimBodyTextAt", (Object)FormattingUtils.sizeToDisplaySize((long)this.trimBodyTextAt)));
                    fieldsMapping.getFields().add(new BrainspaceFieldMapping(METADATA_FIELD_TEXT_TRIMMED, MAP_TO_EXACT, true));
                }
                this.stageName = this.iu.getString("BrainspaceLoadItems.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("BrainspaceLoadItems.Stage.SearchingForItems"));
                HashSet<String> scopeGuids = new HashSet<String>();
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = scopeItems.size();
                this.countItemsProcessed = new AtomicLong(0L);
                AtomicLong itemsNotInProductionSet = new AtomicLong(0L);
                if (this.countItemsToProcess > 0L) {
                    void var17_33;
                    ArrayList<Map<String, Object>> itemsMetadata = new ArrayList<Map<String, Object>>();
                    AtomicLong totalBodySize = new AtomicLong(0L);
                    this.addExecutionLog(this.iu.getNumeralString("BrainspaceLoadItems.Log.ScopeCount", (long)scopeItems.size()));
                    for (Object item : scopeItems) {
                        scopeGuids.add(item.getGuid());
                    }
                    Object var17_31 = null;
                    if (this.exportDocIdsEnabled) {
                        this.productionSetName = this.executionContext.evalParameters(this.productionSetName, this);
                        this.addExecutionLog(this.iu.getFormattedString("BrainspaceLoadItems.Log.ProductionDocIds", (Object)this.productionSetName));
                        for (ProductionSet candidateProductionSet : this.executionContext.nuixCase.getProductionSets()) {
                            if (!candidateProductionSet.getName().equals(this.productionSetName)) continue;
                            ProductionSet productionSet = candidateProductionSet;
                            LOGGER.info("Got production set " + String.valueOf(candidateProductionSet));
                            break;
                        }
                        if (var17_33 == null) {
                            throw new Exception(this.iu.getFormattedString("General.Exception.ProductionSetNotInCase", (Object)this.productionSetName));
                        }
                    }
                    this.stageName = this.iu.getString("BrainspaceLoadItems.Stage.Exporting");
                    this.addExecutionLog(this.iu.getString("BrainspaceLoadItems.Stage.Loading"));
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)scopeItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                    ArrayList<MetadataItem> finalMetadataItems = metadataItems;
                    void finalProductionSet = var17_33;
                    Parallel.forEachPartitioned((Partitioner)partitioner, arg_0 -> this.lambda$startTriggered$0(finalMetadataItems, scopeGuids, (ProductionSet)finalProductionSet, itemsNotInProductionSet, totalBodySize, itemsMetadata, brainspaceRestClient, datasetId, arg_0), (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    if (itemsMetadata.size() > 0) {
                        this.stageName = this.iu.getString("BrainspaceLoadItems.Stage.Loading");
                        brainspaceRestClient.submitItemsJson(datasetId.intValue(), itemsMetadata);
                    }
                    if (itemsNotInProductionSet.get() > 0L) {
                        this.addWarning(this.iu.getNumeralFormattedString("BrainspaceLoadItems.Warning.NotInProductionSet", itemsNotInProductionSet.get(), (Object)this.productionSetName));
                    }
                    for (int i = 0; i < 60; ++i) {
                        String datasetState = brainspaceRestClient.getDatasetBuildState(datasetId.intValue());
                        LOGGER.info("Dataset state " + datasetState);
                        if (datasetState.equals("INGESTION_COMPLETED")) break;
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Thread.sleep(1000L);
                    }
                    this.addExecutionLog(this.iu.getString("BrainspaceLoadItems.Stage.SettingMapping"));
                    brainspaceRestClient.setFieldsMapping(datasetId.intValue(), fieldsMapping);
                } else {
                    this.addWarning(this.iu.getString("BrainspaceLoadItems.Warning.NoItemsMatchedScopeQuery"));
                }
                this.deleteTempMetadataProfile();
                this.handleFailedItems();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                this.deleteTempMetadataProfile();
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void deleteTempMetadataProfile() {
        if (this.standardMetadataProfilePath != null) {
            LOGGER.info("Deleting " + String.valueOf(this.standardMetadataProfilePath));
            try {
                FileUtils.deleteRecursively((Path)this.standardMetadataProfilePath);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete " + String.valueOf(this.standardMetadataProfilePath), (Throwable)e);
            }
        }
    }

    private void handleFailedItems() throws IOException {
        LOGGER.info("Handling failed items");
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("BrainspaceLoadItems.Warning.Failed", (long)this.failedItems.size()));
        }
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.TaggedFailedItem", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", this.scope);
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (this.itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("BrainspaceLoadItems.Log.UntaggedFailedItem", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.countItemsProcessed != null) {
            stageProgress = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L && this.countItemsProcessed != null) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("BrainspaceLoadItems.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

