/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceUseDatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="waitForPreviousBuildRow", children={"waitForPreviousBuild", "waitForPreviousBuildTimeout"}), @FormFieldRow(name="waitForBuildToCompleteRow", children={"waitForBuildToComplete", "waitForBuildToCompleteTimeout"})})
@OperationMetadata(alias=OperationAlias.BRAINSPACE_BUILD_DATASET, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"BRAINSPACE"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.BRAINSPACE_ADVANCED)
public class BrainspaceManageBuildOperation
extends Operation {
    @FormField
    public boolean waitForPreviousBuild;
    @FormField(min=1.0, enableOn={@OnField(name="waitForPreviousBuild")}, positionLabel=@PositionLabel(right="minutes"))
    @ExcludeFromPrintableOptions
    public int waitForPreviousBuildTimeout;
    @FormField
    public boolean buildDataset;
    @FormField
    public boolean waitForBuildToComplete;
    @FormField(min=1.0, enableOn={@OnField(name="waitForBuildToComplete")}, positionLabel=@PositionLabel(right="minutes"))
    @ExcludeFromPrintableOptions
    public int waitForBuildToCompleteTimeout;

    public boolean getDisplayWaitForPreviousBuildTimeout() {
        return this.waitForPreviousBuild;
    }

    public boolean getDisplayWaitForBuildToCompleteTimeout() {
        return this.waitForBuildToComplete;
    }

    public BrainspaceManageBuildOperation() {
        this.requiresCase = false;
        this.buildDataset = true;
        this.waitForPreviousBuild = true;
        this.waitForPreviousBuildTimeout = 60;
        this.waitForBuildToComplete = true;
        this.waitForBuildToCompleteTimeout = 60;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("BrainspaceBuildDataset.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.BRAINSPACE_BUILD_DATASET;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedBrainspaceDatasetOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof BrainspaceUseDatasetOperation) {
                detectedBrainspaceDatasetOperation = true;
                break;
            }
            if (o == this) break;
        }
        if (!detectedBrainspaceDatasetOperation) {
            prerequisites.add(this.iu.getString("BrainspaceBuildDataset.Prerequisites.MissingBrainspaceDatasetOperation"));
        }
        return prerequisites;
    }
}

