/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceRetrieveMetadataOperation;
import com.nuix.automate.workflow.core.execution.options.usebrainspacedataset.BrainspaceScopeType;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceNotebookDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceObject;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceRestClient;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceSearchResponse;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTagDefinition;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class BrainspaceRetrieveMetadataOperationImplementation
extends BrainspaceRetrieveMetadataOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceRetrieveMetadataOperation.class);
    private transient String stageName;
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient int stageCount;
    private transient int stageId;
    private transient Set<String> classifierFieldNames;
    private transient Set<String> numericFieldNames;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ArrayList<String> matchedFieldsSorted;
                ArrayList<String> nonMatchedFieldNames;
                long nuixItemsWithoutMatchCount;
                BrainspaceSearchResponse response;
                AtomicLong brainspaceItemsWithoutNuixGuidCount = new AtomicLong(0L);
                AtomicLong brainspaceItemsWithNoMatchingNuixGuidCount = new AtomicLong(0L);
                AtomicLong brainspaceItemsWithMatchingNuixGuidCount = new AtomicLong(0L);
                AtomicLong failedNuixItems = new AtomicLong(0L);
                AtomicLong matchedItemsCount = new AtomicLong(0L);
                ConcurrentHashMap.KeySetView matchedFields = ConcurrentHashMap.newKeySet();
                ConcurrentHashMap<CallSite, AtomicLong> taggedItemsCounts = new ConcurrentHashMap<CallSite, AtomicLong>();
                this.classifierFieldNames = new HashSet<String>();
                this.numericFieldNames = new HashSet<String>();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.matchingItemsTagName = this.executionContext.evalParameters(this.matchingItemsTagName, this);
                this.retrieveBrainspaceTagsAddPrefixName = this.executionContext.evalParameters(this.retrieveBrainspaceTagsAddPrefixName, this);
                String apiUrl = this.executionContext.evalParameters("{wfn_brainspace_api_url}", this);
                String apiKey = this.executionContext.evalProtectedParameter("{wfn_brainspace_api_key_protected}");
                String certificateFingerprint = this.executionContext.evalParameters("{wfn_brainspace_api_certificate_fingerprint}", this);
                Integer datasetId = this.executionContext.evalIntParameter("{brainspace_dataset_id}", this);
                BrainspaceRestClient brainspaceRestClient = new BrainspaceRestClient(apiUrl, apiKey, certificateFingerprint);
                Map datasetDetails = brainspaceRestClient.getDatasetDetails(datasetId.intValue());
                Object facetsObject = datasetDetails.get("facets");
                if (facetsObject != null) {
                    List facets = (List)facetsObject;
                    for (Object facet : facets) {
                        String fieldName = facet.get("name").toString();
                        if (!"NumericField".equals(facet.get("type"))) continue;
                        this.numericFieldNames.add(fieldName);
                        if (fieldName.contains("score")) {
                            LOGGER.info("Detected Classifier field " + fieldName);
                            this.classifierFieldNames.add(fieldName);
                            continue;
                        }
                        LOGGER.info("Detected NumericField " + fieldName);
                    }
                }
                this.addExecutionLog(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Log.BrainspaceScope", (Object)LocalizableEnumUtils.getLocalizedString((Enum)this.brainspaceScopeType)));
                Object brainspaceQuery = "((*:*))";
                if (this.brainspaceScopeType.equals((Object)BrainspaceScopeType.NOTEBOOK)) {
                    try {
                        BrainspaceObject brainspaceNotebook = brainspaceRestClient.getNotebook(datasetId.intValue(), this.notebookIdentifierType, this.notebookIdentifier);
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_id}", String.valueOf(brainspaceNotebook.getId()))));
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_name}", brainspaceNotebook.getName())));
                        this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.NotebookId", (Object)brainspaceNotebook.getId()));
                        this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.NotebookName", (Object)brainspaceNotebook.getName()));
                        brainspaceQuery = "((notebook:\"" + brainspaceNotebook.getId() + "\"))";
                    }
                    catch (BrainspaceNotebookDoesNotExistException e) {
                        throw new IOException(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Error.CannotFindNotebook", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.notebookIdentifierType), this.notebookIdentifier}));
                    }
                }
                HashSet<String> fields = new HashSet<String>();
                if (this.retrieveBrainspaceFields) {
                    for (Object[] field : this.brainspaceFields) {
                        Object fieldString;
                        if (field[0] == null || ((String)(fieldString = field[0].toString().trim())).length() <= 0) continue;
                        fields.add((String)fieldString);
                    }
                }
                if (this.retrieveBrainspaceClassifierScores) {
                    fields.addAll(this.classifierFieldNames);
                }
                fields.add("Nuix GUID");
                ArrayList<Long> tagIds = new ArrayList<Long>();
                if (this.retrieveBrainspaceTags) {
                    List<BrainspaceTagDefinition> tags = brainspaceRestClient.getAllChoiceTags(datasetId.intValue());
                    for (BrainspaceObject brainspaceObject : tags) {
                        tagIds.add(brainspaceObject.getId());
                    }
                }
                this.stageCount = 2;
                this.stageId = 0;
                this.countItemsProcessed = new AtomicLong(0L);
                this.stageName = this.iu.getString("BrainspaceRetrieveMetadataOperation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Log.Scope", (Object)this.scope));
                LOGGER.info("Searching for items to update: " + this.scope);
                Set itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = itemsToUpdate.size();
                LOGGER.info("Got " + this.countItemsToProcess + " items");
                this.addExecutionLog(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Log.ScopeCount", this.countItemsToProcess));
                HashMap<String, Item> nuixItems = new HashMap<String, Item>();
                for (Item item : itemsToUpdate) {
                    nuixItems.put(item.getGuid(), item);
                    this.countItemsProcessed.incrementAndGet();
                }
                this.countItemsProcessed.set(0L);
                this.countItemsToProcess = 0L;
                ++this.stageId;
                this.stageName = this.iu.getString("BrainspaceRetrieveMetadataOperation.Stage.RetrievingMetadata");
                long l = 0L;
                do {
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    response = brainspaceRestClient.searchForDocuments(datasetId.intValue(), (String)brainspaceQuery, fields, tagIds, l);
                    if (this.countItemsToProcess == 0L) {
                        this.addExecutionLog(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Log.BrainspaceScopeCount", response.getTotalResults()));
                    }
                    this.countItemsToProcess = response.getTotalResults();
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(response.getResults(), ItemsUtils.getPartitionerChunkSize(10, this));
                    ConcurrentHashMap.KeySetView matchedItems = ConcurrentHashMap.newKeySet();
                    Iterator matchedItemsTags = new ConcurrentHashMap();
                    try {
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            while (iterator.hasNext()) {
                                boolean itemFailed = false;
                                this.countItemsProcessed.incrementAndGet();
                                String nuixGuid = "";
                                try {
                                    Map itemResponse = (Map)iterator.next();
                                    Map itemFields = (Map)itemResponse.get("fields");
                                    Object guid = itemFields.get("Nuix GUID");
                                    if (guid == null) {
                                        brainspaceItemsWithoutNuixGuidCount.incrementAndGet();
                                        continue;
                                    }
                                    Item nuixItem = (Item)nuixItems.get(guid.toString());
                                    if (nuixItem == null) {
                                        brainspaceItemsWithNoMatchingNuixGuidCount.incrementAndGet();
                                        LOGGER.warn("Cannot match Brainspace item GUID " + String.valueOf(guid) + " to a Nuix item in scope");
                                        continue;
                                    }
                                    matchedItemsCount.incrementAndGet();
                                    nuixGuid = nuixItem.getGuid();
                                    brainspaceItemsWithMatchingNuixGuidCount.incrementAndGet();
                                    if (this.retrieveBrainspaceFields || this.retrieveBrainspaceClassifierScores) {
                                        try {
                                            ItemCustomMetadataMap itemCustomMetadata = nuixItem.getCustomMetadata();
                                            for (Map.Entry entry : itemFields.entrySet()) {
                                                String fieldName = (String)entry.getKey();
                                                matchedFields.add(fieldName);
                                                if (fieldName.equals("Nuix GUID")) continue;
                                                Object value = entry.getValue();
                                                Object valueString = "";
                                                if (value instanceof Collection) {
                                                    Collection valueCollection = (Collection)value;
                                                    Iterator iterator2 = valueCollection.iterator();
                                                    while (iterator2.hasNext()) {
                                                        if (((String)valueString).length() > 0) {
                                                            valueString = (String)valueString + "; ";
                                                        }
                                                        String elementValue = String.valueOf(iterator2.next());
                                                        valueString = (String)valueString + elementValue;
                                                    }
                                                } else {
                                                    valueString = String.valueOf(value);
                                                }
                                                if (this.numericFieldNames.contains(fieldName)) {
                                                    try {
                                                        double doubleValue = Double.parseDouble((String)valueString);
                                                        itemCustomMetadata.putFloat(fieldName, (Object)doubleValue);
                                                    }
                                                    catch (NumberFormatException e) {
                                                        itemCustomMetadata.put((Object)fieldName, valueString);
                                                    }
                                                    continue;
                                                }
                                                itemCustomMetadata.put((Object)fieldName, valueString);
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Cannot handle Brainspace fields", (Throwable)e);
                                            itemFailed = true;
                                        }
                                    }
                                    try {
                                        Map tagChoiceSummaries;
                                        if (this.retrieveBrainspaceTags && (tagChoiceSummaries = (Map)itemResponse.get("tagChoiceSummaries")) != null) {
                                            long totalResults = ((Number)tagChoiceSummaries.get("totalResults")).longValue();
                                            long count = ((Number)tagChoiceSummaries.get("count")).longValue();
                                            if (count > 0L) {
                                                List<Map<String, Object>> itemTags = (List<Map<String, Object>>)tagChoiceSummaries.get("results");
                                                if (count < totalResults) {
                                                    LOGGER.info("Item has " + totalResults + " tags but only " + count + " were received initially");
                                                    itemTags = brainspaceRestClient.getAllDocumentTags(datasetId.intValue(), nuixGuid);
                                                }
                                                for (Map map : itemTags) {
                                                    ConcurrentLinkedQueue itemsList;
                                                    Object tagName = String.valueOf(map.get("tagName"));
                                                    tagName = ((String)tagName).replace("|", "_");
                                                    Object tagValue = String.valueOf(map.get("choiceValue"));
                                                    String tagNameValue = (String)tagName + "|" + (String)(tagValue = ((String)tagValue).replace("|", "_"));
                                                    ConcurrentLinkedQueue<Item> existingItemsList = matchedItemsTags.putIfAbsent(tagNameValue, itemsList = new ConcurrentLinkedQueue());
                                                    if (existingItemsList == null) {
                                                        existingItemsList = itemsList;
                                                    }
                                                    existingItemsList.add(nuixItem);
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Cannot handle Brainspace tags", (Throwable)e);
                                        itemFailed = true;
                                    }
                                    if (this.tagMatchingItems) {
                                        matchedItems.add(nuixItem);
                                    }
                                    if (!itemFailed) continue;
                                    throw new Exception("Item encountered errors");
                                }
                                catch (Exception e) {
                                    failedNuixItems.incrementAndGet();
                                    LOGGER.error("Cannot handle item " + nuixGuid, (Throwable)e);
                                }
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                        LOGGER.info("Tagging " + matchedItems.size() + " matching items");
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.matchingItemsTagName, matchedItems);
                        if (!this.retrieveBrainspaceTags) continue;
                        for (String tagName : matchedItemsTags.keySet()) {
                            ConcurrentLinkedQueue items = (ConcurrentLinkedQueue)matchedItemsTags.get(tagName);
                            String effectiveTagName = this.retrieveBrainspaceTagsAddPrefixName + tagName;
                            LOGGER.info("Tagging " + items.size() + " item(s) as " + effectiveTagName);
                            this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.retrieveBrainspaceTagsAddPrefixName + tagName, (Collection)items);
                            AtomicLong taggedItemsCount = (AtomicLong)taggedItemsCounts.get(effectiveTagName);
                            if (taggedItemsCount == null) {
                                taggedItemsCount = new AtomicLong(0L);
                                taggedItemsCounts.put((CallSite)((Object)effectiveTagName), taggedItemsCount);
                            }
                            taggedItemsCount.addAndGet(items.size());
                        }
                    }
                    catch (WorkflowExecutionStopRequested e) {
                        this.trackStopped();
                        return;
                    }
                } while ((l += response.getCount()) < response.getTotalResults());
                if (failedNuixItems.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Error.FailedItems", failedNuixItems.get()));
                }
                if (brainspaceItemsWithoutNuixGuidCount.get() > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("BrainspaceRetrieveMetadataOperation.Error.BrainspaceItemsWithNoGuid", brainspaceItemsWithoutNuixGuidCount.get(), (Object)"Nuix GUID"));
                }
                if (brainspaceItemsWithNoMatchingNuixGuidCount.get() > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("BrainspaceRetrieveMetadataOperation.Error.BrainspaceItemsWithNoMatchingGuid", brainspaceItemsWithNoMatchingNuixGuidCount.get(), (Object)"Nuix GUID"));
                }
                if ((nuixItemsWithoutMatchCount = (long)nuixItems.size() - matchedItemsCount.get()) > 0L) {
                    this.addWarning(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Error.NuixItemsNotMatched", nuixItemsWithoutMatchCount));
                }
                this.addExecutionLog(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Log.MatchedItems", matchedItemsCount.get()));
                if (this.tagMatchingItems) {
                    this.addExecutionLog(this.iu.getNumeralFormattedString("BrainspaceRetrieveMetadataOperation.Log.TaggedMatchedItems", matchedItemsCount.get(), (Object)this.matchingItemsTagName));
                }
                if (this.retrieveBrainspaceTags) {
                    ArrayList tags = new ArrayList();
                    tags.addAll(taggedItemsCounts.keySet());
                    tags.sort(String::compareToIgnoreCase);
                    for (String tag : tags) {
                        this.addExecutionLog(this.iu.getNumeralFormattedString("BrainspaceRetrieveMetadataOperation.Log.TaggedMatchedItems", ((AtomicLong)taggedItemsCounts.get(tag)).get(), (Object)tag));
                    }
                }
                if (this.retrieveBrainspaceFields) {
                    nonMatchedFieldNames = new ArrayList<String>();
                    for (String fieldName : fields) {
                        if (matchedFields.contains(fieldName)) continue;
                        nonMatchedFieldNames.add(fieldName);
                    }
                    matchedFieldsSorted = new ArrayList();
                    matchedFieldsSorted.addAll(matchedFields);
                    matchedFieldsSorted.remove("Nuix GUID");
                    if (this.retrieveBrainspaceClassifierScores) {
                        matchedFieldsSorted.removeAll(this.classifierFieldNames);
                    }
                    matchedFieldsSorted.sort(String::compareToIgnoreCase);
                    if (matchedFieldsSorted.size() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Error.FieldsRetrieved", (Object)String.join((CharSequence)", ", matchedFieldsSorted)));
                    } else {
                        this.addExecutionLog(this.iu.getString("BrainspaceRetrieveMetadataOperation.Error.NoFieldsRetrieved"));
                    }
                }
                if (this.retrieveBrainspaceClassifierScores) {
                    nonMatchedFieldNames = new ArrayList();
                    for (String fieldName : fields) {
                        if (matchedFields.contains(fieldName)) continue;
                        nonMatchedFieldNames.add(fieldName);
                    }
                    matchedFieldsSorted = new ArrayList<String>();
                    for (String matchedField : matchedFields) {
                        if (!this.classifierFieldNames.contains(matchedField)) continue;
                        matchedFieldsSorted.add(matchedField);
                    }
                    matchedFieldsSorted.sort(String::compareToIgnoreCase);
                    if (matchedFieldsSorted.size() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Error.ClassifierScoresRetrieved", (Object)String.join((CharSequence)", ", matchedFieldsSorted)));
                    } else {
                        this.addExecutionLog(this.iu.getString("BrainspaceRetrieveMetadataOperation.Error.NoClassifierScoresRetrieved"));
                    }
                }
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L && this.countItemsProcessed != null) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("BrainspaceLoadItems.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

