/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.callapi.AuthType;
import com.nuix.automate.workflow.core.execution.options.callapi.BodyFormat;
import com.nuix.automate.workflow.core.execution.options.callapi.BodyType;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.CALL_API, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"EXTERNAL_COMMAND"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveResponseCode", parameter="{call_api_response_code}"), @OperationParameter(label="queryRetrieveResponseHeaders", parameter="{call_api_response_headers}"), @OperationParameter(label="queryRetrieveResponseBody", parameter="{call_api_response_body}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_NATIVE)
public class CallApiOperation
extends Operation {
    @FormField
    public Verb verb;
    @FormField
    public String url;
    @FormField(required=false)
    @ExcludeFromPrintableOptions
    public String certificateFingerprint;
    @FormField
    public AuthType authType;
    @FormField(visibleOn={@OnField(name="authType", value={"BASIC_AUTH"})})
    public String basicAuthUsername;
    @FormField(visibleOn={@OnField(name="authType", value={"BASIC_AUTH"})})
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String basicAuthPassword;
    @FormField(visibleOn={@OnField(name="authType", value={"API_KEY"})})
    @ExcludeFromPrintableOptions
    public String apiKeyName;
    @FormField(visibleOn={@OnField(name="authType", value={"API_KEY"})})
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String apiKeyValue;
    @FormField(visibleOn={@OnField(name="authType", value={"BEARER_TOKEN"})})
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String bearerToken;
    public String authKey;
    @SensitiveField
    public String authSecret;
    @FormField(required=false, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="value"), @FormFieldColumn(label="descriptionOptional", required=false)})
    @ExcludeFromPrintableOptions
    public List<Object[]> parameters;
    @FormField(required=false, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="value"), @FormFieldColumn(label="descriptionOptional", required=false)})
    @ExcludeFromPrintableOptions
    public List<Object[]> headers;
    @FormField
    public BodyType bodyType;
    @FormField(visibleOn={@OnField(name="bodyType", value={"FORM_DATA"})}, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="value"), @FormFieldColumn(label="descriptionOptional", required=false)})
    @ExcludeFromPrintableOptions
    public List<Object[]> bodyFormData;
    @FormField(visibleOn={@OnField(name="bodyType", value={"RAW"})})
    @ExcludeFromPrintableOptions
    public BodyFormat bodyFormat;
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguageField="bodyFormat", visibleOn={@OnField(name="bodyType", value={"RAW"})})
    @ExcludeFromPrintableOptions
    public String bodyRaw;
    @FormField(visibleOn={@OnField(name="bodyType", value={"BINARY"})})
    @ExcludeFromPrintableOptions
    public String bodyFilelocation;

    public boolean getDisplayBasicAuthUsername() {
        return this.authType.equals((Object)AuthType.BASIC_AUTH);
    }

    public boolean getDisplayBasicAuthPassword() {
        return false;
    }

    public boolean getDisplayAuthKey() {
        return this.authType.equals((Object)AuthType.API_KEY);
    }

    public boolean getDisplayAuthSecret() {
        return false;
    }

    public boolean getDisplayBearerToken() {
        return false;
    }

    public boolean getDisplayBodyFormData() {
        return this.bodyType.equals((Object)BodyType.FORM_DATA);
    }

    public boolean getDisplayBodyFormat() {
        return this.bodyType.equals((Object)BodyType.RAW);
    }

    public boolean getDisplayBodyRaw() {
        return this.bodyType.equals((Object)BodyType.RAW);
    }

    public boolean getDisplayBodyFilePath() {
        return this.bodyType.equals((Object)BodyType.BINARY);
    }

    public CallApiOperation() {
        this.requiresCase = false;
        this.verb = Verb.POST;
        this.url = "https://localhost";
        this.authType = AuthType.NO_AUTH;
        this.authKey = "";
        this.authSecret = "";
        this.basicAuthUsername = "";
        this.basicAuthPassword = "";
        this.apiKeyName = "";
        this.apiKeyValue = "";
        this.bearerToken = "";
        this.headers = new ArrayList<Object[]>();
        this.headers.add(new Object[]{"Accept", "application/json", "Request the response in JSON format"});
        this.parameters = new ArrayList<Object[]>();
        this.bodyType = BodyType.RAW;
        this.bodyRaw = "{\n\t\"id\":\"1\",\n\t\"message\":\"Hello World\"\n}";
        this.bodyFormat = BodyFormat.JSON;
        this.bodyFormData = new ArrayList<Object[]>();
        this.certificateFingerprint = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("CallApiOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.url == null || this.url.trim().length() == 0) {
            prerequisites.add(this.iu.getString("CallApiOperation.Error.MissingUrl"));
        }
        return prerequisites;
    }

    @Override
    public void normalize() {
        super.normalize();
        switch (this.authType) {
            case API_KEY: {
                if (this.apiKeyName != null && this.apiKeyName.length() != 0 || this.authKey == null || this.authKey.length() <= 0) break;
                this.apiKeyName = this.authKey;
                this.apiKeyValue = this.authSecret;
                break;
            }
            case BASIC_AUTH: {
                if (this.basicAuthUsername != null && this.basicAuthUsername.length() != 0 || this.authKey == null || this.authKey.length() <= 0) break;
                this.basicAuthUsername = this.authKey;
                this.basicAuthPassword = this.authSecret;
                break;
            }
            case BEARER_TOKEN: {
                if (this.bearerToken != null && this.bearerToken.length() != 0 || this.authSecret == null || this.authSecret.length() <= 0) break;
                this.bearerToken = this.authSecret;
            }
        }
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

