/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.CloseNuixOperation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CloseNuixOperationImplementation
extends CloseNuixOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CloseNuixOperation.class);
    private transient boolean closedNuix;
    private transient String stageName;
    private transient double progress = 0.0;

    private void handleComponent(String prefix, Component component) {
        String locationOnScreen = "n/a";
        try {
            locationOnScreen = component.getLocationOnScreen().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(prefix + String.valueOf(component.getClass()) + "\t" + component.getName() + "\t" + locationOnScreen + "\t" + String.valueOf(component.getLocation()) + "\t" + String.valueOf(component.getSize()));
        }
        if (component instanceof JMenu && component.getName().equals("File")) {
            LOGGER.info("Detected File menu");
            JMenu fileMenu = (JMenu)component;
            for (int i = 0; i < fileMenu.getItemCount(); ++i) {
                if (!(fileMenu.getItem(i) instanceof JMenuItem)) continue;
                JMenuItem menuItem = fileMenu.getItem(i);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" Menu item " + i + ":" + fileMenu.getItemCount() + " " + menuItem.getName());
                }
                if (menuItem.getName() == null || !menuItem.getName().equals("Exit")) continue;
                if (!this.closedNuix) {
                    this.stageName = this.iu.getString("CloseNuixOperation.Stage.ClosingNuix");
                    LOGGER.info("Detected File->Exit menu item, triggering action");
                    try {
                        ActionEvent actionEvent = new ActionEvent(menuItem, 1001, null);
                        menuItem.getAction().actionPerformed(actionEvent);
                        this.closedNuix = true;
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot trigger Exit action", (Throwable)e);
                    }
                    continue;
                }
                LOGGER.info("Detected additional instance for File->Exit menu item, skipping");
            }
        }
    }

    private void handleContainer(String prefix, Container container) {
        this.handleComponent(prefix, container);
        for (Component component : container.getComponents()) {
            try {
                Container componentContainer = (Container)component;
                this.handleContainer(prefix + " ", componentContainer);
            }
            catch (Exception e) {
                this.handleComponent(prefix + " ", component);
            }
        }
    }

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.executionContext.closeAllTabs();
        this.stageName = this.iu.getString("CloseNuixOperation.Stage.DetectingNuixWindow");
        this.progress = 0.1;
        CloseNuixOperationImplementation currentOperation = this;
        this.startTriggerThread = new Thread(() -> {
            try {
                if (this.closeNuixWorkstation) {
                    for (int i = 10; i >= 0; --i) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        this.stageName = this.iu.getNumeralString("CloseNuixOperation.Stage.ClosingNuixIn", (long)i);
                        LOGGER.info(this.stageName);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("Cannot sleep", (Throwable)e);
                            throw e;
                        }
                    }
                    this.executionContext.workflowExecution.closeCaseOpenedByWorkflow();
                    Window[] windows = Window.getWindows();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Detected " + windows.length + " windows");
                    }
                    for (Window window : windows) {
                        try {
                            this.handleContainer("", window);
                        }
                        catch (RuntimeException runtimeException) {
                            LOGGER.warn("Cannot handle window", (Throwable)runtimeException);
                        }
                    }
                    if (!this.closedNuix) {
                        this.addWarning(this.iu.getString("CloseNuixOperation.Warning.CouldNotCloseNuixWindow"));
                    } else {
                        this.addExecutionLog(this.iu.getString("CloseNuixOperation.Log.ClosedNuixWorkstation"));
                    }
                }
                this.progress = 0.5;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                LOGGER.info("Done processing error");
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String threadStackTraceToString(Thread t) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : t.getStackTrace()) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void monitorRunningThreads() {
        while (true) {
            HashSet<Thread> rampivaThreads = new HashSet<Thread>();
            Set<Thread> allThreads = Thread.getAllStackTraces().keySet();
            for (Thread thread : allThreads) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("   " + thread.getName() + "\t" + String.valueOf(thread) + "\t\t" + thread.getId() + "\t" + String.valueOf(thread.getStackTrace()));
                }
                if (!thread.getName().startsWith("Automate")) continue;
                rampivaThreads.add(thread);
            }
            LOGGER.info("Detected " + rampivaThreads.size() + " Automate thread(s):");
            LOGGER.info("Triggering GC");
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            runtime.freeMemory();
            if (rampivaThreads.size() <= 1) break;
            LOGGER.info("Active Automate threads:");
            for (Thread offendingThread : rampivaThreads) {
                LOGGER.info("   " + offendingThread.getName() + "\t" + String.valueOf(offendingThread) + "\t\t" + offendingThread.getId());
            }
            LOGGER.info("Sleeping 1s ...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Cannot sleep", (Throwable)interruptedException);
            }
        }
        LOGGER.info("Only remaining Automate thread is for this operation");
        LOGGER.info("Sleeping 1s ...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Cannot sleep", (Throwable)interruptedException);
        }
        LOGGER.info("Remaining com.nuix threads:");
        for (Thread offendingThread : Thread.getAllStackTraces().keySet()) {
            String threadStackTrace = this.threadStackTraceToString(offendingThread);
            if (!threadStackTrace.contains("com.nuix")) continue;
            LOGGER.info("   " + offendingThread.getName() + "\t" + String.valueOf(offendingThread) + "\tThreadId: " + offendingThread.getId() + "\n" + threadStackTrace);
        }
        LOGGER.info("Stopping monitoring");
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return this.progress;
    }
}

