/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureDiscoverConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestClient;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestException;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.HashSet;
import java.util.Map;

public class ConfigureDiscoverConnectionOperationImplementation
extends ConfigureDiscoverConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureDiscoverConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient DiscoverService discoverService;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), DiscoverService.class.getSimpleName(), ParameterType.DISCOVER_SERVICE);
                this.stageName = this.iu.getString("ConfigureDiscoverConnectionOperation.Stage.InitializingRestClient");
                HashSet<String> whitelistedCertificateFingerprints = null;
                if (this.useDiscoverService) {
                    this.discoverServiceId = this.executionContext.evalParameters(this.discoverServiceId, this);
                    if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.discoverServiceId) == null) {
                        throw new IllegalStateException(this.iu.getFormattedString("ConfigureDiscoverConnectionOperation.Exception.MissingDiscoverService", (Object)this.discoverServiceId));
                    }
                    this.discoverService = (DiscoverService)this.thirdPartyServices.get(this.discoverServiceId);
                    DiscoverUserCredential userCredential = (DiscoverUserCredential)this.discoverService.getUserCredential();
                    if (userCredential.getToken() == null || userCredential.getToken().trim().isEmpty()) {
                        throw new IllegalStateException(this.iu.getFormattedString("ConfigureDiscoverConnectionOperation.Exception.MissingApiToken", (Object)this.discoverServiceId));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureDiscoverConnectionOperation.Log.DiscoverService", (Object)this.discoverService.getName()));
                    this.hostname = this.discoverService.getHostname();
                    this.apiToken = userCredential.getToken();
                    whitelistedCertificateFingerprints = this.discoverService.getWhitelistedCertFingerprints();
                } else {
                    this.hostname = this.executionContext.evalParameters(this.hostname, this);
                    this.apiToken = this.executionContext.evalProtectedParameter(this.apiToken);
                    if (this.apiToken.length() == 0 || this.apiToken.startsWith("{")) {
                        throw new ParameterException(this.iu.getString("ConfigureDiscoverConnectionOperation.Error.DiscoverApiKeyIsInvalid"));
                    }
                }
                if (whitelistedCertificateFingerprints == null) {
                    whitelistedCertificateFingerprints = new HashSet();
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_discover_hostname}", this.hostname)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_discover_api_token_protected}", this.apiToken)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_discover_whitelisted_cert_fingerprints}", SerializationUtils.toJson(whitelistedCertificateFingerprints))));
                DiscoverRestClient discoverRestClient = new DiscoverRestClient(this.hostname, this.apiToken, (LogChannel)new DummyLogChannel(), whitelistedCertificateFingerprints);
                discoverRestClient.setOperation(this);
                try {
                    String discoverVersion = discoverRestClient.getVersion();
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureDiscoverConnectionOperation.Log.DiscoverServiceVersion", (Object)discoverVersion));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_version}", discoverVersion)));
                }
                catch (DiscoverRestException e) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_version}", "unknown")));
                    this.addWarning(this.iu.getFormattedString("ConfigureDiscoverConnectionOperation.Warning.CannotDetermineServiceVersion", (Object)e.getMessage()));
                }
                discoverRestClient.getMeId();
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

