/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.LogLevel;
import com.nuix.automate.workflow.core.execution.options.nativeocr.OcrEngineModes;
import com.nuix.automate.workflow.core.execution.options.nativeocr.PageSegmentationMode;
import com.nuix.automate.workflow.core.execution.options.nativeocr.Rotation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.WorkersAssignmentMode;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import java.util.HashSet;
import java.util.Set;

@FormFieldRadioButtonGroup(name="workersRadioButtonGroup", styled=true, radioButton="workersAssignmentMode", values={@RadioButtonValue(component="predeterminedWorkerCount", value="PREDETERMINED"), @RadioButtonValue(component="workersPerCpuCore", value="PER_CPU_CORE")})
@FormFieldRows(value={@FormFieldRow(name="ocrEngineBinariesFolderRow", children={"ocrEngineBinariesFolderEnabled", "ocrEngineBinariesFolder"}), @FormFieldRow(name="userWordsFileRow", children={"userWordsFileEnabled", "userWordsFile"}), @FormFieldRow(name="userPatternsFileRow", children={"userPatternsFileEnabled", "userPatternsFile"}), @FormFieldRow(name="dpiRow", children={"dpiEnabled", "dpi"}), @FormFieldRow(name="rasterizePdfDpiRow", children={"rasterizePdfDpiEnabled", "rasterizePdfDpi"}), @FormFieldRow(name="logLevelRow", children={"logLevelEnabled", "logLevel"}), @FormFieldRow(name="languagesRow", children={"languagesEnabled", "languages"}), @FormFieldRow(name="psmRow", children={"psmEnabled", "psm"}), @FormFieldRow(name="rotateRow", children={"rotate", "rotation"}), @FormFieldRow(name="oemRow", children={"oemEnabled", "oem"}), @FormFieldRow(name="ocrEngineConfigFileRow", children={"ocrEngineConfigFileEnabled", "ocrEngineConfigFile"}), @FormFieldRow(name="timeoutPerFileRow", children={"timeoutPerFileEnabled", "timeoutPerFile"}), @FormFieldRow(name="ocrTempFolderRow", children={"ocrTempFolderEnabled", "ocrTempFolder"})})
@OperationMetadata(alias=OperationAlias.CONFIGURE_NATIVE_OCR, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"CONFIGURATION", "OCR"})})
@OperationLicenseModule(module=ModuleType.NATIVE_OCR)
public class ConfigureNativeOcrOperation
extends Operation {
    @FormField
    public WorkersAssignmentMode workersAssignmentMode;
    @FormField(min=1.0, enableOn={@OnField(name="workersAssignmentMode", value={"PREDETERMINED"})}, positionLabel=@PositionLabel(right="workers"))
    @ExcludeFromPrintableOptions
    public int predeterminedWorkerCount;
    @FormField(min=0.1, enableOn={@OnField(name="workersAssignmentMode", value={"PER_CPU_CORE"})}, positionLabel=@PositionLabel(right="workersPerCpuCore"))
    @ExcludeFromPrintableOptions
    public double workersPerCpuCore;
    @FormField
    public boolean ocrEngineBinariesFolderEnabled;
    @FormField(enableOn={@OnField(name="ocrEngineBinariesFolderEnabled")})
    @ExcludeFromPrintableOptions
    public String ocrEngineBinariesFolder;
    @FormField
    public boolean userWordsFileEnabled;
    @FormField(enableOn={@OnField(name="userWordsFileEnabled")})
    @ExcludeFromPrintableOptions
    public String userWordsFile;
    @FormField
    public boolean userPatternsFileEnabled;
    @FormField(enableOn={@OnField(name="userPatternsFileEnabled")})
    @ExcludeFromPrintableOptions
    public String userPatternsFile;
    @FormField
    public boolean dpiEnabled;
    @FormField(enableOn={@OnField(name="dpiEnabled")}, positionLabel=@PositionLabel(right="dpi"))
    @ExcludeFromPrintableOptions
    public int dpi;
    @FormField
    public boolean rasterizePdfDpiEnabled;
    @FormField(enableOn={@OnField(name="rasterizePdfDpiEnabled")}, positionLabel=@PositionLabel(right="dpi"))
    @ExcludeFromPrintableOptions
    public int rasterizePdfDpi;
    @FormField
    public boolean logLevelEnabled;
    @FormField(enableOn={@OnField(name="logLevelEnabled")})
    @ExcludeFromPrintableOptions
    public LogLevel logLevel;
    @FormField
    public boolean languagesEnabled;
    @FormField(enableOn={@OnField(name="languagesEnabled")})
    @ExcludeFromPrintableOptions
    public String languages;
    @FormField
    public boolean psmEnabled;
    @FormField(enableOn={@OnField(name="psmEnabled")})
    @ExcludeFromPrintableOptions
    public PageSegmentationMode psm;
    @FormField
    public boolean deskew;
    @FormField
    public boolean rotate;
    @FormField(enableOn={@OnField(name="rotate")})
    @ExcludeFromPrintableOptions
    public Rotation rotation;
    @FormField
    public boolean oemEnabled;
    @FormField(enableOn={@OnField(name="oemEnabled")})
    @ExcludeFromPrintableOptions
    public OcrEngineModes oem;
    @FormField
    public boolean ocrEngineConfigFileEnabled;
    @FormField(enableOn={@OnField(name="ocrEngineConfigFileEnabled")})
    @ExcludeFromPrintableOptions
    public String ocrEngineConfigFile;
    @FormField
    public boolean timeoutPerFileEnabled;
    @FormField(enableOn={@OnField(name="timeoutPerFileEnabled")}, positionLabel=@PositionLabel(right="seconds"))
    @ExcludeFromPrintableOptions
    public int timeoutPerFile;
    @FormField
    public boolean ocrTempFolderEnabled;
    @FormField(enableOn={@OnField(name="ocrTempFolderEnabled")})
    @ExcludeFromPrintableOptions
    public String ocrTempFolder;
    @FormField
    public boolean dontClearOcrTemp;

    public boolean getDisplayPredeterminedWorkerCount() {
        return WorkersAssignmentMode.PREDETERMINED.equals((Object)this.workersAssignmentMode);
    }

    public boolean getDisplayWorkersPerCpuCore() {
        return WorkersAssignmentMode.PER_CPU_CORE.equals((Object)this.workersAssignmentMode);
    }

    public boolean getDisplayOcrEngineBinariesFolder() {
        return this.ocrEngineBinariesFolderEnabled;
    }

    public boolean getDisplayUserWordsFile() {
        return this.userWordsFileEnabled;
    }

    public boolean getDisplayUserPatternsFile() {
        return this.userPatternsFileEnabled;
    }

    public boolean getDisplayDpi() {
        return this.dpiEnabled;
    }

    public boolean getDisplayRasterizePdfDpi() {
        return this.rasterizePdfDpiEnabled;
    }

    public boolean getDisplayLogLevel() {
        return this.logLevelEnabled;
    }

    public boolean getDisplayLanguages() {
        return this.languagesEnabled;
    }

    public boolean getDisplayPsm() {
        return this.psmEnabled;
    }

    public boolean getDisplayRotation() {
        return this.rotate;
    }

    public boolean getDisplayOem() {
        return this.oemEnabled;
    }

    public boolean getDisplayOcrEngineConfigFileEnabled() {
        return this.ocrEngineConfigFileEnabled;
    }

    public boolean getDisplayTimeoutPerFile() {
        return this.timeoutPerFileEnabled;
    }

    public boolean getDisplayOcrTempFolder() {
        return this.ocrTempFolderEnabled;
    }

    public ConfigureNativeOcrOperation() {
        this.requiresCase = false;
        this.workersAssignmentMode = WorkersAssignmentMode.PER_CPU_CORE;
        this.predeterminedWorkerCount = 1;
        this.workersPerCpuCore = 0.8;
        this.ocrEngineBinariesFolderEnabled = false;
        this.ocrEngineBinariesFolder = SystemUtils.getProgramFilesDir() + "\\Tesseract-OCR";
        this.userWordsFileEnabled = false;
        this.userWordsFile = "C:\\Profiles\\OCR_Words.txt";
        this.userPatternsFileEnabled = false;
        this.userPatternsFile = "C:\\Profiles\\OCR_Patterns.txt";
        this.dpiEnabled = false;
        this.dpi = 300;
        this.logLevelEnabled = false;
        this.logLevel = LogLevel.ERROR;
        this.languagesEnabled = false;
        this.languages = "eng+deu+fra";
        this.psmEnabled = false;
        this.psm = PageSegmentationMode._3_FULLY_AUTOMATIC_PAGE_SEGMENTATION_NO_OSD;
        this.oemEnabled = false;
        this.oem = OcrEngineModes._3_DEFAULT;
        this.ocrEngineConfigFileEnabled = false;
        this.ocrEngineConfigFile = "C:\\Profiles\\Tesseract.config";
        this.timeoutPerFileEnabled = false;
        this.timeoutPerFile = 600;
        this.rasterizePdfDpiEnabled = false;
        this.rasterizePdfDpi = 300;
        this.ocrTempFolderEnabled = false;
        this.ocrTempFolder = OsUtils.getOsWindows() ? "C:\\Temp" : "/tmp";
        this.dontClearOcrTemp = false;
        this.deskew = false;
        this.rotate = false;
        this.rotation = Rotation.AUTO_DETECT;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ConfigureNativeOcrOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CONFIGURE_NATIVE_OCR;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

