/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNativeOcrOperation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.WorkersAssignmentMode;
import com.nuix.automate.workflow.core.utils.ocr.TesseractOcrUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class ConfigureNativeOcrOperationImplementation
extends ConfigureNativeOcrOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureNativeOcrOperation.class);

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.WorkerAssignmentMode", (Object)this.workersAssignmentMode));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_workers_assignment_mode}", this.workersAssignmentMode.name())));
                if (this.workersAssignmentMode.equals((Object)WorkersAssignmentMode.PREDETERMINED)) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.PredeterminedWorkerCount", (Object)this.predeterminedWorkerCount));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_predetermined_worker_count}", "" + this.predeterminedWorkerCount)));
                }
                if (this.workersAssignmentMode.equals((Object)WorkersAssignmentMode.PER_CPU_CORE)) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.WorkersPerCpuCore", (Object)this.workersPerCpuCore));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_workers_per_cpu_core}", "" + this.workersPerCpuCore)));
                }
                if (this.ocrEngineBinariesFolderEnabled) {
                    this.ocrEngineBinariesFolder = this.executionContext.evalParameters(this.ocrEngineBinariesFolder, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.OcrEngineBinariesFolder", (Object)this.ocrEngineBinariesFolder));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_engine_binaries_folder}", this.ocrEngineBinariesFolder)));
                }
                if (this.userWordsFileEnabled) {
                    this.userWordsFile = this.executionContext.evalParameters(this.userWordsFile, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.UserWordsFile", (Object)this.userWordsFile));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_user_words_file}", this.userWordsFile)));
                    if (!Files.exists(Paths.get(this.userWordsFile, new String[0]), new LinkOption[0])) {
                        throw new IOException("File " + this.userWordsFile + " does not exist");
                    }
                }
                if (this.userPatternsFileEnabled) {
                    this.userPatternsFile = this.executionContext.evalParameters(this.userPatternsFile, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.UserPatternsFile", (Object)this.userPatternsFile));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_user_patterns_file}", this.userPatternsFile)));
                    if (!Files.exists(Paths.get(this.userPatternsFile, new String[0]), new LinkOption[0])) {
                        throw new IOException("File " + this.userPatternsFile + " does not exist");
                    }
                }
                if (this.dpiEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.Dpi", (Object)this.dpi));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_dpi}", "" + this.dpi)));
                }
                if (this.rasterizePdfDpiEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.RasterizePdfDpi", (Object)this.rasterizePdfDpi));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_rasterize_pdf_dpi}", "" + this.rasterizePdfDpi)));
                }
                if (this.logLevelEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.LogLevel", (Object)this.logLevel));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_log_level}", this.logLevel.name())));
                }
                if (this.languagesEnabled) {
                    this.languages = this.executionContext.evalParameters(this.languages, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.Languages", (Object)this.languages));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_languages}", this.languages)));
                }
                if (this.psmEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.Psm", (Object)this.psm));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_psm}", this.psm.name())));
                }
                if (this.oemEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.Oem", (Object)this.oem));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_oem}", this.oem.name())));
                }
                if (this.ocrEngineConfigFileEnabled) {
                    this.ocrEngineConfigFile = this.executionContext.evalParameters(this.ocrEngineConfigFile, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.OcrEngineConfigFile", (Object)this.ocrEngineConfigFile));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_engine_config_file}", this.ocrEngineConfigFile)));
                    if (!Files.exists(Paths.get(this.ocrEngineConfigFile, new String[0]), new LinkOption[0])) {
                        throw new IOException("File " + this.ocrEngineConfigFile + " does not exist");
                    }
                }
                if (this.timeoutPerFileEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.TimeoutPerFile", (Object)this.timeoutPerFile));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_timeout_per_file}", "" + this.timeoutPerFile)));
                }
                if (this.ocrTempFolderEnabled) {
                    this.ocrTempFolder = this.executionContext.evalParameters(this.ocrTempFolder, this);
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.OcrTempFolder", (Object)this.ocrTempFolder));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_temp_folder}", this.ocrTempFolder)));
                    if (!FileUtils.isPathAbsolute((String)this.ocrTempFolder)) {
                        String errorMsg = this.iu.getFormattedString("ConfigureNativeOcrOperation.Exception.TempFolderRelative", (Object)this.ocrTempFolder);
                        LOGGER.error("OCR folder location can't be a relative path");
                        this.exception = new Exception(errorMsg);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                if (this.dontClearOcrTemp) {
                    this.addExecutionLog(this.iu.getString("ConfigureNativeOcrOperation.Log.DontClearOcrTemp"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_dont_clear_temp}", "" + this.dontClearOcrTemp)));
                if (this.deskew) {
                    this.addExecutionLog(this.iu.getString("ConfigureNativeOcrOperation.Log.Deskew"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_deskew}", "" + this.deskew)));
                if (this.rotate) {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigureNativeOcrOperation.Log.Rotation", (Object)this.rotation.toString()));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_rotate}", this.rotation.name())));
                } else {
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_native_ocr_rotate}", "")));
                }
                LOGGER.info("Testing OCR with all options");
                TesseractOcrUtils ocrUtils = new TesseractOcrUtils(this.executionContext, this, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("OCRTemp"));
                ocrUtils.close();
                LOGGER.info("OCR tested successfully");
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        String result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        return result;
    }
}

