/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.configuration.KeystoreFile;
import com.nuix.automate.workflow.core.execution.options.configuration.NuixSettingsType;
import com.nuix.automate.workflow.core.execution.options.configuration.ParallelProcessingSettingsSource;
import com.nuix.automate.workflow.core.execution.options.configuration.PasswordSettingsType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="profiles", children={"configurationProfileRow", "processingProfileRow", "requireFilesInExecutionProfile", "parallelProcessingSettingsSource", "workflowLocalWorkersCount", "workflowLocalWorkersMemoryMb", "workflowBrokerWorkersCount"}), @FormFieldGroup(name="passwords", children={"passwordSettingsType", "passwordList", "passwordFilePath"}), @FormFieldGroup(name="keystores", children={"keyStoreFilePath"})})
@FormFieldRows(value={@FormFieldRow(name="configurationProfileRow", children={"useConfigurationProfile", "profileFilePath"}), @FormFieldRow(name="processingProfileRow", children={"useProcessingProfile", "processingProfileName"})})
@OperationMetadata(alias=OperationAlias.CONFIGURE_NUIX_ENGINE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ConfigureNuixOperation
extends Operation
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureNuixOperation.class);
    @FormField
    public boolean useConfigurationProfile;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.CONFIGURATION_PROFILES, enableOn={@OnField(name="useConfigurationProfile")})
    public String profileFilePath;
    @FormField
    public boolean useProcessingProfile;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.PROCESSING_PROFILES, enableOn={@OnField(name="useProcessingProfile")})
    public String processingProfileName;
    public boolean useRemoteWorkers;
    @FormField
    public ParallelProcessingSettingsSource parallelProcessingSettingsSource;
    @FormField(visibleOn={@OnField(name="parallelProcessingSettingsSource", value={"WORKFLOW"})})
    @ExcludeFromPrintableOptions
    public int workflowLocalWorkersCount;
    @FormField(visibleOn={@OnField(name="parallelProcessingSettingsSource", value={"WORKFLOW"})}, positionLabel=@PositionLabel(right="MB"), enableOn={@OnField(name="workflowLocalWorkersCount", comparisonOperator=ComparisonOperator.GREATER_THAN, value={"0"})})
    @ExcludeFromPrintableOptions
    public int workflowLocalWorkersMemoryMb;
    @FormField(visibleOn={@OnField(name="parallelProcessingSettingsSource", value={"WORKFLOW"})})
    @ExcludeFromPrintableOptions
    public int workflowBrokerWorkersCount;
    @ExcludeFromPrintableOptions
    public String workflowBrokerIp;
    @ExcludeFromPrintableOptions
    public int workflowBrokerPort;
    @FormField
    public boolean requireFilesInExecutionProfile;
    @FormField
    @ExcludeFromPrintableOptions
    public PasswordSettingsType passwordSettingsType;
    @FormField(visibleOn={@OnField(name="passwordSettingsType", value={"PASSWORD_LIST"})}, columnFields={@FormFieldColumn(label="password")})
    @ExcludeFromPrintableOptions
    public List<Object[]> passwordList = new ArrayList<Object[]>();
    @FormField(visibleOn={@OnField(name="passwordSettingsType", value={"PASSWORDS_FILE"})})
    @ExcludeFromPrintableOptions
    public String passwordFilePath;
    @FormField(required=false)
    @ExcludeFromPrintableOptions
    public String keyStoreFilePath;
    @ExcludeFromPrintableOptions
    public List<KeystoreFile> keystoreList = new ArrayList<KeystoreFile>();
    @ExcludeFromPrintableOptions
    public NuixSettingsType nuixSettingsType;

    public boolean getDisplayProfileFilePath() {
        return this.useConfigurationProfile;
    }

    public boolean getDisplayProcessingProfileName() {
        return this.useProcessingProfile;
    }

    public boolean getDisplayWorkflowLocalWorkersCount() {
        return ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource);
    }

    public boolean getDisplayWorkflowLocalWorkersMemoryMb() {
        return ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource);
    }

    public boolean getDisplayWorkflowBrokerWorkersCount() {
        return ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource) && this.workflowBrokerWorkersCount > 0;
    }

    public boolean getDisplayWorkflowBrokerIp() {
        return ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource) && this.workflowBrokerWorkersCount > 0;
    }

    public boolean getDisplayWorkflowBrokerPort() {
        return ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource) && this.workflowBrokerWorkersCount > 0;
    }

    public boolean getDisplayPasswordList() {
        return PasswordSettingsType.PASSWORD_LIST.equals((Object)this.passwordSettingsType);
    }

    public boolean getDisplayPasswordFilePath() {
        return PasswordSettingsType.PASSWORDS_FILE.equals((Object)this.passwordSettingsType);
    }

    public ConfigureNuixOperation() {
        this.requiresCase = false;
        this.nuixSettingsType = null;
        this.useConfigurationProfile = false;
        this.useProcessingProfile = true;
        this.processingProfileName = "Default";
        this.requireFilesInExecutionProfile = false;
        this.profileFilePath = "";
        this.passwordFilePath = "";
        this.passwordSettingsType = PasswordSettingsType.NONE;
        this.keyStoreFilePath = "";
        this.parallelProcessingSettingsSource = ParallelProcessingSettingsSource.PROFILE;
        this.workflowLocalWorkersCount = 0;
        this.workflowLocalWorkersMemoryMb = 768;
        this.workflowBrokerIp = "";
        this.workflowBrokerPort = 0;
        this.workflowBrokerWorkersCount = 0;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ConfigureNuixOperation.Property.Name");
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.nuixSettingsType == NuixSettingsType.FROM_FILE) {
            this.useConfigurationProfile = true;
        } else if (this.nuixSettingsType == NuixSettingsType.NUIX_DEFAULT) {
            this.useConfigurationProfile = false;
        }
        this.nuixSettingsType = null;
        if (this.useRemoteWorkers && this.workflowBrokerWorkersCount == -1 && ParallelProcessingSettingsSource.WORKFLOW.equals((Object)this.parallelProcessingSettingsSource)) {
            this.workflowBrokerWorkersCount = 2;
            this.useRemoteWorkers = false;
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        Version requiredNuixVersion;
        int requiredVersionSatisfied;
        List<String> prerequisites = super.getPrerequisites(activity);
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && this.passwordSettingsType != PasswordSettingsType.NONE && (requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion = new Version("7.2.0"))) < 0) {
            prerequisites.add(this.iu.getString("ConfigurationOperation.Prerequisites.CannotUsePasswordSettings"));
        }
        if (this.parallelProcessingSettingsSource == ParallelProcessingSettingsSource.WORKFLOW && this.workflowLocalWorkersCount <= 0) {
            prerequisites.add(this.iu.getString("ConfigurationOperation.Prerequisites.WorkerCountCantBeZero"));
        }
        return prerequisites;
    }
}

