/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.configuration.ParameterListType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.ScriptUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.CONFIGURE_PARAMETERS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ConfigureParametersOperation
extends Operation
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureParametersOperation.class);
    @FormField(componentType=FieldComponentType.PARAMETER_TABLE, required=false, whitelistedFields={"name", "parameterType", "value", "friendlyName", "description"})
    public List<StaticParameter> staticParameters = new ArrayList<StaticParameter>();
    @FormField(componentType=FieldComponentType.PARAMETER_TABLE, required=false)
    public List<StaticParameter> userParameters = new ArrayList<StaticParameter>();

    public ConfigureParametersOperation() {
        this.requiresCase = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ConfigurationOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CONFIGURE_PARAMETERS;
    }

    @Override
    public void normalize() {
        super.normalize();
        this.userParameters = this.normalizeParametersStrict(this.userParameters);
        for (Parameter parameter : this.userParameters) {
            if (parameter.getAllowedValuesMatchBy() != null) continue;
            parameter.setAllowedValuesMatchBy(ParameterValueMatchBy.SYSTEM_OR_USER_PRINTABLE_VALUE);
        }
        this.staticParameters = this.normalizeParametersStrict(this.staticParameters);
        for (Parameter parameter : this.staticParameters) {
            if (parameter.getRegex() == null || parameter.getRegex().equals("")) continue;
            parameter.setRegex("");
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        prerequisites.remove(this.iu.getString("AutomateLicenseResource.Info.OperationRequiresBusinessEdition"));
        List<StaticParameter> parameters = this.getAllParameters();
        for (Parameter parameter : parameters) {
            if (this.executionContext.getExecutionBuiltInParameters() != null && this.executionContext.getExecutionBuiltInParameters().isWhiteListed(parameter.getName())) {
                prerequisites.add(this.iu.getFormattedString("ConfigurationOperation.Prerequisites.CantBeUsedAsCustomParameter", (Object)parameter.getFriendlyNameAndName()));
            }
            if (parameter.getAllowedValues() != null && parameter.getAllowedValues().size() > 0) {
                for (String allowedValue : parameter.getAllowedValues()) {
                    if (ScriptUtils.getScriptEngineName(allowedValue) == null) continue;
                    prerequisites.add(this.iu.getFormattedString("ConfigurationOperation.Prerequisites.OnlyOneAllowedValueScriptAllowed", (Object)parameter.getFriendlyNameAndName()));
                    break;
                }
            }
            if (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE && parameter.isUseLibraryFile()) {
                prerequisites.add(this.iu.getFormattedString("ConfigurationOperation.Prerequisites.LibraryFilesCannotBeUsedInWorkflow", (Object)parameter.getFriendlyNameAndName()));
            }
            if (parameter.getParameterType() != ParameterType.RELATIVITY_FOLDER && parameter.getParameterType() != ParameterType.RELATIVITY_SAVED_SEARCH || parameter.getRelativityCondition() != null && parameter.getRelativityCondition().getFilterType() != null && parameter.getRelativityCondition().getFilterParameter().trim().length() != 0) continue;
            prerequisites.add(this.iu.getFormattedString("ConfigurationOperation.Prerequisites.WorkspaceFilterRequired", (Object)parameter.getFriendlyNameAndName()));
        }
        return prerequisites;
    }

    public List<String> normalizeParameterNames() {
        if (this.staticParameters == null) {
            this.staticParameters = new ArrayList<StaticParameter>();
        }
        if (this.userParameters == null) {
            this.userParameters = new ArrayList<StaticParameter>();
        }
        List<StaticParameter> parameters = this.getAllParameters();
        ArrayList<String> changeLog = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            String parameterName = parameter.getName();
            String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
            if (this.executionContext.checkIfBuiltInParameter(normalizedParameterName)) {
                normalizedParameterName = FormattingUtils.normalizeParameterName((String)(parameterName + "_user"));
            }
            if (normalizedParameterName.equals(parameterName)) continue;
            this.modifiedSinceWorkflowSaved = true;
            LOGGER.info("Changed " + parameterName + " to " + normalizedParameterName);
            changeLog.add("\t" + this.iu.getFormattedString("ConfigurationOperation.ChangeLog.Changed", new Object[]{parameterName, normalizedParameterName}));
            parameter.setName(normalizedParameterName);
        }
        return changeLog;
    }

    private List<StaticParameter> normalizeParametersStrict(List<StaticParameter> parameters) {
        ArrayList<StaticParameter> normalizedParameters = new ArrayList<StaticParameter>();
        if (parameters != null) {
            for (StaticParameter parameter : parameters) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameter.getName());
                parameter.setName(normalizedParameterName);
                if (normalizedParameterName.length() <= 2) continue;
                normalizedParameters.add(parameter);
                parameter.setParameterType(parameter.getEffectiveParameterType());
                if (parameter.getFriendlyName() == null) {
                    parameter.setFriendlyNameFromName();
                }
                if (parameter.getAllowedValues() == null) continue;
                parameter.getAllowedValues().removeIf(value -> value == null || value.trim().isEmpty());
            }
        }
        return normalizedParameters;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    public List<StaticParameter> getAllParameters() {
        ArrayList<StaticParameter> parameters = new ArrayList<StaticParameter>();
        parameters.addAll(this.staticParameters);
        parameters.addAll(this.userParameters);
        return parameters;
    }

    public List<StaticParameter> getParameterFromListType(ParameterListType parameterListType) {
        return parameterListType == ParameterListType.STATIC_PARAMETERS ? this.staticParameters : this.userParameters;
    }

    public boolean isStaticParameter(StaticParameter parameter) {
        return this.staticParameters.contains(parameter);
    }

    public StaticParameter getParameterFromListTypeRow(int row, ParameterListType parameterListType) {
        List<StaticParameter> parameters = this.getParameterFromListType(parameterListType);
        if (parameters != null && parameters.size() > row) {
            return parameters.get(row);
        }
        return null;
    }

    public boolean isParamProtectedOrMasked(int row, ParameterListType parameterListType) {
        Parameter parameter = (Parameter)this.getParameterFromListType(parameterListType).get(row);
        if (parameter == null) {
            return false;
        }
        return parameter.isEffectiveTypeMaskedOrProtected();
    }

    public void setLibraryFiles(Map<String, FileLibraryFile> libraryFiles) {
    }
}

