/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import au.com.bytecode.opencsv.CSVReader;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.DocIdErrorListener;
import com.nuix.automate.workflow.core.execution.operations.ConvertLoadfileToNuixLogicalImageOperation;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;

public class ConvertLoadfileToNuixLogicalImageOperationImplementation
extends ConvertLoadfileToNuixLogicalImageOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConvertLoadfileToNuixLogicalImageOperation.class);
    private AtomicLong totalRecordsCount;
    private AtomicLong totalTlRecordsCount;
    private AtomicLong totalItemsProcessed;
    private AtomicLong totalErrors;
    private static final int MAX_LOG_RECORD_ERRORS = 10;
    private long recordsWithErrors;

    private String getRowValue(List<String> rowValuesList, Map<String, Integer> columnIds, String column) {
        Integer columnId = columnIds.get(column);
        if (columnId != null) {
            return rowValuesList.get(columnId);
        }
        return null;
    }

    private void logErrorWithLimit(String message) {
        this.logErrorWithLimit(message, null);
    }

    private void logErrorWithLimit(String message, Throwable t) {
        if (t != null) {
            LOGGER.error(message, t);
        } else {
            LOGGER.error(message);
        }
        if (this.totalErrors == null) {
            this.totalErrors = new AtomicLong(0L);
        }
        if (this.totalErrors.get() < 10L) {
            this.totalErrors.incrementAndGet();
            if (t != null) {
                this.addWarning(message + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)t, (boolean)true));
            } else {
                this.addWarning(message);
            }
        } else if (this.totalErrors.get() == 10L) {
            this.addWarning(this.iu.getString("ConvertLoadfileToNuixLogicalImageOperation.Log.SkippingErrors"));
            this.totalErrors.incrementAndGet();
        }
    }

    private void convertLoadfile(Path loadfilePath) throws IOException, ParserConfigurationException, TransformerException {
        if (this.stopRequested) {
            return;
        }
        LOGGER.info("Handling loadfile " + String.valueOf(loadfilePath));
        Path resultingNli = Paths.get(this.nliFile, new String[0]);
        if (!Files.exists(resultingNli.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(resultingNli.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Cannot create NLI parent folder", (Throwable)e);
            }
        }
        boolean errorsCount = false;
        int maxErrors = 10;
        try (ZipOutputStream outputZip = new ZipOutputStream(Files.newOutputStream(resultingNli.toFile().toPath(), new OpenOption[0]));){
            outputZip.setLevel(0);
            outputZip.setMethod(0);
            Loadfile loadfile = null;
            HashMap<String, 1> csvLoadfileItems = new HashMap<String, 1>();
            char nullCharacter = '\u0000';
            final HashSet<String> itemsWithErrors = new HashSet<String>();
            int rowNumber = 1;
            try (Reader unicodeReader = com.nuix.automate.utils.general.FileUtils.readFileWithAutoDetectEncoding((InputStream)FileUtils.openInputStream((File)loadfilePath.toFile()));
                 CSVReader csvReader = new CSVReader(unicodeReader, ',', '\"', nullCharacter);){
                boolean header = true;
                int columnsCount = 0;
                HashMap<String, Integer> columnIds = new HashMap<String, Integer>();
                String[] rowValues = null;
                try {
                    List<String> partialPreviousRowValuesList = null;
                    while ((rowValues = csvReader.readNext()) != null) {
                        boolean itemHasErrors = false;
                        if (header) {
                            int i;
                            columnsCount = rowValues.length;
                            ArrayList<LoadFileField> metadataNames = new ArrayList<LoadFileField>();
                            if (this.loadAllFields) {
                                for (i = 0; i < rowValues.length; ++i) {
                                    String fieldName = this.fieldsMetadataPrefix + rowValues[i];
                                    metadataNames.add(new LoadFileField(fieldName, "Text", i));
                                }
                            }
                            loadfile = new Loadfile(metadataNames);
                            for (i = 0; i < columnsCount; ++i) {
                                columnIds.put(rowValues[i], i);
                            }
                            header = false;
                            continue;
                        }
                        this.totalRecordsCount.incrementAndGet();
                        List<String> rowValuesList = Arrays.asList(rowValues);
                        if (partialPreviousRowValuesList != null) {
                            int i;
                            Object lastItem = (String)partialPreviousRowValuesList.get(partialPreviousRowValuesList.size() - 1);
                            lastItem = (String)lastItem + "\n" + rowValuesList.get(0);
                            ArrayList<String> mergedRowValuesList = new ArrayList<String>();
                            for (i = 0; i < partialPreviousRowValuesList.size() - 1; ++i) {
                                mergedRowValuesList.add(partialPreviousRowValuesList.get(i));
                            }
                            mergedRowValuesList.add((String)lastItem);
                            for (i = 1; i < rowValuesList.size(); ++i) {
                                mergedRowValuesList.add(rowValuesList.get(i));
                            }
                            rowValuesList = mergedRowValuesList;
                        }
                        if (rowValuesList.size() < columnsCount) {
                            partialPreviousRowValuesList = rowValuesList;
                            LOGGER.warn("Row " + rowNumber + " has " + rowValues.length + " columns instead of " + columnsCount + ", merging with next line");
                            continue;
                        }
                        partialPreviousRowValuesList = null;
                        ++rowNumber;
                        String docId = this.getRowValue(rowValuesList, columnIds, this.docIdColumn);
                        if (docId == null) {
                            this.logErrorWithLimit("DocID is missing on row " + rowNumber);
                            docId = UidUtils.getRandom();
                            itemsWithErrors.add(docId);
                        }
                        String familyId = this.getRowValue(rowValuesList, columnIds, this.familyIdColumn);
                        if (this.familyIdColumn != null && this.familyIdColumn.length() > 0 && familyId == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.familyIdColumn);
                            itemsWithErrors.add(docId);
                        }
                        String location = this.getRowValue(rowValuesList, columnIds, this.pathColumn);
                        if (this.pathColumn != null && this.pathColumn.length() > 0 && location == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.pathColumn);
                            itemsWithErrors.add(docId);
                        }
                        String name = this.getRowValue(rowValuesList, columnIds, this.nameColumn);
                        if (this.nameColumn != null && this.nameColumn.length() > 0 && name == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.nameColumn);
                            itemsWithErrors.add(docId);
                        }
                        String md5 = this.getRowValue(rowValuesList, columnIds, this.md5Column);
                        if (this.md5Column != null && this.md5Column.length() > 0 && md5 == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.md5Column);
                            itemsWithErrors.add(docId);
                        }
                        String custodian = this.getRowValue(rowValuesList, columnIds, this.custodianColumn);
                        if (this.custodianColumn != null && this.custodianColumn.length() > 0 && custodian == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.custodianColumn);
                            itemsWithErrors.add(docId);
                        }
                        final String nativeFile = this.getRowValue(rowValuesList, columnIds, this.nativeFileColumn);
                        if (this.nativeFileColumn != null && this.nativeFileColumn.length() > 0 && nativeFile == null) {
                            this.logErrorWithLimit("DocID " + docId + " missing " + this.nativeFileColumn);
                            itemsWithErrors.add(docId);
                        }
                        Object locationName = null;
                        locationName = location != null ? location : "";
                        if (name != null) {
                            locationName = (String)locationName + "/" + name;
                        }
                        if (locationName == null) {
                            locationName = nativeFile != null ? nativeFile.replace("\\", "/") : "/" + docId;
                        }
                        List<Object> fieldValues = new ArrayList();
                        if (this.loadAllFields) {
                            fieldValues = rowValuesList;
                        }
                        String mimeType = null;
                        if (nativeFile != null && nativeFile.toLowerCase().endsWith(".msg")) {
                            mimeType = "application/vnd.ms-outlook-note";
                        }
                        LoadfileItem loadfileItem = new LoadfileItem(docId, familyId, (String)locationName, null, md5, custodian, mimeType, fieldValues, false){

                            @Override
                            public InputStream getInputStream() throws IOException {
                                if (nativeFile != null && nativeFile.length() > 0) {
                                    return Files.newInputStream(Paths.get(nativeFile, new String[0]), StandardOpenOption.READ);
                                }
                                return null;
                            }
                        };
                        csvLoadfileItems.put(loadfileItem.getDocId(), loadfileItem);
                    }
                }
                catch (Exception e) {
                    ++this.recordsWithErrors;
                    this.logErrorWithLimit("Cannot handle CSV records,", e);
                }
            }
            LOGGER.info("Read " + rowNumber + " rows");
            int childrenCount = 0;
            int tlCount = 0;
            for (LoadfileItem csvLoadfileItem : csvLoadfileItems.values()) {
                String docId = csvLoadfileItem.getDocId();
                String familyId = csvLoadfileItem.getFamilyId();
                if (familyId == null) {
                    familyId = docId;
                }
                if (docId == null) {
                    this.logErrorWithLimit("Null docID");
                }
                if (docId.equals(familyId)) {
                    loadfile.addTopLevelItem(csvLoadfileItem);
                    ++tlCount;
                    continue;
                }
                LoadfileItem topLevelItem = (LoadfileItem)csvLoadfileItems.get(csvLoadfileItem.getFamilyId());
                if (topLevelItem == null) {
                    itemsWithErrors.add(docId);
                    loadfile.addTopLevelItem(csvLoadfileItem);
                    ++childrenCount;
                    continue;
                }
                topLevelItem.addChild(csvLoadfileItem);
                ++tlCount;
            }
            LOGGER.info("TL items: " + tlCount);
            LOGGER.info("Children items: " + childrenCount);
            LOGGER.info("Warnings: " + this.recordsWithErrors);
            this.totalTlRecordsCount.addAndGet(tlCount);
            AtomicLong itemsWithErrorsCount = new AtomicLong();
            loadfile.writeNli(outputZip, this.totalItemsProcessed, itemsWithErrorsCount, new DocIdErrorListener(){

                @Override
                public void onError(String docId, String message, Throwable t, boolean printToExecutionLog) {
                    if (docId != null) {
                        itemsWithErrors.add(docId);
                    } else {
                        itemsWithErrors.add(UidUtils.getRandom());
                    }
                    if (printToExecutionLog) {
                        ConvertLoadfileToNuixLogicalImageOperationImplementation.this.logErrorWithLimit(message, t);
                    }
                }

                @Override
                public void onError(String docId, String message) {
                    this.onError(docId, message, null, false);
                }
            });
            this.recordsWithErrors += (long)itemsWithErrors.size();
            this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.WroteNli", (Object)resultingNli.getFileName().toString()));
        }
    }

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                this.loadfile = this.executionContext.evalParameters(this.loadfile, this);
                this.nliFile = this.executionContext.evalParameters(this.nliFile, this);
                if (Files.exists(Paths.get(this.nliFile, new String[0]), new LinkOption[0])) {
                    throw new IOException(this.iu.getFormattedString("ConvertLoadfileToNuixLogicalImageOperation.Log.NuixLogicalImageFileAlreadyExists", (Object)this.nliFile));
                }
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.SourceLocation", (Object)this.loadfile));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.DestinationLocation", (Object)this.nliFile));
                this.totalRecordsCount = new AtomicLong();
                this.totalTlRecordsCount = new AtomicLong();
                this.totalItemsProcessed = new AtomicLong();
                this.convertLoadfile(Paths.get(this.loadfile, new String[0]));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExport.Log.Records", this.totalRecordsCount.get()));
                if (this.recordsWithErrors > 0L) {
                    this.addWarning(this.iu.getNumeralString("ConvertPurviewExport.Log.RecordsErrors", this.recordsWithErrors));
                }
                if (this.executionState != ExecutionState.ERROR) {
                    this.trackFinished();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
        this.startTriggerThread.join();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L) {
            double progress = (double)this.totalItemsProcessed.get() / (double)this.totalTlRecordsCount.get();
            return progress;
        }
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L) {
            result = (String)result + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.totalItemsProcessed.get());
        }
        return result;
    }
}

