/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import au.com.bytecode.opencsv.CSVReader;
import com.aspose.email.ExceptionManager;
import com.aspose.email.MapiMessage;
import com.aspose.email.MapiPropertyCollection;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.DocIdErrorListener;
import com.nuix.automate.workflow.core.execution.operations.ConvertPurviewAdvancedOperation;
import com.nuix.automate.workflow.core.execution.operations.ConvertPurviewCdsOperation;
import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsAttachmentType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversation;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsCustomMetadata;
import com.nuix.automate.workflow.core.utils.cds.CdsFileClassType;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsOperationException;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageParser;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFile;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFile;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFolder;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportZip;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.loadfile.CdsLoadFileItem;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileHandler;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import jakarta.mail.internet.InternetAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.joda.time.ReadableInstant;

public class ConvertPurviewAdvancedOperationImplementation
extends ConvertPurviewAdvancedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConvertPurviewCdsOperation.class);
    private final transient Set<String> custodians = new HashSet<String>();
    private final transient Set<String> custodiansCompleted = new HashSet<String>();
    private final transient Set<String> custodiansWithErrors = new HashSet<String>();
    private final transient List<PurviewReportFile> purviewReportFiles = new ArrayList<PurviewReportFile>();
    private final transient List<PurviewExportFile> purviewExportFiles = new ArrayList<PurviewExportFile>();
    private transient int stageNumber;
    private transient LoadfileHandler loadfileHandler;
    private final transient AtomicLong totalRowCount = new AtomicLong();
    private transient AtomicLong currentRowCount;
    private transient AtomicLong custodianRecordsCount;
    private transient AtomicLong custodianTlItemsCount;
    private transient AtomicLong custodianTlItemsProcessed;
    private transient AtomicLong globalItemsWithErrors;
    private transient AtomicLong custodianMissingNativeFiles;
    private transient Set<String> purviewExportsWithErrors;
    private transient Map<String, CdsLoadFileItem> loadFileItems;
    private transient Set<String> attachedAttachments;
    private transient Map<String, CdsLoadFileItem> attachmentLoadFileItems;
    private transient Map<String, Set<String>> parentIdToAttachmentItemIds;
    private transient Map<String, Set<String>> modernParentIdToAttachmentItemIds;
    private transient Map<String, Set<String>> familyIdToAttachmentItemIds;
    private final transient Map<String, String> normalizedTeamNames = new HashMap<String, String>();
    private transient Map<String, CdsConversation> conversationParents;
    private transient Map<String, LoadfileItem> channelLoadfileItems;
    private transient Map<String, String> custodianColumnToNormalizedValue = new HashMap<String, String>();
    private transient DocIdErrorListener docIdErrorListener;
    private transient String purviewFileName;

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                AsposeUtils.applyAsposeEmailLicense();
                try {
                    ExceptionManager.setIgnoreAll((boolean)true);
                    ExceptionManager.setIgnoreExceptionsLogHandler(message -> LOGGER.warn("Ignored Aspose exception: " + message));
                }
                catch (Throwable t) {
                    LOGGER.warn("Unable to disable Aspose Email parser exceptions");
                }
                this.purviewExportLocation = this.executionContext.evalParameters(this.purviewExportLocation, this);
                this.resultingNliLocation = this.executionContext.evalParameters(this.resultingNliLocation, this);
                this.errorLogFileLocation = this.executionContext.evalParameters(this.errorLogFileLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.SourceLocation", (Object)this.purviewExportLocation));
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DestinationLocation", (Object)this.resultingNliLocation));
                if (this.ignoreMissingNativeFiles) {
                    this.addExecutionLog(this.iu.getString("ConvertPurviewExportOperation.Log.IgnoreMissingNativeFiles"));
                }
                this.globalItemsWithErrors = new AtomicLong();
                this.docIdErrorListener = new DocIdErrorListener(){
                    boolean hasErrors = false;

                    @Override
                    public synchronized void onError(String docId, String message, Throwable t, boolean printToExecutionLog) {
                        if (ConvertPurviewAdvancedOperationImplementation.this.writeErrorLog) {
                            if (!this.hasErrors) {
                                try {
                                    FileUtils.writeToFile((String)"FileName,DocID,Error Message,Exception\n", (Path)Paths.get(ConvertPurviewAdvancedOperationImplementation.this.errorLogFileLocation, new String[0]));
                                }
                                catch (IOException e) {
                                    LOGGER.error("Cannot write error log file header", (Throwable)e);
                                }
                            }
                            try {
                                String line = FormattingUtils.encodeForCsv((String)ConvertPurviewAdvancedOperationImplementation.this.purviewFileName) + "," + FormattingUtils.encodeForCsv((String)docId) + "," + FormattingUtils.encodeForCsv((String)message) + ",";
                                if (t != null) {
                                    line = line + FormattingUtils.encodeForCsv((String)ExceptionUtils.getStackTrace((Throwable)t));
                                }
                                FileUtils.appendToFile((String)(line + "\n"), (Path)Paths.get(ConvertPurviewAdvancedOperationImplementation.this.errorLogFileLocation, new String[0]));
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot write error log file line", (Throwable)e);
                            }
                        }
                        ConvertPurviewAdvancedOperationImplementation.this.globalItemsWithErrors.incrementAndGet();
                        this.hasErrors = true;
                        LOGGER.error("Purview Export Conversion Error handling " + docId + ", " + message, t);
                    }

                    @Override
                    public void onError(String docId, String message) {
                        this.onError(docId, message, null, false);
                    }
                };
                Path nliOutputFolder = Paths.get(this.resultingNliLocation, new String[0]);
                if (Files.exists(nliOutputFolder, new LinkOption[0])) {
                    if (!Files.isDirectory(nliOutputFolder, new LinkOption[0])) {
                        throw new CdsOperationException(this.iu.getString("ConvertPurviewExportOperation.Error.DestinationNotFolder"));
                    }
                    if (!FileUtils.isDirectoryEmpty((Path)nliOutputFolder)) {
                        throw new CdsOperationException(this.iu.getString("ConvertPurviewExportOperation.Error.DestinationFolderNotEmpty"));
                    }
                }
                Files.createDirectories(nliOutputFolder, new FileAttribute[0]);
                Path exportFolderPath = Paths.get(this.purviewExportLocation, new String[0]);
                this.purviewReportFiles.addAll(this.scanForCdsExports(exportFolderPath));
                if (this.purviewReportFiles.isEmpty()) {
                    throw new CdsOperationException(this.iu.getFormattedString("ConvertPurviewAdvancedOperation.Error.UnableToDetectReportFiles", new Object[]{this.purviewExportLocation, this.purviewReportZipRegex}));
                }
                if (this.purviewReportFiles.get(0).getItemsHandler().getPurviewExports().isEmpty()) {
                    throw new CdsOperationException(this.iu.getFormattedString("ConvertPurviewAdvancedOperation.Error.UnableToDetectExportFiles", new Object[]{this.purviewExportLocation, this.purviewItemsZipRegex}));
                }
                HashSet<String> userProvidedColumns = new HashSet<String>(Arrays.asList(this.docIdColumn, this.immutableIdColumn, this.familyIdColumn, this.parentIdColumn, this.pathColumn, this.locationColumn, this.locationNameColumn, this.custodianColumn, this.inputPathColumn, this.fileClassColumn, this.itemClassColumn, this.nativeFileColumn, this.dateColumn, this.modernParentIdColumn, this.fileExtensionColumn, this.conversationIdColumn, this.conversationTypeColumn, this.senderColumn, this.recipientsColumn, this.recipientCountColumn, this.subjectColumn, this.documentLastModifiedDateColumn, this.documentCreatedDateColumn, this.teamNameColumn, this.channelNameColumn, this.messageKindColumn, this.hashColumn));
                Iterator<PurviewReportFile> exportFileIterator = this.purviewReportFiles.iterator();
                while (exportFileIterator.hasNext()) {
                    PurviewReportFile purviewReportFile = exportFileIterator.next();
                    this.purviewFileName = purviewReportFile.getName();
                    purviewReportFile.populateHeadersAndCustodians(this.custodianColumn);
                    if (purviewReportFile.getHeaders() == null || purviewReportFile.getHeaders().isEmpty()) {
                        this.addWarning(this.iu.getFormattedString("ConvertPurviewAdvancedOperation.Error.ExportMissingHeaders", (Object)purviewReportFile.getPath()));
                        exportFileIterator.remove();
                        continue;
                    }
                    if (purviewReportFile.getCustodians() == null || purviewReportFile.getCustodians().isEmpty()) {
                        this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Error.CouldNotFindCustodianColumn", (Object)purviewReportFile.getPath()));
                        exportFileIterator.remove();
                        continue;
                    }
                    HashSet<String> missingUserProvidedColumns = new HashSet<String>(userProvidedColumns);
                    block28: for (String header : purviewReportFile.getHeaders()) {
                        if (missingUserProvidedColumns.remove(header)) continue;
                        for (String userHeader : missingUserProvidedColumns) {
                            if (!header.matches(userHeader)) continue;
                            missingUserProvidedColumns.remove(userHeader);
                            continue block28;
                        }
                    }
                    if (!missingUserProvidedColumns.isEmpty()) {
                        String missingColumnNames = String.join((CharSequence)", ", missingUserProvidedColumns);
                        this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Warning.ExportMissingColumns", new Object[]{purviewReportFile.getPath(), missingColumnNames}));
                    }
                    this.custodians.addAll(purviewReportFile.getCustodians());
                    this.totalRowCount.addAndGet(purviewReportFile.getRecordCount());
                }
                if (this.normalizeCustodianColumnToEmail) {
                    Map purviewCustodians = this.executionContext.evalJsonParameter("{purview_custodians}", Map.class, this);
                    Map purviewCustodialDataSources = this.executionContext.evalJsonParameter("{purview_custodial_data_sources}", Map.class, this);
                    if (purviewCustodians != null && purviewCustodialDataSources != null) {
                        String custodianEmail;
                        for (Object value : purviewCustodians.values()) {
                            Map map = (Map)value;
                            custodianEmail = (String)map.get("email");
                            String upn = (String)map.get("upn");
                            if (custodianEmail == null || upn == null) continue;
                            this.custodianColumnToNormalizedValue.putIfAbsent(upn, custodianEmail);
                        }
                        for (Iterator<String> custodianId : purviewCustodialDataSources.keySet()) {
                            Map map = (Map)purviewCustodians.get(custodianId);
                            custodianEmail = (String)map.get("email");
                            if (custodianEmail == null) continue;
                            Map dataSources = (Map)purviewCustodialDataSources.get(custodianId);
                            for (Map dataSource : dataSources.values()) {
                                String dataSourceId = (String)dataSource.get("id");
                                if (dataSourceId == null) continue;
                                this.custodianColumnToNormalizedValue.putIfAbsent(dataSourceId, custodianEmail);
                            }
                        }
                        Iterator<PurviewReportFile> normalizedCustodians = new HashSet<String>();
                        for (String string : this.custodians) {
                            String normalizedCustodian = this.custodianColumnToNormalizedValue.getOrDefault(string, string);
                            normalizedCustodians.add((PurviewReportFile)((Object)normalizedCustodian));
                        }
                        this.custodians.clear();
                        this.custodians.addAll((Collection<String>)((Object)normalizedCustodians));
                    }
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExportOperation.Log.FoundCustodians", (long)this.custodians.size()));
                this.custodianMissingNativeFiles = new AtomicLong();
                for (String custodian : this.custodians) {
                    LOGGER.info("Converting Purview export for custodian: " + custodian);
                    this.currentRowCount = new AtomicLong();
                    this.custodianRecordsCount = new AtomicLong();
                    this.custodianTlItemsCount = new AtomicLong();
                    this.custodianTlItemsProcessed = new AtomicLong();
                    this.purviewExportsWithErrors = new HashSet<String>();
                    this.loadFileItems = new LinkedHashMap<String, CdsLoadFileItem>();
                    this.attachmentLoadFileItems = new LinkedHashMap<String, CdsLoadFileItem>();
                    this.attachedAttachments = new HashSet<String>();
                    this.parentIdToAttachmentItemIds = new LinkedHashMap<String, Set<String>>();
                    this.modernParentIdToAttachmentItemIds = new LinkedHashMap<String, Set<String>>();
                    this.familyIdToAttachmentItemIds = new LinkedHashMap<String, Set<String>>();
                    this.conversationParents = new LinkedHashMap<String, CdsConversation>();
                    this.channelLoadfileItems = new HashMap<String, LoadfileItem>();
                    this.loadfileHandler = this.initializeLoadfile();
                    this.stageNumber = 1;
                    for (PurviewReportFile purviewReportFile : this.purviewReportFiles) {
                        try {
                            LOGGER.info("Converting export: " + String.valueOf(purviewReportFile.getPath()));
                            this.convertCdsExport(purviewReportFile, custodian);
                        }
                        catch (IOException iOException) {
                            this.purviewExportsWithErrors.add(purviewReportFile.getName());
                            LOGGER.error("Error converting CDS export: " + String.valueOf(purviewReportFile.getPath()), (Throwable)iOException);
                        }
                    }
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    AtomicLong childrenCount = new AtomicLong();
                    this.stageNumber = 2;
                    this.buildLoadFileFamilies(this.loadfileHandler, childrenCount);
                    this.custodianTlItemsCount.set(this.loadfileHandler.getTopLevelItem().size());
                    LOGGER.info("TL items: " + this.custodianTlItemsCount.get());
                    LOGGER.info("Children items: " + childrenCount.get());
                    LOGGER.info("Warnings: " + this.globalItemsWithErrors.get());
                    this.loadfileHandler.splitLoadfiles(this.exportSplit, this.exportSplitAt);
                    for (int i = 0; i < this.loadfileHandler.getLoadFiles().size(); ++i) {
                        Path nliPath;
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Loadfile loadfile = this.loadfileHandler.getLoadFiles().get(i);
                        try {
                            String exportFolderName = exportFolderPath.getFileName().toString();
                            nliPath = this.getNliOutputPath(nliOutputFolder, custodian, exportFolderName, i);
                        }
                        catch (FileTraversalException e) {
                            LOGGER.error("File traversal error when getting NLI path for custodian: " + custodian, (Throwable)e);
                            this.custodiansWithErrors.add(custodian);
                            continue;
                        }
                        this.exportNli(loadfile, nliPath);
                        if (i == 0) {
                            this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExportOperation.Log.CustodianRecords", this.custodianRecordsCount.get()));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.NliOutputLocation", (Object)nliPath));
                    }
                    this.custodiansCompleted.add(custodian);
                }
                if (this.globalItemsWithErrors.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("ConvertPurviewExportOperation.Log.CustodianRecordErrors", this.globalItemsWithErrors.get()));
                    if (this.writeErrorLog) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.ErrorLogFile", (Object)this.errorLogFileLocation));
                    }
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExport.Log.Loadfiles", (long)this.purviewReportFiles.size()));
                if (this.executionState != ExecutionState.ERROR) {
                    this.trackFinished();
                }
                if (this.purviewReportFiles == null) return;
            }
            catch (CdsOperationException e) {
                LOGGER.error("Error during CDS conversion", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            finally {
                if (this.purviewReportFiles == null) return;
                for (PurviewReportFile purviewReportFile : this.purviewReportFiles) {
                    try {
                        purviewReportFile.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error closing cdsExportFile", (Throwable)e);
                    }
                }
                return;
            }
            for (PurviewReportFile purviewReportFile : this.purviewReportFiles) {
                try {
                    purviewReportFile.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing cdsExportFile", (Throwable)e);
                }
            }
            return;
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
        this.startTriggerThread.join();
    }

    private List<PurviewReportFile> scanForCdsExports(Path folderPath) throws IOException {
        try (Stream<Path> exportFileStream = Files.list(folderPath);){
            String extractedFolderRegex;
            Object zipRegex;
            if (this.purviewReportZipRegex.endsWith("\\.zip")) {
                zipRegex = this.purviewReportZipRegex;
                extractedFolderRegex = this.purviewReportZipRegex.substring(0, this.purviewReportZipRegex.length() - "\\.zip".length());
            } else {
                zipRegex = this.purviewReportZipRegex + "\\.zip";
                extractedFolderRegex = this.purviewReportZipRegex;
            }
            ArrayList<PurviewReportZip> exportFiles = new ArrayList<PurviewReportZip>();
            for (Path exportFilePath : exportFileStream.collect(Collectors.toList())) {
                if (this.stopRequested) {
                    this.trackStopped();
                    break;
                }
                try {
                    String fileName = exportFilePath.getFileName().toString();
                    String fileExtension = FileUtils.getFileExtension((String)fileName);
                    PurviewReportFile purviewExportFile = null;
                    if (!Files.isDirectory(exportFilePath, new LinkOption[0]) && !fileExtension.equalsIgnoreCase("zip")) continue;
                    if (fileName.matches((String)zipRegex)) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DetectedZip", (Object)fileName));
                        purviewExportFile = new PurviewReportZip(exportFilePath);
                    } else if (fileName.matches(extractedFolderRegex)) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DetectedExport", (Object)fileName));
                        purviewExportFile = new PurviewReportFolder(exportFilePath);
                    }
                    if (purviewExportFile == null) continue;
                    exportFiles.add((PurviewReportZip)purviewExportFile);
                    purviewExportFile.findAndSetLoadfileName(this.purviewReportItemsRegex);
                    for (String loadfileName : purviewExportFile.getLoadfileNames()) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewAdvancedOperation.Log.FoundLoadFile", (Object)String.valueOf(loadfileName)));
                    }
                    if (purviewExportFile.getLoadfileNames().isEmpty()) {
                        throw new IOException(this.iu.getFormattedString("ConvertPurviewExportOperation.Error.CannotDetectZipLoadfile", (Object)exportFilePath));
                    }
                    purviewExportFile.scanForItemExports(this.purviewItemsZipRegex, this.purviewPstZipRegex);
                    if (purviewExportFile.getItemsHandler().getPurviewExports().isEmpty()) {
                        throw new IOException(this.iu.getFormattedString("ConvertPurviewExportOperation.Error.UnableToDetectPurviewExportFiles", (Object)exportFilePath.getParent()));
                    }
                    FileTime loadfileLastModifiedTime = purviewExportFile.getFileTime();
                    Calendar staleLoadfileDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    staleLoadfileDate.set(2024, 5, 1, 0, 0, 0);
                    if (loadfileLastModifiedTime == null || loadfileLastModifiedTime.toMillis() > staleLoadfileDate.getTimeInMillis()) continue;
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewCdsOperation.Warning.DetectedOldExport", new Object[]{exportFilePath, loadfileLastModifiedTime.toString()}));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot handle export/report file " + String.valueOf(exportFilePath), (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.CannotReadPurviewExport", new Object[]{exportFilePath, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                }
            }
            ArrayList<PurviewReportZip> arrayList = exportFiles;
            return arrayList;
        }
    }

    private LoadfileHandler initializeLoadfile() {
        int fieldOffset = 0;
        ArrayList<LoadFileField> loadFileFields = new ArrayList<LoadFileField>();
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.MIME_TYPE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.NATIVE_HOLDS_ITEM_TEXT, "Boolean", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CONVERSATION_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CHAT_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.REACTION_TYPE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.COMMUNICATION_PARTICIPANTS, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.COMMUNICATION_DATE, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.FROM, "Text", true, fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.TO, "Text", true, fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.FLAG_DELETED, "Boolean", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.ITEM_DATE, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CREATED_DATE_TIME, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.LAST_MODIFIED_DATE_TIME, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CONVERSATION_REFERENCE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.MESSAGE_REFERENCES, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.MESSAGE_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.SYSTEM_MESSAGE_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CDS_FILE_TYPE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.NUMBER_OF_PARTICIPANTS, "Integer", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.SENDER, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.SUBJECT_LINE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.ATTACHMENT_TYPE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.COPILOT_APPLICATION, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.DELETED_DATE_TIME, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.ORIGINAL_MESSAGE_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.MESSAGE_REVISION, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CALL_START_TIME, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CALL_END_TIME, "DateTime", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CALL_ID, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CALL_DURATION, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.RECORDING_URL, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.TRANSCRIPT_URL, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.RECORDING_DURATION, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.RECORDING_EXPORT_URL, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.RECORDING_NAME, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.RECORDING_FILE_NAME, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.CHAT_PARTICIPANTS, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.FAILURE_MESSAGE, "Text", fieldOffset++));
        loadFileFields.add(new LoadFileField(CdsCustomMetadata.FAILURE_DETAIL, "Text", fieldOffset++));
        List<LoadFileField> loadFileHeaders = this.parseCdsExportLoadfileHeaders(fieldOffset);
        loadFileFields.addAll(loadFileHeaders);
        return new LoadfileHandler(loadFileFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void convertCdsExport(PurviewReportFile purviewReportFile, String custodian) throws IOException {
        long rowNumber = 0L;
        for (InputStream loadfileInputStream : purviewReportFile.getLoadfileInputStreams()) {
            try {
                CSVReader csvReader = CdsUtils.buildCsvReader(loadfileInputStream);
                try {
                    String[] rowValues;
                    HashMap<Integer, String> indexToColumnName = new HashMap<Integer, String>();
                    List<String> partialPreviousRowValuesList = null;
                    String[] headers = csvReader.readNext();
                    int columnsCount = headers.length;
                    int custodianColumnIndex = -1;
                    for (int i = 0; i < headers.length; ++i) {
                        String columnName = headers[i];
                        indexToColumnName.put(i, columnName);
                        if (!columnName.equals(this.custodianColumn)) continue;
                        custodianColumnIndex = i;
                    }
                    ArrayList<List<String>> rows = new ArrayList<List<String>>();
                    while ((rowValues = csvReader.readNext()) != null) {
                        block29: {
                            if (!this.stopRequested) break block29;
                            this.trackStopped();
                            return;
                        }
                        try {
                            String string;
                            ++rowNumber;
                            this.currentRowCount.incrementAndGet();
                            List<String> rowValuesList = Arrays.asList(rowValues);
                            if (partialPreviousRowValuesList != null) {
                                int i;
                                String string3 = (String)partialPreviousRowValuesList.get(partialPreviousRowValuesList.size() - 1);
                                string3 = string3 + "\n" + rowValuesList.get(0);
                                ArrayList<String> mergedRowValuesList = new ArrayList<String>();
                                for (i = 0; i < partialPreviousRowValuesList.size() - 1; ++i) {
                                    mergedRowValuesList.add(partialPreviousRowValuesList.get(i));
                                }
                                mergedRowValuesList.add(string3);
                                for (i = 1; i < rowValuesList.size(); ++i) {
                                    mergedRowValuesList.add(rowValuesList.get(i));
                                }
                                rowValuesList = mergedRowValuesList;
                            }
                            if (rowValuesList.size() < columnsCount) {
                                partialPreviousRowValuesList = rowValuesList;
                                LOGGER.warn("Row " + rowNumber + " has " + rowValues.length + " columns instead of " + columnsCount + ", merging with next line");
                                continue;
                            }
                            partialPreviousRowValuesList = null;
                            Object var16_23 = null;
                            if (custodianColumnIndex >= 0 && custodianColumnIndex < rowValuesList.size() && (string = rowValuesList.get(custodianColumnIndex)) != null) {
                                String string4 = this.custodianColumnToNormalizedValue.getOrDefault(string, string);
                                rowValuesList.set(custodianColumnIndex, string4);
                            }
                            boolean parseRow = false;
                            if (custodian == null) {
                                parseRow = true;
                            } else {
                                void var16_26;
                                if (custodian.equalsIgnoreCase((String)var16_26)) {
                                    parseRow = true;
                                }
                                if (var16_26 == null && custodian.trim().isEmpty()) {
                                    parseRow = true;
                                }
                            }
                            if (!parseRow) continue;
                            if (!rowValuesList.isEmpty() && rowValuesList.get(0).startsWith("\ufeff")) {
                                String temp = rowValuesList.get(0).substring(1);
                                rowValuesList.set(0, temp);
                            }
                            rows.add(rowValuesList);
                        }
                        catch (Exception e) {
                            this.docIdErrorListener.onError("N/A", "Cannot parse CSV record " + rowNumber, e, false);
                            this.purviewExportsWithErrors.add(purviewReportFile.getName());
                        }
                    }
                    try {
                        rows.sort((o1, o2) -> {
                            int length = Math.min(o1.size(), o2.size());
                            for (int i = 0; i < length; ++i) {
                                String headerName = headers[i];
                                if (headerName == null || !headerName.equals(this.dateColumn)) continue;
                                return ((String)o1.get(i)).compareTo((String)o2.get(i));
                            }
                            return Integer.compare(o1.size(), o2.size());
                        });
                        for (List list : rows) {
                            Map<String, String> rowValueMap = this.buildRowValueMap(indexToColumnName, list);
                            this.parseCdsLoadfileRowValues(purviewReportFile, rowValueMap);
                        }
                    }
                    catch (Exception e) {
                        this.docIdErrorListener.onError("N/A", "Cannot sort records", e, false);
                        this.purviewExportsWithErrors.add(purviewReportFile.getName());
                    }
                }
                finally {
                    if (csvReader == null) continue;
                    csvReader.close();
                }
            }
            finally {
                LOGGER.info("Read " + rowNumber + " rows");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void parseCdsLoadfileRowValues(PurviewReportFile purviewReportFile, Map<String, String> rowValueMap) throws IOException {
        block37: {
            cdsItem = new CdsItem();
            addedLoadfile = false;
            try {
                block42: {
                    block40: {
                        block38: {
                            block39: {
                                block43: {
                                    block41: {
                                        cdsItem.setItemClass(this.getRowValueOrDefault(rowValueMap, this.itemClassColumn));
                                        cdsItem.setImmutableId(this.getRowValueOrDefault(rowValueMap, this.immutableIdColumn));
                                        cdsItem.setInputPath(this.getRowValueOrDefault(rowValueMap, this.inputPathColumn));
                                        cdsItem.setFileClass(CdsFileClassType.getFileClassFromValue(this.getRowValueOrDefault(rowValueMap, this.fileClassColumn), cdsItem.getItemClass()));
                                        fileClass = cdsItem.getFileClass();
                                        if (cdsItem.isIgnorableAttachment()) {
                                            return;
                                        }
                                        cdsItem.setDocumentId(this.getRowValueOrDefault(rowValueMap, this.docIdColumn));
                                        cdsItem.setFamilyId(this.getRowValueOrDefault(rowValueMap, this.familyIdColumn));
                                        cdsItem.setFileId(cdsItem.getDocumentId());
                                        cdsItem.setParentId(this.getRowValueOrDefault(rowValueMap, this.parentIdColumn));
                                        cdsItem.setPath(this.getRowValueOrDefault(rowValueMap, this.pathColumn));
                                        cdsItem.setFileLocation(this.getRowValueOrDefault(rowValueMap, this.locationColumn));
                                        cdsItem.setLocationName(this.getRowValueOrDefault(rowValueMap, this.locationNameColumn));
                                        cdsItem.setCustodian(this.getRowValueOrDefault(rowValueMap, this.custodianColumn));
                                        nativeExtension = this.getRowValueOrDefault(rowValueMap, this.nativeExtensionColumn);
                                        cdsItem.setNativeExportPath(this.getRowValueOrDefault(rowValueMap, this.nativeFileColumn));
                                        cdsItem.setFileExtension(this.getRowValueOrDefault(rowValueMap, this.fileExtensionColumn));
                                        cdsItem.setModernParentId(this.getRowValueOrDefault(rowValueMap, this.modernParentIdColumn));
                                        cdsItem.setInternetMessageId(this.getRowValueOrDefault(rowValueMap, this.internetMessageId));
                                        cdsItem.setHash(this.getRowValueOrDefault(rowValueMap, this.hashColumn));
                                        if (this.reduceNoise) {
                                            uniqueExtensions = new HashSet<String>();
                                            for (String extension : this.noiseExtensions) {
                                                uniqueExtensions.add(extension.toLowerCase().replace(".", ""));
                                            }
                                            isNoiseFile = uniqueExtensions.contains(cdsItem.getFileExtension().toLowerCase().replace(".", ""));
                                            isExtensionDifferent = cdsItem.getFileExtension().replace(".", "").equalsIgnoreCase(nativeExtension.replace(".", "")) == false;
                                            compoundPathStartsWithInputPath = cdsItem.getPath().startsWith(cdsItem.getInputPath());
                                            suffixPath = cdsItem.getPath().replace(cdsItem.getInputPath(), "");
                                            v0 = suffixPathHasFolders = suffixPath.contains("/") != false || suffixPath.contains("\\") != false;
                                            if (isNoiseFile && isExtensionDifferent && compoundPathStartsWithInputPath && suffixPathHasFolders) {
                                                ConvertPurviewAdvancedOperationImplementation.LOGGER.warn("Skipped processing noise item " + cdsItem.getFileId());
                                                return;
                                            }
                                        }
                                        is = this.getPurviewFileInputStream(purviewReportFile, cdsItem);
                                        try {
                                            if (is == null && !this.ignoreMissingNativeFiles && cdsItem.getNativeExportPath() != null && !cdsItem.getNativeExportPath().isEmpty()) {
                                                this.docIdErrorListener.onError(cdsItem.getFileId(), "Missing native file " + cdsItem.getNativeExportPath(), null, false);
                                                this.custodianMissingNativeFiles.incrementAndGet();
                                                cdsItem.setFailureMessage("Missing native file");
                                                cdsItem.setFailureDetail("Native file does not exist: " + cdsItem.getNativeExportPath());
                                            }
                                        }
                                        finally {
                                            if (is != null) {
                                                is.close();
                                            }
                                        }
                                        cdsItem.formatAndSetConversationId(this.getRowValueOrDefault(rowValueMap, this.conversationIdColumn));
                                        cdsItem.setConversationType(this.getRowValueOrDefault(rowValueMap, this.conversationTypeColumn));
                                        cdsItem.setTeamAndChannelName(this.getRowValueOrDefault(rowValueMap, this.teamNameColumn), this.getRowValueOrDefault(rowValueMap, this.channelNameColumn));
                                        cdsItem.setMessageKind(this.getRowValueOrDefault(rowValueMap, this.messageKindColumn));
                                        emailSender = this.getRowValueOrDefault(rowValueMap, this.senderColumn);
                                        cdsItem.setSender(AddressUtils.parseAddress(emailSender));
                                        if (cdsItem.isCopilotItem()) {
                                            cdsItem.updateCopilotApplication();
                                            if (emailSender != null && emailSender.startsWith("Copilot in")) {
                                                cdsItem.setSender(AddressUtils.getCopilotAddress(cdsItem.getCopilotApplication()));
                                            }
                                        }
                                        emailRecipients = this.getRowValueOrDefault(rowValueMap, this.recipientsColumn);
                                        cdsItem.setRecipients(AddressUtils.parseAddresses(emailRecipients));
                                        cdsItem.setSubjectLine(this.getRowValueOrDefault(rowValueMap, this.subjectColumn));
                                        cdsItem.setDate(this.getRowValueOrDefault(rowValueMap, this.dateColumn));
                                        if ((cdsItem.getDate() == null || cdsItem.getDate().isBefore(0L)) && (dateTime = CdsUtils.parseDateFromLoadFile(lastModifiedDate = this.getRowValueOrDefault(rowValueMap, this.officeDateLastModified))) != null && dateTime.isAfter(0L)) {
                                            cdsItem.setDate(dateTime);
                                        }
                                        if (cdsItem.getFileClass() == CdsFileClassType.DOCUMENT || cdsItem.getFileClass() == CdsFileClassType.ATTACHMENT) {
                                            cdsItem.setDocumentCreatedDateTime(this.getRowValueOrDefault(rowValueMap, this.documentCreatedDateColumn));
                                            cdsItem.setDocumentLastModified(this.getRowValueOrDefault(rowValueMap, this.documentLastModifiedDateColumn));
                                        }
                                        cdsItem.updateItemLocation();
                                        participants = new LinkedHashSet<InternetAddress>();
                                        if (cdsItem.getSender() != null) {
                                            participants.add(cdsItem.getSender());
                                        }
                                        participants.addAll(cdsItem.getRecipients());
                                        if (fileClass == CdsFileClassType.CONVERSATION) {
                                            this.handleCdsConversationItem(purviewReportFile, cdsItem, rowValueMap, participants);
                                            addedLoadfile = true;
                                            break block37;
                                        }
                                        if (fileClass != CdsFileClassType.DOCUMENT) break block41;
                                        cdsItem.setTeamsMessageType(CdsTeamsMessageType.DOCUMENT);
                                        break block42;
                                    }
                                    if (fileClass != CdsFileClassType.ATTACHMENT) break block43;
                                    cdsItem.setTeamsMessageType(CdsTeamsMessageType.ATTACHMENT);
                                    if (cdsItem.isModernAttachment()) {
                                        cdsItem.setAttachmentType(CdsAttachmentType.MODERN);
                                    } else {
                                        cdsItem.setAttachmentType(CdsAttachmentType.REGULAR);
                                    }
                                    break block42;
                                }
                                if (fileClass != CdsFileClassType.EMAIL) break block42;
                                cdsItem.setTeamsMessageType(CdsTeamsMessageType.EMAIL);
                                mapiMessage = null;
                                is = this.getPurviewFileInputStream(purviewReportFile, cdsItem);
                                if (!cdsItem.isMeetingOrCall()) ** GOTO lbl127
                                conversationLocation = CdsUtils.getFormattedConversationLocation(cdsItem);
                                parentLocation = conversationLocation + "/" + LoadfileItem.encodeFs(AddressUtils.render(participants));
                                conversationParent = this.getOrBuildSimpleConversationParent(cdsItem.getConversationId());
                                originalCustodian = cdsItem.getCustodian();
                                callEvents = new ArrayList<E>();
                                if (is != null) {
                                    callEvents = CdsTeamsMessageParser.getInstance().parseTeamsCallEvent(cdsItem, parentLocation, is);
                                }
                                if (callEvents == null || callEvents.isEmpty()) break block38;
                                for (CdsItem eventItem : callEvents) {
                                    eventConversationId = eventItem.getConversationId();
                                    eventConversationParent = eventConversationId != null && eventConversationId.trim().isEmpty() == false && eventConversationId.equalsIgnoreCase(cdsItem.getConversationId()) == false ? this.getOrBuildSimpleConversationParent(eventConversationId) : conversationParent;
                                    loadFileItem = this.buildLoadFileItem(eventItem, rowValueMap, true, false, false);
                                    eventConversationParent.addMessage(loadFileItem, originalCustodian, cdsItem.getLocationName());
                                    this.custodianRecordsCount.incrementAndGet();
                                }
                                if (is == null) break block39;
                                is.close();
                            }
                            CdsUtils.closeMapiMessage(mapiMessage);
                            return;
                        }
                        try {
                            break block40;
lbl127:
                            // 1 sources

                            mapiMessage = CdsUtils.loadEmail(is);
                            if (mapiMessage != null) {
                                namedProperties = mapiMessage.getNamedProperties();
                                this.updateConversationFromMsg(cdsItem, namedProperties);
                                CdsTeamsMessageParser.getInstance().parseMessageReactionFromMapi(cdsItem, namedProperties);
                            }
                            loadFileItem = this.buildLoadFileItem(cdsItem, rowValueMap, purviewReportFile, this.convertEmailsToEmlRfc5322, this.detachRegularAttachments, this.stubModernAttachments);
                            this.addLoadFileItem(loadFileItem);
                            this.custodianRecordsCount.incrementAndGet();
                            addedLoadfile = true;
                            messageReactions = CdsTeamsMessageParser.getInstance().generateMessageReactions(loadFileItem, true);
                            for (CdsItem messageReaction : messageReactions) {
                                reactionLoadFileItem = this.buildLoadFileItem(messageReaction, rowValueMap, true, false, false);
                                this.addLoadFileItem(reactionLoadFileItem);
                                this.custodianRecordsCount.incrementAndGet();
                            }
                            break block40;
                            {
                                catch (Throwable var12_28) {
                                    throw var12_28;
                                }
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                        catch (Throwable var22_43) {
                            CdsUtils.closeMapiMessage(mapiMessage);
                            throw var22_43;
                        }
                    }
                    CdsUtils.closeMapiMessage(mapiMessage);
                }
                if (!addedLoadfile) {
                    loadFileItem = this.buildLoadFileItem(cdsItem, rowValueMap, purviewReportFile, this.convertEmailsToEmlRfc5322, this.detachRegularAttachments, this.stubModernAttachments);
                    this.addLoadFileItem(loadFileItem);
                    this.custodianRecordsCount.incrementAndGet();
                    addedLoadfile = true;
                }
            }
            catch (Exception e) {
                if (addedLoadfile) break block37;
                cdsItem.setFailureMessage("Cannot handle item details");
                cdsItem.setFailureDetail("Error handling item details, " + ExceptionUtils.getStackTrace((Throwable)e));
                loadFileItem = this.buildLoadFileItem(cdsItem, rowValueMap, purviewReportFile, this.convertEmailsToEmlRfc5322, this.detachRegularAttachments, this.stubModernAttachments);
                this.addLoadFileItem(loadFileItem);
                this.custodianRecordsCount.incrementAndGet();
            }
        }
    }

    private void updateConversationFromMsg(CdsItem cdsItem, MapiPropertyCollection mapiProperties) {
        if (mapiProperties != null) {
            String mapiConversationType;
            String mapiChannelName;
            String mapiTeamName = CdsTeamsMessageParser.getTeamNameFromMapiProperties(mapiProperties);
            if (mapiTeamName != null && !mapiTeamName.trim().isEmpty()) {
                cdsItem.setTeamName(mapiTeamName);
            }
            if ((mapiChannelName = CdsTeamsMessageParser.getChannelNameFromMapiProperties(mapiProperties)) != null && !mapiChannelName.trim().isEmpty()) {
                cdsItem.setChannelName(mapiChannelName);
            }
            if ((mapiConversationType = CdsTeamsMessageParser.getConversationTypeFromMapiProperties(mapiProperties)) != null && !mapiConversationType.trim().isEmpty()) {
                cdsItem.setConversationType(mapiConversationType);
            }
            cdsItem.updateItemLocation();
            cdsItem.updateChannelNameIfGeneral();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleCdsConversationItem(PurviewReportFile purviewReportFile, CdsItem cdsItem, Map<String, String> rowValueMap, Set<InternetAddress> participants) throws IOException {
        MapiMessage mapiMessage;
        block22: {
            CdsConversation conversationParent;
            InputStream is;
            block23: {
                block24: {
                    CdsTeamsMessageType teamsMessageType;
                    CdsConversationMimeType childMessageMimeType;
                    CdsConversationMimeType parentConversationMimeType;
                    mapiMessage = null;
                    MapiPropertyCollection mapiProperties = null;
                    is = this.getPurviewFileInputStream(purviewReportFile, cdsItem);
                    if (cdsItem.isMsg() && is != null && (mapiMessage = CdsUtils.loadEmail(is)) != null) {
                        mapiProperties = mapiMessage.getNamedProperties();
                        this.updateConversationFromMsg(cdsItem, mapiProperties);
                    }
                    if (cdsItem.isYammerItem()) {
                        parentConversationMimeType = CdsConversationMimeType.YAMMER_CONVERSATION;
                        childMessageMimeType = CdsUtils.getYammerMessageType(cdsItem.getItemClass());
                        teamsMessageType = CdsTeamsMessageType.YAMMER_CONVERSATION;
                    } else if (cdsItem.isChannelItem()) {
                        parentConversationMimeType = CdsConversationMimeType.CHANNEL_CONVERSATION;
                        childMessageMimeType = CdsConversationMimeType.CHANNEL_MESSAGE;
                        teamsMessageType = CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION;
                    } else {
                        parentConversationMimeType = CdsConversationMimeType.CHAT_CONVERSATION;
                        childMessageMimeType = CdsConversationMimeType.CHAT_MESSAGE;
                        teamsMessageType = participants.size() > 2 ? CdsTeamsMessageType.TEAMS_CONVERSATION_MANY : CdsTeamsMessageType.TEAMS_CONVERSATION_ONE;
                    }
                    if (cdsItem.isCopilotItem()) {
                        teamsMessageType = CdsTeamsMessageType.COPILOT_CONVERSATION;
                        cdsItem.updateCopilotApplication();
                        participants.add(AddressUtils.getCopilotAddress(cdsItem.getCopilotApplication()));
                    }
                    cdsItem.setTeamsMessageType(teamsMessageType);
                    cdsItem.setConversationMimeType(childMessageMimeType);
                    conversationParent = this.getOrBuildConversationParent(cdsItem, parentConversationMimeType);
                    conversationParent.getFileIds().add(cdsItem.getDocumentId());
                    conversationParent.getImmutableIds().add(cdsItem.getImmutableId());
                    participants.removeAll(AddressUtils.getSystemEventAddresses());
                    conversationParent.appendParticipants(participants, cdsItem.getLocation());
                    if (is == null) {
                        CdsLoadFileItem messageLoadFileItem = this.buildLoadFileItem(new CdsItem(), rowValueMap, true, false, false);
                        conversationParent.addMessage(messageLoadFileItem, cdsItem);
                    }
                    if (cdsItem.isHtml()) {
                        String contents = "";
                        if (is != null) {
                            contents = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                        }
                        List<CdsItem> messages = CdsTeamsMessageParser.getInstance().parseHtmlGroupedMessages(conversationParent, cdsItem, contents);
                        for (CdsItem groupedMessage : messages) {
                            CdsLoadFileItem messageLoadFileItem = this.buildLoadFileItem(groupedMessage, rowValueMap, true, false, false);
                            conversationParent.addMessage(messageLoadFileItem, cdsItem);
                            this.addReactionsAsLoadfileItems(messageLoadFileItem, rowValueMap);
                            this.custodianRecordsCount.incrementAndGet();
                        }
                        break block22;
                    }
                    if (!cdsItem.isMsg()) break block22;
                    List<CdsItem> callEvents = CdsTeamsMessageParser.getInstance().getCallContentsFromMapi(cdsItem, mapiProperties);
                    String parentLocation = conversationParent.getRootItem().getLocation();
                    boolean callEventAdded = false;
                    if (callEvents != null && !callEvents.isEmpty()) {
                        for (CdsItem eventItem : callEvents) {
                            String chatMessageName = CdsTeamsMessageParser.getChatMessageName(eventItem);
                            eventItem.setLocation(parentLocation, chatMessageName);
                            CdsLoadFileItem loadFileItem = this.buildLoadFileItem(eventItem, rowValueMap, true, false, false);
                            String eventConversationId = eventItem.getConversationId();
                            CdsConversation eventConversationParent = eventConversationId != null && !eventConversationId.trim().isEmpty() && !eventConversationId.equalsIgnoreCase(cdsItem.getConversationId()) ? this.getOrBuildSimpleConversationParent(eventConversationId) : conversationParent;
                            eventConversationParent.addMessage(loadFileItem, cdsItem);
                            this.custodianRecordsCount.incrementAndGet();
                            callEventAdded = true;
                        }
                    }
                    if (!callEventAdded) break block23;
                    if (is == null) break block24;
                    is.close();
                }
                CdsUtils.closeMapiMessage(mapiMessage);
                return;
            }
            try {
                String originalCustodian = cdsItem.getCustodian();
                CdsTeamsMessageParser.getInstance().updateCdsItemFromMsg(conversationParent, cdsItem, mapiMessage);
                CdsLoadFileItem cdsLoadFileItem = this.buildLoadFileItem(cdsItem, rowValueMap, purviewReportFile, true, false, false);
                conversationParent.addMessage(cdsLoadFileItem, originalCustodian, cdsItem.getLocationName());
                this.addReactionsAsLoadfileItems(cdsLoadFileItem, rowValueMap);
                this.custodianRecordsCount.incrementAndGet();
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable) {
                CdsUtils.closeMapiMessage(mapiMessage);
                throw throwable;
            }
        }
        CdsUtils.closeMapiMessage(mapiMessage);
    }

    private void addReactionsAsLoadfileItems(CdsLoadFileItem cdsLoadFileItem, Map<String, String> rowValueMap) {
        List<CdsItem> messageReactions = CdsTeamsMessageParser.getInstance().generateMessageReactions(cdsLoadFileItem, false);
        for (CdsItem messageReaction : messageReactions) {
            CdsLoadFileItem reactionLoadFileItem = this.buildLoadFileItem(messageReaction, rowValueMap, true, false, false);
            this.attachedAttachments.add(reactionLoadFileItem.getDocId());
            cdsLoadFileItem.addChild(reactionLoadFileItem);
            this.custodianRecordsCount.incrementAndGet();
        }
    }

    public void exportNli(Loadfile loadfile, Path nliPath) throws IOException, ParserConfigurationException, TransformerException {
        AtomicLong zipItemsWithErrors = new AtomicLong(0L);
        try (ZipOutputStream outputZip = new ZipOutputStream(Files.newOutputStream(nliPath, new OpenOption[0]));){
            outputZip.setLevel(0);
            outputZip.setMethod(0);
            loadfile.writeNli(outputZip, this.custodianTlItemsProcessed, zipItemsWithErrors, this.docIdErrorListener);
        }
        LOGGER.info("Wrote NLI: " + String.valueOf(nliPath));
    }

    private Path getNliOutputPath(Path nliOutputFolder, String custodian, String exportFolderName, int i) throws FileTraversalException {
        String nliName = custodian == null ? exportFolderName : (custodian.trim().isEmpty() ? this.iu.getString("ConvertPurviewExportOperation.UnassignedCustodian") : custodian);
        nliName = FormattingUtils.sanitizeFilename((String)nliName);
        Object suffix = ".nli";
        if (this.exportSplit.booleanValue() && i > 0) {
            suffix = "_part" + i + ".nli";
        }
        Path nliOutputPath = FileUtils.safeResolveParent((Path)nliOutputFolder, (String[])new String[]{nliName + (String)suffix});
        while (Files.exists(nliOutputPath, new LinkOption[0])) {
            nliOutputPath = FileUtils.safeResolveParent((Path)nliOutputFolder, (String[])new String[]{nliName + "-" + UUID.randomUUID().toString().substring(0, 8) + (String)suffix});
        }
        return nliOutputPath;
    }

    public void buildLoadFileFamilies(LoadfileHandler loadfile, AtomicLong zipChildrenCount) {
        Map<String, LoadFileField> loadfileFields = loadfile.getLoadFileFields();
        HashSet<String> handledDocumentIds = new HashSet<String>();
        ArrayList<CdsLoadFileItem> conversationMessagesAndRoot = new ArrayList<CdsLoadFileItem>();
        for (CdsConversation conversation : this.conversationParents.values()) {
            try {
                CdsLoadFileItem attachment;
                LinkedHashMap<String, CdsLoadFileItem> conversationAttachmentLoadFileItems = new LinkedHashMap<String, CdsLoadFileItem>();
                HashSet<String> attachmentParentIds = new HashSet<String>(conversation.getImmutableIds());
                attachmentParentIds.addAll(conversation.getFileIds());
                Set<String> attachmentIds = this.getItemAttachmentItemIds(this.parentIdToAttachmentItemIds, attachmentParentIds.toArray(new String[0]));
                for (String string : attachmentIds) {
                    attachment = this.attachmentLoadFileItems.get(string);
                    if (attachment == null || attachment.getItem().getFileClass() != CdsFileClassType.ATTACHMENT) continue;
                    conversationAttachmentLoadFileItems.putIfAbsent(attachment.getDocId(), attachment);
                }
                attachmentIds = this.getItemAttachmentItemIds(this.modernParentIdToAttachmentItemIds, attachmentParentIds.toArray(new String[0]));
                for (String string : attachmentIds) {
                    attachment = this.attachmentLoadFileItems.get(string);
                    if (attachment == null || attachment.getItem().getFileClass() != CdsFileClassType.ATTACHMENT) continue;
                    conversationAttachmentLoadFileItems.putIfAbsent(attachment.getDocId(), attachment);
                }
                attachmentIds = this.getItemAttachmentItemIds(this.familyIdToAttachmentItemIds, attachmentParentIds.toArray(new String[0]));
                for (String string : attachmentIds) {
                    attachment = this.attachmentLoadFileItems.get(string);
                    if (attachment == null || attachment.getItem().getFileClass() != CdsFileClassType.ATTACHMENT) continue;
                    conversationAttachmentLoadFileItems.putIfAbsent(attachment.getDocId(), attachment);
                }
                for (Map.Entry entry : conversation.getUserMessages().entrySet()) {
                    if (conversation.getRootItem() == null || conversation.getUserMessages() == null || conversation.getUserMessages().isEmpty()) continue;
                    List messages = (List)entry.getValue();
                    messages.sort((o1, o2) -> {
                        if (o1.getItem().getDate() == null && o2.getItem().getDate() == null) {
                            return 0;
                        }
                        if (o1.getItem().getDate() == null) {
                            return 1;
                        }
                        if (o2.getItem().getDate() == null) {
                            return -1;
                        }
                        int dateSortResult = o1.getItem().getDate().compareTo((ReadableInstant)o2.getItem().getDate());
                        if (dateSortResult == 0) {
                            if (o1.getItem().isSystemMessage() && o2.getItem().isSystemMessage()) {
                                return 0;
                            }
                            if (o1.getItem().isSystemMessage()) {
                                return -1;
                            }
                            if (o2.getItem().isSystemMessage()) {
                                return 1;
                            }
                            if (o1.getItem().isCopilotItem() && o2.getItem().isCopilotItem()) {
                                if (o1.getItem().getTeamsMessageType() == CdsTeamsMessageType.COPILOT_QUESTION) {
                                    return -1;
                                }
                                if (o2.getItem().getTeamsMessageType() == CdsTeamsMessageType.COPILOT_QUESTION) {
                                    return 1;
                                }
                            }
                        }
                        return dateSortResult;
                    });
                    String user = (String)entry.getKey();
                    CdsLoadFileItem parentConversationLoadFileItem = this.createAndHandleUserMessageConversationRoot(conversation, user, messages);
                    conversationMessagesAndRoot.add(parentConversationLoadFileItem);
                    conversationMessagesAndRoot.addAll(messages);
                    HashSet<CallSite> nameHashes = new HashSet<CallSite>();
                    for (CdsLoadFileItem message : messages) {
                        CdsItem messageItem = message.getItem();
                        CdsItem conversationItem = parentConversationLoadFileItem.getItem();
                        String chatMessageName = CdsTeamsMessageParser.getChatMessageName(messageItem);
                        message.setLocation(conversationItem.getLocation(), chatMessageName);
                        Map<String, String> updatedFieldValues = CdsUtils.buildItemFieldValues(messageItem);
                        message.getFieldValueMap().putAll(updatedFieldValues);
                        parentConversationLoadFileItem.addChild(message);
                        zipChildrenCount.addAndGet(1 + message.getChildren().size());
                        if (!messageItem.getMessageAttachmentPaths().isEmpty()) {
                            block8: for (String attachmentPath : messageItem.getMessageAttachmentPaths()) {
                                boolean attachmentHandled = false;
                                for (CdsLoadFileItem attachment2 : conversationAttachmentLoadFileItems.values()) {
                                    CdsItem attachmentItem = attachment2.getItem();
                                    String utfConvert = this.getUtf8Value(attachmentItem.getInputPath());
                                    String windows1252Value = this.getWindows1252Value(attachmentItem.getInputPath());
                                    if ((attachmentItem.getInputPath().equals(attachmentPath) || utfConvert.equals(attachmentPath) || windows1252Value.equals(attachmentPath)) && handledDocumentIds.add(attachment2.getItem().getDocumentId()) && this.attachedAttachments.add(attachment2.getItem().getDocumentId())) {
                                        attachmentHandled = true;
                                        String nameHash = attachment2.getName() + "-" + attachmentItem.getHash();
                                        if (nameHashes.add((CallSite)((Object)nameHash))) {
                                            message.addChild(attachment2);
                                            zipChildrenCount.incrementAndGet();
                                        }
                                    }
                                    if (!attachmentHandled) continue;
                                    continue block8;
                                }
                            }
                        }
                        handledDocumentIds.addAll(this.addRegularAttachments(loadfile, zipChildrenCount, message, new HashSet<String>()));
                    }
                    handledDocumentIds.addAll(this.addRegularAttachments(loadfile, zipChildrenCount, parentConversationLoadFileItem, new HashSet<String>()));
                }
            }
            catch (Exception e) {
                this.custodianRecordsCount.incrementAndGet();
                LOGGER.warn("Error handling conversation", (Throwable)e);
            }
        }
        HashSet<String> nameHashes = new HashSet<String>();
        for (CdsLoadFileItem attachment : this.attachmentLoadFileItems.values()) {
            handledDocumentIds.addAll(this.addRegularAttachments(loadfile, zipChildrenCount, attachment, nameHashes));
        }
        for (CdsLoadFileItem loadFileItem : this.loadFileItems.values()) {
            handledDocumentIds.addAll(this.addRegularAttachments(loadfile, zipChildrenCount, loadFileItem, nameHashes));
            if (!handledDocumentIds.add(loadFileItem.getDocId())) continue;
            loadfile.addTopLevelItem(loadFileItem);
        }
        nameHashes = new HashSet();
        for (CdsLoadFileItem message : conversationMessagesAndRoot) {
            handledDocumentIds.addAll(this.addModernAttachments(loadfile, zipChildrenCount, message, nameHashes));
        }
        for (CdsLoadFileItem loadFileItem : this.loadFileItems.values()) {
            handledDocumentIds.addAll(this.addModernAttachments(loadfile, zipChildrenCount, loadFileItem, nameHashes));
            if (!handledDocumentIds.add(loadFileItem.getDocId())) continue;
            loadfile.addTopLevelItem(loadFileItem);
        }
        for (CdsLoadFileItem attachment : this.attachmentLoadFileItems.values()) {
            handledDocumentIds.addAll(this.addModernAttachments(loadfile, zipChildrenCount, attachment, nameHashes));
        }
        nameHashes = new HashSet();
        for (CdsLoadFileItem message : conversationMessagesAndRoot) {
            handledDocumentIds.addAll(this.addFamilyAttachments(loadfile, zipChildrenCount, message, nameHashes));
        }
        for (CdsLoadFileItem loadFileItem : this.loadFileItems.values()) {
            handledDocumentIds.addAll(this.addFamilyAttachments(loadfile, zipChildrenCount, loadFileItem, nameHashes));
            if (!handledDocumentIds.add(loadFileItem.getDocId())) continue;
            loadfile.addTopLevelItem(loadFileItem);
        }
        for (CdsLoadFileItem attachment : this.attachmentLoadFileItems.values()) {
            handledDocumentIds.addAll(this.addFamilyAttachments(loadfile, zipChildrenCount, attachment, nameHashes));
        }
        for (CdsLoadFileItem attachment : this.attachmentLoadFileItems.values()) {
            if (attachment.getItem() == null || attachment.getItem().getFileId() == null || this.attachedAttachments.contains(attachment.getItem().getFileId())) continue;
            attachment.getItem().setFailureMessage("Invalid family information");
            attachment.getItem().setFailureDetail("Purview Export item " + attachment.getItem().getDocumentId() + " references missing parrent " + attachment.getItem().getParentId());
            LOGGER.info("Missing family information for Purview Export item " + attachment.getItem().getDocumentId() + " with parent " + attachment.getItem().getParentId());
            loadfile.addTopLevelItem(attachment);
        }
    }

    private Set<String> addModernAttachments(LoadfileHandler loadfile, AtomicLong zipChildrenCount, CdsLoadFileItem cdsLoadFileItem, Set<String> nameHashes) {
        CdsItem cdsItem = cdsLoadFileItem.getItem();
        Set<String> attachmentIds = this.getItemAttachmentItemIds(this.modernParentIdToAttachmentItemIds, cdsItem.getImmutableId());
        HashSet<String> handledDocumentIds = new HashSet<String>();
        if (cdsLoadFileItem.getItem().isConversation()) {
            return handledDocumentIds;
        }
        for (String attachmentId : attachmentIds) {
            CdsLoadFileItem attachmentLoadFileItem = this.attachmentLoadFileItems.get(attachmentId);
            if (attachmentLoadFileItem == null || !handledDocumentIds.add(attachmentId) || !this.attachedAttachments.add(attachmentId)) continue;
            String nameHash = attachmentLoadFileItem.getName() + "-" + attachmentLoadFileItem.getItem().getHash();
            if (nameHashes.add(nameHash) || !cdsLoadFileItem.getItem().isCopilotItem()) {
                cdsLoadFileItem.addChild(attachmentLoadFileItem);
                zipChildrenCount.incrementAndGet();
                continue;
            }
            LOGGER.info("Skipping duplicate CoPilot attachment " + attachmentLoadFileItem.getItem().getFileId());
        }
        return handledDocumentIds;
    }

    private Set<String> addRegularAttachments(LoadfileHandler loadfile, AtomicLong zipChildrenCount, CdsLoadFileItem cdsLoadFileItem, Set<String> nameHashes) {
        CdsItem cdsItem = cdsLoadFileItem.getItem();
        Set<String> attachmentIds = this.getItemAttachmentItemIds(this.parentIdToAttachmentItemIds, cdsItem.getFileId());
        HashSet<String> handledDocumentIds = new HashSet<String>();
        if (cdsLoadFileItem.getItem().isConversation()) {
            return handledDocumentIds;
        }
        if (cdsItem.getModernParentId() != null && !cdsItem.getModernParentId().trim().isEmpty()) {
            return handledDocumentIds;
        }
        for (String attachmentId : attachmentIds) {
            CdsLoadFileItem attachmentLoadFileItem = this.attachmentLoadFileItems.get(attachmentId);
            if (attachmentLoadFileItem == null || !handledDocumentIds.add(attachmentId) || !this.attachedAttachments.add(attachmentId)) continue;
            String nameHash = attachmentLoadFileItem.getName() + "-" + attachmentLoadFileItem.getItem().getHash();
            if (nameHashes.add(nameHash) || !cdsLoadFileItem.getItem().isCopilotItem()) {
                cdsLoadFileItem.addChild(attachmentLoadFileItem);
                zipChildrenCount.incrementAndGet();
                continue;
            }
            LOGGER.info("Skipping duplicate CoPilot attachment " + attachmentLoadFileItem.getItem().getFileId());
        }
        return handledDocumentIds;
    }

    private Set<String> addFamilyAttachments(LoadfileHandler loadfile, AtomicLong zipChildrenCount, CdsLoadFileItem cdsLoadFileItem, Set<String> nameHashes) {
        CdsItem cdsItem = cdsLoadFileItem.getItem();
        Set<String> attachmentIds = this.getItemAttachmentItemIds(this.familyIdToAttachmentItemIds, cdsItem.getFileId());
        HashSet<String> handledDocumentIds = new HashSet<String>();
        if (cdsLoadFileItem.getItem().isConversation()) {
            return handledDocumentIds;
        }
        for (String attachmentId : attachmentIds) {
            CdsLoadFileItem attachmentLoadFileItem = this.attachmentLoadFileItems.get(attachmentId);
            if (attachmentLoadFileItem == null || !handledDocumentIds.add(attachmentId) || !this.attachedAttachments.add(attachmentId)) continue;
            String nameHash = attachmentLoadFileItem.getName() + "-" + attachmentLoadFileItem.getItem().getHash();
            if (nameHashes.add(nameHash) || !cdsLoadFileItem.getItem().isCopilotItem()) {
                cdsLoadFileItem.addChild(attachmentLoadFileItem);
                zipChildrenCount.incrementAndGet();
                continue;
            }
            LOGGER.info("Skipping duplicate CoPilot attachment " + attachmentLoadFileItem.getItem().getFileId());
        }
        return handledDocumentIds;
    }

    private CdsLoadFileItem createAndHandleUserMessageConversationRoot(CdsConversation conversation, String user, List<CdsLoadFileItem> messages) {
        Map<String, LoadFileField> loadfileFields = this.loadfileHandler.getLoadFileFields();
        int participantsCount = conversation.getParticipants().size();
        CdsItem conversationItem = conversation.getRootItem();
        conversationItem.setFileId(conversationItem.getDocumentId());
        conversationItem.setDocumentId(UUID.randomUUID().toString().replace("-", ""));
        conversationItem.setImmutableId(conversationItem.getDocumentId());
        String conversationParentLocation = CdsUtils.getFormattedConversationLocation(user, conversation);
        if (conversationItem.getConversationMimeType() == CdsConversationMimeType.CHANNEL_CONVERSATION) {
            Object conversationName = !messages.isEmpty() ? (messages.get(0).getItem() != null && messages.get(0).getItem().getDate() != null ? "Conversation-" + messages.get(0).getItem().getDate().getMillis() : "Conversation-Unknown") : "Conversation-" + System.currentTimeMillis();
            conversationItem.setLocation(conversationParentLocation, new String[]{conversationName});
            if (conversationItem.getTeamName() != null && conversationItem.getChannelName() != null) {
                conversationItem.setCustodian(conversationItem.getChannelName());
            } else {
                conversationItem.setCustodian(user);
            }
        } else {
            conversationItem.setLocation(conversationParentLocation, AddressUtils.render(conversation.getParticipants()));
            conversationItem.setCustodian(user);
        }
        if (conversationItem.getTeamsMessageType() == CdsTeamsMessageType.TEAMS_CONVERSATION_ONE || conversationItem.getTeamsMessageType() == CdsTeamsMessageType.TEAMS_CONVERSATION_MANY) {
            if (participantsCount > 2) {
                conversationItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_CONVERSATION_MANY);
            } else {
                conversationItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_CONVERSATION_ONE);
            }
        }
        this.normalizeTeamsLocation(conversationItem);
        conversationItem.setRecipients(conversation.getParticipants());
        conversationItem.setFamilyId(conversationItem.getDocumentId());
        CdsLoadFileItem firstMessage = messages.get(0);
        conversationItem.setDate(firstMessage.getItem().getDate());
        Map<String, String> firstMessageFieldValues = firstMessage.getFieldValueMap();
        Map<String, String> conversationFieldValues = CdsUtils.buildItemFieldValues(conversationItem);
        CdsUtils.setMissingLoadfileFieldValues(loadfileFields, firstMessageFieldValues, conversationFieldValues);
        CdsLoadFileItem parentConversationLoadFileItem = this.buildLoadFileItem(conversationItem, conversationFieldValues, true, false, false);
        String conversationLocation = parentConversationLoadFileItem.getItem().getLocation();
        if (conversationItem.getTeamsMessageType().equals((Object)CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION)) {
            int conversationNameLength = parentConversationLoadFileItem.getName().length();
            String channelLocation = conversationLocation.substring(0, conversationLocation.length() - conversationNameLength - 1);
            LoadfileItem channel = this.channelLoadfileItems.get(channelLocation);
            if (channel == null) {
                String docId = UidUtils.fromString((String)channelLocation);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(CdsCustomMetadata.MIME_TYPE.toString(), CdsConversationMimeType.CHANNEL.getMimeType());
                channel = new LoadfileItem(docId, docId, channelLocation, CdsConversationMimeType.CHANNEL.getMimeType(), fieldValues, this.convertEmailsToEmlRfc5322){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return null;
                    }
                };
                this.channelLoadfileItems.put(channelLocation, channel);
            }
            channel.addChild(parentConversationLoadFileItem);
            this.loadfileHandler.addTopLevelItem(channel);
        } else {
            this.loadFileItems.put(parentConversationLoadFileItem.getItem().getDocumentId(), parentConversationLoadFileItem);
            this.loadfileHandler.addTopLevelItem(parentConversationLoadFileItem);
        }
        return parentConversationLoadFileItem;
    }

    private Set<String> getItemAttachmentItemIds(Map<String, Set<String>> idToAttachmentItemIds, String ... ids) {
        HashSet<String> attachmentIds = new HashSet<String>();
        for (String id : ids) {
            if (id == null || !idToAttachmentItemIds.containsKey(id)) continue;
            attachmentIds.addAll((Collection<String>)idToAttachmentItemIds.get(id));
        }
        return attachmentIds;
    }

    private CdsLoadFileItem buildLoadFileItem(CdsItem cdsItem, Map<String, String> rowValueMap, boolean convertEmailsToEmlRfc5322, boolean detachRegularAttachments, boolean stubModernAttachments) {
        return this.buildLoadFileItem(cdsItem, rowValueMap, null, convertEmailsToEmlRfc5322, detachRegularAttachments, stubModernAttachments);
    }

    private CdsLoadFileItem buildLoadFileItem(final CdsItem cdsItem, Map<String, String> rowValueMap, final PurviewReportFile purviewReportFile, boolean convertEmailsToEmlRfc5322, boolean detachRegularAttachments, boolean stubModernAttachments) {
        Map<String, String> fieldValueMap = CdsUtils.buildItemFieldValues(cdsItem, rowValueMap);
        CdsLoadFileItem loadfileItem = new CdsLoadFileItem(cdsItem.getDocumentId() + "-" + UidUtils.getShortId((String)UidUtils.getRandom()), cdsItem, fieldValueMap, convertEmailsToEmlRfc5322, detachRegularAttachments, stubModernAttachments){

            @Override
            public InputStream getInputStream() throws IOException {
                if (purviewReportFile != null) {
                    return ConvertPurviewAdvancedOperationImplementation.this.getPurviewFileInputStream(purviewReportFile, cdsItem);
                }
                return null;
            }

            @Override
            public Long getCrc() throws IOException {
                if (purviewReportFile != null) {
                    return purviewReportFile.getCrc(cdsItem);
                }
                return null;
            }

            @Override
            public Long getSize() throws IOException {
                if (purviewReportFile != null) {
                    return purviewReportFile.getSize(cdsItem);
                }
                return null;
            }
        };
        if (cdsItem.getEmbeddedAttachments() != null) {
            for (Map.Entry<String, byte[]> embeddedAttachmentData : cdsItem.getEmbeddedAttachments()) {
                String location;
                String filename = embeddedAttachmentData.getKey();
                final byte[] content = embeddedAttachmentData.getValue();
                try {
                    location = loadfileItem.getLocation() + "/" + URLEncoder.encode(filename, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    location = loadfileItem.getLocation() + "/" + filename;
                }
                LoadfileItem embeddedAttachment = new LoadfileItem(loadfileItem.getDocId() + "-attach" + UidUtils.getShortId((String)UidUtils.getRandom()), loadfileItem.getFamilyId(), location, null, new ArrayList()){

                    @Override
                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(content);
                    }
                };
                loadfileItem.addChild(embeddedAttachment);
            }
        }
        cdsItem.setEmbeddedAttachments(null);
        return loadfileItem;
    }

    public void addLoadFileItem(CdsLoadFileItem loadFileItem) {
        CdsItem item = loadFileItem.getItem();
        this.normalizeTeamsLocation(loadFileItem);
        if (item.getFileClass() == CdsFileClassType.ATTACHMENT) {
            Set childLoadFileItems;
            String modernParentId = item.getModernParentId();
            String parentId = item.getParentId();
            String familyId = item.getFamilyId();
            boolean trackedAttachment = false;
            if (modernParentId != null && !modernParentId.trim().isEmpty()) {
                childLoadFileItems = this.modernParentIdToAttachmentItemIds.computeIfAbsent(modernParentId, k -> new LinkedHashSet());
                childLoadFileItems.add(item.getDocumentId());
            }
            if (parentId != null && !parentId.trim().isEmpty()) {
                childLoadFileItems = this.parentIdToAttachmentItemIds.computeIfAbsent(parentId, k -> new LinkedHashSet());
                childLoadFileItems.add(item.getDocumentId());
            }
            if (familyId != null && !familyId.trim().isEmpty() && !familyId.equals(item.getDocumentId())) {
                childLoadFileItems = this.familyIdToAttachmentItemIds.computeIfAbsent(familyId, k -> new LinkedHashSet());
                childLoadFileItems.add(item.getDocumentId());
            }
            this.attachmentLoadFileItems.put(item.getDocumentId(), loadFileItem);
        } else {
            this.loadFileItems.put(item.getDocumentId(), loadFileItem);
        }
    }

    public List<LoadFileField> parseCdsExportLoadfileHeaders(int headerOffset) {
        ArrayList<LoadFileField> headers = new ArrayList<LoadFileField>();
        PurviewReportFile purviewReportFile = this.purviewReportFiles.get(0);
        for (String headerName : purviewReportFile.getHeaders()) {
            headers.add(new LoadFileField(headerName, "Text", headerOffset++, true));
        }
        return headers;
    }

    private InputStream getPurviewFileInputStream(PurviewReportFile purviewReportFile, CdsItem cdsItem) throws IOException {
        return purviewReportFile.getInputStream(cdsItem);
    }

    private CdsConversation getOrBuildSimpleConversationParent(String conversationId) {
        CdsConversation conversationParent = this.conversationParents.get(conversationId);
        if (conversationParent == null) {
            conversationParent = new CdsConversation(conversationId);
            this.conversationParents.put(conversationId, conversationParent);
        }
        return conversationParent;
    }

    private CdsConversation getOrBuildConversationParent(CdsItem cdsItem, CdsConversationMimeType conversationMimeType) {
        CdsConversation conversationParent = this.getOrBuildSimpleConversationParent(cdsItem.getConversationId());
        if (conversationParent.getRootItem() == null) {
            CdsItem rootItem = cdsItem.clone();
            rootItem.setFileClass(CdsFileClassType.CONVERSATION);
            rootItem.setConversationMimeType(conversationMimeType);
            if (cdsItem.getTeamsMessageType() == CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION && !cdsItem.getRecipients().isEmpty()) {
                rootItem.setTeamAddress(cdsItem.getRecipients().iterator().next());
            }
            conversationParent.setRootItem(rootItem);
        }
        return conversationParent;
    }

    private void normalizeTeamsLocation(CdsLoadFileItem loadFileItem) {
        this.normalizeTeamsLocation(loadFileItem.getItem());
    }

    private void normalizeTeamsLocation(CdsItem cdsItem) {
        if (cdsItem.getLocation() != null && cdsItem.getLocation().contains("Teams/")) {
            String normalizedLocation = this.getNormalizedTeamsLocation(cdsItem.getLocation());
            cdsItem.setLocation(normalizedLocation, new String[0]);
        }
    }

    private String getNormalizedTeamsLocation(String location) {
        CharSequence[] locationSplit = location.split("/");
        for (int i = 0; i < locationSplit.length - 1; ++i) {
            String teamName;
            String normalizedTeamName;
            if (!locationSplit[i].equalsIgnoreCase("Teams") || (normalizedTeamName = this.getNormalizedTeamName(teamName = locationSplit[i + 1])) == null || teamName.equals(normalizedTeamName)) continue;
            locationSplit[i + 1] = normalizedTeamName;
            return String.join((CharSequence)"/", locationSplit);
        }
        return location;
    }

    private String getNormalizedTeamName(String teamName) {
        if (teamName != null && !teamName.isEmpty()) {
            String urlOrEmailFormat = teamName.replace(" ", "");
            String normalizedName = this.normalizedTeamNames.get(urlOrEmailFormat);
            if (normalizedName != null) {
                return normalizedName;
            }
            this.normalizedTeamNames.put(urlOrEmailFormat, teamName);
        }
        return teamName;
    }

    private Map<String, String> buildRowValueMap(Map<Integer, String> indexToColumnName, List<String> rowValues) {
        HashMap<String, String> rowValueMap = new HashMap<String, String>();
        for (int i = 0; i < rowValues.size(); ++i) {
            String columnName = indexToColumnName.get(i);
            String value = rowValues.get(i);
            if (columnName == null || value == null || value.trim().isEmpty()) continue;
            rowValueMap.put(columnName, value);
        }
        return rowValueMap;
    }

    private String getRowValueOrDefault(Map<String, String> rowValueMap, String columnName) {
        return this.getRowValueOrDefault(rowValueMap, columnName, "");
    }

    private String getRowValueOrDefault(Map<String, String> rowValueMap, String columnName, String defaultValue) {
        String value = null;
        for (String key : rowValueMap.keySet()) {
            if (!key.matches(columnName)) continue;
            value = rowValueMap.get(key);
            break;
        }
        if (value == null) {
            value = rowValueMap.get(columnName);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String getUtf8Value(String value) {
        try {
            byte[] result = value.getBytes("Windows-1252");
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return value;
        }
    }

    private String getWindows1252Value(String value) {
        try {
            byte[] result = value.getBytes(StandardCharsets.UTF_8);
            return new String(result, "Windows-1252");
        }
        catch (Exception e) {
            return value;
        }
    }

    @Override
    protected double getPercentageComplete() {
        int totalCdsExports = this.purviewReportFiles.size();
        int totalCustodians = this.custodians.size();
        double percentage = 0.0;
        if (totalCdsExports > 0 && totalCustodians > 0) {
            double stagePercentage = 0.0;
            if (this.currentRowCount != null && this.totalRowCount != null && this.totalRowCount.get() > 0L) {
                stagePercentage += 0.2 * ((double)this.currentRowCount.get() / (double)this.totalRowCount.get());
            }
            if (this.custodianTlItemsProcessed != null && this.custodianTlItemsCount != null && this.custodianTlItemsCount.get() > 0L) {
                stagePercentage += 0.8 * ((double)this.custodianTlItemsProcessed.get() / (double)this.custodianTlItemsCount.get());
            }
            double basePercentage = (double)this.custodiansCompleted.size() / (double)totalCustodians;
            double stageWeight = 1.0 / (double)totalCustodians;
            percentage = basePercentage + (stagePercentage *= stageWeight);
        }
        return percentage;
    }

    @Override
    public String getPrintablePercentageComplete() {
        double percentageComplete = this.getNormalizedPercentageComplete();
        ArrayList<String> stageParts = new ArrayList<String>();
        if (!Double.isNaN(percentageComplete)) {
            stageParts.add(String.format("%.2f%%", percentageComplete * 100.0));
        }
        stageParts.add(this.iu.getFormattedString("ConvertPurviewExportOperation.Stage.Custodian", (Object)(this.custodiansCompleted.size() + 1)));
        if (this.stageNumber == 1) {
            stageParts.add(this.iu.getNumeralString("ConvertPurviewExport.Stage.ParsingLoadFile", this.custodianRecordsCount.get()));
        } else if (this.stageNumber > 1 && this.custodianTlItemsProcessed != null && this.custodianTlItemsProcessed.get() > 0L) {
            stageParts.add(this.iu.getNumeralString("ConvertPurviewExport.Stage.ExportingNli", this.custodianTlItemsProcessed.get()));
        }
        return String.join((CharSequence)" / ", stageParts);
    }
}

