/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import au.com.bytecode.opencsv.CSVReader;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ConvertPurviewExportOperation;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFile;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFolder;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportZip;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;

public class ConvertPurviewExportOperationImplementation
extends ConvertPurviewExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConvertPurviewExportOperation.class);
    private AtomicLong totalRecordsCount;
    private AtomicLong totalTlRecordsCount;
    private AtomicLong totalItemsProcessed;
    private long totalZipFiles;
    private AtomicLong scannedZipFiles;
    private long loadfilesWithErrors;
    private long recordsWithErrors;

    private void convertLocation() throws IOException {
        Path exportPath = Paths.get(this.purviewExportLocation, new String[0]);
        ArrayList<PurviewReportFile> zipFiles = new ArrayList<PurviewReportFile>(this.scanForPurviewExports(exportPath));
        this.scannedZipFiles = new AtomicLong();
        this.totalZipFiles = zipFiles.size();
        this.totalRecordsCount = new AtomicLong();
        this.totalTlRecordsCount = new AtomicLong();
        this.totalItemsProcessed = new AtomicLong();
        zipFiles.parallelStream().forEach(zipfile -> {
            if (this.stopRequested) {
                return;
            }
            try {
                this.convertZipFile((PurviewReportFile)zipfile);
            }
            catch (IOException e) {
                LOGGER.error("Error converting file");
            }
        });
    }

    private List<PurviewReportFile> scanForPurviewExports(Path folderPath) throws IOException {
        try (Stream<Path> exportFileStream = Files.list(folderPath);){
            String extractedFolderRegex;
            Object zipRegex;
            if (this.purviewReportZipRegex.endsWith("\\.zip")) {
                zipRegex = this.purviewReportZipRegex;
                extractedFolderRegex = this.purviewReportZipRegex.substring(0, this.purviewReportZipRegex.length() - "\\.zip".length());
            } else {
                zipRegex = this.purviewReportZipRegex + "\\.zip";
                extractedFolderRegex = this.purviewReportZipRegex;
            }
            ArrayList<PurviewReportZip> exportFiles = new ArrayList<PurviewReportZip>();
            for (Path exportFilePath : exportFileStream.collect(Collectors.toList())) {
                if (this.stopRequested) {
                    this.trackStopped();
                    break;
                }
                try {
                    String fileName = exportFilePath.getFileName().toString();
                    String fileExtension = FileUtils.getFileExtension((String)fileName);
                    PurviewReportFile purviewExportFile = null;
                    if (!Files.isDirectory(exportFilePath, new LinkOption[0]) && !fileExtension.equalsIgnoreCase("zip")) continue;
                    if (fileName.matches((String)zipRegex)) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DetectedZip", (Object)fileName));
                        purviewExportFile = new PurviewReportZip(exportFilePath);
                    } else if (fileName.matches(extractedFolderRegex)) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DetectedExport", (Object)fileName));
                        purviewExportFile = new PurviewReportFolder(exportFilePath);
                    }
                    if (purviewExportFile == null) continue;
                    exportFiles.add((PurviewReportZip)purviewExportFile);
                    purviewExportFile.findAndSetLoadfileName(this.purviewReportItemsRegex);
                    for (String loadfileName : purviewExportFile.getLoadfileNames()) {
                        this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewAdvancedOperation.Log.FoundLoadFile", (Object)String.valueOf(loadfileName)));
                    }
                    if (purviewExportFile.getLoadfileNames().isEmpty()) {
                        throw new IOException(this.iu.getFormattedString("ConvertPurviewExportOperation.Error.CannotDetectZipLoadfile", (Object)exportFilePath));
                    }
                    purviewExportFile.scanForItemExports(this.purviewZipRegex, "");
                    if (purviewExportFile.getItemsHandler().getPurviewExports().isEmpty()) {
                        throw new IOException(this.iu.getFormattedString("ConvertPurviewExportOperation.Error.UnableToDetectPurviewExportFiles", (Object)exportFilePath.getParent()));
                    }
                    FileTime loadfileLastModifiedTime = purviewExportFile.getFileTime();
                    Calendar staleLoadfileDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    staleLoadfileDate.set(2024, 5, 1, 0, 0, 0);
                    if (loadfileLastModifiedTime == null || loadfileLastModifiedTime.toMillis() > staleLoadfileDate.getTimeInMillis()) continue;
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewCdsOperation.Warning.DetectedOldExport", new Object[]{exportFilePath, loadfileLastModifiedTime.toString()}));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot handle export/report file " + String.valueOf(exportFilePath), (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.CannotReadPurviewExport", new Object[]{exportFilePath, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                }
            }
            ArrayList<PurviewReportZip> arrayList = exportFiles;
            return arrayList;
        }
    }

    private void convertZipFile(final PurviewReportFile reportFile) throws IOException {
        boolean loadfileHasErrors = false;
        if (this.stopRequested) {
            return;
        }
        LOGGER.info("Handling zip " + String.valueOf(reportFile));
        for (InputStream loadfileInputStream : reportFile.getLoadfileInputStreams()) {
            try {
                boolean detectedConversations = false;
                Path resultingNli = this.getResultingNli(reportFile.getPath());
                if (!Files.exists(resultingNli.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(resultingNli.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot create NLI parent folder", (Throwable)e);
                    }
                }
                long zipItemsCount = 0L;
                try (ZipOutputStream outputZip = new ZipOutputStream(new FileOutputStream(resultingNli.toFile()));){
                    outputZip.setLevel(0);
                    outputZip.setMethod(0);
                    Loadfile loadfile = null;
                    HashMap<String, 1> csvLoadfileItems = new HashMap<String, 1>();
                    int rowNumber = 1;
                    try (CSVReader csvReader = CdsUtils.buildCsvReader(loadfileInputStream);){
                        boolean header = true;
                        int columnsCount = 0;
                        HashMap<String, Integer> columnIds = new HashMap<String, Integer>();
                        String[] rowValues = null;
                        try {
                            List<String> partialPreviousRowValuesList = null;
                            while ((rowValues = csvReader.readNext()) != null) {
                                String nativeFile;
                                if (header) {
                                    columnsCount = rowValues.length;
                                    List<String> headerNames = Arrays.asList(rowValues);
                                    ArrayList<LoadFileField> loadFileFields = new ArrayList<LoadFileField>();
                                    int headerId = 0;
                                    for (String headerName : headerNames) {
                                        loadFileFields.add(new LoadFileField(headerName, "Text", headerId++));
                                    }
                                    loadfile = new Loadfile(loadFileFields);
                                    for (int i = 0; i < columnsCount; ++i) {
                                        columnIds.put(rowValues[i], i);
                                    }
                                    header = false;
                                    continue;
                                }
                                this.totalRecordsCount.incrementAndGet();
                                List<String> rowValuesList = Arrays.asList(rowValues);
                                if (partialPreviousRowValuesList != null) {
                                    int i;
                                    Object lastItem = (String)partialPreviousRowValuesList.get(partialPreviousRowValuesList.size() - 1);
                                    lastItem = (String)lastItem + "\n" + rowValuesList.get(0);
                                    ArrayList<String> mergedRowValuesList = new ArrayList<String>();
                                    for (i = 0; i < partialPreviousRowValuesList.size() - 1; ++i) {
                                        mergedRowValuesList.add(partialPreviousRowValuesList.get(i));
                                    }
                                    mergedRowValuesList.add((String)lastItem);
                                    for (i = 1; i < rowValuesList.size(); ++i) {
                                        mergedRowValuesList.add(rowValuesList.get(i));
                                    }
                                    rowValuesList = mergedRowValuesList;
                                }
                                if (rowValuesList.size() < columnsCount) {
                                    partialPreviousRowValuesList = rowValuesList;
                                    if (rowValues.length < 40) {
                                        LOGGER.warn("!!!small");
                                    }
                                    LOGGER.warn("Row " + rowNumber + " has " + rowValues.length + " columns instead of " + columnsCount + ", merging with next line");
                                    continue;
                                }
                                partialPreviousRowValuesList = null;
                                ++rowNumber;
                                String docId = rowValuesList.get((Integer)columnIds.get(this.docIdColumn));
                                if (docId == null) {
                                    LOGGER.error("Null field on row " + rowNumber);
                                }
                                if (docId.startsWith("\ufeff")) {
                                    docId = docId.substring(1);
                                }
                                String familyId = rowValuesList.get((Integer)columnIds.get(this.familyIdColumn));
                                String location = rowValuesList.get((Integer)columnIds.get(this.pathColumn));
                                String fileClass = rowValuesList.get((Integer)columnIds.get(this.fileClassColumn));
                                String sender = rowValuesList.get((Integer)columnIds.get(this.senderColumn));
                                if (!detectedConversations && fileClass.equalsIgnoreCase("conversation")) {
                                    detectedConversations = true;
                                    this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Warning.DetectedConversations", (Object)reportFile.getPath().toFile()));
                                }
                                boolean convertToEml = (nativeFile = rowValuesList.get((Integer)columnIds.get(this.nativeFileColumn))) != null && nativeFile.toLowerCase().endsWith(".msg");
                                LoadfileItem loadfileItem = new LoadfileItem(docId, familyId, location, fileClass, rowValuesList, convertToEml){

                                    @Override
                                    public InputStream getInputStream() throws IOException {
                                        CdsItem item = new CdsItem();
                                        item.setNativeExportPath(nativeFile);
                                        return reportFile.getInputStream(item);
                                    }
                                };
                                loadfileItem.setLoadfileSender(sender);
                                csvLoadfileItems.put(loadfileItem.getDocId(), loadfileItem);
                            }
                        }
                        catch (Exception e) {
                            ++this.recordsWithErrors;
                            loadfileHasErrors = true;
                            LOGGER.error("Cannot handle CSV record", (Throwable)e);
                        }
                    }
                    LOGGER.info("Read " + rowNumber + " rows");
                    int childrenCount = 0;
                    for (LoadfileItem csvLoadfileItem : csvLoadfileItems.values()) {
                        String docId = csvLoadfileItem.getDocId();
                        String familyId = csvLoadfileItem.getFamilyId();
                        if (docId == null || familyId == null) {
                            LOGGER.error("Null field " + docId + " " + familyId);
                        }
                        if (docId.equals(familyId)) {
                            loadfile.addTopLevelItem(csvLoadfileItem);
                            ++zipItemsCount;
                            continue;
                        }
                        LoadfileItem topLevelItem = (LoadfileItem)csvLoadfileItems.get(csvLoadfileItem.getFamilyId());
                        if (topLevelItem == null) {
                            LOGGER.warn("Cannot find loadfile top-level item " + csvLoadfileItem.getFamilyId());
                            loadfile.addTopLevelItem(csvLoadfileItem);
                            ++childrenCount;
                            continue;
                        }
                        topLevelItem.addChild(csvLoadfileItem);
                        ++zipItemsCount;
                    }
                    LOGGER.info("TL items: " + zipItemsCount);
                    LOGGER.info("Children items: " + childrenCount);
                    LOGGER.info("Warnings: " + this.recordsWithErrors);
                    this.totalTlRecordsCount.addAndGet(zipItemsCount);
                    this.scannedZipFiles.incrementAndGet();
                    AtomicLong zipItemsWithErrors = new AtomicLong(0L);
                    loadfile.getTopLevelItems().size();
                    loadfile.writeNli(outputZip, this.totalItemsProcessed, zipItemsWithErrors);
                    this.recordsWithErrors += zipItemsWithErrors.get();
                    this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.WroteNli", (Object)resultingNli.getFileName().toString()));
                }
            }
            catch (Exception e) {
                ++this.recordsWithErrors;
                loadfileHasErrors = true;
                LOGGER.error("Cannot handle zip file", (Throwable)e);
            }
            if (loadfileHasErrors) {
                ++this.loadfilesWithErrors;
                LOGGER.warn("Finished handling zip " + String.valueOf(reportFile.getPath().getFileName()) + " with errors");
                continue;
            }
            LOGGER.warn("Finished handling zip " + String.valueOf(reportFile.getPath().getFileName()) + " without errors");
        }
    }

    private Path getResultingNli(Path loadfile) throws IOException {
        Path destinationPath = Paths.get(this.resultingNliLocation, new String[0]);
        Object desiredFileName = FileUtils.getFileNameWithoutExtension((String)loadfile.getFileName().toString()) + ".nli";
        Path folderPath = destinationPath;
        if (destinationPath.getFileName().toString().toLowerCase().contains(".nli")) {
            folderPath = destinationPath.getParent();
            desiredFileName = destinationPath.getFileName().toString();
        }
        if (Files.exists(folderPath, new LinkOption[0])) {
            Files.createDirectories(folderPath, new FileAttribute[0]);
        }
        Path resultingNli = folderPath.resolve((String)desiredFileName);
        String originalName = resultingNli.getFileName().toString();
        boolean originalFileAlreadyExists = false;
        for (int i = 2; i < 100; ++i) {
            if (!Files.exists(resultingNli, new LinkOption[0])) {
                if (originalFileAlreadyExists) {
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.FileAlreadyExists", new Object[]{originalName, resultingNli.getFileName().toString()}));
                }
                return resultingNli;
            }
            resultingNli = folderPath.resolve(FileUtils.getFileNameWithoutExtension((String)desiredFileName) + " " + i + ".nli");
            originalFileAlreadyExists = true;
        }
        throw new IOException("Output file " + resultingNli.toString() + " already exists");
    }

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                this.purviewExportLocation = this.executionContext.evalParameters(this.purviewExportLocation, this);
                this.resultingNliLocation = this.executionContext.evalParameters(this.resultingNliLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.SourceLocation", (Object)this.purviewExportLocation));
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DestinationLocation", (Object)this.resultingNliLocation));
                AsposeUtils.applyAsposeEmailLicense();
                this.convertLocation();
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExport.Log.Loadfiles", this.totalZipFiles));
                if (this.loadfilesWithErrors > 0L) {
                    this.addWarning(this.iu.getNumeralString("ConvertPurviewExport.Log.LoadfilesErrors", this.loadfilesWithErrors));
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExport.Log.Records", this.totalRecordsCount.get()));
                if (this.recordsWithErrors > 0L) {
                    this.addWarning(this.iu.getNumeralString("ConvertPurviewExport.Log.RecordsErrors", this.recordsWithErrors));
                }
                if (this.executionState != ExecutionState.ERROR) {
                    this.trackFinished();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
        this.startTriggerThread.join();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.totalZipFiles > 0L && this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L) {
            double progress = (double)this.totalItemsProcessed.get() / (double)this.totalTlRecordsCount.get() * (double)this.scannedZipFiles.get() / (double)this.totalZipFiles;
            return progress /= (double)this.totalZipFiles;
        }
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L) {
            result = (String)result + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.totalItemsProcessed.get());
        }
        return result;
    }
}

