/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.CreateArmArchiveOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativityLoadDynamicObjectsOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmNotificationOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmArchive;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmExtendedWorkspaceDataOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmFileOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmMigratorOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmProcessingOptions;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CreateArmArchiveOperationImplementation
extends CreateArmArchiveOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityLoadDynamicObjectsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.archiveDirectory = this.executionContext.evalParameters(this.archiveDirectory, this);
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityCreateArmArchiveOperation.Stage.PreparingArchive");
                this.percentageComplete = 0.15;
                boolean armApplicationInstalled = this.relativityRestClient.instanceContainsArmApplication();
                if (!armApplicationInstalled) {
                    throw new Exception(this.iu.getString("RelativityCreateArmArchiveOperation.Exception.ArmNotInstalled"));
                }
                ArmArchive archive = new ArmArchive();
                archive.setWorkspaceID(relativityWorkspaceArtifactId);
                if (this.useDefaultArchiveDirectory) {
                    archive.setArchiveDirectory("");
                    archive.setUseDefaultArchiveDirectory(true);
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.UsingDefaultDirectory"));
                } else {
                    archive.setArchiveDirectory(this.archiveDirectory);
                    archive.setUseDefaultArchiveDirectory(false);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.ArchiveDirectory", (Object)this.archiveDirectory));
                }
                Long futureTime = System.currentTimeMillis() + 300000L;
                DateTime dt = new DateTime((Object)futureTime);
                DateTimeFormatter fmt = ISODateTimeFormat.dateTimeNoMillis();
                String scheduledStartTimeStr = fmt.withZoneUTC().print((ReadableInstant)dt);
                archive.setScheduledStartTime(scheduledStartTimeStr);
                archive.setJobPriority(this.priority);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.JobPriority", (Object)this.priority));
                archive.setUiJobActionsLocked(this.lockUiJob);
                if (this.lockUiJob) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.LockUi"));
                }
                ArmNotificationOptions notificationOptions = new ArmNotificationOptions();
                notificationOptions.setNotifyJobCreator(this.notifyJobCreator);
                notificationOptions.setNotifyJobExecutor(this.notifyJobExecutor);
                archive.setNotificationOptions(notificationOptions);
                if (this.notifyJobCreator && this.notifyJobExecutor) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.NotifyBoth"));
                } else if (this.notifyJobExecutor) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.NotifyExecutor"));
                } else if (this.notifyJobCreator) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.NotifyCreator"));
                }
                ArmMigratorOptions migratorOptions = new ArmMigratorOptions();
                migratorOptions.setIncludeDatabaseBackup(this.includeDatabaseBackup);
                migratorOptions.setIncludeDtSearch(this.includeDtSearch);
                migratorOptions.setIncludeConceptualAnalytics(this.includeConceptualAnalytics);
                migratorOptions.setIncludeStructuredAnalytics(this.includeStructuralAnalytics);
                migratorOptions.setIncludeDataGrid(this.includeDataGrid);
                archive.setMigratorOptions(migratorOptions);
                ArmFileOptions armFileOptions = new ArmFileOptions();
                armFileOptions.setIncludeLinkedFiles(this.includeLinkedFiles);
                armFileOptions.setIncludeRepositoryFiles(this.includeRepositoryFiles);
                armFileOptions.setMissingFileBehavior(this.missingFileBehaviour);
                if (this.includeLinkedFiles || this.includeRepositoryFiles) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.IncludingFiles"));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.MissingFileBehaviour", (Object)this.missingFileBehaviour));
                }
                archive.setFileOptions(armFileOptions);
                ArmProcessingOptions armProcessingOptions = new ArmProcessingOptions();
                armProcessingOptions.setIncludeProcessing(this.includeProcessing);
                armProcessingOptions.setIncludeProcessingFiles(this.includeProcessingFiles);
                armProcessingOptions.setProcessingMissingFileBehavior(this.missingProcessingFileBehaviour);
                archive.setProcessingOptions(armProcessingOptions);
                if (this.includeProcessing) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.IncludingProcessing"));
                }
                if (this.includeProcessingFiles) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.IncludingProcessingFiles"));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.MissingProcessingFileBehaviour", (Object)this.missingProcessingFileBehaviour));
                }
                ArmExtendedWorkspaceDataOptions extendedWorkspaceDataOptions = new ArmExtendedWorkspaceDataOptions();
                extendedWorkspaceDataOptions.setIncludeExtendedWorkspaceData(this.includeExtendedWorkspaceData);
                extendedWorkspaceDataOptions.setApplicationErrorExportBehavior(this.missingErrorExportBehaviour);
                archive.setExtendedWorkspaceDataOptions(extendedWorkspaceDataOptions);
                if (this.includeExtendedWorkspaceData) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.IncludingExtendedWorkspace"));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.ErrorExportBehaviour", (Object)this.missingErrorExportBehaviour));
                }
                this.stageName = this.iu.getString("RelativityCreateArmArchiveOperation.Stage.CreatingArchive");
                this.percentageComplete = 0.3;
                Long jobArtifactId = this.relativityRestClient.createArmArchive(relativityWorkspaceArtifactId, archive);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmArchiveOperation.Info.JobId", (Object)String.valueOf(jobArtifactId)));
                String path = this.relativityRestClient.getArmArchivePath(jobArtifactId);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_arm_archive_path}", path)));
                this.relativityRestClient.runArmJob(jobArtifactId);
                if (this.waitForArchiveCompletion) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmArchiveOperation.Info.WaitingForCompletion"));
                    ArmJobStatus archiveStatus = this.relativityRestClient.getArmJobStatus(jobArtifactId);
                    while (!RelativityUtils.getInstance().isArmJobCompleted(archiveStatus)) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        if (archiveStatus.getCurrentJobStage() != null) {
                            this.percentageComplete = 0.3 + (double)archiveStatus.getCurrentJobStage().getOrder().intValue() / (double)archiveStatus.getTotalNumberOfStages().intValue() * 0.7;
                            this.stageName = archiveStatus.getCurrentJobStage().getName();
                        } else {
                            this.percentageComplete = 0.3;
                            this.stageName = archiveStatus.getJobState().toString();
                        }
                        Thread.sleep(1000L);
                        archiveStatus = this.relativityRestClient.getArmJobStatus(jobArtifactId);
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

