/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmPriority;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRows(value={@FormFieldRow(name="matterIdentifierRow", children={"useMatterIdentifier", "matterIdentifierType", "matterIdentifier"}), @FormFieldRow(name="resourcePoolIdentifierRow", children={"useResourcePoolIdentifier", "resourcePoolIdentifierType", "resourcePoolIdentifier"}), @FormFieldRow(name="databaseServerIdentifierRow", children={"useDatabaseIdentifier", "databaseServerIdentifierType", "databaseServerIdentifier"}), @FormFieldRow(name="cacheLocationIdentifierRow", children={"useCacheLocationIdentifier", "cacheLocationIdentifierType", "cacheLocationIdentifier"}), @FormFieldRow(name="fileRepositoryIdentifierRow", children={"useFileRepositoryIdentifier", "fileRepositoryIdentifierType", "fileRepositoryIdentifier"}), @FormFieldRow(name="structuredAnalyticsRow", children={"hasStructuredAnalytics", "structuredAnalyticsServerIdentifierType", "structuredAnalyticsServerIdentifier"}), @FormFieldRow(name="conceptualAnalyticsRow", children={"hasConceptualAnalytics", "conceptualAnalyticsServerIdentifierType", "conceptualAnalyticsServerIdentifier"}), @FormFieldRow(name="dtSearchLocationRow", children={"hasDtSearchLocation", "dtSearchLocationIdentifierType", "dtSearchLocationIdentifier"}), @FormFieldRow(name="existingTargetDatabaseRow", children={"backupDoesNotContainDatabaseBackup", "existingTargetDatabase"})})
@FormFieldGroup(name="advancedOptionsGroup", children={"referenceFilesAsArchiveLinks", "updateRepositoryFilePaths", "updateLinkedFilePaths", "autoMapUsers", "autoMapGroups"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_CREATE_ARM_RESTORE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class CreateArmRestoreOperation
extends RelativityOperation {
    @FormField
    public String archivePath;
    @FormField
    public ArmPriority priority;
    @FormField
    public boolean waitForCompletion;
    @FormField
    public boolean lockUiJobActions;
    @FormField
    public boolean notifyJobCreator;
    @FormField
    public boolean notifyJobExecutor;
    @FormField
    public boolean useMatterIdentifier;
    @FormField(enableOn={@OnField(name="useMatterIdentifier")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType matterIdentifierType;
    @FormField(enableOn={@OnField(name="useMatterIdentifier")})
    @ExcludeFromPrintableOptions
    public String matterIdentifier;
    @FormField
    public boolean useResourcePoolIdentifier;
    @FormField(enableOn={@OnField(name="useResourcePoolIdentifier")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType resourcePoolIdentifierType;
    @FormField(enableOn={@OnField(name="useResourcePoolIdentifier")})
    @ExcludeFromPrintableOptions
    public String resourcePoolIdentifier;
    @FormField
    public boolean useDatabaseIdentifier;
    @FormField(enableOn={@OnField(name="useDatabaseIdentifier")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType databaseServerIdentifierType;
    @FormField(enableOn={@OnField(name="useDatabaseIdentifier")})
    @ExcludeFromPrintableOptions
    public String databaseServerIdentifier;
    @FormField
    public boolean useCacheLocationIdentifier;
    @FormField(enableOn={@OnField(name="useCacheLocationIdentifier")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType cacheLocationIdentifierType;
    @FormField(enableOn={@OnField(name="useCacheLocationIdentifier")})
    @ExcludeFromPrintableOptions
    public String cacheLocationIdentifier;
    @FormField
    public boolean useFileRepositoryIdentifier;
    @FormField(enableOn={@OnField(name="useFileRepositoryIdentifier")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType fileRepositoryIdentifierType;
    @FormField(enableOn={@OnField(name="useFileRepositoryIdentifier")})
    @ExcludeFromPrintableOptions
    public String fileRepositoryIdentifier;
    @FormField
    public boolean referenceFilesAsArchiveLinks;
    @FormField
    public boolean updateRepositoryFilePaths;
    @FormField
    public boolean updateLinkedFilePaths;
    @FormField
    public boolean autoMapUsers;
    @FormField
    public boolean autoMapGroups;
    @FormField
    public boolean hasStructuredAnalytics;
    @FormField(enableOn={@OnField(name="hasStructuredAnalytics")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType structuredAnalyticsServerIdentifierType;
    @FormField(enableOn={@OnField(name="hasStructuredAnalytics")})
    @ExcludeFromPrintableOptions
    public String structuredAnalyticsServerIdentifier;
    @FormField
    public boolean hasConceptualAnalytics;
    @FormField(enableOn={@OnField(name="hasConceptualAnalytics")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType conceptualAnalyticsServerIdentifierType;
    @FormField(enableOn={@OnField(name="hasConceptualAnalytics")})
    @ExcludeFromPrintableOptions
    public String conceptualAnalyticsServerIdentifier;
    @FormField
    public boolean hasDtSearchLocation;
    @FormField(enableOn={@OnField(name="hasDtSearchLocation")}, allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType dtSearchLocationIdentifierType;
    @FormField(enableOn={@OnField(name="hasDtSearchLocation")})
    @ExcludeFromPrintableOptions
    public String dtSearchLocationIdentifier;
    @FormField
    public boolean backupDoesNotContainDatabaseBackup;
    @FormField(enableOn={@OnField(name="backupDoesNotContainDatabaseBackup")})
    @ExcludeFromPrintableOptions
    public String existingTargetDatabase;

    public boolean getDisplayMatterIdentifierType() {
        return this.useMatterIdentifier;
    }

    public boolean getDisplayMatterIdentifier() {
        return this.useMatterIdentifier;
    }

    public boolean getDisplayResourcePoolIdentifierType() {
        return this.useResourcePoolIdentifier;
    }

    public boolean getDisplayResourcePoolIdentifier() {
        return this.useResourcePoolIdentifier;
    }

    public boolean getDisplayDatabaseServerIdentifierType() {
        return this.useResourcePoolIdentifier && this.useDatabaseIdentifier;
    }

    public boolean getDisplayDatabaseServerIdentifier() {
        return this.useResourcePoolIdentifier && this.useDatabaseIdentifier;
    }

    public boolean getDisplayCacheLocationIdentifierType() {
        return this.useResourcePoolIdentifier && this.useCacheLocationIdentifier;
    }

    public boolean getDisplayCacheLocationIdentifier() {
        return this.useResourcePoolIdentifier && this.useCacheLocationIdentifier;
    }

    public boolean getDisplayFileRepositoryIdentifierType() {
        return this.useResourcePoolIdentifier && this.useFileRepositoryIdentifier;
    }

    public boolean getDisplayFileRepositoryIdentifier() {
        return this.useResourcePoolIdentifier && this.useFileRepositoryIdentifier;
    }

    public boolean getDisplayStructuredAnalyticsServerIdentifierType() {
        return this.hasStructuredAnalytics;
    }

    public boolean getDisplayStructuredAnalyticsServerIdentifier() {
        return this.hasStructuredAnalytics;
    }

    public boolean getDisplayConceptualAnalyticsServerIdentifierType() {
        return this.hasConceptualAnalytics;
    }

    public boolean getDisplayConceptualAnalyticsServerIdentifier() {
        return this.hasConceptualAnalytics;
    }

    public boolean getDisplayDtSearchLocationIdentifierType() {
        return this.hasDtSearchLocation;
    }

    public boolean getDisplayDtSearchLocationIdentifier() {
        return this.hasDtSearchLocation;
    }

    public boolean getDisplayExistingTargetDatabase() {
        return this.backupDoesNotContainDatabaseBackup;
    }

    public CreateArmRestoreOperation() {
        this.requiresCase = false;
        this.waitForCompletion = true;
        this.archivePath = "";
        this.existingTargetDatabase = "";
        this.priority = ArmPriority.MEDIUM;
        this.lockUiJobActions = false;
        this.notifyJobCreator = false;
        this.notifyJobExecutor = false;
        this.backupDoesNotContainDatabaseBackup = false;
        this.databaseServerIdentifier = "";
        this.resourcePoolIdentifier = "";
        this.matterIdentifier = "";
        this.cacheLocationIdentifier = "";
        this.fileRepositoryIdentifier = "";
        this.structuredAnalyticsServerIdentifier = "";
        this.conceptualAnalyticsServerIdentifier = "";
        this.dtSearchLocationIdentifier = "";
        this.useDatabaseIdentifier = false;
        this.useResourcePoolIdentifier = false;
        this.useMatterIdentifier = false;
        this.useCacheLocationIdentifier = false;
        this.useFileRepositoryIdentifier = false;
        this.databaseServerIdentifierType = RelativityIdentifierType.NAME;
        this.resourcePoolIdentifierType = RelativityIdentifierType.NAME;
        this.matterIdentifierType = RelativityIdentifierType.NAME;
        this.cacheLocationIdentifierType = RelativityIdentifierType.NAME;
        this.fileRepositoryIdentifierType = RelativityIdentifierType.NAME;
        this.structuredAnalyticsServerIdentifierType = RelativityIdentifierType.NAME;
        this.conceptualAnalyticsServerIdentifierType = RelativityIdentifierType.NAME;
        this.dtSearchLocationIdentifierType = RelativityIdentifierType.NAME;
        this.hasStructuredAnalytics = false;
        this.hasConceptualAnalytics = false;
        this.hasDtSearchLocation = false;
        this.referenceFilesAsArchiveLinks = false;
        this.updateRepositoryFilePaths = true;
        this.updateLinkedFilePaths = true;
        this.autoMapUsers = true;
        this.autoMapGroups = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityCreateArmRestoreOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityMatterOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetMatterOperation) {
                detectedSetRelativityMatterOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!this.useMatterIdentifier && !detectedSetRelativityMatterOperation) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingSetMatter"));
        }
        if (this.useDatabaseIdentifier && (this.databaseServerIdentifier == null || this.databaseServerIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingDatabaseServer"));
        }
        if (this.useResourcePoolIdentifier && (this.resourcePoolIdentifier == null || this.resourcePoolIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingResourcePool"));
        }
        if (this.useMatterIdentifier && (this.matterIdentifier == null || this.matterIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingMatter"));
        }
        if (this.useCacheLocationIdentifier && (this.cacheLocationIdentifier == null || this.cacheLocationIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingCacheLocation"));
        }
        if (this.useFileRepositoryIdentifier && (this.fileRepositoryIdentifier == null || this.fileRepositoryIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingFileRepository"));
        }
        if (this.hasStructuredAnalytics && (this.structuredAnalyticsServerIdentifier == null || this.structuredAnalyticsServerIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingStructuredAnalyticsServer"));
        }
        if (this.hasConceptualAnalytics && (this.conceptualAnalyticsServerIdentifier == null || this.conceptualAnalyticsServerIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingConceptualAnalyticsServer"));
        }
        if (this.hasDtSearchLocation && (this.dtSearchLocationIdentifier == null || this.dtSearchLocationIdentifier.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingDtSearch"));
        }
        if (this.backupDoesNotContainDatabaseBackup && (this.existingTargetDatabase == null || this.existingTargetDatabase.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmRestoreOperation.Prerequisites.MissingExistingTargetDatabase"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

