/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestLocation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.DELETE_DIGEST_LIST, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class DeleteDigestListOperation
extends Operation {
    @FormField
    public String digestListName = "";
    @FormField
    public Set<DigestLocation> digestLocations = new HashSet<DigestLocation>();

    public DeleteDigestListOperation() {
        this.digestLocations.add(DigestLocation.CASE);
        this.digestLocations.add(DigestLocation.LOCAL_COMPUTER);
        this.digestLocations.add(DigestLocation.USER);
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("DeleteDigestListOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.DELETE_DIGEST_LIST;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.digestListName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("DeleteDigestListOperation.Prerequisites.DigestListNameMustBeSpecified"));
        }
        if (this.digestLocations.isEmpty()) {
            prerequisites.add(this.iu.getString("DeleteDigestListOperation.Prerequisites.MinimumOneLocation"));
        }
        if (this.digestLocations.contains((Object)DigestLocation.LOCAL_COMPUTER) && !System.getProperty("os.name").contains("Windows")) {
            prerequisites.add(this.iu.getFormattedString("DeleteDigestListOperation.Prerequisites.LocationNotSupported", (Object)DigestLocation.LOCAL_COMPUTER));
        }
        this.requiresCase = this.digestLocations.contains((Object)DigestLocation.CASE);
        return prerequisites;
    }
}

