/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DeleteItemSetOperation;
import nuix.ItemSet;

public class DeleteItemSetOperationImplementation
extends DeleteItemSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeleteItemSetOperation.class);
    private transient String stage;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.itemSetName = this.executionContext.evalParameters(this.itemSetName, this);
                this.addExecutionLog(this.iu.getFormattedString("DeleteItemSetOperation.Log.ItemSetName", (Object)this.itemSetName));
                ItemSet itemSet = this.executionContext.nuixCase.findItemSetByName(this.itemSetName);
                if (itemSet == null) {
                    Exception e = new Exception(this.iu.getFormattedString("DeleteItemSetOperation.Exception.DoesNotExist", (Object)this.itemSetName));
                    LOGGER.error("Item set " + this.itemSetName + " does not exist", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.stage = this.iu.getString("DeleteItemSetOperation.Stage.DeletingItemSet");
                this.executionContext.nuixCase.deleteItemSet(itemSet);
                this.addExecutionLog(this.iu.getString("DeleteItemSetOperation.Log.DeletedItemSet"));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.stage != null) {
            result = (String)result + this.stage;
        }
        return result;
    }
}

