/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DeleteItemsOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class DeleteItemsOperationImplementation
extends DeleteItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeleteItemsOperation.class);
    private transient long countTotalItems;
    private transient AtomicLong countItemsProcessed;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.countItemsProcessed = new AtomicLong(0L);
                AtomicLong countItemsFailed = new AtomicLong(0L);
                this.addExecutionLog(this.iu.getFormattedString("DeleteItemsOperation.Log.ScopeQuery", (Object)this.scope));
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countTotalItems = items.size();
                this.addExecutionLog(this.iu.getNumeralString("DeleteItemsOperation.Log.ScopeCount", (long)items.size()));
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        while (iterator.hasNext()) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            Item item = (Item)iterator.next();
                            try {
                                LOGGER.info("Deleting item " + item.getGuid() + "\t" + item.getName());
                                item.removeItemAndDescendants();
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot remove item " + item.getGuid(), (Throwable)e);
                                countItemsFailed.getAndIncrement();
                            }
                            this.countItemsProcessed.getAndIncrement();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                });
                if (countItemsFailed.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("DeleteItemsOperation.Warning.FailedToDelete", countItemsFailed.get()));
                }
                this.addExecutionLog(this.iu.getNumeralString("DeleteItemsOperation.Log.Deleted", this.countItemsProcessed.get() - countItemsFailed.get()));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.countTotalItems != 0L && this.countItemsProcessed != null) {
            percentageComplete = (double)this.countItemsProcessed.get() / (double)this.countTotalItems;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0 && this.countItemsProcessed != null) {
            result = (String)result + this.iu.getNumeralFormattedString("DeleteItemsOperation.Progress.DeletedItems", this.countItemsProcessed.get(), result);
        }
        return result;
    }
}

