/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.common.base.CaseFormat;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.DetectAndAssignCustodiansOperation;
import com.nuix.automate.workflow.core.execution.workflow.DatasetUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nuix.Address;
import nuix.BulkAnnotater;
import nuix.Communication;
import nuix.Item;
import nuix.TreePosition;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class DetectAndAssignCustodiansOperationImplementation
extends DetectAndAssignCustodiansOperation
implements DatasetOperation {
    private static final transient String NO_CUSTODIAN = "[No Custodian]";
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DetectAndAssignCustodiansOperation.class);
    private transient Set<Item> scopeItems;
    private transient Map<Item, String> assignments;
    private transient int totalStages;
    private transient int currentStage;
    private transient String currentStageName;
    private transient int currentStageTotalItems;
    private transient int currentStageProcessedItems;
    private transient HashSet<String> firstNames;
    private transient Map<String, DatasetMetadata> dataSetsMetadata;

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        DetectAndAssignCustodiansOperationImplementation currentOperation = this;
        try {
            this.setCustodiansFromFolderName = BooleanUtils.toBoolean((String)this.executionContext.evalParametersIfSet("{set_custodian_from_folder_name}", this));
            this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.SetCustodianFromFolderNameEnabledFromParameter", new Object[]{"{set_custodian_from_folder_name}", this.setCustodiansFromFolderName}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setCustodiansFromFolderNameDepth = Integer.parseInt(this.executionContext.evalParametersIfSet("{custodian_folder_level}", this));
            this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.SetCustodianFolderLevelFromParameter", new Object[]{"{custodian_folder_level}", this.setCustodiansFromFolderNameDepth}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.automaticDetectionFromFolderName = BooleanUtils.toBoolean((String)this.executionContext.evalParametersIfSet("{set_custodian_from_typical_folder_name}", this));
            this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.SetCustodianFromTypicalFolderNameEnabledFromParameter", new Object[]{"{set_custodian_from_typical_folder_name}", this.automaticDetectionFromFolderName}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.automaticDetectionFromFolderNameMaxDepth = Integer.parseInt(this.executionContext.evalParametersIfSet("{max_custodian_typical_folder_level}", this));
            this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.SetCustodianTypicalFolderLevelMaxDepthFromParameter", new Object[]{"{max_custodian_typical_folder_level}", this.automaticDetectionFromFolderNameMaxDepth}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.automaticDetectionFromPST = BooleanUtils.toBoolean((String)this.executionContext.evalParametersIfSet("{set_custodian_from_pst}", this));
            this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.SetCustodianFromPSTEnabledFromParameter", new Object[]{"{set_custodian_from_pst}", this.automaticDetectionFromPST}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.assignments = new HashMap<Item, String>();
                this.totalStages = 2;
                this.currentStage = 0;
                if (this.automaticDetectionFromFolderName) {
                    ++this.totalStages;
                }
                if (this.automaticDetectionFromPST) {
                    ++this.totalStages;
                }
                if (this.interactiveAssignment) {
                    ++this.totalStages;
                }
                if (this.setCustodiansFromFolderName) {
                    ++this.totalStages;
                }
                if (this.setCustodiansFromDataSetMetadata) {
                    ++this.totalStages;
                }
                this.currentStageName = this.iu.getString("DetectAndAssignCustodiansOperation.Stage.SearchingForItems");
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.ScopeQuery", (Object)this.scope));
                this.addExecutionLog(this.iu.getNumeralString("DetectAndAssignCustodiansOperation.Log.ScopeCount", (long)this.scopeItems.size()));
                ++this.currentStage;
                if (this.setCustodiansFromFolderName) {
                    if (this.setCustodiansFromFolderNameDepth >= 0) {
                        this.addExecutionLog(this.iu.getNumeralString("DetectAndAssignCustodiansOperation.Log.SetCustodiansFromFolderNamesDepth", (long)this.setCustodiansFromFolderNameDepth));
                        this.currentStageName = this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Stage.SettingCustodiansFromFolder", (Object)this.setCustodiansFromFolderNameDepth);
                        this.setCustodiansFromFolderNames();
                    }
                    ++this.currentStage;
                }
                if (this.automaticDetectionFromFolderName) {
                    if (this.automaticDetectionFromFolderNameMaxDepth >= 0) {
                        this.addExecutionLog(this.iu.getNumeralString("DetectAndAssignCustodiansOperation.Log.SetCustodiansFromFolderWithTypicalCustodianNamesMaxDepth", (long)this.automaticDetectionFromFolderNameMaxDepth));
                        this.currentStageName = this.iu.getString("DetectAndAssignCustodiansOperation.Stage.DetectingCustodiansFromFolderNames");
                        this.detectCustodiansFromFolderNames();
                    }
                    ++this.currentStage;
                }
                if (this.automaticDetectionFromPST) {
                    this.addExecutionLog(this.iu.getString("DetectAndAssignCustodiansOperation.Log.SetCustodiansFromPSTFilesSentEmailsSenderName"));
                    this.currentStageName = this.iu.getString("DetectAndAssignCustodiansOperation.Stage.DetectingCustodiansFromPSTFiles");
                    this.detectCustodiansFromPSTFiles();
                    ++this.currentStage;
                }
                if (this.setCustodiansFromDataSetMetadata) {
                    this.addExecutionLog(this.iu.getString("DetectAndAssignCustodiansOperation.Log.SetCustodiansFromDataSetMetadata"));
                    this.currentStageName = this.iu.getString("DetectAndAssignCustodiansOperation.Stage.SetCustodiansFromDataSetMetadata");
                    this.setSetCustodiansFromDataSetMetadata();
                    ++this.currentStage;
                }
                LOGGER.info("Applying assignments");
                this.currentStageTotalItems = 0;
                this.currentStageProcessedItems = 0;
                this.currentStageName = this.iu.getString("DetectAndAssignCustodiansOperation.Stage.AssigningCustodians");
                this.applyAssignments();
                ++this.currentStage;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void detectCustodiansFromPSTFiles() throws IOException {
        this.currentStageTotalItems = 0;
        this.currentStageProcessedItems = 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Searching for PST files");
        }
        Set pstItems = this.executionContext.nuixCase.searchUnsorted("mime-type:application/vnd.ms-outlook");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Items in scope: " + FormattingUtils.itemsCountToDisplay((long)pstItems.size()));
        }
        this.currentStageTotalItems = pstItems.size();
        for (Item pstItem : pstItems) {
            if (!this.scopeItems.contains(pstItem)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Handling pst file " + pstItem.getName());
            }
            boolean pathHasCustodianAssigned = false;
            List pathItems = pstItem.getPath();
            for (Item pathItem : pathItems) {
                if (!this.assignments.containsKey(pathItem)) continue;
                pathHasCustodianAssigned = true;
                break;
            }
            if (pathHasCustodianAssigned) {
                ++this.currentStageProcessedItems;
                continue;
            }
            String query = "path-guid:" + pstItem.getGuid() + " mime-type:application/vnd.ms-outlook-folder (name:\"Sent Items\" OR \"Sent\")";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Searching for Sent Items - " + query);
            }
            Set sentItems = this.executionContext.nuixCase.searchUnsorted(query);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("    Items in scope: " + FormattingUtils.itemsCountToDisplay((long)sentItems.size()));
            }
            HashMap<String, Integer> tentativeCustodians = new HashMap<String, Integer>();
            block2: for (Item sentItem : sentItems) {
                query = "path-guid:" + sentItem.getGuid() + " mime-type:application/vnd.ms-outlook-note";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("    Searching for Sent Emails - " + query);
                }
                Set sentEmailsItems = this.executionContext.nuixCase.searchUnsorted(query);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("      Items in scope: " + FormattingUtils.itemsCountToDisplay((long)sentEmailsItems.size()));
                }
                boolean foundEmailWithSender = false;
                for (Item sentEmail : sentEmailsItems) {
                    Communication communication = sentEmail.getCommunication();
                    if (communication != null) {
                        List fromAddresses = communication.getFrom();
                        for (Address fromAddress : fromAddresses) {
                            String tentativeCustodianName = fromAddress.getPersonal();
                            if (tentativeCustodianName == null || (tentativeCustodianName = tentativeCustodianName.trim()).length() <= 0) continue;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("        Found email with sender: " + tentativeCustodianName);
                            }
                            int seenCustodianTimes = tentativeCustodians.getOrDefault(tentativeCustodianName, 0);
                            tentativeCustodians.put(tentativeCustodianName, seenCustodianTimes + 1);
                            foundEmailWithSender = true;
                            break;
                        }
                    }
                    if (!foundEmailWithSender) continue;
                    continue block2;
                }
            }
            StringBuilder custodiansRepresentation = new StringBuilder();
            String mostFrequentCustodianName = "";
            int mostFrequentCustodianOccurrences = 0;
            for (String custodian : tentativeCustodians.keySet()) {
                int custodianOccurrences = (Integer)tentativeCustodians.get(custodian);
                if (custodianOccurrences > mostFrequentCustodianOccurrences) {
                    mostFrequentCustodianOccurrences = custodianOccurrences;
                    mostFrequentCustodianName = custodian;
                }
                String representation = custodian + " (" + custodianOccurrences + "), ";
                custodiansRepresentation.append(representation);
            }
            if (mostFrequentCustodianOccurrences > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  Most frequent custodian: " + mostFrequentCustodianName);
                }
                this.assignments.put(pstItem, mostFrequentCustodianName);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  No custodians were identified");
            }
            ++this.currentStageProcessedItems;
        }
    }

    private void setSetCustodiansFromDataSetMetadata() throws IOException {
        List rootItems = this.executionContext.nuixCase.getRootItems();
        long itemsWithoutCustodianHeader = 0L;
        for (Item rootItem : rootItems) {
            if (!this.scopeItems.contains(rootItem)) continue;
            for (Item item : rootItem.getChildren()) {
                if (!this.scopeItems.contains(item)) {
                    LOGGER.info("=== not in scope, skipping");
                    continue;
                }
                DatasetMetadata dataSetMetadata = DatasetUtils.getFileDataSet(this.dataSetsMetadata, item);
                if (dataSetMetadata == null) continue;
                if (dataSetMetadata.getDatasetCustodian() != null) {
                    this.assignments.put(item, dataSetMetadata.getDatasetCustodian());
                    continue;
                }
                int custodianPos = -1;
                List header = dataSetMetadata.getMetadataFieldNames();
                if (header != null) {
                    for (int i = 0; i < header.size(); ++i) {
                        if (!((String)header.get(i)).equalsIgnoreCase("custodian")) continue;
                        if (custodianPos != -1) {
                            throw new IOException(this.iu.getFormattedString("DataSetMetadata.Exception.ColumnFoundMultipleTimes", (Object)"Custodian"));
                        }
                        custodianPos = i;
                        LOGGER.info("Detected custodian at column " + (i + 1));
                    }
                }
                if (custodianPos > -1) {
                    String custodian = null;
                    List fileMetadata = (List)dataSetMetadata.getFilesMetadata().get(DatasetUtils.getRelativePathForDatasetItem(item));
                    if (fileMetadata != null && fileMetadata.size() > custodianPos) {
                        custodian = (String)fileMetadata.get(custodianPos);
                    }
                    if (custodian != null && custodian.length() > 0) {
                        this.assignments.put(item, custodian);
                        continue;
                    }
                    ++itemsWithoutCustodianHeader;
                    continue;
                }
                ++itemsWithoutCustodianHeader;
            }
        }
    }

    private void setCustodiansFromFolderNames() throws IOException {
        this.readFirstNamesDictionary();
        List rootItems = this.executionContext.nuixCase.getRootItems();
        for (Item item : rootItems) {
            this.setCustodiansFromFolderNames(item);
        }
    }

    private void detectCustodiansFromFolderNames() throws IOException {
        this.readFirstNamesDictionary();
        List rootItems = this.executionContext.nuixCase.getRootItems();
        for (Item item : rootItems) {
            this.detectCustodiansFromFolderNames(item);
        }
    }

    private void readFirstNamesDictionary() {
        ArrayList<String> dictionaryNames = new ArrayList<String>();
        dictionaryNames.add("/dictionary/EnglishNames.txt");
        dictionaryNames.add("/dictionary/FrenchNames.txt");
        dictionaryNames.add("/dictionary/IrishNames.txt");
        this.firstNames = new HashSet();
        for (String dictionaryName : dictionaryNames) {
            LOGGER.info("Loading dictionary " + dictionaryName);
            try {
                InputStream stream = this.getClass().getResourceAsStream(dictionaryName);
                try {
                    String[] lines;
                    String script = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    for (String line : lines = script.split("[\\r\\n]+")) {
                        this.firstNames.add(StringUtils.strip((String)line).toLowerCase());
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot read dictionary", (Throwable)e);
            }
        }
    }

    private void setCustodiansFromFolderNames(Item item) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing item " + item.getPosition().toString() + " " + item.getGuid() + " " + item.getName());
        }
        if (!this.scopeItems.contains(item)) {
            return;
        }
        if (item.getPathNames().size() - 1 < this.setCustodiansFromFolderNameDepth) {
            List children = item.getChildren();
            for (Item child : children) {
                if (!child.isKind("container")) continue;
                this.setCustodiansFromFolderNames(child);
            }
        } else if (item.getPathNames().size() - 1 == this.setCustodiansFromFolderNameDepth) {
            Object pstName;
            if (item.getType().getName().equals("application/vnd.ms-outlook") && (pstName = item.getProperties().get("PST Name")) != null) {
                this.assignments.put(item, pstName.toString());
                return;
            }
            this.assignments.put(item, item.getName());
        }
    }

    private void detectCustodiansFromFolderNames(Item item) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing item " + item.getPosition().toString() + " " + item.getGuid() + " " + item.getName());
        }
        if (!this.scopeItems.contains(item)) {
            return;
        }
        String itemName = item.getName();
        itemName = StringUtils.stripAccents((String)itemName);
        itemName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, itemName);
        itemName = itemName.replace("'_", "'");
        String[] splits = itemName.split("[,;0123456789\\[\\]\\(\\)\\._\\s]+");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Splits of -" + itemName + "-: " + splits.length);
        }
        boolean folderIsName = false;
        StringBuilder assembledName = new StringBuilder();
        if (splits.length > 0 && splits.length <= 3) {
            int countNames = 0;
            for (String split : splits) {
                String[] splitParts;
                if (this.firstNames.contains(split.toLowerCase())) {
                    ++countNames;
                } else if (split.contains("-") && (splitParts = split.split("-")).length == 2 && this.firstNames.contains(splitParts[0].toLowerCase()) && this.firstNames.contains(splitParts[1].toLowerCase())) {
                    ++countNames;
                }
                if (assembledName.length() > 0) {
                    assembledName.append(" ");
                }
                assembledName.append(StringUtils.capitalize((String)split));
            }
            if (countNames > 0) {
                folderIsName = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  Folder is name ");
                }
            }
        }
        if (folderIsName) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Detected custodian: " + String.valueOf(assembledName));
            }
            this.assignments.put(item, assembledName.toString());
        } else if (item.getPath().size() <= this.automaticDetectionFromFolderNameMaxDepth && !item.getType().getName().equals("application/vnd.ms-outlook")) {
            List children = item.getChildren();
            for (Item child : children) {
                if (!child.isKind("container")) continue;
                this.detectCustodiansFromFolderNames(child);
            }
        }
    }

    private void applyAssignments() {
        this.currentStageTotalItems = this.assignments.size();
        this.currentStageProcessedItems = 0;
        HashMap itemsGuidsExclusionsGuids = new HashMap();
        BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
        for (Item item : this.assignments.keySet()) {
            itemsGuidsExclusionsGuids.put(item.getGuid(), new HashSet());
        }
        for (Item item : this.assignments.keySet()) {
            Item itemPath;
            List itemPaths = item.getPath();
            Iterator iterator = itemPaths.iterator();
            while (iterator.hasNext() && !(itemPath = (Item)iterator.next()).equals((Item)itemPaths.get(itemPaths.size() - 1))) {
                if (!itemsGuidsExclusionsGuids.containsKey(itemPath.getGuid())) continue;
                Set exclusionsGuids = (Set)itemsGuidsExclusionsGuids.get(itemPath.getGuid());
                exclusionsGuids.add(item.getGuid());
            }
            itemsGuidsExclusionsGuids.put(item.getGuid(), new HashSet());
        }
        TreeMap<TreePosition, Item> sortedItems = new TreeMap<TreePosition, Item>();
        for (Item item : this.assignments.keySet()) {
            sortedItems.put(item.getPosition(), item);
        }
        for (TreePosition treePosition : sortedItems.keySet()) {
            Item item = (Item)sortedItems.get(treePosition);
            String custodian = this.assignments.get(item);
            LOGGER.info("Assigning to item " + item.getPosition().toString() + " " + item.getGuid() + " " + item.getName() + "\tCustodian: " + custodian);
            StringBuilder exclusions = new StringBuilder();
            for (String exclusion : (Set)itemsGuidsExclusionsGuids.get(item.getGuid())) {
                if (exclusions.length() > 0) {
                    exclusions.append(", ");
                }
                exclusions.append(exclusion);
            }
            LOGGER.info("  Exclusions: " + exclusions.toString());
            Object query = "guid:" + item.getGuid() + " OR path-guid:" + item.getGuid();
            StringBuilder exclusionsQuery = new StringBuilder();
            for (String exclusion : (Set)itemsGuidsExclusionsGuids.get(item.getGuid())) {
                if (exclusionsQuery.length() > 0) {
                    exclusionsQuery.append(" OR ");
                }
                String exclusionQuery = "(guid:" + exclusion + " OR path-guid:" + exclusion + ")";
                exclusionsQuery.append(exclusionQuery);
            }
            if (exclusionsQuery.length() > 0) {
                query = "(" + (String)query + ") AND NOT (" + exclusionsQuery.toString() + ")";
            }
            query = NuixUtils.addAndQuery(this.scope, (String)query);
            LOGGER.info("  Query: " + (String)query);
            try {
                Set itemsInScope = this.executionContext.nuixCase.searchUnsorted((String)query);
                LOGGER.info("  Items in scope: " + FormattingUtils.itemsCountToDisplay((long)itemsInScope.size()));
                if (custodian.equals(NO_CUSTODIAN)) {
                    bulkAnnotater.unassignCustodian((Collection)itemsInScope);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectAndAssignCustodiansOperation.Log.UnassignedCustodianFrom", (long)itemsInScope.size(), (Object)item.getName()));
                } else {
                    bulkAnnotater.assignCustodian(custodian, (Collection)itemsInScope);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectAndAssignCustodiansOperation.Log.AssignedCustodian", (long)itemsInScope.size(), new Object[]{custodian, item.getName()}));
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot execute query", (Throwable)e);
                this.addWarning("Cannot execute query, " + e.getMessage());
            }
            ++this.currentStageProcessedItems;
        }
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.currentStageName != null && this.currentStageName.length() > 0) {
            result = (String)result + " / " + this.currentStageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double result = 0.0;
        if (this.totalStages > 0) {
            double stagePercentage = 0.0;
            if (this.currentStageTotalItems > 0) {
                stagePercentage = (double)this.currentStageProcessedItems / (double)this.currentStageTotalItems;
            }
            result = ((double)this.currentStage + stagePercentage) / (double)this.totalStages;
        }
        result = Math.max(1.0E-4, Math.min(0.9999, result));
        return result;
    }

    @Override
    public void setDatasetsMetadata(Map<String, DatasetMetadata> datasetsMetadata) {
        this.dataSetsMetadata = datasetsMetadata;
    }
}

