/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DetectThreadingAttachmentImpliedOperation;
import com.nuix.automate.workflow.core.execution.operations.EmailThread;
import com.nuix.automate.workflow.core.execution.operations.ThreadItem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nuix.BulkAnnotater;
import nuix.ClusterItem;
import nuix.ClusterRun;
import nuix.Item;
import nuix.ItemUtility;

public class DetectThreadingAttachmentImpliedOperationImplementation
extends DetectThreadingAttachmentImpliedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DetectThreadingAttachmentImpliedOperation.class);
    private transient long processedClustersCount = 0L;
    private transient long totalClustersCount = 0L;
    private transient Set<Item> scopeItems;
    private transient String stageName = "";

    private String getHash(Item item) {
        Object originalMd5Digest;
        String md5 = item.getDigests().getMd5();
        if ((md5 == null || md5.length() == 0) && (originalMd5Digest = item.getProperties().get("Original MD5 Digest")) != null) {
            md5 = originalMd5Digest.toString();
        }
        return md5;
    }

    @Override
    public void startTriggered() throws Exception {
        this.stageName = "";
        LOGGER.info("Starting execution");
        this.executionContext.closeAllTabs();
        this.clusterRunName = this.executionContext.evalParameters(this.clusterRunName, this);
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.addExecutionLog(this.iu.getFormattedString("DetectThreadingAttachmentImpliedOperation.Log.ScopeQuery", (Object)this.scope));
        if (this.scope.length() > 0) {
            this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
            LOGGER.info("Scope items: " + this.scopeItems.size());
            this.addExecutionLog(this.iu.getNumeralString("DetectThreadingAttachmentImpliedOperation.Log.ScopeCount", (long)this.scopeItems.size()));
        } else {
            this.scopeItems = null;
        }
        this.addExecutionLog(this.iu.getFormattedString("DetectThreadingAttachmentImpliedOperation.Log.IgnoreImmaterial", (Object)this.ignoreImmaterialFamilyItems));
        this.startTriggerThread = new Thread(() -> {
            try {
                List clusters;
                List clusterRuns = this.executionContext.nuixCase.getClusterRuns();
                int clusterRunsInScope = 0;
                for (ClusterRun clusterRun : clusterRuns) {
                    LOGGER.info("Got clusterRun " + clusterRun.getName());
                    if (this.clusterRunName.length() == 0 || this.clusterRunName.trim().equalsIgnoreCase(clusterRun.getName().trim())) {
                        clusters = clusterRun.getClusters();
                        this.totalClustersCount += (long)clusters.size();
                        LOGGER.info("Cluster run is in scope");
                        ++clusterRunsInScope;
                        continue;
                    }
                    LOGGER.info("Cluster run is NOT in scope");
                }
                if (clusterRunsInScope == 0) {
                    if (clusterRuns.size() == 0) {
                        this.addWarning(this.iu.getString("DetectThreadingAttachmentImpliedOperation.Warning.NoClusterRunsDetectedInCase"));
                    } else {
                        this.addWarning(this.iu.getString("DetectThreadingAttachmentImpliedOperation.Warning.NoClusterRunsWithRequiredNameDetected"));
                    }
                }
                for (ClusterRun clusterRun : clusterRuns) {
                    void var12_18;
                    if (this.clusterRunName.length() != 0 && !this.clusterRunName.trim().equalsIgnoreCase(clusterRun.getName().trim())) continue;
                    LOGGER.info("Processing clusterRun " + clusterRun.getName());
                    clusters = clusterRun.getClusters();
                    ConcurrentHashMap.KeySetView endpointAttachmentsInferred = ConcurrentHashMap.newKeySet();
                    clusters.parallelStream().forEach(cluster -> {
                        if (this.stopRequested) {
                            this.executionState = ExecutionState.STOPPED;
                            return;
                        }
                        String threadName = clusterRun.getName() + "-" + cluster.getId();
                        if (cluster.getId() > 0) {
                            String attachmentMd5;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("   Detected thread " + threadName);
                            }
                            HashSet<ThreadItem> threadItemsWithAttachmentsWithNoHashes = new HashSet<ThreadItem>();
                            HashSet<Item> itemsWithAttachmentsWithNoHashes = new HashSet<Item>();
                            EmailThread thread = new EmailThread();
                            List clusterItems = cluster.getItems();
                            for (ClusterItem clusterItem : clusterItems) {
                                void var12_12;
                                if (this.scopeItems != null && !this.scopeItems.contains(clusterItem.getItem())) continue;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("       Got clusterItem " + clusterItem.getItem().getGuid() + " (" + clusterItem.getItem().getName() + ")");
                                }
                                Map itemEndpointStatuses = clusterItem.getItem().getClusterEndpointStatus();
                                String string = "";
                                if (itemEndpointStatuses.containsKey(threadName)) {
                                    String string2 = (String)itemEndpointStatuses.get(threadName);
                                    if (string2 == null) {
                                        String string3 = "";
                                    }
                                } else {
                                    LOGGER.warn("Item " + clusterItem.getItem().getGuid() + "does not have status in thread");
                                }
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("           Status " + (String)var12_12);
                                }
                                ThreadItem threadItem = new ThreadItem(clusterItem.getItem(), (String)var12_12);
                                thread.getThreadItems().add(threadItem);
                                List list = clusterItem.getItem().getDescendants();
                                for (Item child : list) {
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("           Got attachment " + child.getDigests().getMd5() + " (" + child.getName() + "), audited:" + child.isAudited() + ", kind:" + child.getKind().getName());
                                    }
                                    threadItem.getAttachments().add(child);
                                }
                            }
                            Set<ThreadItem> threadItems = thread.getThreadItems();
                            HashSet<String> threadUnaccountedAttachmentsHashes = new HashSet<String>();
                            for (ThreadItem threadItem : threadItems) {
                                for (Item item : threadItem.getAttachments()) {
                                    String attachmentMd52 = this.getHash(item);
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("   Detected attachment " + attachmentMd52);
                                    }
                                    if (!item.isAudited() && this.ignoreImmaterialFamilyItems) continue;
                                    if (attachmentMd52 != null && attachmentMd52.length() > 0) {
                                        if (item.isExcluded() && LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("      Skipping" + item.getGuid() + " (" + item.getName() + ") is excluded, skipping");
                                        }
                                        if (item.isAudited() || !this.ignoreImmaterialFamilyItems) {
                                            if (LOGGER.isDebugEnabled()) {
                                                LOGGER.debug("      Tracking " + item.getDigests().getMd5() + " (" + item.getName() + "), audited:" + item.isAudited() + ", kind:" + item.getKind().getName());
                                            }
                                            threadUnaccountedAttachmentsHashes.add(attachmentMd52);
                                        } else if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("      Skipping " + item.getDigests().getMd5() + " (" + item.getName() + "), audited:" + item.isAudited() + ", kind:" + item.getKind().getName());
                                        }
                                        thread.addAttachment(attachmentMd52, threadItem);
                                        continue;
                                    }
                                    if (!item.isAudited()) continue;
                                    LOGGER.warn("      Attachment " + item.getGuid() + " (" + item.getName() + ") does not have MD5 hash, skipping");
                                    threadItemsWithAttachmentsWithNoHashes.add(threadItem);
                                    itemsWithAttachmentsWithNoHashes.add(threadItem.getItem());
                                    endpointAttachmentsInferred.add(threadItem.getItem());
                                }
                            }
                            HashSet<Item> endpointItems = new HashSet<Item>();
                            for (ThreadItem threadItem : threadItems) {
                                if (!threadItem.getStatus().startsWith("endpoint")) continue;
                                endpointItems.add(threadItem.getItem());
                                for (Item attachment : threadItem.getAttachments()) {
                                    attachmentMd5 = this.getHash(attachment);
                                    if (attachmentMd5 == null || attachmentMd5.length() <= 0) continue;
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("   Attachment " + attachmentMd5 + " contained by item " + threadItem.getItem().getGuid());
                                    }
                                    threadUnaccountedAttachmentsHashes.remove(attachmentMd5);
                                }
                            }
                            for (ThreadItem threadItem : threadItemsWithAttachmentsWithNoHashes) {
                                for (Item attachment : threadItem.getAttachments()) {
                                    attachmentMd5 = this.getHash(attachment);
                                    if (attachmentMd5 == null || attachmentMd5.length() <= 0) continue;
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("   Attachment " + attachmentMd5 + " contained by inferred item " + threadItem.getItem().getGuid());
                                    }
                                    threadUnaccountedAttachmentsHashes.remove(attachmentMd5);
                                }
                            }
                            HashSet<Item> hashSet = new HashSet<Item>();
                            while (threadUnaccountedAttachmentsHashes.size() > 0) {
                                String string = (String)threadUnaccountedAttachmentsHashes.iterator().next();
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("   Handling unaccounted attachment " + string);
                                }
                                threadItems = thread.getAttachmentsMd5ToThreadItems().get(string);
                                ThreadItem threadItem = threadItems.iterator().next();
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("       Designating email " + threadItem.getItem().getGuid());
                                }
                                hashSet.add(threadItem.getItem());
                                endpointAttachmentsInferred.add(threadItem.getItem());
                                for (Item designatedThreadItemAttachment : threadItem.getAttachments()) {
                                    String designatedThreadItemAttachmentMd5 = this.getHash(designatedThreadItemAttachment);
                                    if (designatedThreadItemAttachmentMd5 == null || designatedThreadItemAttachmentMd5.length() <= 0) continue;
                                    boolean attachmentPreviouslyUnaccounted = threadUnaccountedAttachmentsHashes.remove(designatedThreadItemAttachmentMd5);
                                    if (designatedThreadItemAttachmentMd5.equals(string) || !attachmentPreviouslyUnaccounted || !LOGGER.isDebugEnabled()) continue;
                                    LOGGER.debug("       Email handled previously unaccounted attachment " + designatedThreadItemAttachmentMd5);
                                }
                            }
                        }
                        ++this.processedClustersCount;
                    });
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    LOGGER.info("Removing all previous tags");
                    ArrayList<CallSite> tags = new ArrayList<CallSite>();
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|Items|Inclusive|Attachment-Inferred")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Attachment-Inferred")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|Items|Inclusive|Singular")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Singular")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|Items|Inclusive|Ignored")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Ignored")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|Items|Inclusive|Endpoint")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Endpoint")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|Items|Non Inclusive")));
                    tags.add((CallSite)((Object)("Threading|" + clusterRun.getName() + "|All Families|Non Inclusive")));
                    String query = "tag:\"Threading|" + clusterRun.getName() + "|Analysis|*\" OR tag:\"Threading|" + clusterRun.getName() + "|All Families|*\"";
                    Set taggedItems = this.executionContext.nuixCase.searchUnsorted(query);
                    if (taggedItems.size() > 0) {
                        for (String string : tags) {
                            this.stageName = this.iu.getFormattedString("DetectThreadingAttachmentImpliedOperation.Stage.RemovingTag", (Object)string);
                            LOGGER.info("   Removing tag " + string);
                            bulkAnnotater.removeTag(string, (Collection)taggedItems);
                        }
                    }
                    this.addExecutionLog(this.iu.getNumeralString("DetectThreadingAttachmentImpliedOperation.Log.RemovedTagsFrom", (long)taggedItems.size()));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingItemsInclusiveAttachmentInferred");
                    LOGGER.info("       Tagging " + endpointAttachmentsInferred.size() + " items with Threading|" + clusterRun.getName() + "|Items|Inclusive|Attachment-Inferred");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|Items|Inclusive|Attachment-Inferred", endpointAttachmentsInferred);
                    this.addExecutionLog(this.iu.getFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingItemsThreadingInclusive", new Object[]{endpointAttachmentsInferred.size(), clusterRun.getName()}));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingAllFamiliesInclusiveAttachmentInferred");
                    ItemUtility itemUtility = this.executionContext.nuixUtilities.getItemUtility();
                    Set set = itemUtility.findFamilies(endpointAttachmentsInferred);
                    if (this.scopeItems != null) {
                        Set set2 = itemUtility.intersection((Collection)set, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + var12_18.size() + " items with Threading|" + clusterRun.getName() + "|All Families|Inclusive|Attachment-Inferred");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Attachment-Inferred", (Collection)var12_18);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingItemsThreadingAllFamilies", (long)var12_18.size(), (Object)clusterRun.getName()));
                    Object var12_13 = null;
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingItemsInclusiveSingular");
                    Set unclusteredItems = this.executionContext.nuixCase.searchUnsorted("cluster:\"" + clusterRun.getName() + ";unclustered\"");
                    if (this.scopeItems != null) {
                        unclusteredItems = itemUtility.intersection((Collection)unclusteredItems, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + unclusteredItems.size() + " items with Threading|" + clusterRun.getName() + "|Items|Inclusive|Singular");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|Items|Inclusive|Singular", (Collection)unclusteredItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingInclusiveSingular", (long)unclusteredItems.size(), (Object)clusterRun.getName()));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingAllFamiliesInclusiveSingular");
                    Set unclusteredItemsFamilies = itemUtility.findFamilies((Collection)unclusteredItems);
                    unclusteredItems = null;
                    if (this.scopeItems != null) {
                        unclusteredItemsFamilies = itemUtility.intersection((Collection)unclusteredItemsFamilies, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + unclusteredItemsFamilies.size() + " items with Threading|" + clusterRun.getName() + "|All Families|Inclusive|Singular");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Singular", (Collection)unclusteredItemsFamilies);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingAllFamiliesInclusiveSingular", (long)unclusteredItemsFamilies.size(), (Object)clusterRun.getName()));
                    unclusteredItemsFamilies = null;
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingItemsInclusiveIgnored");
                    Set ignoredItems = this.executionContext.nuixCase.searchUnsorted("cluster:\"" + clusterRun.getName() + ";ignored\"");
                    if (this.scopeItems != null) {
                        ignoredItems = itemUtility.intersection((Collection)ignoredItems, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + ignoredItems.size() + " items with Threading|" + clusterRun.getName() + "|Items|Inclusive|Ignored");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|Items|Inclusive|Ignored", (Collection)ignoredItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingInclusiveIgnored", (long)ignoredItems.size(), (Object)clusterRun.getName()));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingAllFamiliesInclusiveIgnored");
                    Set ignoredItemsFamilies = itemUtility.findFamilies((Collection)ignoredItems);
                    if (this.scopeItems != null) {
                        ignoredItemsFamilies = itemUtility.intersection((Collection)ignoredItemsFamilies, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + ignoredItemsFamilies.size() + " items with Threading|" + clusterRun.getName() + "|All Families|Inclusive|Ignored");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Ignored", (Collection)ignoredItemsFamilies);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingAllFamiliesInclusiveIgnored", (long)ignoredItemsFamilies.size(), (Object)clusterRun.getName()));
                    ignoredItemsFamilies = null;
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingItemsInclusiveEndpoint");
                    Set endpointItems = this.executionContext.nuixCase.searchUnsorted("cluster:\"" + clusterRun.getName() + ";;endpoint\" OR cluster:\"" + clusterRun.getName() + ";;endpoint-attach\"");
                    if (this.scopeItems != null) {
                        endpointItems = itemUtility.intersection((Collection)endpointItems, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + endpointItems.size() + " items with Threading|" + clusterRun.getName() + "|Items|Inclusive|Endpoint");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|Items|Inclusive|Endpoint", (Collection)endpointItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingInclusiveEndpoint", (long)endpointItems.size(), (Object)clusterRun.getName()));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingAllFamiliesInclusiveEndpoint");
                    Set endpointItemsFamilies = itemUtility.findFamilies((Collection)endpointItems);
                    endpointItems = null;
                    if (this.scopeItems != null) {
                        endpointItemsFamilies = itemUtility.intersection((Collection)endpointItemsFamilies, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + endpointItemsFamilies.size() + " items with Threading|" + clusterRun.getName() + "|All Families|Inclusive|Endpoint");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|All Families|Inclusive|Endpoint", (Collection)endpointItemsFamilies);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingAllFamiliesInclusiveEndpoint", (long)endpointItemsFamilies.size(), (Object)clusterRun.getName()));
                    endpointItemsFamilies = null;
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingItemsNonInclusive");
                    Set nonInclusiveItems = this.executionContext.nuixCase.searchUnsorted("cluster:\"" + clusterRun.getName() + "\" and !tag:\"Threading|" + clusterRun.getName() + "|Items|Inclusive|Singular\" and !tag:\"Threading|" + clusterRun.getName() + "|Items|Inclusive|Attachment-Inferred\" and !tag:\"Threading|" + clusterRun.getName() + "|Items|Inclusive|Endpoint\" and !tag:\"Threading|" + clusterRun.getName() + "|Items|Inclusive|Ignored\"");
                    if (this.scopeItems != null) {
                        nonInclusiveItems = itemUtility.intersection((Collection)nonInclusiveItems, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + nonInclusiveItems.size() + " items with Threading|" + clusterRun.getName() + "|Items|Non Inclusive");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|Items|Non Inclusive", (Collection)nonInclusiveItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingNonInclusive", (long)nonInclusiveItems.size(), (Object)clusterRun.getName()));
                    this.stageName = this.iu.getString("DetectThreadingAttachmentImpliedOperation.Stage.TaggingAllFamiliesNonInclusive");
                    Set nonInclusiveItemsFamilies = itemUtility.findFamilies((Collection)nonInclusiveItems);
                    nonInclusiveItems = null;
                    if (this.scopeItems != null) {
                        nonInclusiveItemsFamilies = itemUtility.intersection((Collection)nonInclusiveItemsFamilies, this.scopeItems);
                    }
                    LOGGER.info("       Tagging " + nonInclusiveItemsFamilies.size() + " items with Threading|" + clusterRun.getName() + "|All Families|Non Inclusive");
                    bulkAnnotater.addTag("Threading|" + clusterRun.getName() + "|All Families|Non Inclusive", (Collection)nonInclusiveItemsFamilies);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DetectThreadingAttachmentImpliedOperation.Log.TaggingAllFamiliesNonInclusive", (long)nonInclusiveItemsFamilies.size(), (Object)clusterRun.getName()));
                    nonInclusiveItemsFamilies = null;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                LOGGER.info("Done processing error");
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 95.0);
        }
        result = this.stageName != null && this.stageName.length() > 0 ? (String)result + " / " + this.stageName : (String)result + this.iu.getNumeralString("DetectThreadingAttachmentImpliedOperation.Progress.ClustersProcessed", this.processedClustersCount);
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        if (this.totalClustersCount > 0L) {
            return (double)this.processedClustersCount / (double)this.totalClustersCount;
        }
        return 0.0;
    }
}

