/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.DIGEST_LIST_EXPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class DigestListExportOperation
extends Operation {
    @FormField
    public String digestListName;
    @FormField
    public String exportLocation;
    @FormField
    public boolean overwriteIfExists;

    public DigestListExportOperation() {
        this.requiresCase = false;
        this.digestListName = "";
        this.exportLocation = "";
        this.overwriteIfExists = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("DigestListExportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.DIGEST_LIST_EXPORT;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.digestListName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("DigestListExportOperation.Prerequisites.ListNameMustBeSpecified"));
        }
        if (this.exportLocation.trim().length() == 0) {
            prerequisites.add(this.iu.getString("DigestListExportOperation.Prerequisites.ExportLocationMustBeSpecified"));
        }
        return prerequisites;
    }
}

