/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Presence;
import com.nuix.automate.utils.ecc.responses.jobs.Job;
import com.nuix.automate.utils.ecc.responses.jobs.JobStatus;
import com.nuix.automate.utils.ecc.responses.tasks.TaskType;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.ecc.EccRestClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@OperationLicenseModule(module=ModuleType.ECC_COLLECTIONS)
public abstract class EccOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EccOperation.class);
    protected transient String stageName;
    protected transient double percentageComplete;
    protected transient EccRestClient eccRestClient;
    protected final transient EnumSet<JobStatus> finishedJobStates = EnumSet.of(JobStatus.FINISHED, JobStatus.CANCELLED, JobStatus.FAILED, JobStatus.SUSPENDED);
    protected final transient EnumSet<JobStatus> waitingJobStates = EnumSet.of(JobStatus.WAITING, JobStatus.AWAITING_RESOURCE, JobStatus.PENDING, JobStatus.PICKED_UP, JobStatus.READY);

    protected void initializeEccClient() throws ParameterException, GeneralSecurityException {
        String eccServiceId = this.executionContext.evalParametersIfSet("{ecc_service_id}", this);
        String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this).trim();
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        try {
            whitelistedCertFingerprints.addAll((Collection)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{ecc_whitelisted_cert_fingerprints}", this)));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        try {
            whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this).trim());
        }
        catch (ParameterException e) {
            LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
        }
        this.eccRestClient = new EccRestClient(eccServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.eccRestClient.setOperation(this);
    }

    protected String getCollectionPart(String collectionName, int collectionPart, int totalCollectionParts) {
        if (totalCollectionParts == 1) {
            return collectionName;
        }
        return collectionName + " (" + collectionPart + " of " + totalCollectionParts + ")";
    }

    protected boolean isJobInFinishedState(Job job) {
        if (job == null || job.getStatus() == null) {
            return false;
        }
        return this.finishedJobStates.contains(job.getStatus());
    }

    protected boolean wasJobSuccessful(Job job) {
        if (job == null || job.getStatus() == null) {
            return false;
        }
        return job.getStatus() == JobStatus.FINISHED;
    }

    protected boolean jobCollectsFiles(Job job) {
        if (job == null || job.getTaskType() == null) {
            return false;
        }
        return job.getTaskType() == TaskType.COLLECT || job.getTaskType() == TaskType.COLLECT_AND_DELETE || job.getTaskType() == TaskType.DISK_IMAGE || job.getTaskType() == TaskType.NETWORK_CAPTURE;
    }

    protected boolean isJobInWaitingState(Job job) {
        if (job == null || job.getStatus() == null) {
            return false;
        }
        return this.waitingJobStates.contains(job.getStatus());
    }

    protected Map<String, Computer> getComputerIdMap() throws IOException {
        HashMap<String, Computer> computers = new HashMap<String, Computer>();
        if (this.eccRestClient == null) {
            return computers;
        }
        List<Computer> computerList = this.eccRestClient.getComputers();
        for (Computer computer : computerList) {
            computers.put(computer.getUuid(), computer);
        }
        return computers;
    }

    protected boolean computerExistsWithPresence(Map<String, Computer> computers, String computerName, Presence presence) {
        Computer existingComputer = computers.get(computerName);
        if (existingComputer != null) {
            return existingComputer.getPresence() == presence;
        }
        return false;
    }

    protected boolean updateCachedComputersMap(List<String> computerNames, Map<String, Computer> computers) throws IOException {
        boolean computersMapUpdated = false;
        List<Computer> eccComputers = this.eccRestClient.getFilteredComputer(computerNames);
        for (Computer computer : eccComputers) {
            Computer existingComputer = computers.get(computer.getName());
            if (existingComputer != null) {
                if (computer.getPresence() == existingComputer.getPresence()) continue;
                computers.put(computer.getName(), computer);
                computersMapUpdated = true;
                continue;
            }
            computers.put(computer.getName(), computer);
            computersMapUpdated = true;
        }
        return computersMapUpdated;
    }

    protected String resolveComputerId(String computerName, Map<String, Computer> computers) {
        Computer computer = computers.get(computerName);
        if (computer == null) {
            return "-1";
        }
        return String.valueOf(computer.getId());
    }

    @Override
    protected void concatenateToCollectionJson(String parameterName, Collection<String> collection) {
        Collection parameterCollection = collection;
        try {
            String collectionJson = this.executionContext.evalParameters(parameterName, this);
            if (!collectionJson.equals(parameterName)) {
                parameterCollection = (Collection)SerializationUtils.fromJson((String)collectionJson);
                parameterCollection.addAll(collection);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not concatenate values to parameter " + parameterName, (Throwable)e);
        }
        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter(parameterName, SerializationUtils.toJson((Object)parameterCollection))));
    }

    protected boolean hasAgentsDeployed() {
        try {
            String collectionJson = this.executionContext.evalParameters("{ecc_deployed_computer_names}", this);
            if (!collectionJson.equals("{ecc_deployed_computer_names}")) {
                Collection parameterCollection = (Collection)SerializationUtils.fromJson((String)collectionJson);
                return parameterCollection.size() > 0;
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not parse {ecc_deployed_computer_names} parameter,", (Throwable)e);
        }
        return false;
    }
}

