/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ElasticSearchConfigureOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.ES_EXPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "ELASTIC_SEARCH"}), @OperationTag(name="Category", value={"EXPORT", "LOAD"})})
@OperationLicenseModule(module=ModuleType.ELASTICSEARCH)
public class ElasticSearchExportOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportOperationImplementation.class);
    @FormField(required=false)
    public String scope = "path-guid:{last_evidence_guid} AND flag:audited AND has-exclusion:0";
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES)
    public String metadataProfile = "Default";
    @FormField
    public String index = "docs_index";
    @FormField
    public boolean exportText = false;
    @FormField(min=100.0, enableOn={@OnField(name="exportText")}, positionLabel=@PositionLabel(right="characters"))
    public int maxTextSize = 1000000;

    public boolean getDisplayMaxTextSize() {
        return this.exportText;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ElasticSearchExportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ES_EXPORT;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) {
            try {
                boolean detectedConfigureOperation = false;
                for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
                    Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
                    if (o instanceof ElasticSearchConfigureOperation) {
                        detectedConfigureOperation = true;
                    }
                    if (o == this) break;
                }
                if (!detectedConfigureOperation) {
                    prerequisites.add(this.iu.getString("ElasticSearchExportOperation.Prerequisites.Missing"));
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot check prerequisites.", (Throwable)e);
                prerequisites.add(e.getLocalizedMessage());
            }
        }
        return prerequisites;
    }
}

