/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.ElasticSearchExportConsumerGenerator;
import com.nuix.automate.workflow.core.execution.operations.ElasticSearchExportOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportProducer;
import com.nuix.automate.workflow.core.utils.ItemExportCallback;
import com.nuix.automate.workflow.core.utils.es.EsConfig;
import com.nuix.automate.workflow.core.utils.es.EsFactory;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;

public class ElasticSearchExportOperationImplementation
extends ElasticSearchExportOperation
implements ItemExportCallback {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ElasticSearchExportOperationImplementation.class);
    private transient long itemsInScope;
    private transient AtomicInteger itemsGeneratedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsExportedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsWithErrors = new AtomicInteger();
    private transient List<Thread> runningThreads;
    private transient Set<String> rubyFieldNames;
    private transient int maxBulkOperationsCount;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.index = this.executionContext.evalParameters(this.index, this);
        this.itemsGeneratedMetadata = new AtomicInteger(0);
        this.itemsExportedMetadata = new AtomicInteger(0);
        String metadataProfileParameterName = "{metadata_profile}";
        String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
        if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
        if (mp == null) {
            this.exception = new Exception(this.iu.getFormattedString("MetadataExportOperation.Warning.CannotFindMetadataProfile", (Object)this.metadataProfile));
            this.executionState = ExecutionState.ERROR;
            return;
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                EsConfig esConfig = new EsConfig();
                esConfig.setHost(this.executionContext.evalParameters("{wfn_es_host}", this));
                esConfig.setPort(this.executionContext.evalIntParameter("{wfn_es_port}", this));
                this.maxBulkOperationsCount = this.executionContext.evalIntParameter("{wfn_es_bulk_operations_count}", this);
                esConfig.setUsername(this.executionContext.evalParameters("{wfn_es_username}", this));
                esConfig.setPassword(this.executionContext.evalProtectedParameter("{wfn_es_password}"));
                esConfig.setCertFingerprint(this.executionContext.evalParameters("{wfn_es_certificateFingerprint}", this));
                ElasticsearchClient esClient = EsFactory.getEsClient(esConfig);
                try {
                    LOGGER.info("Connecting to ElasticSearch");
                    InfoResponse esInfo = esClient.info();
                    LOGGER.info("ElasticSearch version: " + esInfo.version().toString());
                }
                catch (IOException e) {
                    throw new IOException(this.iu.getFormattedString("ElasticSearchConfigureOperation.CannotConnect", (Object)e.getMessage()));
                }
                this.addExecutionLog(this.iu.getFormattedString("ElasticSearchExportOperation.IndexName", (Object)this.index));
                if (this.exportText) {
                    this.addExecutionLog(this.iu.getString("ElasticSearchExportOperation.ExportText"));
                    this.addExecutionLog(this.iu.getFormattedString("ElasticSearchExportOperation.MaxTestSize", (Object)this.maxTextSize));
                }
                this.rubyFieldNames = new TreeSet<String>();
                for (MetadataItem metadataItem : mp.getMetadata()) {
                    if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                    this.rubyFieldNames.add(metadataItem.getName());
                    LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                }
                if (this.rubyFieldNames.size() > 0) {
                    this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                }
                List items = null;
                try {
                    this.executionContext.closeAllTabs();
                    HashMap searchOptions = new HashMap();
                    LOGGER.info("Searching for " + NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.ScopeQuery", (Object)this.scope));
                    items = this.executionContext.nuixCase.search(this.scope);
                    this.itemsInScope = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("MetadataExportOperation.Log.ScopeCount", this.itemsInScope));
                }
                catch (IOException e) {
                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                List metadata = mp.getMetadata();
                ConcurrentHashMap itemsMetadataRepresentationDictionary = new ConcurrentHashMap();
                long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOGGER.info("Memory used before generating metadata: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                try {
                    this.runningThreads = new ArrayList<Thread>();
                    LinkedBlockingDeque<Map<String, Object>> itemsMetadataRepresentation = new LinkedBlockingDeque<Map<String, Object>>();
                    LinkedBlockingDeque<Item> itemsQueue = new LinkedBlockingDeque<Item>();
                    MetadataExportProducer metadataExportProducer = new MetadataExportProducer(items, itemsQueue, 10000);
                    Thread producerThread = new Thread(metadataExportProducer);
                    producerThread.setName("Automate - Operation " + this.getOperationName() + " Producer");
                    producerThread.start();
                    this.runningThreads.add(producerThread);
                    int threadsNumber = Runtime.getRuntime().availableProcessors();
                    ArrayList<ElasticSearchExportConsumerGenerator> consumers = new ArrayList<ElasticSearchExportConsumerGenerator>();
                    ArrayList<Thread> consumerThreads = new ArrayList<Thread>();
                    int maxPendingGeneratedItems = this.maxBulkOperationsCount * 2;
                    for (int i = 0; i < threadsNumber; ++i) {
                        ElasticSearchExportConsumerGenerator metadataExportConsumer = new ElasticSearchExportConsumerGenerator(itemsQueue, itemsMetadataRepresentation, this.exportText, this.maxTextSize, metadata, this.itemsGeneratedMetadata, this.rubyFieldNames, this, maxPendingGeneratedItems);
                        consumers.add(metadataExportConsumer);
                        Thread thread = new Thread(metadataExportConsumer);
                        thread.setName("Automate - Operation " + this.getOperationName() + " Consumer");
                        consumerThreads.add(thread);
                        thread.start();
                        this.runningThreads.add(thread);
                    }
                    List itemsList = items;
                    while (this.itemsExportedMetadata.get() < itemsList.size()) {
                        if (this.stopRequested) {
                            LOGGER.info("Exiting writer main loop");
                            break;
                        }
                        BulkRequest.Builder br = new BulkRequest.Builder();
                        int operationsAdded = 0;
                        for (int bulkOperationsCount = 0; bulkOperationsCount <= this.maxBulkOperationsCount && itemsMetadataRepresentation.size() > 0; ++bulkOperationsCount) {
                            Map itemProperties = (Map)itemsMetadataRepresentation.remove();
                            String id = itemProperties.remove("_id").toString();
                            br.operations(o -> o.index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(this.index)).id(id)).document((Object)itemProperties)));
                            ++operationsAdded;
                        }
                        if (operationsAdded > 0) {
                            BulkResponse result = esClient.bulk(br.build());
                            for (BulkResponseItem bulkResponseItem : result.items()) {
                                if (bulkResponseItem.error() == null) continue;
                                LOGGER.warn("Cannot export item " + bulkResponseItem.id() + " due to error " + String.valueOf(bulkResponseItem.error()));
                                this.itemsWithErrors.incrementAndGet();
                            }
                            this.itemsExportedMetadata.addAndGet(operationsAdded);
                            continue;
                        }
                        Thread.sleep(1L);
                    }
                    if (this.stopRequested) {
                        metadataExportProducer.stopTriggered();
                    } else {
                        LOGGER.info("Done exporting all items");
                    }
                    LOGGER.info("Waiting for producer to complete");
                    producerThread.join();
                    LOGGER.info("Notifying consumers that no more items will be added");
                    for (ElasticSearchExportConsumerGenerator consumer : consumers) {
                        consumer.setDoneProducing();
                        if (!this.stopRequested) continue;
                        consumer.stopTriggered();
                    }
                    LOGGER.info("Waiting for consumers to complete");
                    for (Thread thread : consumerThreads) {
                        thread.join();
                    }
                    LOGGER.info("All consumers completed");
                }
                catch (WorkflowExecutionStopRequested e) {
                    this.trackStopped();
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            if (this.itemsWithErrors.get() > 0) {
                this.addWarning(this.iu.getNumeralString("ElasticSearchExportOperation.Warning.Failed", (long)this.itemsWithErrors.get()));
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = ((double)this.itemsGeneratedMetadata.get() * 0.5 + (double)this.itemsExportedMetadata.get() * 0.5) / (double)this.itemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.itemsInScope == 0L) {
            result = (String)result + this.iu.getString("MetadataExportOperation.Progress.SearchingForItems");
        } else if (this.itemsGeneratedMetadata != null) {
            result = (String)result + this.iu.getString("MetadataExportOperation.Progress.ExportingMetadata");
            result = (String)result + this.iu.getNumeralString("MetadataExportOperation.Progress.ItemsProcessed", (long)this.itemsExportedMetadata.get());
        }
        return result;
    }

    @Override
    public void onItemProcessed(Item item, boolean failed) {
        this.trackItemProcessed(item.getType().getName(), failed);
        String translationKey = failed ? "OperationStats.Exported" : "OperationStats.Failed";
        this.addOperationRunningLog(this.iu.getFormattedString(translationKey, (Object)String.join((CharSequence)"/", item.getPathNames())));
    }
}

