/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.ArrayList;
import java.util.List;

@FormFieldRadioButtonGroup(name="useExclusionsRadioButtonGroup", radioButton="useExclusionsFile", values={@RadioButtonValue(value="false", component="exclusions"), @RadioButtonValue(value="true", component="exclusionFileName")})
@OperationMetadata(alias=OperationAlias.EXCLUDE_ITEMS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ExcludeItemsOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField
    public boolean skipPreviouslyExcluded = true;
    @FormField
    public boolean useExclusionsFile;
    @FormField(enableOn={@OnField(name="useExclusionsFile", value={"false"})}, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="query")})
    public List<Object[]> exclusions = new ArrayList<Object[]>();
    @FormField(enableOn={@OnField(name="useExclusionsFile")})
    public String exclusionFileName;

    public boolean getDisplayExclusions() {
        return !this.useExclusionsFile;
    }

    public boolean getDisplayExclusionFileName() {
        return this.useExclusionsFile;
    }

    public ExcludeItemsOperation() {
        this.exclusions.add(new String[]{"Logo images", "kind:image (integer-properties:width:[0 TO 400] OR integer-properties:height:[0 TO 200])"});
        this.exclusions.add(new String[]{"Inaccessible", "path-kind:document AND mime-type:filesystem/inaccessible"});
        this.exclusions.add(new String[]{"Unrecognised", "kind:unrecognised AND NOT mime-type:text/plain"});
        this.useExclusionsFile = false;
        this.exclusionFileName = null;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ExcludeItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.EXCLUDE_ITEMS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.useExclusionsFile && this.exclusionFileName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ExcludeItemsOperation.Prerequisites.ExclusionsFileMustBeSpecified"));
        }
        return prerequisites;
    }
}

