/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ExcludeItemsOperation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import nuix.BulkAnnotater;

public class ExcludeItemsOperationImplementation
extends ExcludeItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExcludeItemsOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient boolean stopTriggered = false;

    private void loadListFromFile(File f) throws IOException {
        this.exclusions = FileUtils.loadTwoColumnDetectFormat((File)f, (String)"exclusions", (String)"name", (String)"query");
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.addExecutionLog(this.iu.getFormattedString("ExcludeItemsOperation.Log.ScopeQuery", (Object)this.scope));
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("ExcludeItemsOperation.Log.ScopeCount", scopeCount));
                if (this.useExclusionsFile) {
                    if (this.exclusionFileName == null) {
                        this.exclusionFileName = "";
                    }
                    this.exclusionFileName = this.executionContext.evalParameters(this.exclusionFileName, this);
                    this.loadListFromFile(new File(this.exclusionFileName));
                    this.addExecutionLog(this.iu.getFormattedString("ExcludeItemsOperation.Log.ExclusionsFile", (Object)this.exclusionFileName));
                }
                this.stageCount = this.exclusions.size() * 2;
                this.stageId = 0;
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                this.addExecutionLog(this.iu.getFormattedString("ExcludeItemsOperation.Log.SearchedFor", (Object)this.exclusions.size()));
                for (Object[] exclusion : this.exclusions) {
                    Set items;
                    if (this.stopTriggered) {
                        this.executionState = ExecutionState.STOPPED;
                        return;
                    }
                    String exclusionName = exclusion[0].toString().trim();
                    try {
                        exclusionName = this.executionContext.evalParameters(exclusionName, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    String exclusionQuery = exclusion[1].toString().trim();
                    try {
                        exclusionQuery = this.executionContext.evalParameters(exclusionQuery, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    try {
                        exclusionQuery = this.executionContext.evalParameters(exclusionQuery, this);
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Error finding unpacking exclusion query", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    if (exclusionName.length() == 0) {
                        this.addExecutionLog(this.iu.getString("ExcludeItemsOperation.Log.SkippedDueToBlankExclusionName"));
                        continue;
                    }
                    if (exclusionQuery.length() == 0) {
                        this.addExecutionLog(this.iu.getFormattedString("ExcludeItemsOperation.Log.ExclusionBlank", exclusion[0]));
                        continue;
                    }
                    this.stageName = this.iu.getString("ExcludeItemsOperation.Stage.SearchingForItems");
                    String query = NuixUtils.addAndQuery(this.scope, exclusionQuery);
                    if (this.skipPreviouslyExcluded) {
                        query = NuixUtils.addAndQuery(query, "has-exclusion:0");
                    }
                    try {
                        items = this.executionContext.nuixCase.searchUnsorted(query);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("ExcludeItemsOperation.Log.ExclusionNameExcluded", (long)items.size(), (Object)exclusionName));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error running query " + query, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                    this.stageName = this.iu.getString("ExcludeItemsOperation.Stage.ExcludingItems");
                    try {
                        bulkAnnotater.exclude(exclusionName, (Collection)items);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error applying exclusion " + exclusionName, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.stopTriggered = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

