/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.FilterEmailsOperation;
import com.nuix.automate.workflow.core.execution.options.filteremails.AddressType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.Address;
import nuix.BulkAnnotater;
import nuix.Communication;

public class FilterEmailsOperationImplementation
extends FilterEmailsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FilterEmailsOperation.class);
    private transient String stageName;
    private transient long stageItems;
    private transient long stageTotalItems;
    private transient int stageId;
    private transient Pattern domainPattern;

    private void addAddressesToDictionary(List<Address> addresses, Map<String, Address> dictionary) {
        for (Address address : addresses) {
            String key = address.toDisplayString();
            dictionary.put(key, address);
        }
    }

    private String getAddressDomain(String address) {
        Matcher domainMatcher = this.domainPattern.matcher(address);
        if (domainMatcher.find()) {
            return domainMatcher.group(1);
        }
        return "";
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.addExecutionLog(this.getPrintableSelect());
                this.addExecutionLog(this.iu.getFormattedString("FilterEmailsOperation.Log.ScopeQuery", (Object)this.scope));
                LOGGER.info("Searching for " + this.scope);
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                ConcurrentHashMap.KeySetView itemsToTag = ConcurrentHashMap.newKeySet();
                LOGGER.info(this.getOptionsPrintableText());
                this.stageTotalItems = items.size();
                LOGGER.info("Got " + this.stageTotalItems + " items");
                this.addExecutionLog(this.iu.getNumeralString("FilterEmailsOperation.Log.ScopeCount", this.stageTotalItems));
                this.stageId = 0;
                if (this.addressType == AddressType.DOMAIN_NAME) {
                    String domainRegexString = "@([^@^ ^<^\\[^\\(^>^\\]^\\)]+)";
                    this.domainPattern = Pattern.compile(domainRegexString);
                }
                HashSet<String> lowerCaseAddressesList = new HashSet<String>();
                LOGGER.debug("Normalizing addresses");
                for (String s : this.addressesList) {
                    String normalizedString = s.toLowerCase().trim();
                    try {
                        normalizedString = this.executionContext.evalParameters(normalizedString, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    if (normalizedString.length() <= 0) continue;
                    lowerCaseAddressesList.add(normalizedString);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Normalized -" + s + "- to -" + normalizedString + "-");
                }
                this.addressesList = new ArrayList(lowerCaseAddressesList);
                items.parallelStream().forEach(item -> {
                    block39: {
                        if (this.executionState == ExecutionState.STOPPING || this.executionState == ExecutionState.STOPPED) {
                            this.executionState = ExecutionState.STOPPED;
                            return;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("---Processing item " + item.getGuid());
                        }
                        Hashtable<String, Address> addressDictionary = new Hashtable<String, Address>();
                        HashSet<String> listItemsContained = new HashSet<String>();
                        Communication communication = item.getCommunication();
                        if (communication == null) break block39;
                        if (this.fieldFrom.booleanValue()) {
                            this.addAddressesToDictionary(communication.getFrom(), addressDictionary);
                        }
                        if (this.fieldTo.booleanValue()) {
                            this.addAddressesToDictionary(communication.getTo(), addressDictionary);
                        }
                        if (this.fieldCc.booleanValue()) {
                            this.addAddressesToDictionary(communication.getCc(), addressDictionary);
                        }
                        if (this.fieldBcc.booleanValue()) {
                            this.addAddressesToDictionary(communication.getBcc(), addressDictionary);
                        }
                        int matches = 0;
                        for (Address address : addressDictionary.values()) {
                            boolean match;
                            block41: {
                                String addressRepresentation;
                                block40: {
                                    block42: {
                                        block38: {
                                            if (LOGGER.isDebugEnabled()) {
                                                LOGGER.debug(" Testing address: " + address.toDisplayString());
                                            }
                                            addressRepresentation = null;
                                            try {
                                                switch (this.addressType) {
                                                    case EMAIL_ADDRESS: {
                                                        addressRepresentation = address.getAddress();
                                                        break;
                                                    }
                                                    case DOMAIN_NAME: {
                                                        addressRepresentation = this.getAddressDomain(address.getAddress());
                                                        break;
                                                    }
                                                    case DISPLAY_NAME: {
                                                        addressRepresentation = address.getPersonal();
                                                        break;
                                                    }
                                                    case FULL_ADDRESS: {
                                                        addressRepresentation = address.toDisplayString();
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                if (!LOGGER.isDebugEnabled()) break block38;
                                                LOGGER.debug("  Cannot get normalized address", (Throwable)e);
                                            }
                                        }
                                        if (addressRepresentation == null) {
                                            addressRepresentation = "";
                                        }
                                        addressRepresentation = addressRepresentation.toLowerCase();
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("  Normalized address: " + addressRepresentation);
                                        }
                                        boolean bl = match = this.criteriaContains == false;
                                        if (addressRepresentation.length() != 0) break block40;
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("  Address is empty");
                                        }
                                        if (!this.listOrEmpty.booleanValue()) break block41;
                                        if (!this.criteriaContains.booleanValue()) break block42;
                                        match = true;
                                        listItemsContained.add("");
                                        if (!LOGGER.isDebugEnabled()) break block41;
                                        LOGGER.debug("  Or is empty -> match");
                                        break block41;
                                    }
                                    match = false;
                                    if (!LOGGER.isDebugEnabled()) break block41;
                                    LOGGER.debug("  And is not empty -> NOT match");
                                    break block41;
                                }
                                for (String listString : this.addressesList) {
                                    if (this.criteriaContains.booleanValue()) {
                                        if (!addressRepresentation.contains(listString)) continue;
                                        match = true;
                                        listItemsContained.add(listString);
                                        if (!LOGGER.isDebugEnabled()) break;
                                        LOGGER.debug("  Contains in " + listString + " -> match");
                                        break;
                                    }
                                    if (!addressRepresentation.contains(listString)) continue;
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("  Contains in " + listString + " -> NOT match");
                                    }
                                    match = false;
                                    break;
                                }
                            }
                            if (!match) continue;
                            ++matches;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" Matches: " + matches);
                        }
                        boolean matchInRage = true;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" Testing number of matches vs. requirements");
                        }
                        if (this.criteriaContains.booleanValue() && !this.criteriaContainsAny.booleanValue() && listItemsContained.size() < this.criteriaContainsAtLeastValue) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED criteriaContainsAtLeastValue " + this.criteriaContainsAtLeastValue + " vs. obtained " + listItemsContained.size());
                            }
                        }
                        if (this.countAll.booleanValue() && matches != addressDictionary.size()) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED countAll " + addressDictionary.size());
                            }
                        }
                        if (this.countAtLeast.booleanValue() && matches < this.countAtLeastValue) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED countAtLeast " + this.countAtLeastValue);
                            }
                        }
                        if (this.countExactly.booleanValue() && matches != this.countExactlyValue) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED countExactly " + this.countExactlyValue);
                            }
                        }
                        if (this.countAtMost.booleanValue() && matches > this.countAtMostValue) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED countAtMost " + this.countAtMostValue);
                            }
                        }
                        if (this.countNo.booleanValue() && matches != 0) {
                            matchInRage = false;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("  Matches FAILED countNo");
                            }
                        }
                        if (matchInRage) {
                            itemsToTag.add(item);
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" Items to tag:" + itemsToTag.size());
                        }
                    }
                    ++this.stageItems;
                });
                if (this.executionState == ExecutionState.STOPPING || this.executionState == ExecutionState.STOPPED) {
                    this.executionState = ExecutionState.STOPPED;
                    return;
                }
                this.stageId = 1;
                this.addExecutionLog(this.iu.getFormattedString("FilterEmailsOperation.Log.ItemMatchingCriteria", (Object)itemsToTag.size()));
                try {
                    this.tagPredefinedName = this.executionContext.evalParameters(this.tagPredefinedName, this);
                }
                catch (ParameterException e) {
                    this.addWarning(e.getLocalizedMessage());
                }
                if (itemsToTag.size() > 0) {
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Tagging " + itemsToTag.size() + " items with tag -" + this.tagPredefinedName + "-");
                    }
                    bulkAnnotater.addTag(this.tagPredefinedName, itemsToTag);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        double stageProgress = (double)this.stageItems / (double)this.stageTotalItems;
        if (this.stageId == 0) {
            percentageComplete = stageProgress * 0.9;
            this.stageName = this.iu.getString("FilterEmailsOperation.Stage.ProcessingItems");
        } else {
            percentageComplete = 0.9;
            this.stageName = this.iu.getString("FilterEmailsOperation.Stage.AssigningTags");
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageId == 0 && this.stageTotalItems > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("FilterEmailsOperation.Progress.ItemsProcessed", this.stageItems);
        }
        return result;
    }

    private String getPrintableSelect() {
        ArrayList<String> countLogic = new ArrayList<String>();
        if (this.countAll.booleanValue()) {
            countLogic.add(this.iu.getString("FilterEmailsOperation.Count.All"));
        }
        if (this.countAtLeast.booleanValue()) {
            countLogic.add(this.iu.getFormattedString("FilterEmailsOperation.Count.AtLeast", (Object)this.countAtLeastValue));
        }
        if (this.countExactly.booleanValue()) {
            countLogic.add(this.iu.getFormattedString("FilterEmailsOperation.Count.Exactly", (Object)this.countExactlyValue));
        }
        if (this.countAtMost.booleanValue()) {
            countLogic.add(this.iu.getFormattedString("FilterEmailsOperation.Count.AtMost", (Object)this.countAtMostValue));
        }
        if (this.countNo.booleanValue()) {
            countLogic.add(this.iu.getString("FilterEmailsOperation.Count.No"));
        }
        Object result = this.iu.getFormattedString("FilterEmailsOperation.Result.SelectEmailsWhere", (Object)String.join((CharSequence)" and ", countLogic));
        boolean countSingular = this.getCountSingular();
        if (countSingular) {
            switch (this.addressType) {
                case EMAIL_ADDRESS: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.EmailAddress");
                    break;
                }
                case DOMAIN_NAME: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.DomainName");
                    break;
                }
                case DISPLAY_NAME: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.DisplayName");
                    break;
                }
                case FULL_ADDRESS: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.FullAddress");
                }
            }
        } else {
            switch (this.addressType) {
                case EMAIL_ADDRESS: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.EmailAddresses");
                    break;
                }
                case DOMAIN_NAME: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.DomainNames");
                    break;
                }
                case DISPLAY_NAME: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.DisplayNames");
                    break;
                }
                case FULL_ADDRESS: {
                    result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Address.FullAddresses");
                }
            }
        }
        result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Result.FromThe");
        ArrayList<String> fieldsRepresentation = new ArrayList<String>();
        if (this.fieldFrom.booleanValue()) {
            fieldsRepresentation.add(this.iu.getString("FilterEmailsOperation.Email.From"));
        }
        if (this.fieldTo.booleanValue()) {
            fieldsRepresentation.add(this.iu.getString("FilterEmailsOperation.Email.To"));
        }
        if (this.fieldCc.booleanValue()) {
            fieldsRepresentation.add(this.iu.getString("FilterEmailsOperation.Email.CC"));
        }
        if (this.fieldBcc.booleanValue()) {
            fieldsRepresentation.add(this.iu.getString("FilterEmailsOperation.Email.BCC"));
        }
        result = (String)result + String.join((CharSequence)", ", fieldsRepresentation);
        boolean fieldsSingular = this.getFieldsSingular();
        result = fieldsSingular ? (String)result + " " + this.iu.getString("FilterEmailsOperation.Email.Field") : (String)result + " " + this.iu.getString("FilterEmailsOperation.Email.Fields");
        if (countSingular) {
            if (this.criteriaContains.booleanValue()) {
                result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.Contains");
                result = this.criteriaContainsAny.booleanValue() ? (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.AnyOf") : (String)result + " " + this.iu.getFormattedString("FilterEmailsOperation.Printable.AtLeast", (Object)this.criteriaContainsAtLeastValue);
            } else {
                result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.DoesNotContainAnyOf");
            }
        } else if (this.criteriaContains.booleanValue()) {
            result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.Contain");
            result = this.criteriaContainsAny.booleanValue() ? (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.AnyOf") : (String)result + " " + this.iu.getFormattedString("FilterEmailsOperation.Printable.AtLeast", (Object)this.criteriaContainsAtLeastValue);
        } else {
            result = (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.DoesNotContainAnyOf");
        }
        result = (String)result + " " + this.iu.getFormattedString("FilterEmailsOperation.Result.AddressList", (Object)String.join((CharSequence)", ", this.addressesList));
        if (this.listOrEmpty.booleanValue()) {
            result = countSingular ? (this.criteriaContains.booleanValue() ? (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.OrIsEmpty") : (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.AndIsNotEmpty")) : (this.criteriaContains != false ? (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.OrAreEmpty") : (String)result + " " + this.iu.getString("FilterEmailsOperation.Printable.AndAreNotEmpty"));
        }
        return result;
    }
}

