/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.GenAiConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="tagAnalyzedItemsRow", children={"tagAnalyzedItems", "analyzedItemsTagName", "untagUnanalyzedItems"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"}), @FormFieldRow(name="sampleRow", children={"sampleEnabled", "sampleSize"}), @FormFieldRow(name="metadataProfileRow", children={"createMetadataProfileEnabled", "metadataProfileName"})})
@OperationMetadata(alias=OperationAlias.GEN_AI_ESTIMATE_TOKENS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "GEN_AI"}), @OperationTag(name="Category", value={"ENTITY"})})
@OperationLicenseModule(module=ModuleType.GEN_AI)
public class GenAiEstimateTokensOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean sampleEnabled = true;
    @FormField(enableOn={@OnField(name="sampleEnabled")}, positionLabel=@PositionLabel(right="items"), min=1.0)
    public int sampleSize = 10;
    @FormField(allowedValues={"TEXT", "CUSTOM_METADATA", "IMAGES", "METADATA_PROFILE_FIELD"})
    public SourceTextLocation contentLocation = SourceTextLocation.TEXT;
    @FormField(visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA"})})
    public String contentMetadataFieldName = "GenAI|Transcription";
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES, visibleOn={@OnField(name="contentLocation", value={"METADATA_PROFILE_FIELD"})})
    public String contentMetadataProfileName;
    @FormField(visibleOn={@OnField(name="contentLocation", value={"METADATA_PROFILE_FIELD"})})
    public String contentMetadataProfileField;
    @FormField
    public String resultsMetadataFieldName = "GenAI|EstimateTokens";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean createMetadataProfileEnabled = true;
    @FormField(enableOn={@OnField(name="createMetadataProfileEnabled")})
    public String metadataProfileName = "Tokens";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagAnalyzedItems = true;
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public String analyzedItemsTagName = "Automate|Analyzed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagUnanalyzedItems = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;

    public boolean getDisplaySampleSize() {
        return this.sampleEnabled;
    }

    public boolean getDisplayContentMetadataFieldName() {
        return this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA);
    }

    public boolean getDisplayContentMetadataProfileName() {
        return this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD);
    }

    public boolean getDisplayContentMetadataProfileField() {
        return this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD);
    }

    public boolean getDisplayMetadataProfileName() {
        return this.createMetadataProfileEnabled;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("GenAiEstimateTokensOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GEN_AI_ESTIMATE_TOKENS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigure = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof GenAiConfigureConnectionOperation) {
                detectedConfigure = true;
                break;
            }
            if (o == this) break;
        }
        if (!detectedConfigure) {
            prerequisites.add(this.iu.getString("GenAiPromptOnDocumentsOperation.Prerequisites.MissingConfigureOperation"));
        }
        if (this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD)) {
            try {
                this.contentMetadataProfileName = this.executionContext.evalParameters(this.contentMetadataProfileName, this);
                this.contentMetadataProfileField = this.executionContext.evalParameters(this.contentMetadataProfileField, this);
            }
            catch (ParameterException e) {
                prerequisites.add(FormattingUtils.getExceptionPrintableMessage((Exception)((Object)e)));
            }
            String contentMetadataProfileFieldError = NuixUtils.getMetadataProfileFieldError(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.contentMetadataProfileName, this.contentMetadataProfileField);
            if (contentMetadataProfileFieldError != null) {
                prerequisites.add(contentMetadataProfileFieldError);
            }
        }
        return prerequisites;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LLM_PROMPT;
    }
}

