/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.GenAiEstimateTokensOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.MutablePrintedImage;

public class GenAiEstimateTokensOperationImplementation
extends GenAiEstimateTokensOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiEstimateTokensOperation.class);
    private transient ExecutorService executor;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient long itemsInScope;
    private transient long effectiveItemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeItems;
    private transient Set<Item> scopeTaggedItems;
    private transient BulkAnnotater bulkAnnotater;
    private transient Set<Item> failedItems;
    private transient String tempTag;
    private transient String model;
    private transient String printableService;
    private transient GenAiHelper genAiHelper;
    private transient GenAiService genAiService;
    private transient AtomicLong totalTokenCount;
    private transient Set<String> contentMetadataProfileRubyFieldNames;
    private transient MetadataItem contentMetadataItem;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.totalTokenCount = new AtomicLong(0L);
        if (this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA)) {
            this.contentMetadataFieldName = this.executionContext.evalParameters(this.contentMetadataFieldName, this);
        }
        this.resultsMetadataFieldName = this.executionContext.evalParameters(this.resultsMetadataFieldName, this);
        if (this.tagAnalyzedItems) {
            this.analyzedItemsTagName = this.executionContext.evalParameters(this.analyzedItemsTagName, this);
        }
        if (this.tagFailedItems) {
            this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        }
        if (this.createMetadataProfileEnabled) {
            this.metadataProfileName = this.executionContext.evalParameters(this.metadataProfileName, this);
        }
        this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
        this.itemsProcessed = new AtomicLong(0L);
        this.genAiHelper = this.createMetadataProfileEnabled ? new GenAiHelper(this.executionContext, this, this.thirdPartyServices, this.metadataProfileName) : new GenAiHelper(this.executionContext, this, this.thirdPartyServices);
        this.genAiService = this.genAiHelper.getGenAiService();
        this.model = this.genAiService.getModel();
        this.printableService = this.genAiHelper.getPrintableServiceName();
        this.failedItems = new HashSet<Item>();
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                if (this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD)) {
                    this.contentMetadataProfileName = this.executionContext.evalParameters(this.contentMetadataProfileName, this);
                    this.contentMetadataProfileField = this.executionContext.evalParameters(this.contentMetadataProfileField, this);
                    MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.contentMetadataProfileName);
                    if (mp == null) {
                        throw new IllegalStateException("Cannot find metadata profile " + this.contentMetadataProfileName);
                    }
                    this.contentMetadataProfileRubyFieldNames = new TreeSet<String>();
                    for (Object metadataItem : mp.getMetadata()) {
                        if (!metadataItem.getName().equals(this.contentMetadataProfileField)) continue;
                        this.contentMetadataItem = metadataItem;
                        if (!MetadataItemUtils.isRubyScript((MetadataItem)metadataItem)) break;
                        this.contentMetadataProfileRubyFieldNames.add(metadataItem.getName());
                        LOGGER.info("Content metadata field " + metadataItem.getName() + " is scripted Ruby field");
                        break;
                    }
                    if (this.contentMetadataItem == null) {
                        throw new IllegalStateException("Cannot find metadata profile field " + this.contentMetadataProfileField + " in metadata profile " + this.contentMetadataProfileName);
                    }
                }
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.effectiveItemsInScope = this.itemsInScope = (long)this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                this.stageName = this.iu.getString("Operation.Stage.AnalyzingItems");
                if (this.sampleEnabled) {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.SampleSize", (long)this.sampleSize));
                }
                switch (this.contentLocation) {
                    case TEXT: {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.ContentLocationText"));
                        break;
                    }
                    case CUSTOM_METADATA: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadata", (Object)this.contentMetadataFieldName));
                        break;
                    }
                    case METADATA_PROFILE_FIELD: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadataProfileField", new Object[]{this.contentMetadataProfileName, this.contentMetadataProfileField}));
                    }
                }
                if (this.createMetadataProfileEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CreateMetadataProfile", (Object)this.metadataProfileName));
                }
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                this.executor = Executors.newFixedThreadPool(this.genAiService.getMultiThreading());
                if (this.sampleEnabled && this.sampleSize < this.scopeItems.size()) {
                    HashSet<Item> sampleItems = new HashSet<Item>();
                    int i = 0;
                    for (Item item : this.scopeItems) {
                        sampleItems.add(item);
                        if (++i < this.sampleSize) continue;
                        break;
                    }
                    this.scopeItems = sampleItems;
                    this.effectiveItemsInScope = this.scopeItems.size();
                }
                if (this.tagFailedItems && this.untagSuccessfulItems && this.scopeItems.size() > 0) {
                    LOGGER.info("Tagging " + this.scopeItems.size() + " items with tag " + this.tempTag);
                    try {
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.scopeItems);
                    }
                    catch (IOException e) {
                        LOGGER.info("Cannot tag items", (Throwable)e);
                    }
                }
                Semaphore activeThreadsSemaphore = new Semaphore(this.genAiService.getMultiThreading());
                ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
                AtomicLong threadsCount = new AtomicLong();
                block15: for (Item item : this.scopeItems) {
                    if (this.stopRequested) break;
                    Long threadId = threadsCount.getAndIncrement();
                    Thread itemThread = new Thread(() -> {
                        try {
                            if (this.stopRequested) {
                                return;
                            }
                            try {
                                GenAiHelper.clearItemGenAiMetadata(item, "System|Error");
                                GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
                                this.handleItem(item);
                                this.processedItems.add(item);
                            }
                            catch (Exception e) {
                                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                this.failedItems.add(item);
                                LOGGER.error("Cannot handle item " + item.getGuid(), (Throwable)e);
                            }
                            this.genAiHelper.setItemGenAiMetadata(item, "System|Model", this.model);
                            this.genAiHelper.setItemGenAiMetadata(item, "System|Service", this.printableService);
                            this.itemsProcessed.incrementAndGet();
                        }
                        finally {
                            activeThreadsSemaphore.release();
                            activeThreads.remove(threadId);
                        }
                    });
                    itemThread.setName("GenAI document handling");
                    while (!this.stopRequested) {
                        try {
                            if (!activeThreadsSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) continue;
                            activeThreads.put(threadId, itemThread);
                            itemThread.start();
                            continue block15;
                        }
                        catch (InterruptedException e) {
                            this.stopRequested = true;
                        }
                    }
                }
                while (!activeThreads.isEmpty() && !this.stopRequested) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.stopRequested = true;
                    }
                }
                this.printCounts();
                this.tagItems();
                if (this.stopRequested) {
                    for (Thread activeThread : activeThreads.values()) {
                        activeThread.interrupt();
                    }
                    this.cleanUp();
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.AnalyzeCount", this.itemsProcessed.get()));
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.FailedToAnalyzeItems", (long)this.failedItems.size()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptTokens", (Object)this.totalTokenCount.get()));
    }

    private void handleItem(Item item) throws IOException {
        String bodyText = "[ERROR]";
        int itemTokensCount = 0;
        switch (this.contentLocation) {
            case TEXT: {
                bodyText = item.getTextObject().isAvailable() ? item.getTextObject().toString() : "";
                itemTokensCount = this.genAiHelper.estimateTokens(bodyText);
                break;
            }
            case CUSTOM_METADATA: {
                if (!item.getCustomMetadata().containsKey((Object)this.contentMetadataFieldName)) {
                    throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.MetadataFieldDoesNotExist", (Object)this.contentMetadataFieldName));
                }
                StringBuilder sb = new StringBuilder();
                ItemsUtils.getItemMetadataFieldToString(item, this.contentMetadataFieldName, "", sb, Long.MAX_VALUE, "");
                bodyText = sb.toString();
                itemTokensCount = this.genAiHelper.estimateTokens(bodyText);
                break;
            }
            case IMAGES: {
                int pageCount = 0;
                try {
                    if (item.getProperties().containsKey("Page Count")) {
                        pageCount = (Integer)item.getProperties().get("Page Count");
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot extract page count property", (Throwable)e);
                }
                if (pageCount == 0) {
                    MutablePrintedImage printedImage = item.getPrintedImage();
                    if (printedImage == null) {
                        throw new IOException("Printed image not available");
                    }
                    printedImage.generate();
                    pageCount = printedImage.getPages().size();
                }
                itemTokensCount = 1105 * pageCount;
                break;
            }
            case METADATA_PROFILE_FIELD: {
                try {
                    bodyText = MetadataItemUtils.evaluate(this.contentMetadataItem, item, this.contentMetadataProfileRubyFieldNames);
                    itemTokensCount = this.genAiHelper.estimateTokens(bodyText);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(this.iu.getString("General.Error.CannotEvaluateMetadata"), e);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected content location: " + String.valueOf((Object)this.contentLocation));
            }
        }
        this.totalTokenCount.addAndGet(itemTokensCount);
        GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
        this.genAiHelper.setItemGenAiMetadata(item, this.resultsMetadataFieldName, String.valueOf(itemTokensCount));
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.itemsProcessed.get() / (double)this.effectiveItemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        long completionTokens;
        long promptTokens;
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get());
        }
        if (this.genAiHelper != null && (promptTokens = this.totalTokenCount.get()) + (completionTokens = this.genAiHelper.getCompletionTokens()) > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Count.PromptTokens", (Object)promptTokens);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

