/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.common.reflect.TypeToken;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.genai.WrappedResponse;
import com.nuix.automate.workflow.core.execution.operations.AddEntitiesModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.CountedEntity;
import com.nuix.automate.workflow.core.execution.operations.GenAiExtractEntitiesOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.genai.ResultsLocation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.regex.PatternReplacement;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.ItemModifierCallback;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import org.apache.commons.lang3.StringUtils;

public class GenAiExtractEntitiesOperationImplementation
extends GenAiExtractEntitiesOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiExtractEntitiesOperation.class);
    private transient ExecutorService executor;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient long itemsInScope;
    private transient long effectiveItemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient AtomicLong promptsProcessed;
    private transient AtomicLong entitiesExtracted;
    private transient Set<String> entityTypes;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeItems;
    private transient Set<Item> scopeTaggedItems;
    private transient BulkAnnotater bulkAnnotater;
    private transient AtomicLong itemsTextReplaced;
    private transient AtomicLong itemsPromptOutputReplaced;
    private transient AtomicLong itemsResponseMatchesFollowUpRequirement;
    private transient AtomicLong itemsFollowUpPromptOutputReplaced;
    private transient Set<Item> failedItems;
    private transient String tempTag;
    private transient String model;
    private transient String printableService;
    private transient GenAiHelper genAiHelper;
    private transient GenAiService genAiService;
    private transient List<PatternReplacement> contentPatternReplacements;
    private transient List<PatternReplacement> responsePatternReplacements;
    private transient Set<String> contentMetadataProfileRubyFieldNames;
    private transient MetadataItem contentMetadataItem;

    private List<PatternReplacement> compileRegexList(List<Object[]> regexes) throws ParameterException {
        ArrayList<PatternReplacement> patternReplacementList = new ArrayList<PatternReplacement>();
        for (Object[] regex : regexes) {
            String[] regexArray = new String[]{this.executionContext.evalParameters(regex[0].toString(), this), this.executionContext.evalParameters(regex[1].toString(), this)};
            patternReplacementList.add(new PatternReplacement(regexArray[0], regexArray[1]));
        }
        return patternReplacementList;
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.contextPrompt = this.executionContext.evalParameters(this.contextPrompt, this);
        this.documentPrompt = this.executionContext.evalParameters(this.documentPrompt, this);
        this.extractionPrompt = this.executionContext.evalParameters(this.extractionPrompt, this);
        if (this.replaceContent) {
            this.contentPatternReplacements = this.compileRegexList(this.replaceContentRegexes);
        }
        if (this.replacePromptOutput) {
            this.responsePatternReplacements = this.compileRegexList(this.replacePromptOutputRegexes);
        }
        if (this.tagAnalyzedItems) {
            this.analyzedItemsTagName = this.executionContext.evalParameters(this.analyzedItemsTagName, this);
        }
        if (this.tagFailedItems) {
            this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        }
        if (this.createMetadataProfileEnabled) {
            this.metadataProfileName = this.executionContext.evalParameters(this.metadataProfileName, this);
        }
        this.itemsTextReplaced = new AtomicLong(0L);
        this.itemsPromptOutputReplaced = new AtomicLong(0L);
        this.itemsResponseMatchesFollowUpRequirement = new AtomicLong(0L);
        this.itemsFollowUpPromptOutputReplaced = new AtomicLong(0L);
        if (!(this.documentPrompt.contains("{item_text}") || this.documentPrompt.contains("{item_properties}") || this.documentPrompt.contains("{email_header}"))) {
            throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.DocumentPromptMissingItemText", new Object[]{"{item_text}", "{item_properties}", "{email_header}"}));
        }
        if (this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA)) {
            this.contentMetadataFieldName = this.executionContext.evalParameters(this.contentMetadataFieldName, this);
        }
        if (this.resultsLocation.equals((Object)ResultsLocation.CUSTOM_METADATA)) {
            this.resultsMetadataFieldName = this.executionContext.evalParameters(this.resultsMetadataFieldName, this);
        }
        this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
        this.itemsProcessed = new AtomicLong(0L);
        this.promptsProcessed = new AtomicLong(0L);
        this.entitiesExtracted = new AtomicLong(0L);
        this.entityTypes = ConcurrentHashMap.newKeySet();
        this.genAiHelper = this.createMetadataProfileEnabled ? new GenAiHelper(this.executionContext, this, this.thirdPartyServices, this.metadataProfileName) : new GenAiHelper(this.executionContext, this, this.thirdPartyServices);
        this.genAiService = this.genAiHelper.getGenAiService();
        this.model = this.genAiService.getModel();
        this.printableService = this.genAiHelper.getPrintableServiceName();
        this.failedItems = new HashSet<Item>();
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                if (this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD)) {
                    this.contentMetadataProfileName = this.executionContext.evalParameters(this.contentMetadataProfileName, this);
                    this.contentMetadataProfileField = this.executionContext.evalParameters(this.contentMetadataProfileField, this);
                    MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.contentMetadataProfileName);
                    if (mp == null) {
                        throw new IllegalStateException("Cannot find metadata profile " + this.contentMetadataProfileName);
                    }
                    this.contentMetadataProfileRubyFieldNames = new TreeSet<String>();
                    for (Object metadataItem : mp.getMetadata()) {
                        if (!metadataItem.getName().equals(this.contentMetadataProfileField)) continue;
                        this.contentMetadataItem = metadataItem;
                        if (!MetadataItemUtils.isRubyScript((MetadataItem)metadataItem)) break;
                        this.contentMetadataProfileRubyFieldNames.add(metadataItem.getName());
                        LOGGER.info("Content metadata field " + metadataItem.getName() + " is scripted Ruby field");
                        break;
                    }
                    if (this.contentMetadataItem == null) {
                        throw new IllegalStateException("Cannot find metadata profile field " + this.contentMetadataProfileField + " in metadata profile " + this.contentMetadataProfileName);
                    }
                }
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.effectiveItemsInScope = this.itemsInScope = (long)this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                this.stageName = this.iu.getString("Operation.Stage.AnalyzingItems");
                if (this.sampleEnabled) {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.SampleSize", (long)this.sampleSize));
                }
                switch (this.contentLocation) {
                    case TEXT: {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.ContentLocationText"));
                        break;
                    }
                    case CUSTOM_METADATA: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadata", (Object)this.contentMetadataFieldName));
                        break;
                    }
                    case METADATA_PROFILE_FIELD: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadataProfileField", new Object[]{this.contentMetadataProfileName, this.contentMetadataProfileField}));
                    }
                }
                if (this.replaceContent) {
                    for (Object[] regex : this.replaceContentRegexes) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceContentRegex", new Object[]{regex[0], regex[1]}));
                    }
                }
                if (!this.contextPrompt.isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContextPrompt", (Object)GenAiHelper.indentMultiLineText(this.contextPrompt)));
                }
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.DocumentPrompt", (Object)GenAiHelper.indentMultiLineText(this.documentPrompt)));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ExtractionPrompt", (Object)GenAiHelper.indentMultiLineText(this.extractionPrompt)));
                if (this.replacePromptOutput) {
                    for (Object[] regex : this.replacePromptOutputRegexes) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceResponseRegex", new Object[]{regex[0], regex[1]}));
                    }
                }
                if (this.jsonEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.JsonSchema", (Object)GenAiHelper.indentMultiLineText(this.jsonSchema)));
                }
                switch (this.resultsLocation) {
                    case ENTITIES: {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.ResultsLocationText"));
                        break;
                    }
                    case CUSTOM_METADATA: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ResultsLocationMetadata", (Object)this.resultsMetadataFieldName));
                    }
                }
                if (this.temperatureEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.Temperature", (Object)this.temperature));
                }
                if (this.maxResponseTokensEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MaxResponseTokens", (Object)this.maxResponseTokens));
                }
                if (this.createMetadataProfileEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CreateMetadataProfile", (Object)this.metadataProfileName));
                }
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                this.executor = Executors.newFixedThreadPool(this.genAiService.getMultiThreading());
                if (this.sampleEnabled && this.sampleSize < this.scopeItems.size()) {
                    HashSet<Item> sampleItems = new HashSet<Item>();
                    int i = 0;
                    for (Item item : this.scopeItems) {
                        sampleItems.add(item);
                        if (++i < this.sampleSize) continue;
                        break;
                    }
                    this.scopeItems = sampleItems;
                    this.effectiveItemsInScope = this.scopeItems.size();
                }
                if (this.tagFailedItems && this.untagSuccessfulItems && this.scopeItems.size() > 0) {
                    LOGGER.info("Tagging " + this.scopeItems.size() + " items with tag " + this.tempTag);
                    try {
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.scopeItems);
                    }
                    catch (IOException e) {
                        LOGGER.info("Cannot tag items", (Throwable)e);
                    }
                }
                Semaphore activeThreadsSemaphore = new Semaphore(this.genAiService.getMultiThreading());
                ConcurrentHashMap activeThreads = new ConcurrentHashMap();
                AtomicLong threadsCount = new AtomicLong();
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    block4: for (Item item : this.scopeItems) {
                        if (this.stopRequested) break;
                        Long threadId = threadsCount.getAndIncrement();
                        Thread itemThread = new Thread(() -> {
                            try {
                                if (this.stopRequested) {
                                    return;
                                }
                                try {
                                    GenAiHelper.clearItemGenAiMetadata(item, "System|Error");
                                    GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
                                    this.handleItem(item);
                                    this.processedItems.add(item);
                                }
                                catch (IOException e) {
                                    this.genAiHelper.setItemGenAiMetadata(item, "System|Error", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                    this.failedItems.add(item);
                                    LOGGER.error("Cannot handle item " + item.getGuid(), (Throwable)e);
                                }
                                this.genAiHelper.setItemGenAiMetadata(item, "System|Model", this.model);
                                this.genAiHelper.setItemGenAiMetadata(item, "System|Service", this.printableService);
                                this.itemsProcessed.incrementAndGet();
                            }
                            finally {
                                activeThreadsSemaphore.release();
                                activeThreads.remove(threadId);
                            }
                        });
                        itemThread.setName("GenAI document handling");
                        while (!this.stopRequested) {
                            try {
                                if (!activeThreadsSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) continue;
                                activeThreads.put(threadId, itemThread);
                                itemThread.start();
                                continue block4;
                            }
                            catch (InterruptedException e) {
                                this.stopRequested = true;
                            }
                        }
                    }
                    while (!activeThreads.isEmpty() && !this.stopRequested) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            this.stopRequested = true;
                        }
                    }
                });
                this.printCounts();
                this.tagItems();
                if (this.stopRequested) {
                    for (Thread activeThread : activeThreads.values()) {
                        activeThread.interrupt();
                    }
                    this.cleanUp();
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.AnalyzeCount", this.itemsProcessed.get()));
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.FailedToAnalyzeItems", (long)this.failedItems.size()));
        }
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ExtractedCount", this.entitiesExtracted.get()));
        if (this.replaceContent) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsMatchingContentSanitizationRegex", (Object)this.itemsTextReplaced.get()));
        }
        if (this.replacePromptOutput) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsPromptResponsesMatchingCleanupRegex", (Object)this.itemsPromptOutputReplaced.get()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptTokens", (Object)this.genAiHelper.getPromptTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CompletionTokens", (Object)this.genAiHelper.getCompletionTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.TotalTokens", (Object)this.genAiHelper.getTotalTokens()));
    }

    private void handleItem(Item item) throws IOException {
        AtomicBoolean itemPromptResponseMatchesFollowUpRequirement;
        AtomicBoolean itemFollowUpPromptOutputReplaced;
        AtomicBoolean itemPromptOutputReplaced;
        AtomicReference<Object> promptException;
        block22: {
            String bodyText = "[ERROR]";
            switch (this.contentLocation) {
                case TEXT: {
                    if (item.getTextObject().isAvailable()) {
                        bodyText = item.getTextObject().toString();
                        break;
                    }
                    bodyText = "";
                    break;
                }
                case CUSTOM_METADATA: {
                    if (!item.getCustomMetadata().containsKey((Object)this.contentMetadataFieldName)) {
                        throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.MetadataFieldDoesNotExist", (Object)this.contentMetadataFieldName));
                    }
                    StringBuilder sb = new StringBuilder();
                    ItemsUtils.getItemMetadataFieldToString(item, this.contentMetadataFieldName, "", sb, Long.MAX_VALUE, "");
                    bodyText = sb.toString();
                    break;
                }
                case METADATA_PROFILE_FIELD: {
                    try {
                        bodyText = MetadataItemUtils.evaluate(this.contentMetadataItem, item, this.contentMetadataProfileRubyFieldNames);
                        break;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException(this.iu.getString("General.Error.CannotEvaluateMetadata"), e);
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected content location: " + String.valueOf((Object)this.contentLocation));
                }
            }
            GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
            promptException = new AtomicReference<Object>(null);
            if (this.replaceContent) {
                boolean matched = false;
                for (PatternReplacement patternReplacement : this.contentPatternReplacements) {
                    Matcher matcher = patternReplacement.getPattern().matcher(bodyText);
                    if (!matcher.find()) continue;
                    matched = true;
                    LOGGER.info("Item " + item.getGuid() + " content matched regex " + patternReplacement.getRegex() + " and was replaced");
                    bodyText = matcher.replaceAll(patternReplacement.getReplacement());
                }
                if (matched) {
                    this.itemsTextReplaced.incrementAndGet();
                }
            }
            itemPromptOutputReplaced = new AtomicBoolean(false);
            itemFollowUpPromptOutputReplaced = new AtomicBoolean(false);
            itemPromptResponseMatchesFollowUpRequirement = new AtomicBoolean(false);
            String finalBodyText = bodyText;
            if (this.stopRequested) {
                return;
            }
            if (promptException.get() != null) {
                return;
            }
            try {
                this.handleItemPrompt(item, "Extraction", finalBodyText, itemPromptOutputReplaced);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                if (this.stopRequested) break block22;
                promptException.set(e);
            }
        }
        if (itemPromptOutputReplaced.get()) {
            this.itemsPromptOutputReplaced.incrementAndGet();
        }
        if (itemFollowUpPromptOutputReplaced.get()) {
            this.itemsFollowUpPromptOutputReplaced.incrementAndGet();
        }
        if (itemPromptResponseMatchesFollowUpRequirement.get()) {
            this.itemsResponseMatchesFollowUpRequirement.incrementAndGet();
        }
        if (promptException.get() != null) {
            Exception e = promptException.get();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new GenAiException(e);
        }
    }

    private List<String> splitContent(String content, int maxTokens) throws IOException {
        String[] splitContent = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)content, (String)this.splitSeparator);
        ArrayList<String> sizedSplitContent = new ArrayList<String>();
        StringBuilder currentContent = new StringBuilder();
        int currentTokensCount = 0;
        for (String contentPart : splitContent) {
            int partTokensCount = this.genAiHelper.estimateTokens(contentPart);
            if (partTokensCount > maxTokens) {
                LOGGER.error("Separator " + this.splitSeparator + " produced " + splitContent.length + " part(s), including 1 part with " + partTokensCount + " tokens, which is more than the maximum allowed " + maxTokens + " tokens");
                throw new GenAiException(this.iu.getFormattedString("GenAI.Error.CannotSplitWithinTokenLimits", new Object[]{splitContent.length, partTokensCount, maxTokens}));
            }
            if (currentTokensCount + partTokensCount > maxTokens) {
                sizedSplitContent.add(currentContent.toString());
                currentContent = new StringBuilder();
                currentTokensCount = 0;
            }
            if (currentContent.length() > 0) {
                currentTokensCount += this.genAiHelper.estimateTokens(this.splitSeparator);
                currentContent.append(this.splitSeparator);
            }
            currentTokensCount += this.genAiHelper.estimateTokens(contentPart);
            currentContent.append(contentPart);
        }
        sizedSplitContent.add(currentContent.toString());
        return sizedSplitContent;
    }

    /*
     * WARNING - void declaration
     */
    private void handleResponses(Item item, String content, List<String> responses) {
        HashMap<String, Set> itemEntities = new HashMap<String, Set>();
        boolean itemFailed = false;
        for (String string : responses) {
            if (string == null) continue;
            try {
                void var7_14;
                void var7_12;
                String string2 = string.trim();
                if (string2.startsWith("```json")) {
                    String string3 = string2.substring(7);
                }
                if (var7_12.endsWith("```")) {
                    String string4 = var7_12.substring(0, var7_12.length() - 3);
                }
                String string5 = var7_14.trim();
                Type listOfMapType = new TypeToken<List<Map<String, String>>>(){}.getType();
                List entities = (List)SerializationUtils.fromJson((String)string5, (Type)listOfMapType);
                for (Map entity : entities) {
                    String type = (String)entity.get("type");
                    String value = (String)entity.get("value");
                    if (value == null || value.isEmpty() || type == null || type.isEmpty()) continue;
                    Set values = itemEntities.computeIfAbsent(type, k -> new TreeSet(String.CASE_INSENSITIVE_ORDER));
                    values.add(value);
                }
                if (entities.isEmpty() || !itemEntities.isEmpty()) continue;
                throw new GenAiException("Extraction is a valid JSON but it does not have the expected \"type\" and \"value\" fields.");
            }
            catch (Exception e) {
                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", "Cannot parse extraction as a JSON list with \"type\" and \"value\" fields:\n" + string + "\n\n" + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                itemFailed = true;
                LOGGER.error("Item " + item.getGuid() + " response is not in valid a JSON list of map with type and value", (Throwable)e);
            }
        }
        if (this.resultsLocation.equals((Object)ResultsLocation.CUSTOM_METADATA)) {
            for (Map.Entry entry : itemEntities.entrySet()) {
                String entityName = (String)entry.getKey();
                this.entityTypes.add(entityName);
                this.entitiesExtracted.addAndGet(((Set)entry.getValue()).size());
                if (!this.resultsLocation.equals((Object)ResultsLocation.CUSTOM_METADATA)) continue;
                this.genAiHelper.setItemGenAiMetadata(item, this.resultsMetadataFieldName + "|" + entityName, String.join((CharSequence)"\n", (Iterable)entry.getValue()));
            }
        } else {
            try {
                HashMap<String, List<CountedEntity>> countedEntities = new HashMap<String, List<CountedEntity>>();
                for (Map.Entry entry : itemEntities.entrySet()) {
                    String entityName = (String)entry.getKey();
                    Set values = (Set)entry.getValue();
                    ArrayList<CountedEntity> countedEntityList = new ArrayList<CountedEntity>();
                    this.entitiesExtracted.addAndGet(((Set)entry.getValue()).size());
                    for (String value : values) {
                        int count = StringUtils.countMatches((CharSequence)content, (CharSequence)value);
                        count = Math.max(1, count);
                        CountedEntity countedEntity = new CountedEntity(value, count);
                        countedEntityList.add(countedEntity);
                    }
                    countedEntities.put(entityName, countedEntityList);
                }
                item.modify((ItemModifierCallback)new AddEntitiesModifierCallback(countedEntities));
            }
            catch (Throwable e) {
                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", "Cannot set entities, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                itemFailed = true;
                LOGGER.error("Item " + item.getGuid() + " cannot assign entities", e);
            }
        }
        if (itemFailed) {
            this.failedItems.add(item);
        }
    }

    private void handleItemPrompt(Item item, String name, String content, AtomicBoolean itemPromptOutputReplaced) throws IOException, ExecutionException, InterruptedException {
        int level = 1;
        if (this.resultsLocation.equals((Object)ResultsLocation.CUSTOM_METADATA)) {
            GenAiHelper.clearItemGenAiMetadata(item, this.resultsMetadataFieldName);
        }
        AtomicInteger estimatedTokenCount = new AtomicInteger(0);
        if (!this.contextPrompt.isEmpty()) {
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.contextPrompt));
        }
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{item_text}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{email_header}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{item_properties}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.extractionPrompt));
        String emailHeaderContent = "";
        if (this.documentPrompt.contains("{email_header}")) {
            emailHeaderContent = FormattingUtils.getEmailHeader((Item)item);
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(emailHeaderContent));
        }
        String itemPropertiesContent = "";
        if (this.documentPrompt.contains("{item_properties}")) {
            itemPropertiesContent = SerializationUtils.toJson((Object)item.getProperties(), (boolean)false);
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(itemPropertiesContent));
        }
        int maxTokens = this.genAiService.getContextWindow() - estimatedTokenCount.get();
        List<String> splitContent = this.splitContent(content, maxTokens);
        int batchId = 0;
        ArrayList<String> responses = new ArrayList<String>();
        String responseRole = "assistant";
        ArrayList<Future<WrappedResponse>> futureResponses = new ArrayList<Future<WrappedResponse>>();
        ArrayList<GenAiMessage> messages = null;
        boolean storeMetadata = false;
        for (int i = 0; i < splitContent.size(); ++i) {
            String string = splitContent.get(i);
            messages = new ArrayList<GenAiMessage>();
            if (!this.contextPrompt.isEmpty()) {
                messages.add(new GenAiMessage("system", this.contextPrompt));
            }
            String documentPromptText = this.documentPrompt.replace("{item_text}", string);
            documentPromptText = documentPromptText.replace("{email_header}", emailHeaderContent);
            documentPromptText = documentPromptText.replace("{item_properties}", itemPropertiesContent);
            messages.add(new GenAiMessage("user", documentPromptText + this.extractionPrompt));
            futureResponses.add(this.executePrompt(messages, name, level, ++batchId, item, "1/" + splitContent.size(), storeMetadata, itemPromptOutputReplaced));
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " waiting for " + futureResponses.size() + " responses");
        }
        for (Future future : futureResponses) {
            WrappedResponse wrappedResponse = (WrappedResponse)future.get();
            responseRole = wrappedResponse.getRole();
            responses.add(wrappedResponse.getContent());
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " received all " + futureResponses.size() + " responses");
        }
        this.handleResponses(item, content, responses);
    }

    private Future<WrappedResponse> executePrompt(List<GenAiMessage> messages, String name, int level, int batch, Item item, String promptsInBatchCount, boolean storeMetadata, AtomicBoolean itemPromptOutputReplaced) {
        return this.executor.submit(() -> {
            if (this.stopRequested) {
                return null;
            }
            String normalizedResponseText = null;
            GenAiRequest request = new GenAiRequest(item.getGuid() + "-" + name + "-" + level + "-" + batch, messages);
            if (this.jsonEnabled) {
                request.setJsonSchema(this.jsonSchema);
            }
            if (this.temperatureEnabled) {
                request.setTemperature(this.temperature);
            }
            if (this.maxResponseTokensEnabled) {
                request.setMaxResponseTokens(this.maxResponseTokens);
            }
            String role = null;
            try {
                GenAiResponse response = this.genAiHelper.getCompletions(request);
                role = response.getMessage().getRole();
                normalizedResponseText = response.getMessage().getContent();
                if (this.replacePromptOutput) {
                    boolean matched = false;
                    for (PatternReplacement patternReplacement : this.responsePatternReplacements) {
                        Matcher matcher = patternReplacement.getPattern().matcher(normalizedResponseText);
                        if (!matcher.find()) continue;
                        matched = true;
                        LOGGER.info("Item " + item.getGuid() + " " + name + " - Level " + level + ", Batch " + batch + " response matched regex " + patternReplacement.getRegex() + " and was replaced");
                        normalizedResponseText = matcher.replaceAll(patternReplacement.getReplacement());
                    }
                    if (matched) {
                        itemPromptOutputReplaced.set(true);
                    }
                }
                if (storeMetadata) {
                    this.genAiHelper.setItemGenAiMetadata(item, name + "|Level " + level + "|Batch " + batch, normalizedResponseText);
                }
                LOGGER.info(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.Items", new Object[]{name, level, batch, promptsInBatchCount, response.getUsage().getPromptTokens(), response.getUsage().getCompletionTokens()}));
            }
            catch (Exception e) {
                LOGGER.error("Item " + item.getGuid() + " - " + name + " - Level " + level + ", Batch " + batch + " failed", (Throwable)e);
                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", "Level " + level + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                this.failedItems.add(item);
            }
            finally {
                this.promptsProcessed.incrementAndGet();
            }
            return new WrappedResponse(normalizedResponseText, Collections.singletonList(item), role);
        });
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.itemsProcessed.get() / (double)this.effectiveItemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        long completionTokens;
        long promptTokens;
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get());
        }
        if (this.genAiHelper != null && (promptTokens = this.genAiHelper.getPromptTokens()) + (completionTokens = this.genAiHelper.getCompletionTokens()) > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Count.Tokens", new Object[]{promptTokens, completionTokens});
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }
}

