/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.ocr.ImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import nuix.Binary;
import nuix.BinaryData;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.MutablePrintedImage;
import nuix.PrintedPage;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class GenAiGenericPromptOnImagesOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiGenericPromptOnImagesOperation.class);
    public static final String PAGE_NUMBER_PARAMETER = "{page_number}";
    public static final String PAGE_TRANSCRIPTION_PARAMETER = "{page_transcription}";
    public String scope;
    public boolean sampleEnabled;
    public int sampleSize;
    public boolean temperatureEnabled;
    public double temperature;
    public boolean maxResponseTokensEnabled;
    public int maxResponseTokens;
    public String contextPrompt;
    public String nativeImagesScope;
    public double nonNativeImagesPrintMP;
    public boolean repeatPromptForEachPage;
    public boolean maxPagesEnabled;
    public int maxPages;
    public boolean parseJsonOutput;
    public boolean multiPageAutoMergeJson;
    public String multiPageOutputSeparator;
    public boolean addPageSeparatorBeforeFirstPage;
    public boolean tagAnalyzedItems;
    public String analyzedItemsTagName;
    public boolean untagUnanalyzedItems;
    public boolean tagFailedItems;
    public String failedItemTagName;
    public boolean untagSuccessfulItems;
    public boolean createMetadataProfileEnabled;
    public String metadataProfileName;
    public boolean jsonEnabled;
    public String jsonSchema;
    public boolean sendContextPromptIndependentlyOfQuestionPrompts;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient long itemsInScope;
    private transient long effectiveItemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient AtomicLong imagesProcessed;
    private transient AtomicLong itemsContentTrimmed;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeItems;
    private transient Set<Item> scopeTaggedItems;
    private transient BulkAnnotater bulkAnnotater;
    private transient Set<Item> failedItems;
    private transient String tempTag;
    private transient String model;
    private transient String printableService;
    private transient GenAiHelper genAiHelper;
    private transient GenAiService genAiService;

    public abstract List<Object[]> getPrompts();

    protected String getEffectiveMetadataName(String name) {
        return GenAiHelper.getNormalizedMetadataName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearItemGenAiMetadata(Item item, String name) {
        String effectiveName = GenAiHelper.getNormalizedMetadataName(name);
        Item item2 = item;
        synchronized (item2) {
            ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
            customMetadata.remove((Object)effectiveName);
        }
    }

    protected boolean skipPage(Item item, String promptName, int pageId) {
        return false;
    }

    protected void storePageResult(Item item, String promptName, int pageId, String result) throws IOException {
    }

    protected List<String> getResponsesFromPageResponses(Item item, Map<Integer, String> pageResponses, String promptName, int pages) {
        ArrayList<String> responses = new ArrayList<String>();
        for (int i = 1; i <= pages; ++i) {
            String pageResponse = pageResponses.get(i);
            if (pageResponse != null) {
                responses.add(pageResponse);
                continue;
            }
            responses.add("");
        }
        return responses;
    }

    protected void clearPageResults(Item item, String promptName) {
    }

    public void evaluatePrompts() throws ParameterException {
        for (Object[] prompt : this.getPrompts()) {
            String name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
            String promptQuestion = this.executionContext.evalParameters(prompt[1].toString(), this);
            prompt[0] = name;
            prompt[1] = promptQuestion;
        }
    }

    public void logPrompts() {
        for (Object[] prompt : this.getPrompts()) {
            String name = prompt[0].toString();
            String promptQuestion = prompt[1].toString();
            this.addExecutionLog(this.iu.getFormattedString("Operation.Log.Prompt", new Object[]{name, GenAiHelper.indentMultiLineText(promptQuestion)}));
        }
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.nativeImagesScope = this.executionContext.evalParameters(this.nativeImagesScope, this);
        this.contextPrompt = this.executionContext.evalParameters(this.contextPrompt, this);
        if (this.tagAnalyzedItems) {
            this.analyzedItemsTagName = this.executionContext.evalParameters(this.analyzedItemsTagName, this);
        }
        if (this.tagFailedItems) {
            this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        }
        if (this.createMetadataProfileEnabled) {
            this.metadataProfileName = this.executionContext.evalParameters(this.metadataProfileName, this);
        }
        this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
        this.itemsProcessed = new AtomicLong(0L);
        this.imagesProcessed = new AtomicLong(0L);
        this.itemsContentTrimmed = new AtomicLong(0L);
        this.genAiHelper = this.createMetadataProfileEnabled ? new GenAiHelper(this.executionContext, this, this.thirdPartyServices, this.metadataProfileName) : new GenAiHelper(this.executionContext, this, this.thirdPartyServices);
        this.genAiService = this.genAiHelper.getGenAiService();
        this.model = this.genAiService.getModel();
        this.printableService = this.genAiHelper.getPrintableServiceName();
        this.failedItems = new HashSet<Item>();
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.effectiveItemsInScope = this.itemsInScope = (long)this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                this.stageName = this.iu.getString("Operation.Stage.AnalyzingItems");
                if (this.sampleEnabled) {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.SampleSize", (long)this.sampleSize));
                }
                this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.NativeImagesScope", (Object)this.nativeImagesScope));
                this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.NonNativeImagesPrintMP", (Object)this.nonNativeImagesPrintMP));
                this.evaluatePrompts();
                this.logPrompts();
                if (this.jsonEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.JsonSchema", (Object)GenAiHelper.indentMultiLineText(this.jsonSchema)));
                }
                if (this.repeatPromptForEachPage) {
                    this.addExecutionLog(this.iu.getString("GenAiOperation.Log.RepeatPromptForEachPage"));
                    if (this.multiPageAutoMergeJson) {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.MultiPageAutoMergeJson"));
                    }
                    if (this.multiPageOutputSeparator.length() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MultiPageOutputSeparator", (Object)GenAiHelper.indentMultiLineText(this.multiPageOutputSeparator)));
                    }
                    if (this.addPageSeparatorBeforeFirstPage) {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.AddPageSeparatorBeforeFirstPage"));
                    }
                } else {
                    this.addExecutionLog(this.iu.getString("GenAiOperation.Log.DoNotRepeatPromptForEachPage"));
                }
                if (this.maxPagesEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MaxPages", (Object)this.maxPages));
                }
                if (this.temperatureEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.Temperature", (Object)this.temperature));
                }
                if (this.maxResponseTokensEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MaxResponseTokens", (Object)this.maxResponseTokens));
                }
                if (this.createMetadataProfileEnabled) {
                    this.metadataProfileName = this.executionContext.evalParametersTrim(this.metadataProfileName, this);
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CreateMetadataProfile", (Object)this.metadataProfileName));
                }
                if (!this.contextPrompt.isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContextPrompt", (Object)GenAiHelper.indentMultiLineText(this.contextPrompt)));
                }
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                if (this.sampleEnabled && this.sampleSize < this.scopeItems.size()) {
                    HashSet<Item> sampleItems = new HashSet<Item>();
                    int i = 0;
                    for (Item item : this.scopeItems) {
                        sampleItems.add(item);
                        if (++i < this.sampleSize) continue;
                        break;
                    }
                    this.scopeItems = sampleItems;
                    this.effectiveItemsInScope = this.scopeItems.size();
                }
                if (this.tagFailedItems && this.untagSuccessfulItems && this.scopeItems.size() > 0) {
                    LOGGER.info("Tagging " + this.scopeItems.size() + " items with tag " + this.tempTag);
                    try {
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.scopeItems);
                    }
                    catch (IOException e) {
                        LOGGER.info("Cannot tag items", (Throwable)e);
                    }
                }
                Semaphore activeThreadsSemaphore = new Semaphore(this.genAiService.getMultiThreading());
                ConcurrentHashMap activeThreads = new ConcurrentHashMap();
                AtomicLong threadsCount = new AtomicLong();
                AtomicReference exception = new AtomicReference();
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    try {
                        block4: for (Item item : this.scopeItems) {
                            if (this.stopRequested) break;
                            Long threadId = threadsCount.getAndIncrement();
                            Thread itemThread = new Thread(() -> {
                                try {
                                    if (this.stopRequested) {
                                        return;
                                    }
                                    try {
                                        this.clearItemGenAiMetadata(item, "System|Warning");
                                        this.handleItem(item);
                                        this.processedItems.add(item);
                                        this.clearItemGenAiMetadata(item, "System|Error");
                                    }
                                    catch (IOException e) {
                                        this.genAiHelper.setItemGenAiMetadata(item, "System|Error", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                        this.clearPreviousResults(item);
                                        this.failedItems.add(item);
                                        LOGGER.error("Cannot handle item " + item.getGuid(), (Throwable)e);
                                    }
                                    Item item2 = item;
                                    synchronized (item2) {
                                        this.genAiHelper.setItemGenAiMetadata(item, "System|Model", this.model);
                                        this.genAiHelper.setItemGenAiMetadata(item, "System|Service", this.printableService);
                                    }
                                    this.itemsProcessed.incrementAndGet();
                                }
                                finally {
                                    activeThreadsSemaphore.release();
                                    activeThreads.remove(threadId);
                                }
                            });
                            itemThread.setName("GenAI document handling");
                            while (!this.stopRequested) {
                                if (!activeThreadsSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) continue;
                                activeThreads.put(threadId, itemThread);
                                itemThread.start();
                                continue block4;
                            }
                        }
                        while (!activeThreads.isEmpty() && !this.stopRequested) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                this.stopRequested = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                });
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
                this.printCounts();
                this.tagItems();
                if (this.stopRequested) {
                    for (Thread activeThread : activeThreads.values()) {
                        activeThread.interrupt();
                    }
                    this.cleanUp();
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.AnalyzeCount", this.itemsProcessed.get()));
        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ImagesPrompted", (Object)this.imagesProcessed.get()));
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.FailedToAnalyzeItems", (long)this.failedItems.size()));
        }
        if (this.itemsContentTrimmed.get() > 0L) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.ItemContentTrimmed", this.itemsContentTrimmed.get()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptTokens", (Object)this.genAiHelper.getPromptTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CompletionTokens", (Object)this.genAiHelper.getCompletionTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.TotalTokens", (Object)this.genAiHelper.getTotalTokens()));
    }

    protected boolean getItemTypeSupported(Item item) {
        return item.matchesSearch(this.nativeImagesScope);
    }

    private void trackStats(String stage, String path, String fileExtension, boolean failed) {
        String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
        this.trackItemProcessedFailed(mimeType, stage, failed);
    }

    private String evaluatePageParameter(Item item, String prompt, int pageNumber) {
        if (prompt.contains(PAGE_NUMBER_PARAMETER)) {
            prompt = prompt.replace(PAGE_NUMBER_PARAMETER, String.valueOf(pageNumber));
        }
        if (prompt.contains(PAGE_TRANSCRIPTION_PARAMETER)) {
            Object pageTranscription = item.getCustomMetadata().get((Object)this.getEffectiveMetadataName("Transcription|" + pageNumber));
            prompt = prompt.replace(PAGE_TRANSCRIPTION_PARAMETER, String.valueOf(pageTranscription));
        }
        return prompt;
    }

    private void handleItem(Item item) throws IOException {
        AtomicReference<Object> promptException = new AtomicReference<Object>(null);
        this.getPrompts().parallelStream().forEach(prompt -> {
            block51: {
                try {
                    int itemPages;
                    ArrayList<GenAiRequest> requests;
                    String name;
                    block49: {
                        if (this.stopRequested) {
                            return;
                        }
                        if (promptException.get() != null) {
                            return;
                        }
                        name = prompt[0].toString();
                        String promptQuestion = prompt[1].toString();
                        requests = new ArrayList<GenAiRequest>();
                        itemPages = 1;
                        try {
                            GenAiRequest request2;
                            ArrayList<GenAiMessage> messages;
                            DataElement dataElement;
                            byte[] base64Image;
                            byte[] bytes;
                            ArrayList<DataElement> images;
                            if (this.getItemTypeSupported(item)) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("OCRing item " + item.getGuid() + " from native file");
                                }
                                Binary itemBinary = item.getBinary();
                                BinaryData binaryData = itemBinary.getBinaryData();
                                byte[] bytes2 = IOUtils.toByteArray((InputStream)binaryData.getInputStream());
                                byte[] base64Image2 = Base64.getEncoder().encode(bytes2);
                                DataElement dataElement2 = new DataElement(item.getType().toString(), new String(base64Image2));
                                ArrayList<DataElement> images2 = new ArrayList<DataElement>();
                                images2.add(dataElement2);
                                ArrayList<GenAiMessage> messages2 = new ArrayList<GenAiMessage>();
                                if (this.contextPrompt.length() > 0) {
                                    messages2.add(new GenAiMessage("system", this.evaluatePageParameter(item, this.contextPrompt, 1)));
                                }
                                messages2.add(new GenAiMessage("user", this.evaluatePageParameter(item, promptQuestion, 1), images2));
                                GenAiRequest request3 = new GenAiRequest(item.getGuid(), messages2);
                                if (this.jsonEnabled) {
                                    request3.setJsonSchema(this.jsonSchema);
                                }
                                requests.add(request3);
                                request3.setReference(1);
                                break block49;
                            }
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Transcribe item " + item.getGuid() + " from printed image file");
                            }
                            try {
                                images = new ArrayList<DataElement>();
                                MutablePrintedImage printedImage = item.getPrintedImage();
                                if (printedImage == null) {
                                    throw new IOException("Printed image not available");
                                }
                                printedImage.generate();
                                List pages = printedImage.getPages();
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Saving item " + item.getGuid() + " pages");
                                }
                                int pageNumber = 0;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Item " + item.getGuid() + " page count: " + pages.size());
                                }
                                itemPages = pages.size();
                                for (PrintedPage page : pages) {
                                    if (this.maxPagesEnabled && ++pageNumber > this.maxPages) {
                                        this.genAiHelper.setItemGenAiMetadata(item, "System|Warning", this.iu.getFormattedString("GenAI.PagesSkipped", new Object[0]));
                                        LOGGER.warn("Item " + item.getGuid() + " page count: " + pages.size() + " reduced to max allowed: " + this.maxPages);
                                        break;
                                    }
                                    if (this.skipPage(item, name, pageNumber)) {
                                        if (!LOGGER.isDebugEnabled()) continue;
                                        LOGGER.debug("Skipping page " + pageNumber + " with existing transcription");
                                        continue;
                                    }
                                    double pageMP = page.getPageWidth() * page.getPageHeight() / 1000000.0;
                                    double zoom = this.nonNativeImagesPrintMP / pageMP;
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("Item " + item.getGuid() + " page " + pageNumber + " size: " + page.getPageWidth() + " / " + page.getPageHeight() + " MP: " + (double)Math.round(pageMP * 100.0) / 100.0 + " Zoom: " + zoom);
                                    }
                                    HashMap<String, Double> options = new HashMap<String, Double>();
                                    options.put("zoom", Math.sqrt(zoom * 2.0));
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    BufferedImage originalImage = page.getPageImage(options);
                                    Image resultingImage = originalImage.getScaledInstance(originalImage.getWidth() / 2, originalImage.getHeight() / 2, 4);
                                    BufferedImage bufferedImage = ImageUtil.convertToBufferedImage(resultingImage);
                                    ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                                    bytes = baos.toByteArray();
                                    base64Image = Base64.getEncoder().encode(bytes);
                                    dataElement = new DataElement("image/png", new String(base64Image));
                                    if (this.repeatPromptForEachPage) {
                                        images = new ArrayList();
                                        images.add(dataElement);
                                        messages = new ArrayList();
                                        if (this.contextPrompt.length() > 0) {
                                            messages.add(new GenAiMessage("system", this.evaluatePageParameter(item, this.contextPrompt, pageNumber)));
                                        }
                                        messages.add(new GenAiMessage("user", this.evaluatePageParameter(item, promptQuestion, pageNumber), images));
                                        request2 = new GenAiRequest(item.getGuid(), messages);
                                        if (this.jsonEnabled) {
                                            request2.setJsonSchema(this.jsonSchema);
                                        }
                                        requests.add(request2);
                                        request2.setReference(pageNumber);
                                        continue;
                                    }
                                    images.add(dataElement);
                                }
                            }
                            catch (Throwable e) {
                                LOGGER.warn("Cannot generate printed image", e);
                                if (item.getName().toLowerCase().endsWith(".pdf")) {
                                    LOGGER.info("Transcribe item " + item.getGuid() + " from native PDF file");
                                    try {
                                        int pageCount;
                                        images = new ArrayList();
                                        byte[] pdfBytes = IOUtils.toByteArray((InputStream)item.getBinary().getBinaryData().getInputStream());
                                        PDDocument document = Loader.loadPDF((byte[])pdfBytes);
                                        PDFRenderer localPdfRenderer = new PDFRenderer(document);
                                        itemPages = pageCount = document.getNumberOfPages();
                                        for (int pageId = 0; pageId < pageCount; ++pageId) {
                                            int pageNumber = pageId + 1;
                                            if (this.maxPagesEnabled && pageId >= this.maxPages) {
                                                this.genAiHelper.setItemGenAiMetadata(item, "System|Warning", this.iu.getFormattedString("GenAI.PagesSkipped", new Object[0]));
                                                LOGGER.warn("Item " + item.getGuid() + " page count: " + pageCount + " reduced to max allowed: " + this.maxPages);
                                            }
                                            if (this.skipPage(item, name, pageNumber)) {
                                                if (!LOGGER.isDebugEnabled()) continue;
                                                LOGGER.debug("Skipping page " + pageNumber + " with existing transcription");
                                                continue;
                                            }
                                            PDPage page = document.getPage(pageId);
                                            PDRectangle cropBox = page.getCropBox();
                                            double pageMP = (double)(cropBox.getWidth() * cropBox.getHeight()) / 1000000.0;
                                            float scale = (float)Math.sqrt(this.nonNativeImagesPrintMP / pageMP);
                                            if (LOGGER.isDebugEnabled()) {
                                                LOGGER.debug("Item " + item.getGuid() + " page " + pageNumber + " size: " + cropBox.getWidth() + " / " + cropBox.getHeight() + " MP: " + (double)Math.round(pageMP * 100.0) / 100.0 + " Scale: " + scale);
                                            }
                                            BufferedImage bufferedImage = localPdfRenderer.renderImage(pageId, scale);
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                                            bytes = baos.toByteArray();
                                            base64Image = Base64.getEncoder().encode(bytes);
                                            dataElement = new DataElement("image/png", new String(base64Image));
                                            if (this.repeatPromptForEachPage) {
                                                images = new ArrayList();
                                                images.add(dataElement);
                                                messages = new ArrayList<GenAiMessage>();
                                                if (this.contextPrompt.length() > 0) {
                                                    messages.add(new GenAiMessage("system", this.evaluatePageParameter(item, this.contextPrompt, pageNumber)));
                                                }
                                                messages.add(new GenAiMessage("user", this.evaluatePageParameter(item, promptQuestion, pageNumber), images));
                                                request2 = new GenAiRequest(item.getGuid(), messages);
                                                if (this.jsonEnabled) {
                                                    request2.setJsonSchema(this.jsonSchema);
                                                }
                                                request2.setReference(pageNumber);
                                                requests.add(request2);
                                                continue;
                                            }
                                            images.add(dataElement);
                                        }
                                    }
                                    catch (Throwable ex) {
                                        LOGGER.warn("Cannot get pages from native PDF", e);
                                        if (!this.stopRequested) {
                                            promptException.set(new IOException("Cannot generate image", e));
                                        }
                                        return;
                                    }
                                }
                                if (!this.stopRequested) {
                                    promptException.set(new IOException("Cannot generate image", e));
                                }
                                return;
                            }
                            if (!this.repeatPromptForEachPage) {
                                ArrayList messages3 = new ArrayList();
                                if (this.contextPrompt.length() > 0) {
                                    messages3.add(new GenAiMessage("system", this.contextPrompt));
                                }
                                messages3.add(new GenAiMessage("user", promptQuestion, images));
                                GenAiRequest request4 = new GenAiRequest(item.getGuid(), messages3);
                                if (this.jsonEnabled) {
                                    request4.setJsonSchema(this.jsonSchema);
                                }
                                requests.add(request4);
                            }
                        }
                        catch (Exception e) {
                            if (!this.stopRequested) {
                                promptException.set(new IOException("Cannot extract image", e));
                            }
                            return;
                        }
                    }
                    ConcurrentHashMap<Integer, String> pageResponses = new ConcurrentHashMap<Integer, String>();
                    for (GenAiRequest request4 : requests) {
                        if (this.temperatureEnabled) {
                            request4.setTemperature(this.temperature);
                        }
                        if (!this.maxResponseTokensEnabled) continue;
                        request4.setMaxResponseTokens(this.maxResponseTokens);
                    }
                    requests.parallelStream().forEach(request -> {
                        block6: {
                            if (this.stopRequested) {
                                return;
                            }
                            if (promptException.get() != null) {
                                return;
                            }
                            int pageId = (Integer)request.getReference();
                            try {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("LLM prompt item " + item.getGuid() + " prompt: " + pageId + "/" + requests.size());
                                }
                                request.setId(item.getGuid() + "_" + name + "_page" + pageId);
                                GenAiResponse response = this.genAiHelper.getCompletions((GenAiRequest)request);
                                int imagesCount = 0;
                                for (GenAiMessage genAiMessage : request.getMessages()) {
                                    if (genAiMessage.getImages() == null) continue;
                                    imagesCount += genAiMessage.getImages().size();
                                }
                                this.imagesProcessed.addAndGet(imagesCount);
                                String responseText = response.getMessage().getContent();
                                pageResponses.put(pageId, responseText);
                                this.storePageResult(item, name, pageId, responseText);
                            }
                            catch (Throwable e) {
                                LOGGER.error("Error handling page " + pageId, e);
                                if (this.stopRequested) break block6;
                                promptException.set(new IOException("Error handling page " + pageId, e));
                            }
                        }
                    });
                    List<String> responses = this.getResponsesFromPageResponses(item, pageResponses, name, itemPages);
                    this.clearPageResults(item, name);
                    boolean dataIsJson = false;
                    ArrayList mergedList = new ArrayList();
                    if (this.multiPageAutoMergeJson) {
                        try {
                            for (String response : responses) {
                                if ((response = response.trim()).startsWith("```json") && (response = response.substring(7)).endsWith("```")) {
                                    response = response.substring(0, response.length() - 3);
                                }
                                response = response.trim();
                                List responseList = (List)SerializationUtils.fromJson((String)response, List.class);
                                mergedList.addAll(responseList);
                            }
                            dataIsJson = true;
                        }
                        catch (Exception localPdfRenderer) {
                            // empty catch block
                        }
                    }
                    try {
                        if (dataIsJson) {
                            this.applyPromptResult(item, name, SerializationUtils.toJson(mergedList));
                            break block51;
                        }
                        this.applyPromptResult(item, name, this.mergePagedResponses(responses));
                    }
                    catch (IOException e) {
                        promptException.set(e);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Error handling prompt", t);
                }
            }
        });
        if (promptException.get() != null) {
            Exception e = promptException.get();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @NotNull
    private String mergePagedResponses(List<String> responses) {
        StringBuilder mergedOutput = new StringBuilder();
        for (int pageId = 1; pageId <= responses.size(); ++pageId) {
            boolean addSeparator = false;
            if (pageId == 1) {
                if (this.addPageSeparatorBeforeFirstPage) {
                    addSeparator = true;
                }
            } else {
                addSeparator = true;
            }
            if (addSeparator) {
                String separator = this.multiPageOutputSeparator;
                separator = separator.replace(PAGE_NUMBER_PARAMETER, String.valueOf(pageId));
                mergedOutput.append(separator);
            }
            mergedOutput.append(responses.get(pageId - 1));
        }
        return mergedOutput.toString();
    }

    public void applyPromptResult(Item item, String promptName, String result) throws IOException {
        this.genAiHelper.setItemGenAiMetadata(item, promptName, result, this.parseJsonOutput);
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.itemsProcessed.get() / (double)this.effectiveItemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        long completionTokens;
        long promptTokens;
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get());
        }
        if (this.imagesProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Images", this.imagesProcessed.get());
        }
        if (this.genAiHelper != null && (promptTokens = this.genAiHelper.getPromptTokens()) + (completionTokens = this.genAiHelper.getCompletionTokens()) > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Count.Tokens", new Object[]{promptTokens, completionTokens});
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }

    public void clearPreviousResults(Item item) {
        for (Object[] prompt : this.getPrompts()) {
            String name = prompt[0].toString();
            GenAiHelper.clearItemGenAiMetadata(item, name);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }
}

