/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.genai.ContentProvider;
import com.nuix.automate.workflow.core.execution.genai.ItemSetContentProvider;
import com.nuix.automate.workflow.core.execution.genai.StringListContentProvider;
import com.nuix.automate.workflow.core.execution.genai.WrappedContent;
import com.nuix.automate.workflow.core.execution.genai.WrappedItem;
import com.nuix.automate.workflow.core.execution.genai.WrappedResponse;
import com.nuix.automate.workflow.core.execution.operations.GenAiPromptOnDocumentSetOperation;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextFromStringModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.EvidenceContainer;
import nuix.Item;
import nuix.ItemModifierCallback;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.Processor;
import nuix.ProductionSetItem;
import nuix.SimpleCase;

public class GenAiPromptOnDocumentSetOperationImplementation
extends GenAiPromptOnDocumentSetOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiPromptOnDocumentSetOperation.class);
    private static final String GEN_AI_EVIDENCE_NAME = "GenAI";
    private transient ExecutorService executor;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient long itemsInScope;
    private transient long effectiveItemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient AtomicLong promptsProcessed;
    private transient Set<Item> scopeItems;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeTaggedItems;
    private transient AtomicLong promptsOutputReplaced;
    private transient AtomicLong promptsInputReplaced;
    private transient Set<Item> failedItems;
    private transient String tempTag;
    private transient String model;
    private transient String printableService;
    private transient GenAiHelper genAiHelper;
    private transient GenAiService genAiService;
    private transient List<String[]> contentRegex;
    private transient List<String[]> responseRegex;
    private transient Processor processor;
    private transient Item rootItem;
    private transient Item resultItem;
    private transient SimpleCase simpleCase;
    private transient int progressPromptId;
    private transient int progressLevel;
    private transient int progressBatchesTotal;
    private AtomicInteger batchesCompleted;
    private transient BulkAnnotater bulkAnnotater;
    private transient Set<String> contentMetadataProfileRubyFieldNames;
    private transient MetadataItem contentMetadataItem;
    private transient Map<String, String> results;

    @Override
    public void startTriggered() throws Exception {
        String[] regexArray;
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.contextPrompt = this.executionContext.evalParameters(this.contextPrompt, this);
        this.recursiveContextPrompt = this.executionContext.evalParameters(this.recursiveContextPrompt, this);
        this.documentPrompt = this.executionContext.evalParameters(this.documentPrompt, this);
        this.recursiveContentPrompt = this.executionContext.evalParameters(this.recursiveContentPrompt, this);
        this.resultingItemName = this.executionContext.evalParametersTrim(this.resultingItemName, this);
        this.levelTagName = this.executionContext.evalParametersTrim(this.levelTagName, this);
        if (this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA)) {
            this.metadataFieldName = this.executionContext.evalParameters(this.metadataFieldName, this);
        }
        if (this.tagAnalyzedItems) {
            this.analyzedItemsTagName = this.executionContext.evalParameters(this.analyzedItemsTagName, this);
        }
        if (this.tagFailedItems) {
            this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        }
        if (this.createMetadataProfileEnabled) {
            this.metadataProfileName = this.executionContext.evalParameters(this.metadataProfileName, this);
        }
        this.contentRegex = new ArrayList<String[]>();
        this.responseRegex = new ArrayList<String[]>();
        this.results = new ConcurrentHashMap<String, String>();
        if (this.replaceContent) {
            for (Object[] regex : this.replaceContentRegexes) {
                regexArray = new String[]{this.executionContext.evalParameters(regex[0].toString(), this), this.executionContext.evalParameters(regex[1].toString(), this)};
                this.contentRegex.add(regexArray);
            }
        }
        if (this.replacePromptOutput) {
            for (Object[] regex : this.replacePromptOutputRegexes) {
                regexArray = new String[]{this.executionContext.evalParameters(regex[0].toString(), this), this.executionContext.evalParameters(regex[1].toString(), this)};
                this.responseRegex.add(regexArray);
            }
        }
        this.promptsOutputReplaced = new AtomicLong(0L);
        this.promptsInputReplaced = new AtomicLong(0L);
        if (!(this.documentPrompt.contains("{item_text}") || this.documentPrompt.contains("{item_properties}") || this.documentPrompt.contains("{email_header}"))) {
            throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.DocumentPromptMissingItemText", new Object[]{"{item_text}", "{item_properties}", "{email_header}"}));
        }
        this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
        this.itemsProcessed = new AtomicLong(0L);
        this.promptsProcessed = new AtomicLong(0L);
        this.genAiHelper = this.createMetadataProfileEnabled ? new GenAiHelper(this.executionContext, this, this.thirdPartyServices, this.metadataProfileName) : new GenAiHelper(this.executionContext, this, this.thirdPartyServices);
        this.genAiService = this.genAiHelper.getGenAiService();
        this.model = this.genAiService.getModel();
        this.printableService = this.genAiHelper.getPrintableServiceName();
        this.failedItems = new HashSet<Item>();
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("Operation.Stage.Initializing");
                this.simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
                this.createGenAiRootItem(this.resultingItemName);
                LOGGER.info("Root GenAI item: " + this.rootItem.getName() + " / " + this.rootItem.getGuid());
                this.resultItem = this.getOrAddChildItem(this.resultingItemName);
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                if (this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD)) {
                    this.contentMetadataProfileName = this.executionContext.evalParameters(this.contentMetadataProfileName, this);
                    this.contentMetadataProfileField = this.executionContext.evalParameters(this.contentMetadataProfileField, this);
                    MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.contentMetadataProfileName);
                    if (mp == null) {
                        throw new IllegalStateException("Cannot find metadata profile " + this.contentMetadataProfileName);
                    }
                    this.contentMetadataProfileRubyFieldNames = new TreeSet<String>();
                    for (MetadataItem metadataItem : mp.getMetadata()) {
                        if (!metadataItem.getName().equals(this.contentMetadataProfileField)) continue;
                        this.contentMetadataItem = metadataItem;
                        if (!MetadataItemUtils.isRubyScript(metadataItem)) break;
                        this.contentMetadataProfileRubyFieldNames.add(metadataItem.getName());
                        LOGGER.info("Content metadata field " + metadataItem.getName() + " is scripted Ruby field");
                        break;
                    }
                    if (this.contentMetadataItem == null) {
                        throw new IllegalStateException("Cannot find metadata profile field " + this.contentMetadataProfileField + " in metadata profile " + this.contentMetadataProfileName);
                    }
                }
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.effectiveItemsInScope = this.itemsInScope = (long)this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                this.stageName = this.iu.getString("Operation.Stage.AnalyzingItems");
                if (this.sampleEnabled) {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.SampleSize", (long)this.sampleSize));
                }
                if (this.scopeItems.isEmpty()) {
                    this.addWarning(this.iu.getString("AddToProductionSetOperation.Warning.NoItemsMatchedSearchQuery"));
                } else {
                    String promptQuestion;
                    String name;
                    this.addExecutionLog(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.ResultingItemName", (Object)this.resultingItemName));
                    switch (this.contentLocation) {
                        case TEXT: {
                            this.addExecutionLog(this.iu.getString("GenAiOperation.Log.ContentLocationText"));
                            break;
                        }
                        case CUSTOM_METADATA: {
                            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadata", (Object)this.metadataFieldName));
                            break;
                        }
                        case METADATA_PROFILE_FIELD: {
                            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadataProfileField", new Object[]{this.contentMetadataProfileName, this.contentMetadataProfileField}));
                        }
                    }
                    if (this.replaceContent) {
                        for (Object[] regex : this.replaceContentRegexes) {
                            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceContentRegex", new Object[]{regex[0], regex[1]}));
                        }
                    }
                    if (!this.contextPrompt.isEmpty()) {
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContextPrompt", (Object)GenAiHelper.indentMultiLineText(this.contextPrompt)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("Operation.Log.DocumentPrompt", (Object)GenAiHelper.indentMultiLineText(this.documentPrompt)));
                    if (this.useDifferentSettingsForRecursivePrompts) {
                        if (!this.recursiveContextPrompt.isEmpty()) {
                            this.addExecutionLog(this.iu.getFormattedString("Operation.Log.RecursiveContextPrompt", (Object)GenAiHelper.indentMultiLineText(this.recursiveContextPrompt)));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.RecursiveContentPrompt", (Object)GenAiHelper.indentMultiLineText(this.recursiveContentPrompt)));
                    }
                    if (!this.useDifferentSettingsForRecursivePrompts) {
                        for (Object[] prompt : this.prompts) {
                            name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
                            promptQuestion = this.executionContext.evalParameters(prompt[1].toString(), this);
                            prompt[0] = name;
                            prompt[1] = promptQuestion;
                            this.addExecutionLog(this.iu.getFormattedString("Operation.Log.Prompt", new Object[]{name, GenAiHelper.indentMultiLineText(promptQuestion)}));
                        }
                    } else {
                        for (Object[] prompt : this.recursivePrompts) {
                            name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
                            promptQuestion = this.executionContext.evalParameters(prompt[1].toString(), this);
                            String recursivePromptQuestion = this.executionContext.evalParameters(prompt[2].toString(), this);
                            prompt[0] = name;
                            prompt[1] = promptQuestion;
                            prompt[2] = recursivePromptQuestion;
                            this.addExecutionLog(this.iu.getFormattedString("Operation.Log.Prompt", new Object[]{name, GenAiHelper.indentMultiLineText(promptQuestion)}));
                            this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContentPromptForRecursiveResponses", new Object[]{name, GenAiHelper.indentMultiLineText(recursivePromptQuestion)}));
                        }
                    }
                    if (this.replacePromptOutput) {
                        for (Object[] regex : this.replacePromptOutputRegexes) {
                            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceResponseRegex", new Object[]{regex[0], regex[1]}));
                        }
                    }
                    if (this.jsonEnabled) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.JsonSchema", (Object)GenAiHelper.indentMultiLineText(this.jsonSchema)));
                    }
                    if (this.temperatureEnabled) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.Temperature", (Object)this.temperature));
                    }
                    if (this.maxResponseTokensEnabled) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MaxResponseTokens", (Object)this.maxResponseTokens));
                    }
                    if (this.sampleEnabled && this.sampleSize < this.scopeItems.size()) {
                        HashSet<Item> sampleItems = new HashSet<Item>();
                        int i = 0;
                        for (Item item : this.scopeItems) {
                            sampleItems.add(item);
                            if (++i < this.sampleSize) continue;
                            break;
                        }
                        this.scopeItems = sampleItems;
                        this.effectiveItemsInScope = this.scopeItems.size();
                    }
                    if (this.createMetadataProfileEnabled) {
                        this.metadataProfileName = this.executionContext.evalParametersTrim(this.metadataProfileName, this);
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CreateMetadataProfile", (Object)this.metadataProfileName));
                    }
                    this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    this.executor = Executors.newFixedThreadPool(this.genAiService.getMultiThreading());
                    this.handleItems(this.scopeItems);
                    this.printCounts();
                    this.tagItems();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.AnalyzeCount", this.itemsProcessed.get()));
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.FailedPrompt", (long)this.failedItems.size()));
        }
        if (this.replaceContent) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptInputsMatchingSanitizationRegex", (Object)this.promptsInputReplaced.get()));
        }
        if (this.replacePromptOutput) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptResponsesMatchingCleanupRegex", (Object)this.promptsOutputReplaced.get()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptTokens", (Object)this.genAiHelper.getPromptTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CompletionTokens", (Object)this.genAiHelper.getCompletionTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.TotalTokens", (Object)this.genAiHelper.getTotalTokens()));
    }

    private Item getGenAiRootItem() throws IOException {
        for (Item rootItem : this.simpleCase.getRootItems()) {
            if (!rootItem.getName().equals(GEN_AI_EVIDENCE_NAME)) continue;
            return rootItem;
        }
        return null;
    }

    private Processor getProcessor() {
        Processor processor = this.simpleCase.createProcessor();
        HashMap<String, Integer> currentSettings = new HashMap<String, Integer>(processor.getParallelProcessingSettings());
        currentSettings.put("workerCount", 1);
        processor.setParallelProcessingSettings(currentSettings);
        return processor;
    }

    private Item getFolderItem() throws IOException {
        for (Item folderItem : this.rootItem.getChildren()) {
            if (!folderItem.getName().equals(this.getOperationName())) continue;
            return folderItem;
        }
        throw new IOException("Cannot find item " + this.getOperationName() + " in evidence " + String.valueOf(this.rootItem));
    }

    private Item getOrAddChildItem(String itemName) throws IOException {
        Item folderItem = this.getFolderItem();
        for (Item childItem : folderItem.getChildren()) {
            if (!childItem.getName().equals(itemName)) continue;
            return childItem;
        }
        LOGGER.info("Cannot find existing item, creating new item " + itemName + "...");
        this.addExecutionLog(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.AddResultsItem", (Object)itemName));
        Path childItemPath = this.createDummyChildFile(itemName);
        Item finalFolderItem = folderItem;
        if (this.processor == null) {
            this.processor = this.getProcessor();
        }
        ArrayList<File> childFiles = new ArrayList<File>();
        childFiles.add(childItemPath.toFile());
        LOGGER.info("Adding child item...");
        this.processor.addChildItems(finalFolderItem, childFiles);
        LOGGER.info("Processing...");
        try {
            this.processor.process();
        }
        catch (IOException e) {
            LOGGER.error("Cannot process child item", (Throwable)e);
        }
        this.rootItem = this.getGenAiRootItem();
        folderItem = this.getFolderItem();
        for (Item childItem : folderItem.getChildren()) {
            if (!childItem.getName().equals(itemName)) continue;
            return childItem;
        }
        throw new IOException("Cannot find results item " + itemName);
    }

    private Path createDummyChildFile(String itemName) throws IOException {
        Path resultingItemPath;
        Path genAiStorePath = this.executionContext.nuixCase.getLocation().toPath().resolve("Stores").resolve(GEN_AI_EVIDENCE_NAME);
        LOGGER.info("Preparing folder " + String.valueOf(genAiStorePath) + "...");
        Files.createDirectories(genAiStorePath, new FileAttribute[0]);
        Path resultingFolderPath = genAiStorePath.resolve(this.getOperationName());
        if (!Files.exists(resultingFolderPath, new LinkOption[0])) {
            Files.createDirectories(resultingFolderPath, new FileAttribute[0]);
        }
        if (!(resultingItemPath = resultingFolderPath.resolve(itemName)).getParent().toAbsolutePath().equals(resultingFolderPath)) {
            throw new IOException("Invalid item name " + itemName);
        }
        Files.deleteIfExists(resultingItemPath);
        FileUtils.writeToFile((String)" ", (Path)resultingItemPath);
        return resultingItemPath;
    }

    private void createGenAiRootItem(String itemName) throws IOException {
        this.rootItem = this.getGenAiRootItem();
        if (this.rootItem != null) {
            return;
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.CreateEvidenceContainer", (Object)GEN_AI_EVIDENCE_NAME));
        if (this.processor == null) {
            this.processor = this.getProcessor();
        }
        LOGGER.info("Case does not contain GenAI evidence container, creating processor...");
        EvidenceContainer evidenceContainer = this.processor.newEvidenceContainer(GEN_AI_EVIDENCE_NAME);
        LOGGER.info("Saving evidence container...");
        Path childItemPath = this.createDummyChildFile(itemName);
        evidenceContainer.addFile(childItemPath.getParent().toFile());
        evidenceContainer.save();
        LOGGER.info("Processing...");
        this.processor.process();
        this.rootItem = this.getGenAiRootItem();
        if (this.rootItem != null) {
            return;
        }
        throw new IOException("Cannot find GenAI root item");
    }

    private String getLevelBatchName(String name, int level, int batch) {
        return this.levelTagName + "|" + name + "|Level " + level + "|Batch " + batch;
    }

    private List<GenAiMessage> initMessages(int level, AtomicInteger estimatedTokenCount, StringBuilder promptText, String promptQuestion) {
        boolean useRecursiveContextPrompt;
        ArrayList<GenAiMessage> messages = new ArrayList<GenAiMessage>();
        boolean bl = useRecursiveContextPrompt = level > 1 && this.useDifferentSettingsForRecursivePrompts;
        if (!useRecursiveContextPrompt) {
            if (!this.contextPrompt.isEmpty()) {
                messages.add(new GenAiMessage("system", this.contextPrompt));
                estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.contextPrompt));
            }
        } else if (!this.recursiveContextPrompt.isEmpty()) {
            messages.add(new GenAiMessage("system", this.recursiveContextPrompt));
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.recursiveContextPrompt));
        }
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(promptQuestion));
        return messages;
    }

    /*
     * Could not resolve type clashes
     */
    private int handleContent(ContentProvider contentProvider, int level, String name, String promptQuestion, String recursivePromptQuestion) throws ExecutionException, InterruptedException, IOException {
        String content;
        LOGGER.info(name + " - Level " + level + " - Handling " + contentProvider.size() + " items...");
        boolean detectedContent = false;
        this.progressLevel = level;
        this.batchesCompleted = new AtomicInteger(0);
        this.progressBatchesTotal = 1;
        int levelItemsProcessed = 0;
        int batch = 0;
        String effectiveQuestion = level > 1 ? recursivePromptQuestion : promptQuestion;
        AtomicInteger promptTokensCount = new AtomicInteger(0);
        StringBuilder promptText = new StringBuilder();
        List<GenAiMessage> messages = this.initMessages(level, promptTokensCount, promptText, effectiveQuestion);
        ArrayList<Object> itemsInBatch = new ArrayList<Item>();
        int promptsInBatchCount = 0;
        ArrayList<Future<WrappedResponse>> futureResponses = new ArrayList<Future<WrappedResponse>>();
        boolean finalLevel = true;
        while (contentProvider.hasNext()) {
            String nextDocumentPrompt;
            if (this.stopRequested) {
                return level;
            }
            String emailHeaderContent = "";
            Object itemPropertiesContent = "";
            WrappedContent nextWrappedContent = contentProvider.next();
            String nextContent = nextWrappedContent.getContent();
            String nextDocId = "";
            String nextName = "";
            String nextGuid = "";
            ArrayList<Item> nextItems = new ArrayList<Item>();
            if (level == 1) {
                Item item = ((WrappedItem)nextWrappedContent).getItem();
                nextItems.add(item);
                if (this.documentPrompt.contains("{doc_id}")) {
                    Set productionSetItems = item.getProductionSetItems();
                    if (!productionSetItems.isEmpty()) {
                        Iterator iterator = productionSetItems.iterator();
                        if (iterator.hasNext()) {
                            ProductionSetItem productionSetItem = (ProductionSetItem)iterator.next();
                            nextDocId = productionSetItem.getDocumentNumber().toString();
                        }
                    } else {
                        throw new GenAiException("Item does not have a Doc ID");
                    }
                }
                if (this.documentPrompt.contains("{item_guid}")) {
                    nextGuid = item.getGuid();
                }
                if (this.documentPrompt.contains("{item_name}")) {
                    nextName = item.getName();
                }
                if (this.documentPrompt.contains("{email_header}")) {
                    emailHeaderContent = FormattingUtils.getEmailHeader((Item)item);
                }
                if (this.documentPrompt.contains("{item_properties}")) {
                    itemPropertiesContent = SerializationUtils.toJson((Object)item.getProperties(), (boolean)false);
                }
            } else {
                nextItems.addAll(((WrappedResponse)nextWrappedContent).getItems());
            }
            if (nextContent == null || nextContent.trim().length() == 0) {
                if (nextItems.isEmpty()) continue;
                for (Object errorItem : nextItems) {
                    this.genAiHelper.setItemGenAiMetadata((Item)errorItem, "System|Error", "Level " + level + ", No content");
                }
                if (nextItems.size() == 1) {
                    LOGGER.info(name + " - Level " + level + " - Item with no content [" + ((Item)nextItems.get(0)).getGuid() + "]");
                } else {
                    LOGGER.info(name + " - Level " + level + " - " + nextItems.size() + " items with no content [" + ((Item)nextItems.get(0)).getGuid() + ", ...]");
                }
                this.failedItems.addAll(nextItems);
                continue;
            }
            detectedContent = true;
            if (this.replaceContent) {
                Object errorItem;
                boolean matched = false;
                errorItem = this.contentRegex.iterator();
                while (errorItem.hasNext()) {
                    String[] regex = (String[])errorItem.next();
                    Matcher matcher = Pattern.compile(regex[0]).matcher(nextContent);
                    if (!matcher.find()) continue;
                    matched = true;
                    LOGGER.info(name + " - Level " + level + " - Content matched regex " + regex[0] + " and was replaced");
                    nextContent = matcher.replaceAll(regex[1]);
                }
                if (matched) {
                    this.promptsInputReplaced.incrementAndGet();
                }
            }
            if (level == 1) {
                this.itemsProcessed.incrementAndGet();
            }
            if (level > 1 && this.useDifferentSettingsForRecursivePrompts) {
                nextDocumentPrompt = this.recursiveContentPrompt;
                nextDocumentPrompt = nextDocumentPrompt.replace("{answer_text}", nextContent);
            } else {
                nextDocumentPrompt = this.documentPrompt;
                if (nextDocumentPrompt.contains("{doc_id}")) {
                    nextDocumentPrompt = nextDocumentPrompt.replace("{doc_id}", nextDocId);
                }
                nextDocumentPrompt = nextDocumentPrompt.replace("{item_text}", nextContent);
                nextDocumentPrompt = nextDocumentPrompt.replace("{email_header}", emailHeaderContent);
                nextDocumentPrompt = nextDocumentPrompt.replace("{item_properties}", (CharSequence)itemPropertiesContent);
                nextDocumentPrompt = nextDocumentPrompt.replace("{item_guid}", nextGuid);
                nextDocumentPrompt = nextDocumentPrompt.replace("{item_name}", nextName);
            }
            int nextPromptTokens = this.genAiHelper.estimateTokens(nextDocumentPrompt);
            if (!this.genAiHelper.fitsInContext(nextPromptTokens)) {
                if (level == 1) {
                    Item item = (Item)nextItems.get(0);
                    throw new GenAiException(this.iu.getFormattedString("GenAI.Error.ItemGuidContentTooLarge", new Object[]{name, item.getGuid(), nextPromptTokens, this.genAiHelper.getPrintableContextWindow(), this.genAiHelper.getContextWindow()}));
                }
                throw new GenAiException(this.iu.getFormattedString("GenAI.Error.ResponseContentTooLarge", new Object[]{name, batch + 1, level, nextPromptTokens, this.genAiHelper.getPrintableContextWindow(), this.genAiHelper.getContextWindow()}));
            }
            if (promptsInBatchCount > 0 && !this.genAiHelper.fitsInContext(promptTokensCount.get() + nextPromptTokens)) {
                levelItemsProcessed += promptsInBatchCount;
                finalLevel = false;
                futureResponses.add(this.executePrompt(messages, promptText, name, effectiveQuestion, level, ++batch, promptsInBatchCount, itemsInBatch, finalLevel));
                promptTokensCount = new AtomicInteger(0);
                promptText = new StringBuilder();
                messages = this.initMessages(level, promptTokensCount, promptText, effectiveQuestion);
                if (this.tagItemsAtLevel) {
                    this.bulkAnnotater.addTag(this.getLevelBatchName(name, level, batch), itemsInBatch);
                }
                this.processedItems.addAll(itemsInBatch);
                itemsInBatch = new ArrayList();
                promptsInBatchCount = 0;
            }
            promptText.append(nextDocumentPrompt);
            promptTokensCount.addAndGet(nextPromptTokens);
            ++promptsInBatchCount;
            itemsInBatch.addAll(nextItems);
        }
        if (!detectedContent) {
            if (level == 1) {
                throw new IllegalStateException(this.iu.getFormattedString("GenAi.Error.NoContentDetectedCheckSourceLocation", new Object[]{name, level}));
            }
            throw new IllegalStateException(this.iu.getFormattedString("GenAi.Error.NoContentDetected", new Object[]{name, level}));
        }
        if (promptsInBatchCount > 0) {
            levelItemsProcessed += promptsInBatchCount;
            futureResponses.add(this.executePrompt(messages, promptText, name, effectiveQuestion, level, ++batch, promptsInBatchCount, itemsInBatch, finalLevel));
            if (this.tagItemsAtLevel && !finalLevel) {
                this.bulkAnnotater.addTag(this.getLevelBatchName(name, level, batch), itemsInBatch);
            }
            this.processedItems.addAll(itemsInBatch);
        }
        this.progressBatchesTotal = futureResponses.size();
        LOGGER.info(name + " - Level " + level + " - Waiting for all responses...");
        ArrayList<WrappedResponse> responses = new ArrayList<WrappedResponse>();
        for (Future futureResponse : futureResponses) {
            responses.add((WrappedResponse)futureResponse.get());
        }
        LOGGER.info(name + " - Level " + level + " - Received all responses");
        if (responses.size() == 1) {
            content = ((WrappedResponse)responses.get(0)).getContent();
            if (content == null) {
                content = "";
            }
        } else {
            int nextLevel = level + 1;
            if (nextLevel > this.maxRecursionPasses) {
                throw new IllegalStateException(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Error.MaxRecursion", new Object[]{name, level}));
            }
            if (levelItemsProcessed == responses.size() && level > 1) {
                throw new IllegalStateException(this.iu.getFormattedString("GenAi.Error.PassDidNotReduceBatches", new Object[]{name, level}));
            }
            StringListContentProvider stringListContentProvider = new StringListContentProvider(responses);
            return this.handleContent(stringListContentProvider, nextLevel, name, promptQuestion, recursivePromptQuestion);
        }
        this.results.put(name, content);
        this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.CompletionPass", (long)level, (Object)name));
        return level;
    }

    private void handleResults() throws IOException {
        AtomicReference e = new AtomicReference();
        switch (this.resultsLocation) {
            case CUSTOM_METADATA: {
                for (String name : this.results.keySet()) {
                    String content = this.results.get(name);
                    this.genAiHelper.setItemGenAiMetadata(this.resultItem, name, content, this.parseJsonOutput);
                }
                break;
            }
            case TEXT: {
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    if (this.results.size() == 1) {
                        String text = this.results.values().iterator().next();
                        try {
                            this.resultItem.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(text));
                        }
                        catch (IOException ex) {
                            e.set(ex);
                        }
                    } else {
                        StringBuilder text = new StringBuilder();
                        for (String name : this.results.keySet()) {
                            text.append(name).append(":\n").append(this.results.get(name)).append("\n\n");
                        }
                        try {
                            this.resultItem.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(text.toString()));
                        }
                        catch (IOException ex) {
                            e.set(ex);
                        }
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected results location " + String.valueOf((Object)this.resultsLocation));
            }
        }
        if (e.get() != null) {
            throw (IOException)e.get();
        }
    }

    private Future<WrappedResponse> executePrompt(List<GenAiMessage> messages, StringBuilder promptText, String name, String promptQuestion, int level, int batch, int promptsInBatchCount, List<Item> itemsInBatch, boolean finalLevel) {
        return this.executor.submit(() -> {
            if (this.stopRequested) {
                return null;
            }
            String normalizedResponseText = null;
            messages.add(new GenAiMessage("user", String.valueOf(promptText) + promptQuestion));
            GenAiRequest request = new GenAiRequest(name + "-" + level + "-" + batch, messages);
            if (this.jsonEnabled) {
                request.setJsonSchema(this.jsonSchema);
            }
            if (this.temperatureEnabled) {
                request.setTemperature(this.temperature);
            }
            if (this.maxResponseTokensEnabled) {
                request.setMaxResponseTokens(this.maxResponseTokens);
            }
            String role = null;
            try {
                GenAiResponse response = this.genAiHelper.getCompletions(request);
                role = response.getMessage().getRole();
                normalizedResponseText = response.getMessage().getContent();
                if (this.replacePromptOutput) {
                    boolean matched = false;
                    for (String[] regex : this.responseRegex) {
                        Matcher matcher = Pattern.compile(regex[0]).matcher(normalizedResponseText);
                        if (!matcher.find()) continue;
                        matched = true;
                        LOGGER.info(name + " - Level " + level + ", Batch " + batch + " response matched regex " + regex[0] + " and was replaced");
                        normalizedResponseText = matcher.replaceAll(regex[1]);
                    }
                    if (matched) {
                        this.promptsOutputReplaced.incrementAndGet();
                    }
                }
                if (this.keepIndividualBatchesResponses && !finalLevel) {
                    this.genAiHelper.setItemGenAiMetadata(this.resultItem, name + "|Level " + level + "|Batch " + batch, normalizedResponseText, this.parseJsonOutput);
                }
                LOGGER.info(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.Items", new Object[]{name, level, batch, promptsInBatchCount, response.getUsage().getPromptTokens(), response.getUsage().getCompletionTokens()}));
            }
            catch (Exception e) {
                if (this.keepIndividualBatchesResponses) {
                    this.genAiHelper.setItemGenAiMetadata(this.resultItem, name + "|Level " + level + "|Batch " + batch + "|FailureMessage", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                    this.genAiHelper.setItemGenAiMetadata(this.resultItem, name + "|Level " + level + "|Batch " + batch + "|FailureDetail", ExceptionUtils.getStackTrace((Throwable)e));
                }
                for (Item erroItem : itemsInBatch) {
                    this.genAiHelper.setItemGenAiMetadata(erroItem, "System|Error", "Level " + level + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                }
                this.failedItems.addAll(itemsInBatch);
                itemsInBatch.clear();
            }
            finally {
                this.promptsProcessed.incrementAndGet();
            }
            this.batchesCompleted.incrementAndGet();
            return new WrappedResponse(normalizedResponseText, itemsInBatch, role);
        });
    }

    private void handleItems(Collection<Item> items) throws IOException {
        AtomicBoolean itemPromptOutputReplaced = new AtomicBoolean(false);
        AtomicReference<Object> promptException = new AtomicReference<Object>(null);
        GenAiHelper.clearItemGenAiMetadata(this.resultItem, "System|Error");
        this.genAiHelper.setItemGenAiMetadata(this.resultItem, "System|Model", this.model);
        this.genAiHelper.setItemGenAiMetadata(this.resultItem, "System|Service", this.printableService);
        int promptsCount = this.useDifferentSettingsForRecursivePrompts ? this.recursivePrompts.size() : this.prompts.size();
        for (int i = 0; i < promptsCount; ++i) {
            String recursivePromptQuestion;
            String promptQuestion;
            String name;
            if (this.stopRequested) {
                return;
            }
            if (promptException.get() != null) {
                return;
            }
            if (this.useDifferentSettingsForRecursivePrompts) {
                name = ((Object[])this.recursivePrompts.get(i))[0].toString();
                promptQuestion = ((Object[])this.recursivePrompts.get(i))[1].toString();
                recursivePromptQuestion = ((Object[])this.recursivePrompts.get(i))[2].toString();
            } else {
                name = ((Object[])this.prompts.get(i))[0].toString();
                recursivePromptQuestion = promptQuestion = ((Object[])this.prompts.get(i))[1].toString();
            }
            GenAiHelper.clearItemGenAiMetadata(this.resultItem, name);
            int totalLevels = 0;
            for (Item item : items) {
                GenAiHelper.clearItemGenAiMetadata(item, "System|Error");
                GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
            }
            ItemSetContentProvider itemSetContentProvider = new ItemSetContentProvider(items, this.contentLocation, this.metadataFieldName, this.contentMetadataItem, this.contentMetadataProfileRubyFieldNames);
            try {
                totalLevels = this.handleContent(itemSetContentProvider, 1, name, promptQuestion, recursivePromptQuestion);
            }
            catch (InterruptedException | ExecutionException e) {
                promptException.set(e);
            }
            if (!this.keepIndividualBatchesResponses) {
                for (int li = 1; li <= totalLevels; ++li) {
                    GenAiHelper.clearItemGenAiMetadata(this.resultItem, name + "|Level " + li);
                }
            }
            ++this.progressPromptId;
        }
        this.handleResults();
        if (promptException.get() != null) {
            Exception e = promptException.get();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = 0.0;
        double promptsCount = this.prompts.size();
        if (promptsCount > 0.0) {
            result = (double)this.progressPromptId / promptsCount;
            if (this.maxRecursionPasses > 0) {
                double levelProgress = (double)(this.progressLevel - 1) / (double)this.maxRecursionPasses;
                if (this.progressBatchesTotal > 0) {
                    double batchesProgress = (double)this.batchesCompleted.get() / (double)this.progressBatchesTotal;
                    levelProgress += batchesProgress / (double)this.maxRecursionPasses;
                }
                result += levelProgress / promptsCount;
            }
        }
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        long completionTokens;
        long promptTokens;
        int currentPromptId;
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.prompts.size() > 1 && (currentPromptId = this.progressPromptId + 1) > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Prompts", (long)currentPromptId);
        }
        if (this.progressLevel > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Log.Level", (Object)this.progressLevel);
        }
        if (this.batchesCompleted != null) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Log.Batch", (Object)(this.batchesCompleted.get() + 1));
        }
        if (this.genAiHelper != null && (promptTokens = this.genAiHelper.getPromptTokens()) + (completionTokens = this.genAiHelper.getCompletionTokens()) > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Count.Tokens", new Object[]{promptTokens, completionTokens});
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }
}

