/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.genai.WrappedResponse;
import com.nuix.automate.workflow.core.execution.operations.GenAiPromptOnDocumentsOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.regex.PatternReplacement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import org.apache.commons.lang3.StringUtils;

public class GenAiPromptOnDocumentsOperationImplementation
extends GenAiPromptOnDocumentsOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiPromptOnDocumentsOperation.class);
    private transient ExecutorService executor;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient long itemsInScope;
    private transient long effectiveItemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient AtomicLong promptsProcessed;
    private transient AtomicLong itemsContentTrimmed;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeItems;
    private transient Set<Item> scopeTaggedItems;
    private transient BulkAnnotater bulkAnnotater;
    private transient AtomicLong itemsTextReplaced;
    private transient AtomicLong itemsPromptOutputReplaced;
    private transient AtomicLong itemsResponseMatchesFollowUpRequirement;
    private transient AtomicLong itemsFollowUpPromptOutputReplaced;
    private transient Set<Item> failedItems;
    private transient String tempTag;
    private transient String model;
    private transient String printableService;
    private transient GenAiHelper genAiHelper;
    private transient GenAiService genAiService;
    private transient List<PatternReplacement> contentPatternReplacements;
    private transient List<PatternReplacement> responsePatternReplacements;
    private transient List<PatternReplacement> followUpResponsePatternReplacements;
    private transient Pattern followUpPromptRequireResponsePattern;
    private transient Set<String> contentMetadataProfileRubyFieldNames;
    private transient MetadataItem contentMetadataItem;

    private List<PatternReplacement> compileRegexList(List<Object[]> regexes) throws ParameterException {
        ArrayList<PatternReplacement> patternReplacementList = new ArrayList<PatternReplacement>();
        for (Object[] regex : regexes) {
            String[] regexArray = new String[]{this.executionContext.evalParameters(regex[0].toString(), this), this.executionContext.evalParameters(regex[1].toString(), this)};
            patternReplacementList.add(new PatternReplacement(regexArray[0], regexArray[1]));
        }
        return patternReplacementList;
    }

    @Override
    public void startTriggered() throws Exception {
        if (this.splitIntoParts) {
            this.followUpPromptsEnabled = false;
        } else {
            this.keepIndividualPartsResponses = false;
        }
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.contextPrompt = this.executionContext.evalParameters(this.contextPrompt, this);
        this.documentPrompt = this.executionContext.evalParameters(this.documentPrompt, this);
        this.partContentPrompt = this.executionContext.evalParameters(this.partContentPrompt, this);
        if (this.replaceContent) {
            this.contentPatternReplacements = this.compileRegexList(this.replaceContentRegexes);
        }
        if (this.replacePromptOutput) {
            this.responsePatternReplacements = this.compileRegexList(this.replacePromptOutputRegexes);
        }
        if (this.followUpPromptsEnabled && this.replaceFollowUpPromptOutput) {
            this.followUpResponsePatternReplacements = this.compileRegexList(this.replaceFollowUpPromptOutputRegexes);
        }
        if (this.followUpPromptsEnabled) {
            this.followUpPromptRequireResponseRegex = this.executionContext.evalParameters(this.followUpPromptRequireResponseRegex, this);
            this.followUpPromptRequireResponsePattern = Pattern.compile(this.followUpPromptRequireResponseRegex);
        }
        if (this.tagAnalyzedItems) {
            this.analyzedItemsTagName = this.executionContext.evalParameters(this.analyzedItemsTagName, this);
        }
        if (this.tagFailedItems) {
            this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        }
        if (this.createMetadataProfileEnabled) {
            this.metadataProfileName = this.executionContext.evalParameters(this.metadataProfileName, this);
        }
        this.itemsTextReplaced = new AtomicLong(0L);
        this.itemsPromptOutputReplaced = new AtomicLong(0L);
        this.itemsResponseMatchesFollowUpRequirement = new AtomicLong(0L);
        this.itemsFollowUpPromptOutputReplaced = new AtomicLong(0L);
        if (!(this.documentPrompt.contains("{item_text}") || this.documentPrompt.contains("{item_properties}") || this.documentPrompt.contains("{email_header}"))) {
            throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.DocumentPromptMissingItemText", new Object[]{"{item_text}", "{item_properties}", "{email_header}"}));
        }
        if (this.splitIntoParts && !this.partContentPrompt.contains("{answer_text}")) {
            throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.ContentForBatchReponsesPromptMissingItemText", (Object)"{answer_text}"));
        }
        this.metadataFieldName = this.executionContext.evalParametersTrim(this.metadataFieldName, this);
        this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
        this.itemsProcessed = new AtomicLong(0L);
        this.promptsProcessed = new AtomicLong(0L);
        this.itemsContentTrimmed = new AtomicLong(0L);
        this.genAiHelper = this.createMetadataProfileEnabled ? new GenAiHelper(this.executionContext, this, this.thirdPartyServices, this.metadataProfileName) : new GenAiHelper(this.executionContext, this, this.thirdPartyServices);
        this.genAiService = this.genAiHelper.getGenAiService();
        this.model = this.genAiService.getModel();
        this.printableService = this.genAiHelper.getPrintableServiceName();
        this.failedItems = ConcurrentHashMap.newKeySet();
        this.startTriggerThread = new Thread(() -> {
            try {
                Object name;
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                if (this.contentLocation.equals((Object)SourceTextLocation.METADATA_PROFILE_FIELD)) {
                    this.contentMetadataProfileName = this.executionContext.evalParameters(this.contentMetadataProfileName, this);
                    this.contentMetadataProfileField = this.executionContext.evalParameters(this.contentMetadataProfileField, this);
                    MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.contentMetadataProfileName);
                    if (mp == null) {
                        throw new IllegalStateException("Cannot find metadata profile " + this.contentMetadataProfileName);
                    }
                    this.contentMetadataProfileRubyFieldNames = new TreeSet<String>();
                    for (MetadataItem metadataItem : mp.getMetadata()) {
                        if (!metadataItem.getName().equals(this.contentMetadataProfileField)) continue;
                        this.contentMetadataItem = metadataItem;
                        if (!MetadataItemUtils.isRubyScript(metadataItem)) break;
                        this.contentMetadataProfileRubyFieldNames.add(metadataItem.getName());
                        LOGGER.info("Content metadata field " + metadataItem.getName() + " is scripted Ruby field");
                        break;
                    }
                    if (this.contentMetadataItem == null) {
                        throw new IllegalStateException("Cannot find metadata profile field " + this.contentMetadataProfileField + " in metadata profile " + this.contentMetadataProfileName);
                    }
                }
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.effectiveItemsInScope = this.itemsInScope = (long)this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                this.stageName = this.iu.getString("Operation.Stage.AnalyzingItems");
                if (this.sampleEnabled) {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.SampleSize", (long)this.sampleSize));
                }
                switch (this.contentLocation) {
                    case TEXT: {
                        this.addExecutionLog(this.iu.getString("GenAiOperation.Log.ContentLocationText"));
                        break;
                    }
                    case CUSTOM_METADATA: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadata", (Object)this.metadataFieldName));
                        break;
                    }
                    case METADATA_PROFILE_FIELD: {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ContentLocationMetadataProfileField", new Object[]{this.contentMetadataProfileName, this.contentMetadataProfileField}));
                    }
                }
                if (this.replaceContent) {
                    for (Object[] regex : this.replaceContentRegexes) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceContentRegex", new Object[]{regex[0], regex[1]}));
                    }
                }
                if (!this.contextPrompt.isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContextPrompt", (Object)GenAiHelper.indentMultiLineText(this.contextPrompt)));
                }
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.DocumentPrompt", (Object)GenAiHelper.indentMultiLineText(this.documentPrompt)));
                if (!this.splitIntoParts) {
                    for (Object[] prompt : this.prompts) {
                        name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
                        String string = this.executionContext.evalParameters(prompt[1].toString(), this);
                        prompt[0] = name;
                        prompt[1] = string;
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.Prompt", new Object[]{name, GenAiHelper.indentMultiLineText(string)}));
                    }
                } else {
                    for (Object[] prompt : this.partPrompts) {
                        name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
                        String string = this.executionContext.evalParameters(prompt[1].toString(), this);
                        String promptAssembleQuestion = this.executionContext.evalParameters(prompt[2].toString(), this);
                        prompt[0] = name;
                        prompt[1] = string;
                        prompt[2] = promptAssembleQuestion;
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.Prompt", new Object[]{name, GenAiHelper.indentMultiLineText(string)}));
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ContentPromptForPartResponses", new Object[]{name, GenAiHelper.indentMultiLineText(promptAssembleQuestion)}));
                    }
                }
                if (this.replacePromptOutput) {
                    for (Object[] regex : this.replacePromptOutputRegexes) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceResponseRegex", new Object[]{regex[0], regex[1]}));
                    }
                }
                if (this.jsonEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.JsonSchema", (Object)GenAiHelper.indentMultiLineText(this.jsonSchema)));
                }
                if (this.followUpPromptsEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.FollowUpPromptRequireResponseRegex", (Object)this.followUpPromptRequireResponseRegex));
                    for (Object[] prompt : this.followUpPrompts) {
                        name = this.executionContext.evalParametersTrim(prompt[0].toString(), this);
                        String string = this.executionContext.evalParameters(prompt[1].toString(), this);
                        prompt[0] = name;
                        prompt[1] = string;
                        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.FollowUpPrompt", new Object[]{name, GenAiHelper.indentMultiLineText(string)}));
                    }
                    if (this.replaceFollowUpPromptOutput) {
                        for (Object[] regex : this.replaceFollowUpPromptOutputRegexes) {
                            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceFollowUpResponseRegex", new Object[]{regex[0], regex[1]}));
                        }
                    }
                    if (this.followUpJsonEnabled) {
                        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.FollowUpJsonSchema", (Object)GenAiHelper.indentMultiLineText(this.followUpJsonSchema)));
                    }
                }
                if (this.temperatureEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.Temperature", (Object)this.temperature));
                }
                if (this.maxResponseTokensEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.MaxResponseTokens", (Object)this.maxResponseTokens));
                }
                if (this.createMetadataProfileEnabled) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CreateMetadataProfile", (Object)this.metadataProfileName));
                }
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                this.executor = Executors.newFixedThreadPool(this.genAiService.getMultiThreading());
                if (this.sampleEnabled && this.sampleSize < this.scopeItems.size()) {
                    HashSet<Item> sampleItems = new HashSet<Item>();
                    int i = 0;
                    for (Item item : this.scopeItems) {
                        sampleItems.add(item);
                        if (++i < this.sampleSize) continue;
                        break;
                    }
                    this.scopeItems = sampleItems;
                    this.effectiveItemsInScope = this.scopeItems.size();
                }
                if (this.tagFailedItems && this.untagSuccessfulItems && this.scopeItems.size() > 0) {
                    LOGGER.info("Tagging " + this.scopeItems.size() + " items with tag " + this.tempTag);
                    try {
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.scopeItems);
                    }
                    catch (IOException e) {
                        LOGGER.info("Cannot tag items", (Throwable)e);
                    }
                }
                Semaphore activeThreadsSemaphore = new Semaphore(this.genAiService.getMultiThreading());
                ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
                AtomicLong threadsCount = new AtomicLong();
                if (!this.splitIntoParts) {
                    this.partPrompts = new ArrayList();
                    for (Object[] prompt : this.prompts) {
                        this.partPrompts.add(new Object[]{prompt[0], prompt[1], ""});
                    }
                }
                block20: for (Item item : this.scopeItems) {
                    if (this.stopRequested) break;
                    Long threadId = threadsCount.getAndIncrement();
                    Thread itemThread = new Thread(() -> {
                        try {
                            if (this.stopRequested) {
                                return;
                            }
                            try {
                                GenAiHelper.clearItemGenAiMetadata(item, "System|Error");
                                GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
                                this.handleItem(item);
                                this.processedItems.add(item);
                            }
                            catch (IOException e) {
                                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                this.clearMetadata(item);
                                this.failedItems.add(item);
                                LOGGER.error("Cannot handle item " + item.getGuid(), (Throwable)e);
                            }
                            this.genAiHelper.setItemGenAiMetadata(item, "System|Model", this.model);
                            this.genAiHelper.setItemGenAiMetadata(item, "System|Service", this.printableService);
                            this.itemsProcessed.incrementAndGet();
                        }
                        finally {
                            activeThreadsSemaphore.release();
                            activeThreads.remove(threadId);
                        }
                    });
                    itemThread.setName("GenAI document handling");
                    while (!this.stopRequested) {
                        if (!activeThreadsSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) continue;
                        activeThreads.put(threadId, itemThread);
                        itemThread.start();
                        continue block20;
                    }
                }
                while (!activeThreads.isEmpty() && !this.stopRequested) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.stopRequested = true;
                    }
                }
                this.printCounts();
                this.tagItems();
                if (this.stopRequested) {
                    for (Thread activeThread : activeThreads.values()) {
                        activeThread.interrupt();
                    }
                    this.cleanUp();
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.AnalyzeCount", this.itemsProcessed.get()));
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.FailedToAnalyzeItems", (long)this.failedItems.size()));
        }
        if (this.itemsContentTrimmed.get() > 0L) {
            this.addWarning(this.iu.getNumeralString("GenAiOperation.Warning.ItemContentTrimmed", this.itemsContentTrimmed.get()));
        }
        if (this.replaceContent) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsMatchingContentSanitizationRegex", (Object)this.itemsTextReplaced.get()));
        }
        if (this.replacePromptOutput) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsPromptResponsesMatchingCleanupRegex", (Object)this.itemsPromptOutputReplaced.get()));
        }
        if (this.followUpPromptsEnabled) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsPromptResponsesMatchingFollowupRegex", (Object)this.itemsResponseMatchesFollowUpRequirement.get()));
        }
        if (this.followUpPromptsEnabled && this.replaceFollowUpPromptOutput) {
            this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ItemsFollowUpPromptResponsesCleanupMatchingRegex", (Object)this.itemsFollowUpPromptOutputReplaced.get()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.PromptTokens", (Object)this.genAiHelper.getPromptTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.CompletionTokens", (Object)this.genAiHelper.getCompletionTokens()));
        this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.TotalTokens", (Object)this.genAiHelper.getTotalTokens()));
    }

    private void handleItem(Item item) throws IOException {
        String bodyText = "[ERROR]";
        switch (this.contentLocation) {
            case TEXT: {
                if (item.getTextObject().isAvailable()) {
                    bodyText = item.getTextObject().toString();
                    break;
                }
                bodyText = "";
                break;
            }
            case CUSTOM_METADATA: {
                if (!item.getCustomMetadata().containsKey((Object)this.metadataFieldName)) {
                    throw new GenAiException(this.iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.MetadataFieldDoesNotExist", (Object)this.metadataFieldName));
                }
                StringBuilder sb = new StringBuilder();
                ItemsUtils.getItemMetadataFieldToString(item, this.metadataFieldName, "", sb, Long.MAX_VALUE, "");
                bodyText = sb.toString();
                break;
            }
            case METADATA_PROFILE_FIELD: {
                try {
                    bodyText = MetadataItemUtils.evaluate(this.contentMetadataItem, item, this.contentMetadataProfileRubyFieldNames);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(this.iu.getString("General.Error.CannotEvaluateMetadata"), e);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected content location: " + String.valueOf((Object)this.contentLocation));
            }
        }
        GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
        AtomicReference<Object> promptException = new AtomicReference<Object>(null);
        if (this.replaceContent) {
            boolean matched = false;
            for (PatternReplacement patternReplacement : this.contentPatternReplacements) {
                Matcher matcher = patternReplacement.getPattern().matcher(bodyText);
                if (!matcher.find()) continue;
                matched = true;
                LOGGER.info("Item " + item.getGuid() + " content matched regex " + patternReplacement.getRegex() + " and was replaced");
                bodyText = matcher.replaceAll(patternReplacement.getReplacement());
            }
            if (matched) {
                this.itemsTextReplaced.incrementAndGet();
            }
        }
        AtomicBoolean itemPromptOutputReplaced = new AtomicBoolean(false);
        AtomicBoolean itemFollowUpPromptOutputReplaced = new AtomicBoolean(false);
        AtomicBoolean itemPromptResponseMatchesFollowUpRequirement = new AtomicBoolean(false);
        AtomicBoolean itemContentTrimmed = new AtomicBoolean(false);
        String finalBodyText = bodyText;
        this.partPrompts.parallelStream().forEach(prompt -> {
            block4: {
                if (this.stopRequested) {
                    return;
                }
                if (promptException.get() != null) {
                    return;
                }
                String name = prompt[0].toString();
                String promptQuestion = prompt[1].toString();
                String batchPromptQuestion = prompt[2].toString();
                try {
                    this.handleItemPrompt(item, finalBodyText, name, promptQuestion, batchPromptQuestion, itemPromptOutputReplaced, itemFollowUpPromptOutputReplaced, itemPromptResponseMatchesFollowUpRequirement, itemContentTrimmed);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    if (this.stopRequested) break block4;
                    promptException.set(e);
                }
            }
        });
        if (itemPromptOutputReplaced.get()) {
            this.itemsPromptOutputReplaced.incrementAndGet();
        }
        if (itemFollowUpPromptOutputReplaced.get()) {
            this.itemsFollowUpPromptOutputReplaced.incrementAndGet();
        }
        if (itemPromptResponseMatchesFollowUpRequirement.get()) {
            this.itemsResponseMatchesFollowUpRequirement.incrementAndGet();
        }
        if (itemContentTrimmed.get()) {
            this.itemsContentTrimmed.incrementAndGet();
        }
        if (promptException.get() != null) {
            Exception e = promptException.get();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new GenAiException(e);
        }
    }

    private List<String> splitContent(String content, int maxTokens) throws IOException {
        String[] splitContent = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)content, (String)this.splitSeparator);
        ArrayList<String> sizedSplitContent = new ArrayList<String>();
        StringBuilder currentContent = new StringBuilder();
        int currentTokensCount = 0;
        for (String contentPart : splitContent) {
            int partTokensCount = this.genAiHelper.estimateTokens(contentPart);
            if (partTokensCount > maxTokens) {
                LOGGER.error("Separator " + this.splitSeparator + " produced " + splitContent.length + " part(s), including 1 part with " + partTokensCount + " tokens, which is more than the maximum allowed " + maxTokens + " tokens");
                throw new GenAiException(this.iu.getFormattedString("GenAI.Error.CannotSplitWithinTokenLimits", new Object[]{splitContent.length, partTokensCount, maxTokens}));
            }
            if (currentTokensCount + partTokensCount > maxTokens) {
                sizedSplitContent.add(currentContent.toString());
                currentContent = new StringBuilder();
                currentTokensCount = 0;
            }
            if (currentContent.length() > 0) {
                currentTokensCount += this.genAiHelper.estimateTokens(this.splitSeparator);
                currentContent.append(this.splitSeparator);
            }
            currentTokensCount += this.genAiHelper.estimateTokens(contentPart);
            currentContent.append(contentPart);
        }
        sizedSplitContent.add(currentContent.toString());
        return sizedSplitContent;
    }

    private void handleItemPrompt(Item item, String content, String name, String prompt, String batchPrompt, AtomicBoolean itemPromptOutputReplaced, AtomicBoolean itemFollowUpPromptOutputReplaced, AtomicBoolean itemPromptResponseMatchesFollowUpRequirement, AtomicBoolean itemContentTrimmed) throws IOException, ExecutionException, InterruptedException {
        int level = 1;
        GenAiHelper.clearItemGenAiMetadata(item, name);
        AtomicInteger estimatedTokenCount = new AtomicInteger(0);
        if (!this.contextPrompt.isEmpty()) {
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.contextPrompt));
        }
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{item_text}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{email_header}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.documentPrompt.replace("{item_properties}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(prompt));
        String emailHeaderContent = "";
        if (this.documentPrompt.contains("{email_header}")) {
            emailHeaderContent = FormattingUtils.getEmailHeader((Item)item);
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(emailHeaderContent));
        }
        String itemPropertiesContent = "";
        if (this.documentPrompt.contains("{item_properties}")) {
            itemPropertiesContent = SerializationUtils.toJson((Object)item.getProperties(), (boolean)false);
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(itemPropertiesContent));
        }
        int maxTokens = this.genAiService.getContextWindow() - estimatedTokenCount.get();
        List<String> splitContent = this.splitContent(content, maxTokens);
        int batchId = 0;
        ArrayList<String> responses = new ArrayList<String>();
        String responseRole = "assistant";
        ArrayList<Future<WrappedResponse>> futureResponses = new ArrayList<Future<WrappedResponse>>();
        boolean storeMetadata = this.keepIndividualPartsResponses && splitContent.size() > 1;
        ArrayList<GenAiMessage> messages = null;
        for (int i = 0; i < splitContent.size(); ++i) {
            if (i > 0 && !this.splitIntoParts) {
                itemContentTrimmed.set(true);
                this.genAiHelper.setItemGenAiMetadata(item, "System|Warning", this.iu.getFormattedString("GenAI.Warning.ItemOnlyFirstPartAnalyzed", (Object)splitContent.size()));
                LOGGER.warn("Item " + item.getGuid() + "-" + name + " was split in " + splitContent.size() + " batches, only the first one was processed");
                break;
            }
            String string = splitContent.get(i);
            messages = new ArrayList<GenAiMessage>();
            if (!this.contextPrompt.isEmpty()) {
                messages.add(new GenAiMessage("system", this.contextPrompt));
            }
            String documentPromptText = this.documentPrompt;
            documentPromptText = GenAiHelper.evalItemParameters(item, documentPromptText);
            documentPromptText = documentPromptText.replace("{item_text}", string);
            documentPromptText = documentPromptText.replace("{email_header}", emailHeaderContent);
            documentPromptText = documentPromptText.replace("{item_properties}", itemPropertiesContent);
            messages.add(new GenAiMessage("user", documentPromptText + prompt));
            futureResponses.add(this.executePrompt(messages, name, level, ++batchId, item, "1/" + splitContent.size(), storeMetadata, itemPromptOutputReplaced));
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " waiting for " + futureResponses.size() + " responses");
        }
        for (Future future : futureResponses) {
            WrappedResponse wrappedResponse = (WrappedResponse)future.get();
            responseRole = wrappedResponse.getRole();
            responses.add(wrappedResponse.getContent());
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " received all " + futureResponses.size() + " responses");
        }
        if (responses.size() == 1) {
            this.genAiHelper.setItemGenAiMetadata(item, name, (String)responses.get(0), this.parseJsonOutput);
            if (!this.splitIntoParts && this.followUpPromptsEnabled) {
                this.handleItemFollowUpPrompts(item, name, (String)responses.get(0), responseRole, messages, itemFollowUpPromptOutputReplaced, itemPromptResponseMatchesFollowUpRequirement);
            }
        } else {
            this.handleItemPromptResponses(2, item, responses, name, batchPrompt, itemPromptOutputReplaced);
        }
    }

    private void handleItemFollowUpPrompts(Item item, String promptName, String responseText, String responseRole, List<GenAiMessage> messages, AtomicBoolean itemFollowUpPromptOutputReplaced, AtomicBoolean itemPromptResponseMatchesFollowUpRequirement) {
        if (!this.followUpPromptsEnabled) {
            return;
        }
        Matcher requiredResponseMatcher = this.followUpPromptRequireResponsePattern.matcher(responseText);
        if (!requiredResponseMatcher.find()) {
            return;
        }
        itemPromptResponseMatchesFollowUpRequirement.set(true);
        AtomicReference<Object> promptException = new AtomicReference<Object>(null);
        messages.add(new GenAiMessage(responseRole, responseText));
        this.followUpPrompts.parallelStream().forEach(followUpPrompt -> {
            try {
                ArrayList<GenAiMessage> followUpMessages = new ArrayList<GenAiMessage>(messages);
                if (this.stopRequested) {
                    return;
                }
                String followUpName = followUpPrompt[0].toString();
                String followUpQuestion = followUpPrompt[1].toString();
                followUpMessages.add(new GenAiMessage("user", followUpQuestion));
                GenAiRequest followUpRequest = new GenAiRequest(item.getGuid() + "-" + promptName + "-" + followUpName, followUpMessages);
                if (this.temperatureEnabled) {
                    followUpRequest.setTemperature(this.temperature);
                }
                if (this.maxResponseTokensEnabled) {
                    followUpRequest.setMaxResponseTokens(this.maxResponseTokens);
                }
                GenAiResponse followUpResponse = this.genAiHelper.getCompletions(followUpRequest);
                String followUpResponseText = followUpResponse.getMessage().getContent();
                if (this.replaceFollowUpPromptOutput) {
                    for (PatternReplacement patternReplacement : this.followUpResponsePatternReplacements) {
                        Matcher matcher = patternReplacement.getPattern().matcher(followUpResponseText);
                        if (!matcher.find()) continue;
                        itemFollowUpPromptOutputReplaced.set(true);
                        LOGGER.info("Item " + item.getGuid() + " follow-up prompt " + promptName + " - " + followUpName + " response matched regex " + patternReplacement.getRegex() + " and was replaced");
                        followUpResponseText = matcher.replaceAll(patternReplacement.getReplacement());
                    }
                }
                this.genAiHelper.setItemGenAiMetadata(item, promptName + "|" + followUpName, followUpResponseText, this.parseJsonOutput);
            }
            catch (IOException e) {
                LOGGER.info("Error handing item " + item.getGuid() + " follow-up prompt " + promptName + " - " + String.valueOf(followUpPrompt[0]), (Throwable)e);
                if (!this.stopRequested) {
                    promptException.set(e);
                }
            }
            finally {
                this.promptsProcessed.incrementAndGet();
            }
        });
    }

    private Future<WrappedResponse> executePrompt(List<GenAiMessage> messages, String name, int level, int batch, Item item, String promptsInBatchCount, boolean storeMetadata, AtomicBoolean itemPromptOutputReplaced) {
        return this.executor.submit(() -> {
            if (this.stopRequested) {
                return null;
            }
            String normalizedResponseText = null;
            GenAiRequest request = new GenAiRequest(item.getGuid() + "-" + name + "-" + level + "-" + batch, messages);
            if (this.jsonEnabled) {
                request.setJsonSchema(this.jsonSchema);
            }
            if (this.temperatureEnabled) {
                request.setTemperature(this.temperature);
            }
            if (this.maxResponseTokensEnabled) {
                request.setMaxResponseTokens(this.maxResponseTokens);
            }
            String role = null;
            try {
                GenAiResponse response = this.genAiHelper.getCompletions(request);
                role = response.getMessage().getRole();
                normalizedResponseText = response.getMessage().getContent();
                if (this.replacePromptOutput) {
                    boolean matched = false;
                    for (PatternReplacement patternReplacement : this.responsePatternReplacements) {
                        Matcher matcher = patternReplacement.getPattern().matcher(normalizedResponseText);
                        if (!matcher.find()) continue;
                        matched = true;
                        LOGGER.info("Item " + item.getGuid() + " " + name + " - Level " + level + ", Batch " + batch + " response matched regex " + patternReplacement.getRegex() + " and was replaced");
                        normalizedResponseText = matcher.replaceAll(patternReplacement.getReplacement());
                    }
                    if (matched) {
                        itemPromptOutputReplaced.set(true);
                    }
                }
                if (storeMetadata) {
                    this.genAiHelper.setItemGenAiMetadata(item, name + "|Level " + level + "|Batch " + batch, normalizedResponseText, this.parseJsonOutput, false);
                }
                LOGGER.info(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Log.Items", new Object[]{name, level, batch, promptsInBatchCount, response.getUsage().getPromptTokens(), response.getUsage().getCompletionTokens()}));
            }
            catch (Exception e) {
                LOGGER.error("Item " + item.getGuid() + " - " + name + " - Level " + level + ", Batch " + batch + " failed", (Throwable)e);
                this.genAiHelper.setItemGenAiMetadata(item, "System|Error", "Level " + level + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
                this.failedItems.add(item);
            }
            finally {
                this.promptsProcessed.incrementAndGet();
            }
            return new WrappedResponse(normalizedResponseText, Collections.singletonList(item), role);
        });
    }

    private void handleItemPromptResponses(int level, Item item, List<String> previousResponses, String name, String batchPrompt, AtomicBoolean itemPromptOutputReplaced) throws IOException, ExecutionException, InterruptedException {
        ArrayList<String> responses = new ArrayList<String>();
        ArrayList<Future<WrappedResponse>> futureResponses = new ArrayList<Future<WrappedResponse>>();
        AtomicInteger estimatedTokenCount = new AtomicInteger(0);
        if (!this.contextPrompt.isEmpty()) {
            estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(this.partContentPrompt));
        }
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(batchPrompt.replace("{answer_text}", "")));
        estimatedTokenCount.addAndGet(this.genAiHelper.estimateTokens(batchPrompt));
        int maxTokens = this.genAiService.getContextWindow() - estimatedTokenCount.get();
        int currentTokenCount = 0;
        int batchId = 0;
        int itemsInPrompt = 0;
        StringBuilder currentPrompt = new StringBuilder();
        boolean storeMetadata = false;
        for (String string : previousResponses) {
            String responsePrompt = this.partContentPrompt;
            responsePrompt = GenAiHelper.evalItemParameters(item, responsePrompt);
            int reponseTokenCount = this.genAiHelper.estimateTokens(responsePrompt = responsePrompt.replace("{answer_text}", string));
            if (currentTokenCount + reponseTokenCount > maxTokens) {
                storeMetadata = this.keepIndividualPartsResponses;
                futureResponses.add(this.getPromptResponse(name, level, ++batchId, item, itemsInPrompt, currentPrompt.toString(), batchPrompt, storeMetadata, itemPromptOutputReplaced));
                currentPrompt = new StringBuilder();
                currentTokenCount = 0;
            }
            ++itemsInPrompt;
            currentPrompt.append(responsePrompt);
            currentTokenCount += reponseTokenCount;
        }
        if (currentPrompt.length() > 0) {
            futureResponses.add(this.getPromptResponse(name, level, ++batchId, item, itemsInPrompt, currentPrompt.toString(), batchPrompt, storeMetadata, itemPromptOutputReplaced));
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " waiting for " + futureResponses.size() + " responses");
        }
        for (Future future : futureResponses) {
            responses.add(((WrappedResponse)future.get()).getContent());
        }
        if (futureResponses.size() > 1) {
            LOGGER.info("Item " + item.getGuid() + "-" + name + " level " + level + " received all " + futureResponses.size() + " responses");
        }
        if (previousResponses.size() == responses.size()) {
            throw new GenAiException(this.iu.getFormattedString("GenAi.Error.PassDidNotReduceBatches", new Object[]{name, level}));
        }
        if (responses.size() == 1) {
            this.genAiHelper.setItemGenAiMetadata(item, name, (String)responses.get(0), this.parseJsonOutput);
        } else {
            int nextLevel = level + 1;
            if (nextLevel > this.maxRecursionPasses) {
                throw new IllegalStateException(this.iu.getFormattedString("GenAiPromptOnDocumentSetOperation.Error.MaxRecursion", new Object[]{name, level}));
            }
            this.handleItemPromptResponses(nextLevel, item, responses, name, batchPrompt, itemPromptOutputReplaced);
        }
    }

    private Future<WrappedResponse> getPromptResponse(String name, int level, int batch, Item item, int itemsInPrompt, String prompt, String batchQuestionPrompt, boolean storeMetadata, AtomicBoolean itemPromptOutputReplaced) throws IOException {
        ArrayList<GenAiMessage> messages = new ArrayList<GenAiMessage>();
        if (!this.contextPrompt.isEmpty()) {
            messages.add(new GenAiMessage("system", this.partContextPrompt));
        }
        messages.add(new GenAiMessage("user", prompt + batchQuestionPrompt));
        return this.executePrompt(messages, name, level, batch, item, String.valueOf(itemsInPrompt), storeMetadata, itemPromptOutputReplaced);
    }

    private void clearMetadata(Item item) {
        for (Object[] prompt : this.prompts) {
            String name = prompt[0].toString();
            GenAiHelper.clearItemGenAiMetadata(item, name);
            if (!this.followUpPromptsEnabled) continue;
            for (Object[] followUpPrompt : this.followUpPrompts) {
                String followUpName = followUpPrompt[0].toString();
                GenAiHelper.clearItemGenAiMetadata(item, name + "|" + followUpName);
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.itemsProcessed.get() / (double)this.effectiveItemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        long completionTokens;
        long promptTokens;
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get());
        }
        if (this.genAiHelper != null && (promptTokens = this.genAiHelper.getPromptTokens()) + (completionTokens = this.genAiHelper.getCompletionTokens()) > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getFormattedString("General.Count.Tokens", new Object[]{promptTokens, completionTokens});
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }
}

