/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="originalFieldsGroup", children={"originalFieldGuid", "originalFieldDocIds"}), @FormFieldGroup(name="domainFieldsGroup", children={"fieldDomainsAll", "fieldDomainsFrom", "fieldDomainsTo", "fieldDomainsCc", "fieldDomainsBcc", "fieldRecipientsCount"}), @FormFieldGroup(name="outputResultsGroup", children={"saveToCsvRow", "resultsOutputCustomMetadata"})})
@FormFieldRow(name="saveToCsvRow", children={"resultsOutputCsv", "resultsCsvPath"})
@OperationMetadata(alias=OperationAlias.GENERATE_DOMAIN_FIELDS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"METADATA"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveCsvFile", parameter="{last_metadata_export_file}"), @OperationParameter(label="lastExportFolder", parameter="{last_export_folder}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class GenerateDomainFieldsOperation
extends Operation {
    @FormField
    public String searchScope = "has-communication:1";
    @FormField
    public String separator = "; ";
    @FormField(min=1.0)
    public int maxFieldsLength = 10000;
    @FormField
    public boolean originalFieldGuid = true;
    @FormField
    public boolean originalFieldDocIds = true;
    @FormField
    public boolean fieldDomainsAll = true;
    @FormField
    public boolean fieldDomainsFrom = true;
    @FormField
    public boolean fieldDomainsTo = true;
    @FormField
    public boolean fieldDomainsCc = true;
    @FormField
    public boolean fieldDomainsBcc = true;
    @FormField
    public boolean fieldRecipientsCount = false;
    @FormField
    public boolean resultsOutputCsv = true;
    @FormField(enableOn={@OnField(name="resultsOutputCsv")})
    public String resultsCsvPath = "{case_folder}/Export/Domain Fields {date_time}.csv";
    @FormField
    public boolean resultsOutputCustomMetadata = false;
    public boolean appendToPreviousMetadata = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("GenerateDomainFieldsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GENERATE_DOMAIN_FIELDS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.resultsOutputCsv && !this.resultsOutputCustomMetadata) {
            prerequisites.add(this.iu.getString("GenerateDomainFieldsOperation.Prerequisites.NoOutputMethodSelected"));
        }
        if (this.resultsOutputCsv && this.resultsCsvPath.trim().length() == 0) {
            prerequisites.add(this.iu.getString("GenerateDomainFieldsOperation.Prerequisites.OutputCSVFileMustBeSpecified"));
        }
        if (this.originalFieldDocIds && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0) {
            prerequisites.add(this.iu.getString("GenerateDomainFieldsOperation.Prerequisites.PleaseUpdateNuixVersion"));
        }
        if (this.maxFieldsLength <= 0) {
            prerequisites.add(this.iu.getString("GenerateDomainFieldsOperation.Prerequisites.MaxFieldsLengthMustBeGreaterThanZero"));
        }
        return prerequisites;
    }
}

