/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.GenerateDuplicateCustodiansFieldOperation;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.FieldsInclusiveness;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ProductionSetItem;
import org.apache.commons.lang3.NotImplementedException;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class GenerateDuplicateCustodiansFieldOperationImplementation
extends GenerateDuplicateCustodiansFieldOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenerateDuplicateCustodiansFieldOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient AtomicLong stageItems = new AtomicLong(0L);
    private transient AtomicLong stageTotalItems = new AtomicLong(0L);
    private transient String effectiveCsvPath;
    private transient BufferedWriter bufferedWriter;

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    @Override
    public void startTriggered() throws Exception {
        this.stageCount = 1;
        this.stageId = 0;
        this.executionContext.closeAllTabs();
        this.stageItems.set(0L);
        LOGGER.info("Unpacking path: " + this.resultsCsvPath);
        this.effectiveCsvPath = this.executionContext.evalParameters(this.resultsCsvPath, this);
        File outputFile = new File(this.effectiveCsvPath);
        try {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            this.bufferedWriter.write("\ufeff");
            this.effectiveCsvPath = outputFile.getAbsolutePath();
        }
        catch (IOException e1) {
            LOGGER.error("Cannot create file at default location.", (Throwable)e1);
            this.exception = e1;
            this.executionState = ExecutionState.ERROR;
            return;
        }
        if (this.originalFieldDocIds) {
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateCustodiansFieldOperation.CSVHeader.ItemDocID")));
            this.bufferedWriter.write(",");
        }
        this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateCustodiansFieldOperation.CSVHeader.ItemGUID")));
        this.bufferedWriter.write(",");
        if (this.fieldsInclusiveness == FieldsInclusiveness.ALTERNATE) {
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateCustodiansFieldOperation.CSVHeader.AlternateCustodians")));
        } else if (this.fieldsInclusiveness == FieldsInclusiveness.ALL) {
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateCustodiansFieldOperation.CSVHeader.AllCustodians")));
        } else {
            throw new NotImplementedException(this.iu.getFormattedString("GenerateDuplicateCustodiansFieldOperation.Exception.UnexpectedOption", (Object)this.fieldsInclusiveness));
        }
        this.bufferedWriter.write("\n");
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("GenerateDuplicateCustodiansFieldOperation.Stage.GettingItemsCount");
                String query = "has-production-set:1";
                this.stageTotalItems.set(this.executionContext.nuixCase.count(query));
                query = "has-production-set:1 flag:top_level";
                Set items = this.executionContext.nuixCase.searchUnsorted(query);
                LOGGER.info("Searching for (" + query + ") produced " + FormattingUtils.itemsCountToDisplay((long)items.size()));
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateCustodiansFieldOperation.Log.UpdateItemsCount", this.stageTotalItems.get()));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateCustodiansFieldOperation.Log.Inclusiveness", (Object)this.fieldsInclusiveness));
                this.stageName = this.iu.getString("GenerateDuplicateCustodiansFieldOperation.Stage.OutputtingField");
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    while (iterator.hasNext()) {
                        Item item = (Item)iterator.next();
                        try {
                            BufferedWriter bufferedWriter;
                            String custodian;
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            TreeSet<String> alternateCustodians = new TreeSet<String>();
                            for (Item duplicateItem : item.getDuplicates()) {
                                String custodian2;
                                if (!duplicateItem.isTopLevel() || (custodian2 = duplicateItem.getCustodian()) == null) continue;
                                alternateCustodians.add(custodian2);
                            }
                            if (this.fieldsInclusiveness != FieldsInclusiveness.ALL) {
                                custodian = item.getCustodian();
                                if (custodian != null) {
                                    alternateCustodians.remove(item.getCustodian());
                                }
                            } else {
                                custodian = item.getCustodian();
                                if (custodian != null) {
                                    alternateCustodians.add(item.getCustodian());
                                }
                            }
                            String output = FormattingUtils.encodeForCsv((String)String.join((CharSequence)this.separator, alternateCustodians));
                            List familyItems = item.getFamily();
                            if (this.originalFieldDocIds) {
                                bufferedWriter = this.bufferedWriter;
                                synchronized (bufferedWriter) {
                                    for (Item familyItem : familyItems) {
                                        if (!familyItem.isAudited() || familyItem.isExcluded()) continue;
                                        this.stageItems.incrementAndGet();
                                        try {
                                            HashSet<String> docIds = new HashSet<String>();
                                            for (ProductionSetItem productionSetItem : familyItem.getProductionSetItems()) {
                                                docIds.add(productionSetItem.getDocumentNumber().toString());
                                            }
                                            for (String docId : docIds) {
                                                this.bufferedWriter.write(docId);
                                                this.bufferedWriter.write(",");
                                                this.bufferedWriter.write(familyItem.getGuid());
                                                this.bufferedWriter.write(",");
                                                this.bufferedWriter.write(output);
                                                this.bufferedWriter.write("\n");
                                            }
                                        }
                                        catch (IOException e1) {
                                            LOGGER.error("Cannot write to file", (Throwable)e1);
                                            this.setErrorMessage(e1.getLocalizedMessage());
                                            this.exception = e1;
                                            this.executionState = ExecutionState.ERROR;
                                            return;
                                        }
                                    }
                                    continue;
                                }
                            }
                            bufferedWriter = this.bufferedWriter;
                            synchronized (bufferedWriter) {
                                for (Item familyItem : familyItems) {
                                    if (!familyItem.isAudited() || familyItem.isExcluded()) continue;
                                    this.stageItems.incrementAndGet();
                                    try {
                                        this.bufferedWriter.write(familyItem.getGuid());
                                        this.bufferedWriter.write(",");
                                        this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)String.join((CharSequence)this.separator, alternateCustodians)));
                                        this.bufferedWriter.write("\n");
                                    }
                                    catch (IOException e1) {
                                        LOGGER.error("Cannot write to file", (Throwable)e1);
                                        this.setErrorMessage(e1.getLocalizedMessage());
                                        this.exception = e1;
                                        this.executionState = ExecutionState.ERROR;
                                        return;
                                    }
                                }
                            }
                        }
                        catch (Throwable e2) {
                            LOGGER.error("Cannot process item " + item.getGuid(), e2);
                            this.setErrorMessage(e2.getLocalizedMessage());
                            this.exception = e2;
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.stageTotalItems.get() != this.stageItems.get()) {
                    this.addWarning(this.iu.getNumeralFormattedString("GenerateDuplicateCustodiansFieldOperation.Warning.ProductionSetsContains", this.stageTotalItems.get(), (Object)this.iu.getNumeralString("GenerateDuplicateCustodiansFieldOperation.Warning.ProcessedStageItems", this.stageItems.get())));
                }
                LOGGER.info("Done, wrote " + this.stageItems.get() + " lines");
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_metadata_export_file}", this.effectiveCsvPath)));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateCustodiansFieldOperation.Log.OutputCSV", (Object)this.effectiveCsvPath));
                this.bufferedWriter.close();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        ItemsUtils.stopBackgroundTask();
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.stageTotalItems.get() != 0L) {
            stageProgress = (double)this.stageItems.get() / (double)this.stageTotalItems.get();
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("GenerateDuplicateCustodiansFieldOperation.Progress.ItemsProcessed", this.stageItems.get());
        }
        return result;
    }
}

