/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.GraphPromoteOperation;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphUtils;
import com.nuix.graph.playbook.GraphEngine;
import com.nuix.graph.playbook.Settings;
import com.nuix.graph.playbook.engine.EngineStats;
import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.engine.ProcessingCallback;
import com.nuix.graph.playbook.engine.entities.SourceNode;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;

public class GraphPromoteOperationImplementation
extends GraphPromoteOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GraphPromoteOperationImplementation.class);
    private transient long itemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient AtomicLong uniqueNodes;
    private transient AtomicLong uniqueEdges;
    private transient AtomicLong itemsWithErrors;
    private transient GraphEngine graphEngine;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        String playbookFile = this.executionContext.evalParameters("{wfn_memgraph_playbook_file}", this);
        int transactionSize = this.executionContext.evalIntParameter("{wfn_memgraph_transaction_size}", this);
        this.itemsProcessed = new AtomicLong(0L);
        this.itemsWithErrors = new AtomicLong(0L);
        this.uniqueNodes = new AtomicLong(0L);
        this.uniqueEdges = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("Operation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                List scopeItems = null;
                if (this.promoteItems) {
                    scopeItems = this.executionContext.nuixCase.search(this.scope);
                    this.itemsInScope = scopeItems.size();
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)scopeItems.size()));
                }
                String url = this.executionContext.evalProtectedParameter("{wfn_memgraph_url}");
                String username = "";
                String password = "";
                try {
                    username = this.executionContext.evalParametersIfSet("{wfn_memgraph_username}", this);
                    password = this.executionContext.evalParametersIfSet("{wfn_memgraph_password}", this);
                }
                catch (ParameterException parameterException) {
                    // empty catch block
                }
                MemgraphUtils memgraphUtils = new MemgraphUtils(this.executionContext, this);
                try {
                    this.stageName = this.iu.getString("Operation.Stage.Synchronizing");
                    Integer memgraphJobsInFront = memgraphUtils.getLock();
                    if (memgraphJobsInFront.equals(-1)) {
                        this.addExecutionLog(this.iu.getString("GraphPromoteOperation.Log.WaitingOnJobs"));
                    } else if (!memgraphJobsInFront.equals(0)) {
                        this.addExecutionLog(this.iu.getNumeralFormattedString("GraphPromoteOperation.Log.WaitingOnJobs", (long)memgraphJobsInFront.intValue(), new Object[0]));
                    }
                    while (!memgraphJobsInFront.equals(0)) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Thread.sleep(5000L);
                        memgraphJobsInFront = memgraphUtils.getLock();
                    }
                    this.stageName = this.iu.getString("Operation.Stage.ExportingItems");
                    try {
                        Settings.SettingsBuilder builder = Settings.builder().transactionSize(transactionSize);
                        builder = this.setSettings(builder);
                        Settings settings = builder.build();
                        this.graphEngine = GraphEngine.load((String)url, (String)username, (String)password, (String)playbookFile, (Settings)settings);
                        Thread statsThread = new Thread(() -> {
                            try {
                                int statsCount = 0;
                                while (true) {
                                    if (this.graphEngine == null) {
                                        LOGGER.info("Exiting stats thread");
                                        return;
                                    }
                                    if (this.stopRequested) {
                                        this.graphEngine.abort();
                                    }
                                    Thread.sleep(1000L);
                                    EngineStats engineStats = this.graphEngine.getEngineStats();
                                    if (++statsCount % 60 != 0) continue;
                                    LOGGER.info(engineStats.toString());
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }, "Memgraph Engine Stats");
                        statsThread.setDaemon(true);
                        statsThread.start();
                        ProcessingCallback processingCallback = new ProcessingCallback(){

                            public void afterItemProcessed(Item item, ExecutionContext context, List<SourceNode> sourceNodes) {
                                GraphPromoteOperationImplementation.this.itemsProcessed.incrementAndGet();
                            }

                            public void itemException(Item item, ExecutionContext context, Exception exception) {
                                GraphPromoteOperationImplementation.this.itemsWithErrors.incrementAndGet();
                            }
                        };
                        if (this.promoteItems && !this.stopRequested) {
                            this.addExecutionLog(this.iu.getString("GraphPromoteOperation.Log.ExportingItems"));
                            this.graphEngine.process(this.executionContext.nuixCase, scopeItems, processingCallback);
                        }
                        if (this.promoteCase && !this.stopRequested) {
                            this.addExecutionLog(this.iu.getString("GraphPromoteOperation.Log.ExportingCase"));
                            this.graphEngine.process(this.executionContext.nuixCase, processingCallback);
                        }
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                    }
                    finally {
                        if (this.graphEngine != null) {
                            EngineStats engineStats = this.graphEngine.getEngineStats();
                            this.uniqueNodes.set(engineStats.getTotalNodes());
                            this.uniqueEdges.set(engineStats.getTotalEdges());
                            try {
                                this.graphEngine.close();
                                this.graphEngine = null;
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot close GraphEngine", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    memgraphUtils.releaseLock();
                }
                this.printCounts();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private Settings.SettingsBuilder setSettings(Settings.SettingsBuilder builder) {
        Integer heartbeatCallbackRate;
        Boolean disableContextCache;
        Integer rulesWarningThreshold;
        Integer ruleWarningThreshold;
        Integer expressionWarningThreshold;
        Integer committedOperationsCacheSize;
        Integer rulesExecutionTimeout;
        Integer incomingQueueSize;
        Integer transactionSize;
        Integer loaderQueueSize;
        Integer producerThreads = this.getPropertyInt("producerThreads");
        if (producerThreads != null) {
            LOGGER.info("Setting producerThreads: " + producerThreads);
            builder = builder.producerThreads(producerThreads.intValue());
        }
        if ((loaderQueueSize = this.getPropertyInt("loaderQueueSize")) != null) {
            LOGGER.info("Setting loaderQueueSize: " + loaderQueueSize);
            builder = builder.loaderQueueSize(loaderQueueSize.intValue());
        }
        if ((transactionSize = this.getPropertyInt("transactionSize")) != null) {
            LOGGER.info("Setting transactionSize: " + transactionSize);
            builder = builder.transactionSize(transactionSize.intValue());
        }
        if ((incomingQueueSize = this.getPropertyInt("incomingQueueSize")) != null) {
            LOGGER.info("Setting incomingQueueSize: " + incomingQueueSize);
            builder = builder.incomingQueueSize(incomingQueueSize.intValue());
        }
        if ((rulesExecutionTimeout = this.getPropertyInt("rulesExecutionTimeout")) != null) {
            LOGGER.info("Setting rulesExecutionTimeout: " + rulesExecutionTimeout);
            builder = builder.rulesExecutionTimeout(rulesExecutionTimeout.intValue());
        }
        if ((committedOperationsCacheSize = this.getPropertyInt("committedOperationsCacheSize")) != null) {
            LOGGER.info("Setting committedOperationsCacheSize: " + committedOperationsCacheSize);
            builder = builder.committedOperationsCacheSize(committedOperationsCacheSize.intValue());
        }
        if ((expressionWarningThreshold = this.getPropertyInt("expressionWarningThreshold")) != null) {
            LOGGER.info("Setting expressionWarningThreshold: " + expressionWarningThreshold);
            builder = builder.expressionWarningThreshold(expressionWarningThreshold.intValue());
        }
        if ((ruleWarningThreshold = this.getPropertyInt("ruleWarningThreshold")) != null) {
            LOGGER.info("Setting ruleWarningThreshold: " + ruleWarningThreshold);
            builder = builder.ruleWarningThreshold(ruleWarningThreshold.intValue());
        }
        if ((rulesWarningThreshold = this.getPropertyInt("rulesWarningThreshold")) != null) {
            LOGGER.info("Setting rulesWarningThreshold: " + rulesWarningThreshold);
            builder = builder.rulesWarningThreshold(rulesWarningThreshold.intValue());
        }
        if ((disableContextCache = this.getPropertyBoolean("disableContextCache")) != null) {
            LOGGER.info("Setting disableContextCache: " + disableContextCache);
            builder = builder.disableContextCache(disableContextCache.booleanValue());
        }
        if ((heartbeatCallbackRate = this.getPropertyInt("heartbeatCallbackRate")) != null) {
            LOGGER.info("Setting heartbeatCallbackRate: " + heartbeatCallbackRate);
            builder = builder.heartbeatCallbackRate(heartbeatCallbackRate.intValue());
        }
        return builder;
    }

    private Integer getPropertyInt(String name) {
        String value = System.getProperty("graphEngine." + name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    private Boolean getPropertyBoolean(String name) {
        String value = System.getProperty("graphEngine." + name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private void printCounts() {
        this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ExportedCount", this.itemsProcessed.get()));
        if (this.itemsWithErrors.get() > 0L) {
            this.addWarning(this.iu.getNumeralString("GraphPromoteOperation.Warning.ExportError", this.itemsWithErrors.get()));
        }
        this.addExecutionLog(this.iu.getFormattedString("GraphOperation.Log.UniqueNodes", (Object)this.uniqueNodes.get()));
        this.addExecutionLog(this.iu.getFormattedString("GraphOperation.Log.UniqueEdges", (Object)this.uniqueEdges.get()));
        if (this.uniqueNodes.get() == 0L) {
            this.addWarning(this.iu.getString("GraphOperation.Warning.NoNodes"));
        }
    }

    private long getItemsInQueue() {
        if (this.graphEngine != null) {
            EngineStats stats = this.graphEngine.getEngineStats();
            return stats.getMemgraphQueueSize();
        }
        return 0L;
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)(this.itemsProcessed.get() - this.getItemsInQueue() + this.itemsWithErrors.get()) / (double)this.itemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get() - this.getItemsInQueue());
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }
}

