/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ListRelativityDocumentsOperation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class ListRelativityDocumentsOperationImplementation
extends ListRelativityDocumentsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ListRelativityDocumentsOperation.class);
    private transient String stageName;
    private transient String relativityWorkspaceId;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countItemsMatched;
    private transient long countItemsToProcess;
    private transient int stageCount;
    private transient int stageId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getWorkspaceDocuments(String workspaceArtifactIdString) throws IOException {
        Long workspaceArtifactId = Long.parseLong(workspaceArtifactIdString);
        Set<String> docIds = null;
        File file = null;
        try (Writer writer = null;){
            file = new File(this.exportLocation);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(this.exportLocation, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
            docIds = this.relativityRestClient.getWorkspaceDocumentIds(workspaceArtifactId);
            this.countItemsToProcess = docIds.size();
            this.addExecutionLog(this.iu.getNumeralString("ListRelativityDocumentsOperation.Log.DiscoveredDocuments", this.countItemsToProcess));
            for (String docId : docIds) {
                this.countItemsProcessed.incrementAndGet();
                writer.write(docId);
                writer.write("\r\n");
            }
            writer.flush();
            writer.close();
            this.addExecutionLog(this.iu.getNumeralFormattedString("ListRelativityDocumentsOperation.Log.WroteDocID", (long)docIds.size(), (Object)file.getAbsolutePath()));
        }
        return docIds;
    }

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(true);
                this.assertRelativityInstanceLicensed();
                this.stageName = "";
                this.stageId = 0;
                this.stageCount = 1;
                this.countItemsProcessed = new AtomicLong(0L);
                this.countItemsToProcess = 0L;
                this.exportLocation = this.executionContext.evalParameters(this.exportLocation, this);
                if (!FileUtils.isPathAbsolute((String)this.exportLocation)) {
                    String errorMsg = this.iu.getFormattedString("ListRelativityDocumentsOperationImplementation.Exception.ExportPathRelative", (Object)this.exportLocation);
                    LOGGER.error("Export file can't be a relative path");
                    this.exception = new Exception(errorMsg);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
                this.stageName = this.iu.getString("ListRelativityDocumentsOperation.Stage.QueryingDocuments");
                Set<String> docIds = this.getWorkspaceDocuments(this.relativityWorkspaceId);
                this.countItemsProcessed = new AtomicLong(0L);
                this.countItemsMatched = new AtomicLong(0L);
                ++this.stageId;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("ListRelativityDocumentsOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

