/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.MARKDOWN_REPORT, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE", "GEN_AI"}), @OperationTag(name="Category", value={"REPORTING"})})
@OperationLicenseModule(module=ModuleType.GEN_AI_EXPERIMENTAL)
@FormFieldRows(value={@FormFieldRow(name="tagAnalyzedItemsRow", children={"tagAnalyzedItems", "analyzedItemsTagName", "untagUnanalyzedItems"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"})})
public class MarkdownReportOperation
extends Operation {
    @FormField(allowedValues={"TEXT", "CUSTOM_METADATA", "CUSTOM_TEXT"})
    public SourceTextLocation contentLocation = SourceTextLocation.CUSTOM_TEXT;
    @FormField(visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA"})})
    public String metadataFieldName;
    @FormField(required=false, visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    public String scope;
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguage="markdown", visibleOn={@OnField(name="contentLocation", value={"CUSTOM_TEXT"})})
    public String content = "# Case {case_name} Report\n\n## Introduction\nThis report describes ...\n\n## Analysis of Provided Content\nThe data analyzed does contains ...\n\n## Conclusion\nIn conclusion, based on the data analyzed document, ...";
    @FormField(required=false)
    public String customReportTemplatePath;
    @FormField
    public String reportLocation = "{case_folder}/Reports/{case_name} - Custom Report {date_time}.docx";
    @FormField(visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public boolean tagAnalyzedItems = true;
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")}, visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public String analyzedItemsTagName = "Automate|Analyzed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")}, visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public boolean untagUnanalyzedItems = true;
    @FormField(visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")}, visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagFailedItems")}, visibleOn={@OnField(name="contentLocation", value={"CUSTOM_METADATA", "TEXT"})})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;

    public boolean getDisplayMetadataFieldName() {
        return this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA);
    }

    public boolean getDisplayScope() {
        return this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_METADATA) || this.contentLocation.equals((Object)SourceTextLocation.TEXT);
    }

    public MarkdownReportOperation() {
        this.requiresCase = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("MarkdownReportOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.reportLocation.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ProcessingReportOperation.Prerequisites.ReportLocationMustBeSpecified"));
        }
        return prerequisites;
    }
}

