/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.LoadOptions;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.MarkdownReportOperation;
import com.nuix.automate.workflow.core.execution.options.genai.SourceTextLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class MarkdownReportOperationImplementation
extends MarkdownReportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MarkdownReportOperation.class);
    private Document template;
    private transient long itemsInScope;
    private transient String stageName;
    private transient AtomicLong itemsProcessed;
    private transient Set<Item> failedItems;
    private transient Set<Item> processedItems;
    private transient Set<Item> scopeItems;
    private transient Set<Item> scopeTaggedItems;
    private transient BulkAnnotater bulkAnnotater;
    private transient String tempTag;
    private transient GenAiHelper genAiHelper;

    @Override
    public void startTriggered() {
        block12: {
            try {
                this.content = this.executionContext.evalParameters(this.content, this);
                this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
                this.metadataFieldName = this.executionContext.evalParameters(this.metadataFieldName, this);
                File reportFile = new File(this.reportLocation);
                this.reportLocation = reportFile.getAbsolutePath();
                File reportFolder = reportFile.getParentFile();
                if (!reportFolder.exists()) {
                    reportFolder.mkdirs();
                }
                AsposeUtils.applyAsposeWordsLicense();
                if (this.customReportTemplatePath != null) {
                    this.customReportTemplatePath = this.executionContext.evalParameters(this.customReportTemplatePath, this);
                }
                this.genAiHelper = new GenAiHelper();
                this.failedItems = ConcurrentHashMap.newKeySet();
                this.processedItems = ConcurrentHashMap.newKeySet();
                this.itemsProcessed = new AtomicLong(0L);
                this.tempTag = "Automate|System|Run|GenAI|" + String.valueOf(UUID.randomUUID());
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                if (this.customReportTemplatePath.length() > 0) {
                    File templateFile = new File(this.customReportTemplatePath);
                    if (!templateFile.exists()) {
                        LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
                        this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CouldNotFindReportTemplateFile", (Object)templateFile.getAbsolutePath()));
                    } else {
                        this.template = new Document(this.customReportTemplatePath);
                    }
                }
                if (this.contentLocation.equals((Object)SourceTextLocation.CUSTOM_TEXT)) {
                    this.generateReport(this.content, this.reportLocation);
                    this.addExecutionLog(this.iu.getFormattedString("ProcessingReportOperation.Log.ReportLocation", (Object)this.reportLocation));
                    break block12;
                }
                this.scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.itemsInScope = this.scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", (long)this.scopeItems.size()));
                if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
                    String scopeQuery = NuixUtils.addAndQuery(this.scope, "tag:\"" + this.analyzedItemsTagName.replace("\"", "\\\"") + "\"");
                    this.scopeTaggedItems = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                }
                if (this.tagFailedItems && this.untagSuccessfulItems && this.scopeItems.size() > 0) {
                    LOGGER.info("Tagging " + this.scopeItems.size() + " items with tag " + this.tempTag);
                    try {
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.scopeItems);
                    }
                    catch (IOException e) {
                        LOGGER.info("Cannot tag items", (Throwable)e);
                    }
                }
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(this.scopeItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    while (iterator.hasNext()) {
                        String content;
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Item item = (Item)iterator.next();
                        GenAiHelper.clearItemGenAiMetadata(item, "System|Error");
                        GenAiHelper.clearItemGenAiMetadata(item, "System|Warning");
                        switch (this.contentLocation) {
                            case CUSTOM_METADATA: {
                                content = String.valueOf(item.getCustomMetadata().get((Object)this.metadataFieldName));
                                break;
                            }
                            case TEXT: {
                                if (item.getTextObject().isAvailable()) {
                                    content = item.getTextObject().toString();
                                    break;
                                }
                                content = "";
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected content location: " + String.valueOf((Object)this.contentLocation));
                            }
                        }
                        try {
                            String effectiveLocation = this.reportLocation;
                            effectiveLocation = GenAiHelper.evalItemParameters(item, effectiveLocation);
                            this.generateReport(content, effectiveLocation);
                        }
                        catch (Exception e) {
                            this.genAiHelper.setItemGenAiMetadata(item, "System|Error", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                            Set<Item> set = this.failedItems;
                            synchronized (set) {
                                this.failedItems.add(item);
                            }
                            LOGGER.error("Cannot handle item " + item.getGuid(), (Throwable)e);
                        }
                        this.itemsProcessed.incrementAndGet();
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                this.tagItems();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        }
        this.trackFinished();
    }

    private void tagItems() throws IOException {
        if (this.tagAnalyzedItems && this.untagUnanalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            HashSet<Item> itemsToUnTag = new HashSet<Item>();
            itemsToUnTag.addAll(this.scopeTaggedItems);
            itemsToUnTag.removeAll(this.processedItems);
            LOGGER.info("Untagging " + itemsToUnTag.size() + " with " + this.analyzedItemsTagName);
            if (itemsToUnTag.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUnTag.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.removeTag(this.analyzedItemsTagName, itemsToUnTag);
            }
        }
        if (this.tagAnalyzedItems) {
            this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
            LOGGER.info("Tagging " + this.processedItems.size() + " with " + this.analyzedItemsTagName);
            if (this.processedItems.size() > 0) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.processedItems.size(), (Object)this.analyzedItemsTagName));
                this.bulkAnnotater.addTag(this.analyzedItemsTagName, this.processedItems);
            }
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    private void generateReport(String text, String reportLocation) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        LoadOptions loadOptions = new LoadOptions();
        loadOptions.setLoadFormat(63);
        Document markdownDocument = new Document((InputStream)inputStream, loadOptions);
        if (this.template != null) {
            DocumentBuilder builder = new DocumentBuilder(this.template);
            builder.moveToDocumentEnd();
            builder.insertDocument(markdownDocument, 0);
            markdownDocument = builder.getDocument();
            markdownDocument.updateFields();
        }
        markdownDocument.save(reportLocation);
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L || this.itemsProcessed == null) {
            return 1.0E-4;
        }
        double result = (double)this.itemsProcessed.get() / (double)this.itemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.itemsProcessed.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.itemsProcessed.get());
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName + "...";
        }
        return result;
    }
}

