/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.matchitems.MatchScope;
import java.util.List;

@FormFieldGroup(name="matchItemsByGroup", children={"matchItemsByMD5", "matchItemsByGUID", "matchItemsByDocID"}, styled=false, positionLabel=@PositionLabel(left="matchItemsBy"))
@OperationMetadata(alias=OperationAlias.MATCH, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"TAG"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class MatchItemsOperation
extends Operation {
    @FormField(required=false)
    public String scope = "";
    @FormField
    public boolean matchItemsByMD5 = true;
    @FormField
    public boolean matchItemsByGUID = true;
    @FormField
    public boolean matchItemsByDocID = true;
    @FormField
    public String sourceTextFile = "";
    @FormField
    public boolean fileHasHeader = false;
    @FormField
    public MatchScope tagScope = MatchScope.MATCHES;
    @FormField
    public String tag = "Items of Interest";

    @Override
    public String getOperationName() {
        return this.iu.getString("MatchItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.MATCH;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!(this.matchItemsByMD5 || this.matchItemsByGUID || this.matchItemsByDocID)) {
            prerequisites.add(this.iu.getString("MatchItemsOperation.Prerequisites.AtLeastOneMatchMustBeSelected"));
        }
        if (this.matchItemsByDocID && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0) {
            prerequisites.add(this.iu.getString("MatchItemsOperation.Prerequisites.UpdateToNuixVersion"));
        }
        if (this.sourceTextFile.trim().length() == 0) {
            prerequisites.add(this.iu.getString("MatchItemsOperation.Prerequisites.SourceFileMustBeSpecified"));
        }
        if (this.tag.trim().length() == 0) {
            prerequisites.add(this.iu.getString("MatchItemsOperation.Prerequisites.TagCannotBeBlank"));
        }
        return prerequisites;
    }
}

