/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.ItemExportCallback;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.Item;
import nuix.MetadataItem;

public class MetadataExportConsumerGenerator
implements Runnable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportConsumerGenerator.class);
    ConcurrentHashMap<String, String> itemsMetadataRepresentation;
    private BlockingDeque<Item> items;
    private List<MetadataItem> metadata;
    private AtomicInteger itemsGeneratedMetadata;
    private boolean doneProducing = false;
    private int maxGeneratedSize;
    private boolean stopRequested = false;
    private boolean isConcordanceExport = false;
    private Set<String> rubyFieldNames;
    private ItemExportCallback callback;

    public MetadataExportConsumerGenerator(BlockingDeque<Item> items, ConcurrentHashMap<String, String> itemsMetadataRepresentation, List<MetadataItem> metadata, AtomicInteger itemsGeneratedMetadata, int maxGeneratedSize, boolean isConcordanceExport, Set<String> rubyFieldNames, ItemExportCallback callback) {
        this.items = items;
        this.itemsMetadataRepresentation = itemsMetadataRepresentation;
        this.metadata = metadata;
        this.itemsGeneratedMetadata = itemsGeneratedMetadata;
        this.maxGeneratedSize = maxGeneratedSize;
        this.isConcordanceExport = isConcordanceExport;
        this.rubyFieldNames = rubyFieldNames;
        this.callback = callback;
    }

    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        LOGGER.info("Starting consumer");
        try {
            while (!this.doneProducing || this.items.size() > 0) {
                Item item = this.items.poll(1L, TimeUnit.SECONDS);
                if (this.stopRequested) {
                    return;
                }
                if (item != null) {
                    if (this.isConcordanceExport) {
                        this.consumeToConcordance(item);
                    } else {
                        this.consume(item);
                    }
                }
                while (this.itemsMetadataRepresentation.size() > this.maxGeneratedSize) {
                    if (this.stopRequested) {
                        return;
                    }
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedIOException ex) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)ex);
            return;
        }
        catch (IOException e) {
            LOGGER.error("Error writing metadata", (Throwable)e);
            return;
        }
        catch (InterruptedException ex) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)ex);
            return;
        }
        LOGGER.info("Exiting metadata export thread");
    }

    public void setDoneProducing() {
        this.doneProducing = true;
    }

    void consume(Item item) throws IOException {
        StringBuilder itemMetadataRepresentation = new StringBuilder();
        boolean firstItem = true;
        for (MetadataItem metadataItem : this.metadata) {
            String metadataItemRepresentation = null;
            try {
                metadataItemRepresentation = MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
            }
            catch (Exception e) {
                metadataItemRepresentation = e.getMessage();
            }
            if (firstItem) {
                firstItem = false;
            } else {
                itemMetadataRepresentation.append(",");
            }
            itemMetadataRepresentation.append(FormattingUtils.encodeForCsv((String)metadataItemRepresentation));
        }
        itemMetadataRepresentation.append("\r\n");
        this.itemsMetadataRepresentation.put(item.getGuid(), itemMetadataRepresentation.toString());
        this.itemsGeneratedMetadata.incrementAndGet();
        this.callback.onItemProcessed(item, false);
    }

    void consumeToConcordance(Item item) {
        String[] metadataItemRepresentations = (String[])this.metadata.stream().map(metadataItem -> {
            try {
                return MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }).toArray(String[]::new);
        String concordanceRow = FormattingUtils.encodeConcordanceRow((String[])metadataItemRepresentations) + "\r\n";
        this.itemsMetadataRepresentation.put(item.getGuid(), concordanceRow);
        this.itemsGeneratedMetadata.incrementAndGet();
        this.callback.onItemProcessed(item, false);
    }
}

