/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.ItemExportCallback;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.Item;
import nuix.MetadataItem;

public class MetadataExportConsumerWriter
implements Runnable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportConsumerWriter.class);
    private BlockingDeque<Item> items;
    private Writer writer;
    private List<MetadataItem> metadata;
    private AtomicInteger itemsGeneratedMetadata;
    private boolean doneProducing = false;
    private boolean stopRequested = false;
    private boolean isConcordanceExport = false;
    private Set<String> rubyFieldNames;
    private ItemExportCallback callback;

    public MetadataExportConsumerWriter(BlockingDeque<Item> items, Writer writer, List<MetadataItem> metadata, AtomicInteger itemsGeneratedMetadata, boolean isConcordanceExport, Set<String> rubyFieldNames, ItemExportCallback callback) {
        this.items = items;
        this.writer = writer;
        this.metadata = metadata;
        this.itemsGeneratedMetadata = itemsGeneratedMetadata;
        this.isConcordanceExport = isConcordanceExport;
        this.rubyFieldNames = rubyFieldNames;
        this.callback = callback;
    }

    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        LOGGER.info("Starting consumer");
        try {
            while (!this.doneProducing || this.items.size() > 0) {
                Item item = this.items.poll(1L, TimeUnit.SECONDS);
                if (this.stopRequested) {
                    return;
                }
                if (item == null) continue;
                if (this.isConcordanceExport) {
                    this.consumeToConcordance(item);
                    continue;
                }
                this.consume(item);
            }
        }
        catch (InterruptedIOException ex) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)ex);
            return;
        }
        catch (IOException e) {
            LOGGER.error("Error writing metadata", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)e);
            return;
        }
        LOGGER.info("Exiting metadata export thread");
    }

    public void setDoneProducing() {
        this.doneProducing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consume(Item item) throws IOException {
        StringBuilder itemMetadataRepresentation = new StringBuilder();
        boolean firstItem = true;
        for (MetadataItem metadataItem : this.metadata) {
            String metadataItemRepresentation = null;
            try {
                metadataItemRepresentation = MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
            }
            catch (Exception e) {
                metadataItemRepresentation = e.getMessage();
            }
            if (firstItem) {
                firstItem = false;
            } else {
                itemMetadataRepresentation.append(",");
            }
            itemMetadataRepresentation.append(FormattingUtils.encodeForCsv((String)metadataItemRepresentation));
        }
        itemMetadataRepresentation.append("\r\n");
        Writer writer = this.writer;
        synchronized (writer) {
            this.writer.write(itemMetadataRepresentation.toString());
        }
        this.itemsGeneratedMetadata.incrementAndGet();
        this.callback.onItemProcessed(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeToConcordance(Item item) throws IOException {
        String[] metadataItemRepresentations = (String[])this.metadata.stream().map(metadataItem -> {
            try {
                return MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }).toArray(String[]::new);
        String concordanceRow = FormattingUtils.encodeConcordanceRow((String[])metadataItemRepresentations) + "\r\n";
        Writer writer = this.writer;
        synchronized (writer) {
            this.writer.write(concordanceRow);
        }
        this.itemsGeneratedMetadata.incrementAndGet();
        this.callback.onItemProcessed(item, false);
    }
}

