/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportConsumerGenerator;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportConsumerWriter;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportProducer;
import com.nuix.automate.workflow.core.execution.options.sorting.SortOrder;
import com.nuix.automate.workflow.core.utils.ItemExportCallback;
import com.nuix.automate.workflow.core.utils.general.ItemSortablePathNameExpression;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.Item;
import nuix.ItemExpression;
import nuix.MetadataItem;
import nuix.MetadataProfile;

public class MetadataExportOperationImplementation
extends MetadataExportOperation
implements ItemExportCallback {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportOperationImplementation.class);
    private transient long itemsInScope;
    private transient AtomicInteger itemsGeneratedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsExportedMetadata = new AtomicInteger();
    private transient List<Thread> runningThreads;
    private transient Set<String> rubyFieldNames;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exportLocation = this.executionContext.evalParameters(this.exportLocation, this);
        this.itemsGeneratedMetadata = new AtomicInteger(0);
        this.itemsExportedMetadata = new AtomicInteger(0);
        String metadataProfileParameterName = "{metadata_profile}";
        String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
        if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.metadataProfile = this.executionContext.evalParameters(this.metadataProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.metadataProfile = this.executionContext.evalParameters(this.metadataProfile, this);
            this.addExecutionLog(this.iu.getFormattedString("LegalExportOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
        if (mp == null) {
            this.exception = new Exception(this.iu.getFormattedString("MetadataExportOperation.Warning.CannotFindMetadataProfile", (Object)this.metadataProfile));
            this.executionState = ExecutionState.ERROR;
            return;
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                this.rubyFieldNames = new TreeSet<String>();
                for (MetadataItem metadataItem : mp.getMetadata()) {
                    if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                    this.rubyFieldNames.add(metadataItem.getName());
                    LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                }
                if (this.rubyFieldNames.size() > 0) {
                    this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                }
                List items = null;
                try {
                    this.executionContext.closeAllTabs();
                    HashMap<String, String> searchOptions = new HashMap<String, String>();
                    LOGGER.info("Searching for " + NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.ScopeQuery", (Object)this.scope));
                    if (this.sortOrder == SortOrder.TOP_LEVEL_ITEM_DATE) {
                        searchOptions.put("order", "top-level-item-date ASC,top-level-guid ASC");
                        items = this.executionContext.nuixCase.search(this.scope, searchOptions);
                    } else if (this.sortOrder == SortOrder.TOP_LEVEL_ITEMS_DESCENDING) {
                        searchOptions.put("order", "top-level-item-date DESC,top-level-guid ASC");
                        items = this.executionContext.nuixCase.search(this.scope, searchOptions);
                    } else {
                        items = this.executionContext.nuixCase.search(this.scope);
                    }
                    if (this.sortOrder == SortOrder.POSITION) {
                        LOGGER.info("Sorting items");
                        items = this.executionContext.versionGreaterOrEqualTo("8.0.0") ? this.executionContext.nuixUtilities.getItemUtility().sortItems((Collection)items, (ItemExpression)new ItemSortablePathNameExpression()) : this.executionContext.nuixUtilities.getItemSorter().sortItems(items, (ItemExpression)new ItemSortablePathNameExpression());
                    }
                    this.itemsInScope = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("MetadataExportOperation.Log.ScopeCount", this.itemsInScope));
                    this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.SortOrder", (Object)this.sortOrder.toString()));
                }
                catch (IOException e) {
                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                List metadata = mp.getMetadata();
                ConcurrentHashMap itemsMetadataRepresentationDictionary = new ConcurrentHashMap();
                long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOGGER.info("Memory used before generating metadata: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.ExportLocation", (Object)this.exportLocation));
                try {
                    File file = new File(this.exportLocation);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(this.exportLocation, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
                    writer.write("\ufeff");
                    StringBuilder header = new StringBuilder();
                    if (this.exportLocation.toLowerCase().endsWith(".dat")) {
                        String[] metadataItemNames = (String[])metadata.stream().map(MetadataItem::getLocalisedName).toArray(String[]::new);
                        String concordanceHeader = FormattingUtils.encodeConcordanceRow((String[])metadataItemNames);
                        header.append(concordanceHeader);
                    } else {
                        for (MetadataItem metadataItem : metadata) {
                            if (header.length() > 0) {
                                header.append(",");
                            }
                            header.append(FormattingUtils.encodeForCsv((String)metadataItem.getLocalisedName()));
                        }
                    }
                    header.append("\r\n");
                    writer.write(header.toString());
                    this.runningThreads = new ArrayList<Thread>();
                    if (this.sortOrder == SortOrder.NONE) {
                        this.itemsExportedMetadata = this.itemsGeneratedMetadata;
                        LinkedBlockingDeque<Item> itemsQueue = new LinkedBlockingDeque<Item>();
                        MetadataExportProducer metadataExportProducer = new MetadataExportProducer(items, itemsQueue, 10000);
                        Thread producerThread = new Thread(metadataExportProducer);
                        producerThread.setName("Automate - Operation " + this.getOperationName() + " Producer");
                        producerThread.start();
                        this.runningThreads.add(producerThread);
                        int threadsNumber = Runtime.getRuntime().availableProcessors();
                        ArrayList<MetadataExportConsumerWriter> consumers = new ArrayList<MetadataExportConsumerWriter>();
                        ArrayList<Thread> consumerThreads = new ArrayList<Thread>();
                        for (int i = 0; i < threadsNumber; ++i) {
                            MetadataExportConsumerWriter metadataExportConsumer = new MetadataExportConsumerWriter(itemsQueue, writer, metadata, this.itemsGeneratedMetadata, this.exportLocation.endsWith(".dat"), this.rubyFieldNames, this);
                            consumers.add(metadataExportConsumer);
                            Thread thread = new Thread(metadataExportConsumer);
                            thread.setName("Automate - Operation " + this.getOperationName() + " Consumer");
                            consumerThreads.add(thread);
                            thread.start();
                            this.runningThreads.add(thread);
                        }
                        LOGGER.info("Waiting for producer to complete");
                        while (producerThread.isAlive()) {
                            if (this.stopRequested) {
                                metadataExportProducer.stopTriggered();
                            }
                            producerThread.join(1000L);
                        }
                        LOGGER.info("Notifying consumers that no more items will be added");
                        for (MetadataExportConsumerWriter consumer : consumers) {
                            consumer.setDoneProducing();
                            if (!this.stopRequested) continue;
                            consumer.stopTriggered();
                        }
                        LOGGER.info("Waiting for consumers to complete");
                        for (Thread thread : consumerThreads) {
                            thread.join();
                        }
                        LOGGER.info("All consumers completed");
                    } else {
                        ConcurrentHashMap<String, String> itemsMetadataRepresentation = new ConcurrentHashMap<String, String>();
                        LinkedBlockingDeque<Item> itemsQueue = new LinkedBlockingDeque<Item>();
                        MetadataExportProducer metadataExportProducer = new MetadataExportProducer(items, itemsQueue, 10000);
                        Thread producerThread = new Thread(metadataExportProducer);
                        producerThread.setName("Automate - Operation " + this.getOperationName() + " Producer");
                        producerThread.start();
                        this.runningThreads.add(producerThread);
                        int threadsNumber = Runtime.getRuntime().availableProcessors();
                        ArrayList<MetadataExportConsumerGenerator> consumers = new ArrayList<MetadataExportConsumerGenerator>();
                        ArrayList<Thread> consumerThreads = new ArrayList<Thread>();
                        for (int i = 0; i < threadsNumber; ++i) {
                            MetadataExportConsumerGenerator metadataExportConsumer = new MetadataExportConsumerGenerator(itemsQueue, itemsMetadataRepresentation, metadata, this.itemsGeneratedMetadata, 10000, this.exportLocation.endsWith(".dat"), this.rubyFieldNames, this);
                            consumers.add(metadataExportConsumer);
                            Thread thread = new Thread(metadataExportConsumer);
                            thread.setName("Automate - Operation " + this.getOperationName() + " Consumer");
                            consumerThreads.add(thread);
                            thread.start();
                            this.runningThreads.add(thread);
                        }
                        List itemsList = items;
                        HashSet<String> seenGuids = new HashSet<String>();
                        block13: while (this.itemsExportedMetadata.get() < itemsList.size()) {
                            String itemRepresentation;
                            if (this.stopRequested) {
                                LOGGER.info("Exiting writer main loop");
                                break;
                            }
                            String currentItemGuid = ((Item)itemsList.get(this.itemsExportedMetadata.get())).getGuid();
                            boolean newItem = seenGuids.add(currentItemGuid);
                            if (!newItem) {
                                this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.DuplicateGuidDetected", (Object)currentItemGuid));
                                this.itemsExportedMetadata.incrementAndGet();
                                continue;
                            }
                            while (true) {
                                if (this.stopRequested) {
                                    LOGGER.info("Exiting writer sub loop");
                                    continue block13;
                                }
                                itemRepresentation = itemsMetadataRepresentation.remove(currentItemGuid);
                                if (itemRepresentation != null) break;
                                Thread.sleep(100L);
                            }
                            writer.write(itemRepresentation);
                            this.itemsExportedMetadata.incrementAndGet();
                        }
                        if (this.stopRequested) {
                            metadataExportProducer.stopTriggered();
                        } else {
                            LOGGER.info("Done exporting all items");
                        }
                        LOGGER.info("Waiting for producer to complete");
                        producerThread.join();
                        LOGGER.info("Notifying consumers that no more items will be added");
                        for (MetadataExportConsumerGenerator consumer : consumers) {
                            consumer.setDoneProducing();
                            if (!this.stopRequested) continue;
                            consumer.stopTriggered();
                        }
                        LOGGER.info("Waiting for consumers to complete");
                        for (Thread thread : consumerThreads) {
                            thread.join();
                        }
                        LOGGER.info("All consumers completed");
                    }
                    ((Writer)writer).close();
                    itemsMetadataRepresentationDictionary.clear();
                    memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    LOGGER.info("Memory used after writing metadata: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                }
                catch (WorkflowExecutionStopRequested e) {
                    this.trackStopped();
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_metadata_export_file}", this.exportLocation)));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.exportLocation).getParentFile().getAbsolutePath())));
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = ((double)this.itemsGeneratedMetadata.get() * 0.5 + (double)this.itemsExportedMetadata.get() * 0.5) / (double)this.itemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.itemsInScope == 0L) {
            result = (String)result + this.iu.getString("MetadataExportOperation.Progress.SearchingForItems");
        } else if (this.itemsGeneratedMetadata != null) {
            result = (String)result + this.iu.getString("MetadataExportOperation.Progress.ExportingMetadata");
            result = (String)result + this.iu.getNumeralString("MetadataExportOperation.Progress.ItemsProcessed", (long)((this.itemsGeneratedMetadata.get() + this.itemsExportedMetadata.get()) / 2));
        }
        return result;
    }

    @Override
    public void onItemProcessed(Item item, boolean failed) {
        this.trackItemProcessed(item.getType().getName(), failed);
        String translationKey = failed ? "OperationStats.Exported" : "OperationStats.Failed";
        this.addOperationRunningLog(this.iu.getFormattedString(translationKey, (Object)String.join((CharSequence)"/", item.getPathNames())));
    }
}

