/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import nuix.Item;

public class MetadataExportProducer
implements Runnable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportProducer.class);
    private Collection<Item> items;
    private BlockingDeque<Item> itemsQueue;
    private int maxNumberOfItemsPending;
    private boolean stopRequested = false;

    public MetadataExportProducer(Collection<Item> items, BlockingDeque<Item> itemsQueue, int maxNumberOfItemsPending) {
        this.items = items;
        this.itemsQueue = itemsQueue;
        this.maxNumberOfItemsPending = maxNumberOfItemsPending;
    }

    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        LOGGER.info("Starting producer");
        for (Item item : this.items) {
            try {
                if (this.stopRequested) {
                    return;
                }
                while (this.itemsQueue.size() > this.maxNumberOfItemsPending) {
                    if (this.stopRequested) {
                        return;
                    }
                    Thread.sleep(10L);
                }
                this.itemsQueue.add(item);
            }
            catch (InterruptedException e) {
                LOGGER.info("Generator thread interrupted", (Throwable)e);
                return;
            }
        }
    }
}

