/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.MetadataToSqlOperation;
import com.nuix.automate.workflow.core.execution.options.metadatatosql.MetadataToSqlDao;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlDatabase;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlPlatform;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.sql.MetadataPayload;
import com.nuix.automate.workflow.core.utils.sql.SqlUtils;
import com.nuix.common.ByteSize;
import com.nuix.util.expression.MultiValue;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.joda.time.DateTime;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class MetadataToSqlOperationImplementation
extends MetadataToSqlOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataToSqlOperation.class);
    private transient AtomicLong itemsWithErrors = new AtomicLong();
    private transient long itemsInScope;
    private transient List<Item> items = null;
    private transient AtomicInteger itemsGeneratedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsExportedMetadata = new AtomicInteger();
    private transient Set<String> rubyFieldNames;
    private transient String[] sqlColumnTypes;
    private transient List<String> columns = new ArrayList<String>();
    private transient Jdbi metadataDbi;
    private transient MetadataToSqlDao dao;
    private final transient String whitelist = "^[a-zA-Z0-9_ -]+$";

    private void createConnection() throws SQLException, StatementException {
        String connectionString = SqlUtils.getConnectionString(this.sqlPlatform, this.sqlServerName, this.port, this.instance, this.domain, this.databaseName, this.sqlEncryption, this.username, this.password, this.executionContext, this);
        this.metadataDbi = null;
        this.metadataDbi = !this.username.equals("") && !this.password.equals("") ? Jdbi.create((String)connectionString, (String)this.username, (String)this.password) : Jdbi.create((String)connectionString);
        this.metadataDbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.dao = (MetadataToSqlDao)this.metadataDbi.onDemand(MetadataToSqlDao.class);
        this.dao.checkConnection();
        LOGGER.info("SQL connected to " + connectionString);
    }

    private Object getSqlColumnValue(Object javaType) {
        Object value = javaType;
        if (value != null) {
            if (javaType.getClass().equals(ByteSize.class)) {
                value = ((ByteSize)javaType).getValue();
            }
            if (javaType.getClass().equals(MultiValue.class)) {
                value = ((MultiValue)javaType).toString();
            }
            if (javaType.getClass().equals(DateTime.class)) {
                Instant itemDate = Instant.ofEpochMilli(((DateTime)javaType).getMillis());
                value = Timestamp.from(itemDate);
            }
        }
        return value;
    }

    private boolean isWhitelistedString(String sqlString) {
        if (sqlString == null) {
            return false;
        }
        return sqlString.matches("^[a-zA-Z0-9_ -]+$");
    }

    private String normalizeSqlColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        String safeColumnName = columnName.replaceAll("[^a-zA-Z0-9_ -]+", " ");
        if (this.isWhitelistedString(safeColumnName)) {
            this.addWarning(this.iu.getFormattedString("MetadataToSqlOperation.Warning.ColumnStrippedCharacters", new Object[]{columnName, safeColumnName}));
            return safeColumnName;
        }
        throw new IllegalArgumentException(this.iu.getFormattedString("MetadataToSqlOperation.Log.InvalidColumnName", new Object[]{columnName, this.iu.getString("MetadataToSqlOperation.Error.ValidCharacters")}));
    }

    private String mapMetadataToSqlType(Object javaType) {
        if (javaType.getClass().equals(Boolean.class)) {
            return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[BIT]" : "BOOLEAN";
        }
        if (javaType.getClass().equals(Integer.class)) {
            return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[INTEGER]" : "INTEGER";
        }
        if (javaType.getClass().equals(ByteSize.class) || javaType.getClass().equals(Long.class)) {
            return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[BIGINT]" : "BIGINT";
        }
        if (javaType.getClass().equals(Float.class) || javaType.getClass().equals(Double.class)) {
            return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[FLOAT]" : "REAL";
        }
        if (javaType.getClass().equals(DateTime.class) || javaType.getClass().equals(Date.class)) {
            return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[DATETIME]" : "TIMESTAMP";
        }
        return this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[NVARCHAR](MAX)" : "TEXT";
    }

    private void createTable(MetadataProfile mp) throws StatementException, IllegalArgumentException {
        int metadataCount = 0;
        ArrayList<String> boundColumnList = new ArrayList<String>();
        this.sqlColumnTypes = new String[mp.getMetadata().size()];
        for (MetadataItem metadataItem : mp.getMetadata()) {
            Object evaluatedMetadataItem = null;
            int itemIndex = 0;
            for (Item item : this.items) {
                try {
                    evaluatedMetadataItem = MetadataItemUtils.evaluateUnformatted(metadataItem, item, this.rubyFieldNames);
                    if (evaluatedMetadataItem != null) {
                        this.sqlColumnTypes[metadataCount] = this.mapMetadataToSqlType(evaluatedMetadataItem);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++itemIndex;
            }
            String sqlType = null;
            if (evaluatedMetadataItem != null) {
                sqlType = this.sqlColumnTypes[metadataCount];
            } else {
                this.addWarning(this.iu.getFormattedString("MetadataToSqlOperation.Warning.UnableToDetermineType", (Object)metadataItem.getLocalisedName()));
                sqlType = this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL ? "[NVARCHAR](MAX)" : "TEXT";
            }
            String currentColumnName = metadataItem.getLocalisedName();
            if (!this.isWhitelistedString(currentColumnName)) {
                currentColumnName = this.normalizeSqlColumnName(metadataItem.getLocalisedName());
            }
            if (this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
                this.columns.add(currentColumnName);
                boundColumnList.add(String.format("[%s] %s NULL", currentColumnName, sqlType));
            } else if (this.sqlPlatform == SqlPlatform.POSTGRES_SQL) {
                this.columns.add(currentColumnName);
                boundColumnList.add(String.format("\"%s\" %s NULL", currentColumnName, sqlType));
            }
            ++metadataCount;
        }
        String boundColumns = String.join((CharSequence)", ", boundColumnList);
        LOGGER.info("Table columns: " + boundColumns);
        this.dao.createMetadataTable(this.sqlPlatform, this.tableName, this.databaseName, boundColumns);
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.sqlServerName = this.executionContext.evalParameters(this.sqlServerName, this);
        this.instance = this.executionContext.evalParameters(this.instance, this);
        this.domain = this.executionContext.evalParameters(this.domain, this);
        this.username = this.executionContext.evalParameters(this.username, this);
        this.password = this.executionContext.evalProtectedParameter(this.password);
        this.databaseName = this.executionContext.evalParameters(this.databaseName, this);
        this.tableName = this.executionContext.evalParameters(this.tableName, this);
        this.itemsGeneratedMetadata = new AtomicInteger(0);
        this.itemsExportedMetadata = new AtomicInteger(0);
        String metadataProfileParameterName = "{metadata_profile}";
        String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
        if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
        if (mp == null) {
            this.exception = new Exception(this.iu.getFormattedString("MetadataExportOperation.Warning.CannotFindMetadataProfile", (Object)this.metadataProfile));
            this.executionState = ExecutionState.ERROR;
            return;
        }
        if (mp.getMetadata() == null || mp.getMetadata().size() == 0) {
            this.exception = new Exception(this.iu.getFormattedString("MetadataExportOperation.Warning.MetadataProfileInvalid", (Object)this.metadataProfile));
            this.executionState = ExecutionState.ERROR;
            return;
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                if (!this.isWhitelistedString(this.databaseName)) {
                    throw new IllegalArgumentException(this.iu.getFormattedString("MetadataToSqlOperation.Log.InvalidDatabaseName", new Object[]{this.databaseName, "MetadataToSqlOperation.Error.ValidCharacters"}));
                }
                if (!this.isWhitelistedString(this.tableName)) {
                    throw new IllegalArgumentException(this.iu.getFormattedString("MetadataToSqlOperation.Log.InvalidTableName", new Object[]{this.tableName, this.iu.getString("MetadataToSqlOperation.Error.ValidCharacters")}));
                }
                this.rubyFieldNames = new TreeSet<String>();
                for (MetadataItem metadataItem : mp.getMetadata()) {
                    if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                    this.rubyFieldNames.add(metadataItem.getName());
                    LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                }
                if (this.rubyFieldNames.size() > 0) {
                    this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                }
                this.createConnection();
                Long existingRecordsCount = null;
                try {
                    existingRecordsCount = this.dao.getExistingRecordsCount(this.sqlPlatform, this.tableName, this.databaseName);
                    this.addExecutionLog(this.iu.getFormattedString("MetadataToSqlOperation.Log.PreviousRecordCount", (Object)existingRecordsCount));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get existing records count", (Throwable)e);
                    this.addExecutionLog(this.iu.getFormattedString("MetadataToSqlOperation.Log.CannotQueryPreviousRecordCount", (Object)""));
                }
                try {
                    this.executionContext.closeAllTabs();
                    HashMap searchOptions = new HashMap();
                    LOGGER.info("Searching for " + NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    this.addExecutionLog(this.iu.getFormattedString("MetadataExportOperation.Log.ScopeQuery", (Object)this.scope));
                    this.items = this.executionContext.nuixCase.search(this.scope);
                    this.itemsInScope = this.items.size();
                    this.addExecutionLog(this.iu.getNumeralString("MetadataExportOperation.Log.ScopeCount", this.itemsInScope));
                    if (existingRecordsCount == null) {
                        if (!this.createTableIfNotExists) throw new SQLException(this.iu.getFormattedString("MetadataToSqlOperation.Log.CannotQueryTable", (Object)this.tableName));
                        LOGGER.info("Attempting to create table");
                        this.addExecutionLog(this.iu.getFormattedString("MetadataToSqlOperation.Log.CreatingTable", (Object)this.tableName));
                        try {
                            this.createTable(mp);
                        }
                        catch (StatementException e) {
                            LOGGER.error("Cannot crete table");
                            throw new SQLException(this.iu.getFormattedString("MetadataToSqlOperation.Log.CannotCreateTable", (Object)e.getLocalizedMessage()));
                        }
                    } else {
                        int metadataCount = 0;
                        this.sqlColumnTypes = new String[mp.getMetadata().size()];
                        for (MetadataItem metadataItem : mp.getMetadata()) {
                            String currentColumnName;
                            Object evaluatedMetadataItem = null;
                            for (Item item : this.items) {
                                try {
                                    evaluatedMetadataItem = MetadataItemUtils.evaluateUnformatted(metadataItem, item, this.rubyFieldNames);
                                    if (evaluatedMetadataItem == null) continue;
                                    this.sqlColumnTypes[metadataCount] = this.mapMetadataToSqlType(evaluatedMetadataItem);
                                    break;
                                }
                                catch (Exception exception) {
                                }
                            }
                            if (!this.isWhitelistedString(currentColumnName = metadataItem.getLocalisedName())) {
                                currentColumnName = this.normalizeSqlColumnName(metadataItem.getLocalisedName());
                            }
                            this.columns.add(currentColumnName);
                            ++metadataCount;
                        }
                    }
                    CharSequence[] sqlPlatformString = new String[this.columns.size()];
                    for (int i = 0; i < this.columns.size(); ++i) {
                        if (this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
                            sqlPlatformString[i] = "[" + this.columns.get(i) + "]";
                            continue;
                        }
                        if (this.sqlPlatform != SqlPlatform.POSTGRES_SQL) continue;
                        sqlPlatformString[i] = "\"" + this.columns.get(i) + "\"";
                    }
                    ArrayList<CallSite> definedColumnValues = new ArrayList<CallSite>();
                    for (int i = 0; i < this.columns.size(); ++i) {
                        definedColumnValues.add((CallSite)((Object)(":col" + i)));
                    }
                    String columnNameString = String.join((CharSequence)", ", sqlPlatformString);
                    String columnValueString = String.join((CharSequence)", ", definedColumnValues);
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(this.items, ItemsUtils.getPartitionerChunkSize(256, this));
                    try {
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            ArrayList<MetadataPayload> batches = new ArrayList<MetadataPayload>();
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            int threadItemsCount = 0;
                            while (iterator.hasNext()) {
                                Item item = (Item)iterator.next();
                                if (this.stopRequested) {
                                    throw new WorkflowExecutionStopRequested();
                                }
                                HashMap<String, Object> columnValues = new HashMap<String, Object>();
                                boolean itemHasErrors = false;
                                int threadMetadataCount = 0;
                                for (MetadataItem metadataItem : mp.getMetadata()) {
                                    ++threadMetadataCount;
                                    Object metadataValue = null;
                                    try {
                                        String type = this.sqlColumnTypes[threadMetadataCount - 1];
                                        metadataValue = type.equals("TEXT") || type.equals("[NVARCHAR](MAX)") ? MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames) : this.getSqlColumnValue(MetadataItemUtils.evaluateUnformatted(metadataItem, item, this.rubyFieldNames));
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Cannot evaluate item " + item.getGuid() + " metadata " + metadataItem.getLocalisedName() + ", " + e.getMessage());
                                    }
                                    try {
                                        if (metadataValue == null) {
                                            columnValues.put("col" + (threadMetadataCount - 1), null);
                                            continue;
                                        }
                                        columnValues.put("col" + (threadMetadataCount - 1), metadataValue);
                                    }
                                    catch (Exception e) {
                                        itemHasErrors = true;
                                        LOGGER.error("Cannot set item " + item.getGuid() + " metadata " + metadataItem.getLocalisedName() + " value " + String.valueOf(metadataValue));
                                    }
                                }
                                this.itemsGeneratedMetadata.incrementAndGet();
                                this.itemsExportedMetadata.incrementAndGet();
                                MetadataPayload payload = new MetadataPayload();
                                payload.setColumnData(columnValues);
                                batches.add(payload);
                                ++threadItemsCount;
                                if (itemHasErrors) {
                                    this.itemsWithErrors.incrementAndGet();
                                    this.trackItemProcessed(item.getType().getName(), false);
                                    this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Exported", (Object)String.join((CharSequence)"/", item.getPathNames())));
                                    continue;
                                }
                                this.trackItemProcessed(item.getType().getName(), true);
                                this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Failed", (Object)String.join((CharSequence)"/", item.getPathNames())));
                            }
                            try {
                                LOGGER.info("Running batch of " + threadItemsCount + " items");
                                this.dao.insertMetadata(this.sqlPlatform, this.tableName, this.databaseName, columnNameString, columnValueString, batches);
                                LOGGER.info("Finished running batch");
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot run SQL batch", (Throwable)e);
                                this.itemsWithErrors.addAndGet(threadItemsCount);
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    }
                    catch (WorkflowExecutionStopRequested e) {
                        this.trackStopped();
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception thrown while processing items", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            if (this.itemsWithErrors.get() > 0L) {
                this.addWarning(this.iu.getNumeralString("MetadataExportOperation.Log.ItemsWithErrors", this.itemsWithErrors.get()));
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = ((double)this.itemsGeneratedMetadata.get() * 0.5 + (double)this.itemsExportedMetadata.get() * 0.5) / (double)this.itemsInScope;
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.itemsInScope == 0L) {
            result = (String)result + this.iu.getString("MetadataToSqlOperation.Progress.ConnectingToSql");
        } else if (this.itemsGeneratedMetadata != null) {
            result = (String)result + this.iu.getString("MetadataExportOperation.Progress.ExportingMetadata");
            result = (String)result + this.iu.getNumeralString("MetadataExportOperation.Progress.ItemsProcessed", (long)((this.itemsGeneratedMetadata.get() + this.itemsExportedMetadata.get()) / 2));
        }
        return result;
    }
}

