/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.operations.NativeOcrItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextFromStringModifierCallback;
import com.nuix.automate.workflow.core.execution.options.genai.ResultsLocation;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.ocr.ComputeConsumption;
import com.nuix.automate.workflow.core.utils.ocr.Consumption;
import com.nuix.automate.workflow.core.utils.ocr.OcrResult;
import com.nuix.automate.workflow.core.utils.ocr.OcrStatus;
import com.nuix.automate.workflow.core.utils.ocr.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nuix.Binary;
import nuix.BinaryData;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.ItemModifierCallback;
import nuix.ItemType;
import nuix.MutablePrintedImage;
import nuix.SingleItemImporter;
import nuix.Text;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class OcrItemsOperationImplementation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NativeOcrItemsOperation.class);
    private static final String DEFAULT_SEPARATOR = "---";
    private transient long itemsInScopeCount;
    private transient AtomicLong countItemsWithoutStoredBinary;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countPagesProcessed;
    private transient AtomicLong countItemsProcessedSuccessfully;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient String tempTag;
    private transient String effectiveSeparator;
    private transient Map<String, List<Item>> digestItems;
    private transient Map<String, MimeTypeVolume> mimeTypeVolumes;
    private transient String stageName;
    protected transient OcrUtils ocrUtils;
    @FormField(required=false)
    public String scope;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON, allowedValues={"false", "true"})
    public boolean replaceText;
    public ResultsLocation resultsLocation;
    public String metadataFieldName;
    @FormField
    public boolean createSearchablePdf;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems;

    protected abstract OcrUtils initializeOcrUtils() throws IOException;

    protected abstract int evalEffectiveWorkers();

    protected abstract boolean getItemTypeSupported(ItemType var1);

    protected abstract void logConsumption();

    protected abstract void logHeader(BufferedWriter var1);

    protected abstract Consumption getNullConsumption();

    protected abstract String getEffectiveMetadataFieldName();

    protected abstract void setTextMetadata(Item var1, String var2);

    protected abstract void setContextMetadata(Item var1);

    @Override
    public void startTriggered() throws Exception {
        this.executionContext.closeAllTabs();
        this.countItemsProcessed = new AtomicLong(0L);
        this.countItemsWithoutStoredBinary = new AtomicLong(0L);
        this.countItemsProcessedSuccessfully = new AtomicLong(0L);
        this.countPagesProcessed = new AtomicLong(0L);
        this.mimeTypeVolumes = new HashMap<String, MimeTypeVolume>();
        this.failedItems = new HashSet<Item>();
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.tempTag = "Automate|System|Run|OCR|" + String.valueOf(UUID.randomUUID());
        this.addExecutionLog("Scope query: " + this.scope);
        if (this.resultsLocation == null || this.resultsLocation.equals((Object)ResultsLocation.TEXT)) {
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.TextModifications", (Object)(this.replaceText ? "Overwrite" : "Append text")));
        } else {
            this.metadataFieldName = this.executionContext.evalParameters(this.metadataFieldName, this);
            this.metadataFieldName = this.getEffectiveMetadataFieldName();
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.MetadataField", (Object)this.metadataFieldName));
        }
        if (this.createSearchablePdf) {
            this.addExecutionLog(this.iu.getString("NativeOcrItemsOperation.Log.CreatePdfs"));
        }
        try {
            this.effectiveSeparator = this.executionContext.evalParametersIfSet("{native_ocr_separator}", this);
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (this.effectiveSeparator == null) {
            this.effectiveSeparator = DEFAULT_SEPARATOR;
        } else {
            this.addExecutionLog(this.iu.getFormattedString("NativeOcrItemsOperation.Log.CustomSeparator", (Object)this.effectiveSeparator));
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                boolean reportFileExists;
                String reportLocation = this.executionContext.evalParameters("{case_folder}/Stores/Reports/ocr_summary_report_{date_time}.csv", this);
                Path reportFile = Paths.get(reportLocation, new String[0]);
                Path reportFolder = reportFile.getParent();
                if (!Files.exists(reportFolder, new LinkOption[0])) {
                    Files.createDirectories(reportFolder, new FileAttribute[0]);
                }
                StandardOpenOption openOption = (reportFileExists = Files.exists(reportFile, new LinkOption[0])) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
                try (BufferedWriter reportWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(reportFile, openOption), StandardCharsets.UTF_8));){
                    this.addExecutionLog(this.iu.getFormattedString("NativeOcrItemsOperation.Log.ReportFile", (Object)reportFile));
                    if (!reportFileExists) {
                        this.logHeader(reportWriter);
                    } else {
                        reportWriter.append("---\n");
                    }
                    try (OcrUtils ocrUtils = this.initializeOcrUtils();){
                        int effectiveWorkers = this.evalEffectiveWorkers();
                        SingleItemImporter pdfPrintImporter = this.executionContext.nuixUtilities.getPdfPrintImporter();
                        AtomicReference exception = new AtomicReference();
                        this.executionContext.nuixCase.withWriteAccess(() -> {
                            try {
                                String itemsToSearchQuery = NuixUtils.addAndQuery(this.scope, "has-exclusion:0");
                                LOGGER.info("Searching for items in scope: " + itemsToSearchQuery);
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                this.stageName = this.iu.getString("NativeOcrItemsOperation.Stage.SearchingItems");
                                Set itemsInScope = this.executionContext.nuixCase.searchUnsorted(itemsToSearchQuery);
                                this.itemsInScopeCount = itemsInScope.size();
                                LOGGER.info("Got " + this.itemsInScopeCount + " items");
                                this.addExecutionLog(this.iu.getNumeralString("OcrOperation.Log.ScopeCount", this.itemsInScopeCount));
                                if (this.itemsInScopeCount > 0L) {
                                    LOGGER.info("Tagging " + this.itemsInScopeCount + " items with tag " + this.tempTag);
                                    this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, (Collection)itemsInScope);
                                }
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                this.stageName = this.iu.getString("NativeOcrItemsOperation.Stage.ScanningDigest");
                                LOGGER.info("Mapping items to MD5");
                                this.digestItems = new HashMap<String, List<Item>>();
                                for (Item item : itemsInScope) {
                                    String key = item.getDigests().getMd5();
                                    if (key == null) {
                                        key = item.getGuid();
                                    }
                                    List keyItems = this.digestItems.computeIfAbsent(key, s -> new ArrayList());
                                    keyItems.add(item);
                                }
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                this.stageName = null;
                                ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
                                AtomicLong threadsCount = new AtomicLong();
                                Semaphore semaphore = new Semaphore(effectiveWorkers, true);
                                for (List list : this.digestItems.values()) {
                                    boolean acquired;
                                    if (this.stopRequested) break;
                                    Long threadId = threadsCount.getAndIncrement();
                                    Thread thread = new Thread(() -> {
                                        try {
                                            this.handleOcrItem(items, ocrUtils, pdfPrintImporter, semaphore, reportWriter);
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Error handling item", (Throwable)e);
                                        }
                                        finally {
                                            this.countItemsProcessed.addAndGet(items.size());
                                            this.trackIncrementVolumeProcessed(((Item)items.get(0)).getAuditedSize() * (long)items.size());
                                            semaphore.release();
                                            activeThreads.remove(threadId);
                                        }
                                    });
                                    activeThreads.put(threadId, thread);
                                    while (!(acquired = semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS))) {
                                    }
                                    thread.setName("OCR document handling");
                                    thread.start();
                                }
                                while (activeThreads.size() > 0 && !this.stopRequested) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException e) {
                                        this.stopRequested = true;
                                    }
                                }
                                if (this.stopRequested) {
                                    for (Thread thread : activeThreads.values()) {
                                        thread.interrupt();
                                    }
                                    this.trackStopped();
                                    return;
                                }
                            }
                            catch (Exception e) {
                                exception.set(e);
                            }
                        });
                        if (exception != null && exception.get() != null) {
                            throw (Exception)exception.get();
                        }
                        if (this.countItemsWithoutStoredBinary.get() > 0L) {
                            this.addWarning(this.iu.getNumeralString("NativeOcrItemsOperation.Log.ItemsWithoutBinaryData", this.countItemsWithoutStoredBinary.get()));
                        }
                        if (this.countPagesProcessed.get() > 0L) {
                            this.addExecutionLog(this.iu.getNumeralString("NativeOcrImagesOperation.Log.OcrPages", this.countPagesProcessed.get()));
                        }
                        if (this.countItemsProcessedSuccessfully.get() > 0L) {
                            this.addExecutionLog(this.iu.getNumeralString("NativeOcrItemsOperation.Log.SuccessOcrItems", this.countItemsProcessedSuccessfully.get()));
                        }
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                    }
                    this.logConsumption();
                    this.handleFailedItems();
                    this.trackFinished();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOcrItem(List<Item> items, OcrUtils ocrUtils, SingleItemImporter pdfPrintImporter, Semaphore semaphore, BufferedWriter reportWriter) {
        OcrStatus ocrStatus;
        long incremented;
        Item item = items.get(0);
        if (!item.getBinary().isStored() && (incremented = this.countItemsWithoutStoredBinary.incrementAndGet()) == 1L) {
            this.addWarning(this.iu.getString("NativeOcrItemsOperation.Warn.DetectedItemsWithoutBinaryData"));
        }
        long startEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        ArrayList<String> tasks = new ArrayList<String>();
        ArrayList<String> sameHashItemTasks = new ArrayList<String>();
        ArrayList<AtomicLong> itemsDuration = new ArrayList<AtomicLong>();
        ArrayList<Object> messageLines = new ArrayList<Object>();
        for (int i = 0; i < items.size(); ++i) {
            itemsDuration.add(new AtomicLong(0L));
        }
        boolean itemFailed = false;
        Integer pagesOcred = null;
        String itemCasePath = String.join((CharSequence)"/", item.getPathNames());
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processing", (Object)itemCasePath));
        Consumption totalConsumption = this.getNullConsumption();
        String fileExtension = item.getType().getPreferredExtension();
        try {
            Path destinationPdfPathWithExtension;
            Path destinationTextPathWithExtension;
            block72: {
                Path itemTempPath = ocrUtils.getTempFolder(item.getGuid(), item.getGuid());
                Path destinationTextPath = itemTempPath.resolve(item.getGuid());
                destinationTextPathWithExtension = itemTempPath.resolve(item.getGuid() + ".txt");
                destinationPdfPathWithExtension = itemTempPath.resolve(item.getGuid() + ".pdf");
                if (!Files.exists(itemTempPath, new LinkOption[0])) {
                    Files.createDirectories(itemTempPath, new FileAttribute[0]);
                }
                if (this.getItemTypeSupported(item.getType())) {
                    Path itemPath;
                    block71: {
                        Binary itemBinary;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("OCRing item " + item.getGuid() + " from native file");
                        }
                        if ((itemPath = (itemBinary = item.getBinary()).getStoredPath()) != null) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Item " + item.getGuid() + " binary is stored to file");
                            }
                        } else {
                            try {
                                tasks.add("Binary Export");
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Saving item " + item.getGuid() + " binary to file");
                                }
                                BinaryData binaryData = itemBinary.getBinaryData();
                                itemPath = itemTempPath.resolve(item.getGuid() + "_original." + fileExtension);
                                binaryData.copyTo(itemPath);
                                this.trackStats("export_binary", itemCasePath, fileExtension, false);
                            }
                            catch (Exception e) {
                                itemFailed = true;
                                this.trackStats("export_binary", itemCasePath, fileExtension, true);
                                LOGGER.warn("Cannot export item " + item.getGuid() + " binary");
                                if (ocrUtils.isLogLevelOff()) break block71;
                                messageLines.add("Cannot export binary: " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                            }
                        }
                    }
                    if (!itemFailed) {
                        if (fileExtension.equals("pdf")) {
                            tasks.add("Rasterize PDF");
                            tasks.add("OCR Image");
                        } else {
                            tasks.add("OCR Image");
                        }
                        OcrResult result = ocrUtils.ocrFile(itemPath, destinationTextPath, this.createSearchablePdf, destinationTextPath, semaphore, this.countPagesProcessed, itemTempPath);
                        if (result != null) {
                            if (result.getMessage() != null && result.getMessage().length() > 0) {
                                messageLines.add(result.getMessage());
                            }
                            OcrItemsOperationImplementation ocrItemsOperationImplementation = this;
                            synchronized (ocrItemsOperationImplementation) {
                                if (totalConsumption == null) {
                                    totalConsumption = result.getConsumption();
                                } else {
                                    totalConsumption.add(result.getConsumption());
                                }
                            }
                        }
                        pagesOcred = result.getPages();
                        itemFailed = !OcrStatus.SUCCESS.equals((Object)result.getStatus());
                        this.trackStats("extract_text", itemCasePath, fileExtension, itemFailed);
                    }
                } else {
                    ArrayList<Path> pagePaths = new ArrayList<Path>();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("OCRing item " + item.getGuid() + " from printed image file");
                    }
                    try {
                        Object page2;
                        MutablePrintedImage printedImage = item.getPrintedImage();
                        if (printedImage == null) {
                            throw new IOException("Printed image not available");
                        }
                        if (printedImage.getInfo() == null || !printedImage.getInfo().wasPrinted()) {
                            tasks.add("Generate Printed Image");
                        }
                        printedImage.generate();
                        this.trackStats("generate_image", itemCasePath, fileExtension, false);
                        List pages = printedImage.getPages();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Saving item " + item.getGuid() + " pages");
                        }
                        int pageId = 1;
                        for (Object page2 : pages) {
                            HashMap<String, Double> options = new HashMap<String, Double>();
                            options.put("zoom", 4.0);
                            Path printedPage = itemTempPath.resolve(item.getGuid() + "_" + String.format("%03d", pageId) + ".png");
                            ImageIOUtil.writeImage((BufferedImage)page2.getPageImage(options), (String)printedPage.toString(), (int)300);
                            ++pageId;
                            pagePaths.add(printedPage);
                        }
                        tasks.add("OCR Image");
                        List<OcrResult> results = ocrUtils.ocrImageFiles(pagePaths, destinationTextPath, this.createSearchablePdf, destinationTextPath, semaphore, this.countPagesProcessed, itemTempPath);
                        pagesOcred = results.get(0).getPages();
                        itemFailed = !OcrStatus.SUCCESS.equals((Object)results.get(0).getStatus());
                        this.trackStats("extract_text", itemCasePath, fileExtension, itemFailed);
                        if (results.get(0).getMessage() != null && results.get(0).getMessage().length() > 0) {
                            messageLines.add(results.get(0).getMessage());
                        }
                        page2 = this;
                        synchronized (page2) {
                            for (OcrResult result : results) {
                                if (totalConsumption == null) {
                                    totalConsumption = result.getConsumption();
                                    continue;
                                }
                                totalConsumption.add(result.getConsumption());
                            }
                        }
                    }
                    catch (Throwable e) {
                        itemFailed = true;
                        this.trackStats("generate_image", itemCasePath, fileExtension, true);
                        LOGGER.warn("Cannot generate image", e);
                        if (ocrUtils.isLogLevelOff()) break block72;
                        messageLines.add("Cannot generate image: " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                    }
                }
            }
            boolean replaceTextSuccessful = false;
            if (!itemFailed) {
                try {
                    if (Files.exists(destinationTextPathWithExtension, new LinkOption[0])) {
                        String ocrText;
                        if (this.resultsLocation == null || this.resultsLocation.equals((Object)ResultsLocation.TEXT)) {
                            if (this.replaceText) {
                                tasks.add("Replace Text");
                                sameHashItemTasks.add("Replace Text");
                                int itemId = 0;
                                ocrText = FileUtils.readFileWithAutodetectEncoding((File)destinationTextPathWithExtension.toFile());
                                for (Item sameHashItem : items) {
                                    long itemStartEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                    sameHashItem.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(ocrText));
                                    this.setContextMetadata(sameHashItem);
                                    long itemEndEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                    ((AtomicLong)itemsDuration.get(itemId)).addAndGet(itemEndEpoch - itemStartEpoch);
                                    ++itemId;
                                }
                                replaceTextSuccessful = true;
                            } else {
                                String itemTextString;
                                tasks.add("Append Text");
                                sameHashItemTasks.add("Append Text");
                                StringBuilder mergedText = new StringBuilder();
                                Text itemText = item.getTextObject();
                                if (itemText != null && itemText.isAvailable() && (itemTextString = item.getTextObject().toString()).length() > 0) {
                                    mergedText.append(item.getTextObject().toString());
                                    mergedText.append(this.effectiveSeparator + "\n");
                                }
                                String ocrText2 = FileUtils.readFileWithAutodetectEncoding((File)destinationTextPathWithExtension.toFile());
                                mergedText.append(ocrText2);
                                int itemId = 0;
                                for (Item sameHashItem : items) {
                                    long itemStartEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                    sameHashItem.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(mergedText.toString()));
                                    this.setContextMetadata(sameHashItem);
                                    long itemEndEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                    ((AtomicLong)itemsDuration.get(itemId)).addAndGet(itemEndEpoch - itemStartEpoch);
                                    ++itemId;
                                }
                                replaceTextSuccessful = true;
                            }
                        } else {
                            tasks.add("Assign Metadata");
                            sameHashItemTasks.add("Assign Metadata");
                            int itemId = 0;
                            ocrText = FileUtils.readFileWithAutodetectEncoding((File)destinationTextPathWithExtension.toFile());
                            for (Item sameHashItem : items) {
                                long itemStartEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                this.setTextMetadata(sameHashItem, ocrText);
                                this.setContextMetadata(sameHashItem);
                                long itemEndEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                ((AtomicLong)itemsDuration.get(itemId)).addAndGet(itemEndEpoch - itemStartEpoch);
                                ++itemId;
                            }
                            replaceTextSuccessful = true;
                        }
                    } else {
                        if (!itemFailed) {
                            if (!ocrUtils.isLogLevelOff()) {
                                messageLines.add("Text file missing");
                            }
                            LOGGER.error("Item " + item.getGuid() + " OCRed successfully but is missing text file " + String.valueOf(destinationTextPathWithExtension));
                        }
                        itemFailed = true;
                    }
                }
                catch (Throwable e) {
                    if (!ocrUtils.isLogLevelOff()) {
                        messageLines.add("Cannot update text: " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                    }
                    LOGGER.error("Cannot update item " + item.getGuid() + " text", e);
                    itemFailed = true;
                }
                this.trackStats("update_text", itemCasePath, fileExtension, !replaceTextSuccessful);
            }
            if (this.createSearchablePdf) {
                boolean replacePdfSuccessful = false;
                if (!itemFailed) {
                    if (Files.exists(destinationPdfPathWithExtension, new LinkOption[0])) {
                        try {
                            tasks.add("Replace PDF");
                            sameHashItemTasks.add("Replace PDF");
                            int itemId = 0;
                            for (Item sameHashItem : items) {
                                long itemStartEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                pdfPrintImporter.importItem(sameHashItem, destinationPdfPathWithExtension.toFile());
                                long itemEndEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                                ((AtomicLong)itemsDuration.get(itemId)).addAndGet(itemEndEpoch - itemStartEpoch);
                                ++itemId;
                            }
                            replacePdfSuccessful = true;
                        }
                        catch (Exception e) {
                            if (!ocrUtils.isLogLevelOff()) {
                                messageLines.add("Cannot import PDF: " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                            }
                            LOGGER.error("Cannot import item " + item.getGuid() + " PDF", (Throwable)e);
                            itemFailed = true;
                        }
                    } else {
                        if (!itemFailed) {
                            if (!ocrUtils.isLogLevelOff()) {
                                messageLines.add("PDF file missing");
                            }
                            LOGGER.error("Item " + item.getGuid() + " OCRed successfully but is missing PDF file " + String.valueOf(destinationPdfPathWithExtension));
                        }
                        itemFailed = true;
                    }
                    this.trackStats("update_pdf", itemCasePath, fileExtension, !replacePdfSuccessful);
                }
            }
        }
        catch (Exception e) {
            messageLines.add("Cannot handle item: " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
            itemFailed = true;
            this.trackStats("preparing_item", itemCasePath, fileExtension, true);
            LOGGER.warn("Cannot OCR item " + item.getGuid(), (Throwable)e);
        }
        if (!itemFailed) {
            ocrStatus = OcrStatus.SUCCESS;
            this.countItemsProcessedSuccessfully.addAndGet(items.size());
        } else {
            ocrStatus = OcrStatus.FAILED;
            this.failedItems.addAll(items);
        }
        long endEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        OcrResult ocrResult = new OcrResult(String.join((CharSequence)"\n", messageLines), totalConsumption, ocrStatus, pagesOcred);
        int itemId = 0;
        for (Item sameHashItem : items) {
            String effectiveTasks;
            String sameHashItemCasePath = itemId == 0 ? itemCasePath : String.join((CharSequence)"/", sameHashItem.getPathNames());
            if (itemId == 0) {
                effectiveTasks = String.join((CharSequence)", ", tasks);
            } else {
                effectiveTasks = String.join((CharSequence)", ", sameHashItemTasks);
                ocrResult.setConsumption(new ComputeConsumption(((AtomicLong)itemsDuration.get(itemId)).get()));
            }
            this.logResult(reportWriter, sameHashItem.getGuid(), sameHashItemCasePath, pagesOcred, ocrResult, effectiveTasks);
            if (!ocrUtils.isLogLevelError() && itemId == 0) {
                String originalMessage = ocrResult.getMessage();
                String duplicateMessage = "Duplicate of " + item.getGuid();
                if (originalMessage != null && originalMessage.length() > 0) {
                    ocrResult.setMessage(duplicateMessage + "\n" + ocrResult.getMessage());
                } else {
                    ocrResult.setMessage(duplicateMessage);
                }
            }
            ++itemId;
        }
    }

    private void handleFailedItems() throws IOException {
        LOGGER.info("Handling failed items");
        if (this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("NativeOcrItemsOperation.Warning.FailedToOcrItems", (long)this.failedItems.size()));
        }
        if (this.tagFailedItems && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.TaggedFailedItem", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems && this.untagSuccessfulItems) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (this.itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.UntaggedFailedItem", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logResult(BufferedWriter reportWriter, String itemGuid, String itemPath, Integer itemPages, OcrResult result, String tasks) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(FormattingUtils.dateTimeToExcelDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
            stringBuilder.append(",");
            stringBuilder.append(itemGuid);
            stringBuilder.append(",");
            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemPath));
            stringBuilder.append(",");
            if (itemPages != null) {
                stringBuilder.append(itemPages);
            }
            stringBuilder.append(",");
            if (result.getConsumption() != null) {
                stringBuilder.append(String.join((CharSequence)",", result.getConsumption().toStringList()));
            }
            stringBuilder.append(",");
            stringBuilder.append(result.getStatus().getLocalizedString());
            stringBuilder.append(",");
            if (result.getMessage() != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)tasks));
            }
            stringBuilder.append(",");
            if (result.getMessage() != null) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)result.getMessage()));
            }
            stringBuilder.append("\r\n");
            BufferedWriter bufferedWriter = reportWriter;
            synchronized (bufferedWriter) {
                reportWriter.append(stringBuilder);
                reportWriter.flush();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error writing message to summary file.", (Throwable)e);
        }
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.itemsInScopeCount > 0L) {
            percentageComplete = (double)this.countItemsProcessed.get() / (double)this.itemsInScopeCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.countItemsProcessed != null && this.countItemsProcessed.get() > 0L) {
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("NativeOcrItemsOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
        }
        if (this.countPagesProcessed != null && this.countPagesProcessed.get() > 0L) {
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("NativeOcrImagesOperation.Progress.PagesProcessed", this.countPagesProcessed.get());
        }
        return result;
    }

    private void trackStats(String stage, String path, String fileExtension, boolean failed) {
        String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
        this.trackItemProcessedFailed(mimeType, stage, failed);
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        long volume = 0L;
        for (MimeTypeVolume mimeTypeVolume : this.getMimeTypeVolumes()) {
            volume += mimeTypeVolume.getAuditedSize();
        }
        return volume;
    }
}

