/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.ocr.Quality;
import com.nuix.automate.workflow.core.execution.options.ocr.Rotation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nuix.ThirdPartyDependency;
import nuix.ThirdPartyDependencyStatus;

@FormFieldRows(value={@FormFieldRow(name="ocrProfileRow", children={"useOcrProfile", "ocrProfileName"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"}), @FormFieldRow(name="splitWorkRow", children={"splitWork", "splitWorkAt"})})
@OperationMetadata(alias=OperationAlias.OCR, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"OCR"})})
@OperationParameter(label="queryRetrieveFailedItems", parameter="tag:\"{last_failed_items_tag_name}\"")
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class OcrOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation
implements RemoteWorkerBasedOperation {
    @FormField(required=false)
    public String scope = "mime-type:application/pdf AND NOT content:*";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean useOcrProfile = true;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.OCR_PROFILES, enableOn={@OnField(name="useOcrProfile")})
    @ExcludeFromPrintableOptions
    public String ocrProfileName = "Default";
    @FormField(enableOn={@OnField(name="useOcrProfile")})
    public Boolean differentiateProfile;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON, allowedValues={"false", "true"}, enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean replaceText = true;
    @FormField(componentType=FieldComponentType.CHECKED_DROPDOWN, allowedValuesDynamicType=DynamicValuesType.OCR_LANGUAGES, enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public List<String> languages = new ArrayList<String>();
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean deskew;
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public Rotation rotation;
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public Quality quality;
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean updateDuplicateItems;
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean clearCacheOnCompletion;
    @FormField(required=false, enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public String customCacheDirectory;
    @FormField(min=1.0, enableOn={@OnField(name="useOcrProfile", value={"false"})}, positionLabel=@PositionLabel(right="minutes"))
    @ExcludeFromPrintableOptions
    public int timeoutMinutes;
    @FormField(enableOn={@OnField(name="useOcrProfile", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean updatePdf;
    @FormField
    @ExcludeFromPrintableOptions
    public Boolean tagFailedItems;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public Boolean untagSuccessfulItems;
    @FormField
    public Boolean splitWork;
    @FormField(enableOn={@OnField(name="splitWork")}, positionLabel=@PositionLabel(right="items"))
    @ExcludeFromPrintableOptions
    public int splitWorkAt;
    public static final String[] OCR_LANGUAGES = new String[]{"Abkhaz", "Adyghe", "Afrikaans", "Agul", "Albanian", "Altaic", "Arabic", "ArmenianEastern", "ArmenianGrabar", "ArmenianWestern", "Awar", "Aymara", "AzeriCyrillic", "AzeriLatin", "Bashkir", "Basque", "Belarusian", "Bemba", "Blackfoot", "Breton", "Bugotu", "Bulgarian", "Buryat", "Catalan", "Chamorro", "Chechen", "ChinesePRC", "ChineseTaiwan", "Chukcha", "Chuvash", "Corsican", "CrimeanTatar", "Croatian", "Crow", "Czech", "Danish", "Dargwa", "Dungan", "Dutch", "DutchBelgian", "English", "EskimoCyrillic", "EskimoLatin", "Esperanto", "Estonian", "Even", "Evenki", "Faeroese", "Fijian", "Finnish", "French", "Frisian", "Friulian", "GaelicScottish", "Gagauz", "Galician", "Ganda", "German", "GermanLuxembourg", "GermanNewSpelling", "Greek", "Guarani", "Hani", "Hausa", "Hawaiian", "Hebrew", "Hungarian", "Icelandic", "Ido", "Indonesian", "Ingush", "Interlingua", "Irish", "Italian", "Japanese", "Kabardian", "Kalmyk", "KarachayBalkar", "Karakalpak", "Kasub", "Kawa", "Kazakh", "Khakas", "Khanty", "Kikuyu", "Kirgiz", "Kongo", "Korean", "Koryak", "Kpelle", "Kumyk", "Kurdish", "Lak", "Lappish", "Latin", "Latvian", "LatvianGothic", "Lezgin", "Lithuanian", "Luba", "Macedonian", "Malagasy", "Malay", "Malinke", "Maltese", "Mansi", "Maori", "Mari", "Maya", "Miao", "Minankabaw", "Mohawk", "Mongol", "Mordvin", "Nahuatl", "Nenets", "Nivkh", "Nogay", "Norwegian", "NorwegianBokmal", "NorwegianNynorsk", "Nyanja", "Occidental", "Ojibway", "Ossetic", "Papiamento", "PidginEnglish", "Polish", "PortugueseBrazilian", "PortugueseStandard", "Provencal", "Quechua", "RhaetoRomanic", "Romanian", "RomanianMoldavia", "Romany", "Ruanda", "Rundi", "Russian", "RussianOldSpelling", "RussianWithAccent", "Samoan", "Selkup", "SerbianCyrillic", "SerbianLatin", "Shona", "Sioux", "Slovak", "Slovenian", "Somali", "Sorbian", "Sotho", "Spanish", "Sunda", "Swahili", "Swazi", "Swedish", "Tabassaran", "Tagalog", "Tahitian", "Tajik", "Tatar", "Thai", "Tinpo", "Tongan", "Tswana", "Tun", "Turkish", "Turkmen", "TurkmenLatin", "Tuvin", "Udmurt", "UighurCyrillic", "UighurLatin", "Ukrainian", "UzbekCyrillic", "UzbekLatin", "Vietnamese", "Visayan", "Welsh", "Wolof", "Xhosa", "Yakut", "Yiddish", "Zapotec", "Zulu"};

    public boolean getDisplayOcrProfileName() {
        return this.useOcrProfile;
    }

    public boolean getDisplayReplaceText() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayLanguages() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayDeskew() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayRotation() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayQuality() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayUpdateDuplicateItems() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayClearCacheOnCompletion() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayCustomCacheDirectory() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayTimeoutMinutes() {
        return !this.useOcrProfile;
    }

    public boolean getDisplayUpdatePdf() {
        return !this.useOcrProfile;
    }

    public boolean getDisplaySplitWorkAt() {
        return this.splitWork;
    }

    public OcrOperation() {
        this.languages.add("English");
        this.languages.add("French");
        this.deskew = true;
        this.rotation = Rotation.AUTO;
        this.quality = Quality.HIGH_QUALITY;
        this.updateDuplicateItems = false;
        this.clearCacheOnCompletion = true;
        this.customCacheDirectory = "";
        this.timeoutMinutes = 90;
        this.updatePdf = false;
        this.tagFailedItems = true;
        this.failedItemTagName = "Automate|Failed Items|OCR";
        this.untagSuccessfulItems = true;
        this.splitWork = true;
        this.splitWorkAt = 100000;
        this.differentiateProfile = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("OcrOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.OCR;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        String nuixOcrErrorMessage;
        List<String> prerequisites = super.getPrerequisites(activity);
        if (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) {
            EnumSet<Quality> abbyProfileQualities = EnumSet.range(Quality.DOC_ARCHIVING_ACCURACY, Quality.FIELD_LEVEL_RECOGNITION);
            if (abbyProfileQualities.contains((Object)this.quality) && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0) {
                prerequisites.add(this.iu.getFormattedString("OcrOperation.Prerequisites.UpdateNuixVersionSevenFourOrNewer", (Object)this.quality.toString()));
            }
            if (this.executionContext.nuixVersion.compareTo(new Version("7.0.0")) < 0) {
                prerequisites.add(this.iu.getString("OcrOperation.Prerequisites.UpdateNuixVersionSevenOrNewer"));
            }
            if (this.useOcrProfile) {
                if (this.executionContext.nuixVersion.compareTo(new Version("7.8.7")) < 0) {
                    prerequisites.add(this.iu.getString("OcrOperation.Prerequisites.UpdateNuixVersionSevenEightSevenOrNewer"));
                }
            } else if (this.executionContext.nuixVersion.compareTo(new Version("8.0.0")) >= 0) {
                prerequisites.add(this.iu.getString("OcrOperation.Prerequisites.UpdateNuixVersionEightOrNewer"));
            }
        }
        if ((nuixOcrErrorMessage = this.getNuixOcrErrorMessage()) != null) {
            prerequisites.add(nuixOcrErrorMessage);
        }
        return prerequisites;
    }

    public String getNuixOcrErrorMessage() {
        List dependencies = this.executionContext.nuixUtilities.getThirdPartyDependencies();
        for (ThirdPartyDependency dependency : dependencies) {
            if (!dependency.getDescription().equalsIgnoreCase("Nuix OCR")) continue;
            ThirdPartyDependencyStatus result = dependency.performLazyCheck();
            if (result.isAttentionRequired()) {
                return dependency.getDescription() + ": " + result.getMessage();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return null;
    }

    @Override
    public String getProcessingJobGuid() {
        return null;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OCR;
    }

    @Override
    public Activity getActivity() {
        return Activity.OCR;
    }

    @Override
    public Integer getWorkerMemory() {
        return null;
    }

    @Override
    public Integer getAddedWorkerCount() {
        return null;
    }
}

