/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.LicenceException;
import nuix.OcrProcessor;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import nuix.profile.OcrProfile;

public class OcrOperationImplementation
extends OcrOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OcrOperation.class);
    private transient ExportProcessingJob exportProcessingJob;
    private transient long itemsInScopeCount;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient int workersPendingCount;
    private transient List<Item> itemsInScope;
    private transient boolean isPaused;
    private transient String tempTag;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient int workPart;
    private transient OcrProfile ocrProfile;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);

    public List<Item> getItemsInScope() {
        if (this.itemsInScope != null) {
            return this.itemsInScope;
        }
        return new ArrayList<Item>();
    }

    private void runItems(List<Item> partItemsInScope, int partId) throws Exception {
        OcrProcessor ocrProcessor = this.executionContext.nuixUtilities.createOcrProcessor();
        ocrProcessor.whenItemEventOccurs(this::itemProcessed);
        Hashtable<String, Object> ocrOptions = new Hashtable<String, Object>();
        ocrOptions.put("regeneratePdfs", "false");
        ocrOptions.put("updateText", "true");
        ocrOptions.put("textModification", this.replaceText ? "overwrite" : "append");
        ocrOptions.put("languages", this.languages);
        ocrOptions.put("deskew", this.deskew ? "true" : "false");
        ocrOptions.put("rotation", this.rotation.toNuixString());
        ocrOptions.put("quality", this.quality.toNuixString(this.executionContext.nuixVersion, this.updatePdf));
        ocrOptions.put("updateDuplicates", this.updateDuplicateItems ? "true" : "false");
        ocrOptions.put("clearOcrCache", this.clearCacheOnCompletion ? "true" : "false");
        if (this.customCacheDirectory.length() > 0) {
            ocrOptions.put("outputDirectory", this.customCacheDirectory);
        }
        ocrOptions.put("timeout", this.timeoutMinutes);
        ocrOptions.put("updatePdf", this.updatePdf ? "true" : "false");
        long partItemsInScopeCount = partItemsInScope.size();
        if (this.stopRequested) {
            this.trackStopped();
            return;
        }
        if (partItemsInScopeCount == 0L) {
            return;
        }
        if (!this.useOcrProfile) {
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.TextModifications", (Object)(this.replaceText ? "Overwrite" : "Append text")));
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.Languages", (Object)String.join((CharSequence)"; ", this.languages)));
            if (this.deskew) {
                this.addExecutionLog(this.iu.getString("OcrOperation.Log.ImagePreprocessingDeskew"));
            }
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.ImageRotation", (Object)this.rotation.toString()));
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.Optimisations", (Object)this.quality.toString()));
            if (this.updateDuplicateItems) {
                this.addExecutionLog(this.iu.getString("OcrOperation.Log.UpdateDuplicateItemsInCase"));
            }
            if (this.clearCacheOnCompletion) {
                this.addExecutionLog(this.iu.getString("OcrOperation.Log.ClearCacheOnCompletion"));
            }
            if (this.customCacheDirectory.length() > 0) {
                this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.CustomCacheDirectory", (Object)this.customCacheDirectory));
            }
            this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.Timeout", (Object)this.timeoutMinutes));
            if (this.updatePdf) {
                this.addExecutionLog(this.iu.getString("OcrOperation.Log.UpdateWithOCRedPrintedImage"));
            }
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", this).equalsIgnoreCase("true")) {
            ocrProcessor.setParallelProcessingSettings(configurationParser.getParallelProcessingSettings());
        }
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)ocrProcessor, this.workPart <= 1);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)ocrProcessor);
        if (this.useOcrProfile) {
            if (this.workPart <= 1) {
                try {
                    this.ocrProfileName = this.executionContext.evalParameters(this.ocrProfileName, this);
                }
                catch (ParameterException e) {
                    this.addWarning(e.getLocalizedMessage());
                }
                this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.OCRProfile", (Object)this.ocrProfileName));
            }
            this.ocrProfile = NuixUtils.getOcrProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.ocrProfileName);
            if (this.ocrProfile == null) {
                LOGGER.error("The OCR profile " + this.ocrProfileName + " does not exist on the system");
                throw new Exception(this.iu.getFormattedString("OcrOperation.Exception.CannotUseProfile", (Object)this.ocrProfileName));
            }
            if (this.ocrProfile.isUseOutputDirectory()) {
                if (this.differentiateProfile.booleanValue()) {
                    String suffix = "/" + this.executionContext.evalParameters("{date_time}", this);
                    try {
                        suffix = "/" + UidUtils.getShortId((String)this.executionContext.evalParametersIfSet("{job_id}", this));
                    }
                    catch (ParameterException parameterException) {
                        // empty catch block
                    }
                    this.ocrProfile = NuixUtils.differentiateOcrProfile(this.ocrProfile, suffix, this.executionContext.nuixUtilities);
                    this.addExecutionLog(this.iu.getFormattedString("OcrOperation.Log.DifferentiatedOutputDirectory", (Object)Paths.get(this.ocrProfile.getOutputDirectory(), new String[0]).normalize().toAbsolutePath().toString()));
                } else {
                    this.addWarning(this.iu.getFormattedString("OcrOperation.Warning.ProfileUsesCustomOutputDirectory", (Object)this.ocrProfile.getOutputDirectory()));
                }
            }
            this.exportProcessingJob = ocrProcessor.processAsync(partItemsInScope, this.ocrProfile);
        } else {
            this.exportProcessingJob = ocrProcessor.processAsync(partItemsInScope, ocrOptions);
        }
        String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
        LOGGER.info("Job Guid: " + processingJobGuid);
        NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
        NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
        if (this.executionState == ExecutionState.STOPPING) {
            this.trackStopped();
        }
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.tempTag = "Automate|System|Run|OCR|" + String.valueOf(UUID.randomUUID());
        this.addExecutionLog("Scope query: " + this.scope);
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_failed_items_tag_name}", this.failedItemTagName)));
        this.failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
        try {
            this.customCacheDirectory = this.executionContext.evalParameters(this.customCacheDirectory, this);
        }
        catch (ParameterException e) {
            this.addWarning(e.getLocalizedMessage());
        }
        OcrOperationImplementation currentOperation = this;
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                String itemsToSearchQuery = NuixUtils.addAndQuery(this.scope, "has-exclusion:0");
                LOGGER.info("Searching for items in scope: " + itemsToSearchQuery);
                this.itemsInScope = this.executionContext.nuixCase.search(itemsToSearchQuery);
                this.itemsInScopeCount = this.itemsInScope.size();
                LOGGER.info("Got " + this.itemsInScopeCount + " items");
                this.addExecutionLog(this.iu.getNumeralString("OcrOperation.Log.ScopeCount", this.itemsInScopeCount));
                if (this.itemsInScopeCount > 0L) {
                    LOGGER.info("Tagging " + this.itemsInScopeCount + " items with tag " + this.tempTag);
                    this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.itemsInScope);
                }
                if (this.splitWork.booleanValue() && this.itemsInScopeCount > (long)this.splitWorkAt) {
                    this.addExecutionLog(this.iu.getNumeralString("General.Log.SplitWorkAt", (long)this.splitWorkAt));
                    LOGGER.info("Performing work in parts");
                    int addedForWork = 0;
                    this.workPart = 0;
                    while (addedForWork < this.itemsInScope.size()) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        ArrayList<Item> partItems = new ArrayList<Item>();
                        this.partStartPercentage = (double)addedForWork / (double)this.itemsInScope.size();
                        LOGGER.info("Exported in parts: " + addedForWork + " of " + this.itemsInScope.size());
                        ++this.workPart;
                        int nextItemId = Math.min(addedForWork + this.splitWorkAt, this.itemsInScope.size());
                        partItems.addAll(this.itemsInScope.subList(addedForWork, nextItemId));
                        LOGGER.info("Preparing work on part from " + addedForWork + " to " + (nextItemId - 1));
                        addedForWork = nextItemId;
                        LOGGER.info("Added to part: " + addedForWork);
                        double trancheEndPercentage = (double)addedForWork / (double)this.itemsInScope.size();
                        this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                        LOGGER.info("Starting work on part " + this.workPart);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("General.Log.WorkPart", (long)partItems.size(), (Object)this.workPart));
                        this.runItems(partItems, this.workPart);
                    }
                    LOGGER.info("Exported in parts: " + addedForWork + " of " + this.itemsInScope.size());
                } else {
                    this.runItems(this.itemsInScope, 0);
                }
                this.handleFailedItems();
                if (this.ocrProfile != null && this.ocrProfile.isUseOutputDirectory() && this.differentiateProfile.booleanValue()) {
                    try {
                        Files.delete(Paths.get(this.ocrProfile.getOutputDirectory(), new String[0]));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot delete OCR folder", (Throwable)e);
                    }
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void resumeTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                this.exportProcessingJob.resume();
            }
            catch (Exception e) {
                LOGGER.error("Cannot resume job.", (Throwable)e);
            }
        }
    }

    @Override
    public void pauseTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                this.exportProcessingJob.pause();
            }
            catch (Exception e) {
                LOGGER.error("Cannot pause job.", (Throwable)e);
            }
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.exportProcessingJob != null) {
                        LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                        this.exportProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.exportProcessingJob.hasFinished() && this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        }
    }

    private void handleFailedItems() throws IOException {
        LOGGER.info("Handling failed items");
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("OcrOperation.Warning.FailedOCRing", (long)this.failedItems.size()));
        }
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.TaggedFailedItem", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (this.itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.UntaggedFailedItem", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        block23: {
            percentageComplete = 0.0;
            if (this.exportProcessingJob != null) {
                try {
                    String exportStage;
                    int stageCount = 7;
                    int currentStage = 0;
                    switch (exportStage = this.exportProcessingJob.getCurrentStage().toLowerCase()) {
                        case "native": {
                            currentStage = 1;
                            break;
                        }
                        case "stored_email_fixup": {
                            currentStage = 2;
                            break;
                        }
                        case "pdf": {
                            currentStage = 3;
                            break;
                        }
                        case "ocr": {
                            currentStage = 4;
                            break;
                        }
                        case "print_store": {
                            currentStage = 5;
                            break;
                        }
                        case "text_replacement": {
                            currentStage = 6;
                        }
                    }
                    long itemsProcessed = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                    long itemsCount = this.exportProcessingJob.getTotalItemCount();
                    double stagePercentageComplete = 0.0;
                    if (itemsCount > 0L) {
                        stagePercentageComplete = (double)itemsProcessed / (double)itemsCount;
                    }
                    percentageComplete = (stagePercentageComplete + (double)currentStage) / (double)stageCount;
                    if (this.executionState != ExecutionState.FINISHED) {
                        percentageComplete = Math.min(percentageComplete, 0.9999);
                    }
                    if (this.executionState != ExecutionState.NOT_STARTED) {
                        percentageComplete = Math.max(percentageComplete, 1.0E-4);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block23;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        if (this.partSizePercentage > 0.0) {
            percentageComplete = percentageComplete * this.partSizePercentage + this.partStartPercentage;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result;
        block6: {
            result = "";
            double percentageComplete = this.getNormalizedPercentageComplete();
            if (!Double.isNaN(percentageComplete)) {
                result = String.format("%.2f%%", percentageComplete * 100.0);
            }
            if (this.exportProcessingJob != null) {
                if (this.workPart > 0) {
                    result = (String)result + " / " + this.iu.getFormattedString("General.Progress.Part", (Object)this.workPart);
                }
                try {
                    String exportStage = FormattingUtils.stageToString((String)this.exportProcessingJob.getCurrentStage().toLowerCase());
                    if (((String)result).length() > 0) {
                        result = (String)result + " / ";
                    }
                    result = (String)result + exportStage;
                    result = (String)result + " / ";
                    result = (String)result + this.iu.getNumeralString("OcrOperation.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Cannot get job stage.", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        this.trackIncrementVolumeProcessed(itemEventInfo.getItem().getAuditedSize());
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (this.tagFailedItems.booleanValue() && itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

