/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.reflect.TypeToken;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExecutionParameter;
import com.nuix.automate.utils.general.ExecutionParameters;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.ReflectionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.TimerTask;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.OperationSetting;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.operations.OperationEvent;
import com.nuix.automate.workflow.core.execution.operations.OperationListener;
import com.nuix.automate.workflow.core.execution.operations.OperationProgress;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperationImplementation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import com.nuix.automate.workflow.core.utils.general.OperationRunnable;
import com.nuix.automate.workflow.core.utils.general.OperationWarning;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import org.apache.commons.lang3.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormat;

public abstract class Operation
implements TimerTask.Callback,
Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Operation.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private final transient int TIMER_PERIOD_MS = 100;
    private final transient int MAX_OPTIONS_LENGTH = 256;
    private final transient int DEFAULT_MAX_DISPLAY_PARAMETER_LENGTH = 1000;
    private transient int maxDisplayParameterLength;
    public static final long MIN_ADD_WORKER_DELAY = 5000L;
    public static final long MAX_ADD_WORKER_DELAY = 10000L;
    public transient long currentRemoteWorkerDelay = 5000L;
    @ExcludeFromPrintableOptions
    public String notes = "";
    @ExcludeFromPrintableOptions
    public boolean disabled;
    @ExcludeFromPrintableOptions
    public Boolean softFail;
    @ExcludeFromPrintableOptions
    public Boolean suppressWarnings;
    @ExcludeFromPrintableOptions
    public boolean skippable;
    public boolean enableFieldOverwrite;
    public double progressWeight = 1.0;
    public transient int workflowPosition;
    public transient int executionPosition;
    public transient ExecutionState executionState = ExecutionState.NOT_STARTED;
    public transient boolean modifiedSinceWorkflowSaved = false;
    public transient DateTime startDateTime = null;
    public transient DateTime finishedDateTime = null;
    protected transient String caseId = null;
    protected transient JFrame executionUiFrame;
    protected transient boolean stopRequested = false;
    protected transient boolean skipRequested = false;
    protected transient boolean requiresCase = true;
    protected transient Thread startTriggerThread;
    protected transient Throwable exception;
    transient ExecutionContext executionContext;
    private transient List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private transient boolean wasStartTriggered = false;
    private transient TimerTask timerTask;
    private transient Timer operationExecutionTimer;
    private transient List<String> warningMessages;
    private transient Set<String> uniqueWarningMessages;
    private transient Set<String> transientWarningMessages = new LinkedHashSet<String>();
    private transient String errorMessage;
    private transient double previousPercentageComplete = 0.0;
    private transient String originalState;
    private transient List<OperationProgress> historicalProgress = null;
    private transient int minEtaSeconds = 60;
    private transient int maxEtaSeconds = 43200;
    private transient long licenceInvalidStartTime;
    private transient long updateStateErrorCount = 0L;
    private transient long updateStateAllowedErrorCount = 120L;
    private transient CircularBufferLog runningLog = new CircularBufferLog();
    private transient OperationMimeTypeStats operationMimeTypeStats = new OperationMimeTypeStats();
    private transient ExecutionParameters executionParameters = new ExecutionParameters();
    protected static final String OPERATION_PAUSED_MESSAGE = "temporarily halted due to insufficient free disk space.";
    protected transient boolean modifiesNuixCase = true;
    private static final Set<String> fieldNameBlacklist = new HashSet<String>(Arrays.asList("enableFieldOverwrite", "notes"));

    protected void increaseCurrentWorkerDelay() {
        long previousRemoteWorkerDelay = this.currentRemoteWorkerDelay;
        this.currentRemoteWorkerDelay = Math.min(this.currentRemoteWorkerDelay * 2L, 10000L);
        if (previousRemoteWorkerDelay != this.currentRemoteWorkerDelay) {
            LOGGER.info("Increasing remote worker delay to " + this.currentRemoteWorkerDelay);
        }
    }

    protected void resetCurrentWorkerDelay() {
        LOGGER.info("Resetting remote worker delay");
        this.currentRemoteWorkerDelay = 5000L;
    }

    public String getOriginalState() {
        return this.originalState;
    }

    public void setOriginalState(String originalState) {
        this.originalState = originalState;
    }

    public boolean getRequiresCase() {
        return this.requiresCase;
    }

    public boolean getSkipRequested() {
        return this.skipRequested;
    }

    public void addOperationListener(OperationListener operationListener) {
        this.operationListeners.add(operationListener);
    }

    public void removeOperationListener(OperationListener operationListener) {
        this.operationListeners.remove(operationListener);
    }

    private void fireWorkflowExecutionLogging(String message, LogLevel logLevel) {
        OperationEvent operationEvent = new OperationEvent(this);
        for (OperationListener operationListener : this.operationListeners) {
            operationListener.operationExecutionLogging(operationEvent, message, logLevel);
        }
    }

    private void fireExecutionFinished() {
        OperationEvent operationEvent = new OperationEvent(this);
        for (OperationListener operationListener : this.operationListeners) {
            operationListener.executionFinished();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage, false);
    }

    public void setErrorMessage(String errorMessage, boolean softError) {
        this.errorMessage = errorMessage;
        if (softError) {
            if (!this.areWarningsSuppressed()) {
                this.executionState = ExecutionState.SOFT_ERROR;
            } else if (this.executionState == ExecutionState.ERROR || this.executionState == ExecutionState.SOFT_ERROR) {
                this.trackFinished();
            }
        } else {
            this.executionState = ExecutionState.ERROR;
            this.errorMessage = errorMessage;
        }
    }

    @JsonIgnore
    public void setExecutionUiFrame(JFrame executionUiFrame) {
        this.executionUiFrame = executionUiFrame;
    }

    public Throwable getException() {
        return this.exception;
    }

    private void checkExecutionMode() {
        Set<Feature> features = this.getRequiredFeatures();
        ExecutionMode executionMode = this.executionContext.workflowExecution.getWorkflow().getExecutionMode();
        ExecutionMode requiredExecutionMode = features.contains((Object)Feature.NUIX_WORKSTATION) ? ExecutionMode.WORKFLOW_NUIX : (features.contains((Object)Feature.NUIX) ? ExecutionMode.AUTOMATE_NUIX : ExecutionMode.AUTOMATE_NATIVE);
        if (executionMode == ExecutionMode.AUTOMATE_NATIVE && (features.contains((Object)Feature.NUIX_WORKSTATION) || features.contains((Object)Feature.NUIX))) {
            throw new IllegalStateException(this.iu.getFormattedString("WorkflowExecution.Error.InvalidExecutionMode", new Object[]{this.getOperationName(), requiredExecutionMode}));
        }
    }

    protected void startTriggered() throws Exception {
    }

    protected void resumeTriggered() {
    }

    protected void pauseTriggered() {
    }

    protected void stopTriggered() {
    }

    public void cleanUp() {
        LOGGER.info("Cleaning up");
    }

    public void skip() {
        if (!this.wasStartTriggered) {
            LOGGER.info("Request to skip operation [" + this.toString() + "] before starting");
        } else {
            LOGGER.info("Request to stop operation [" + this.toString() + "]");
            if (this.executionState == ExecutionState.RUNNING) {
                this.addExecutionLog(this.iu.getString("Operation.Log.Skip"));
                this.skipRequested = true;
                this.executionState = ExecutionState.STOPPING;
                this.stopTriggered();
            }
        }
    }

    public void abort() {
        int timeoutIncrement = 100;
        LOGGER.error("Aborting Thread");
        for (int timeout = 0; timeout < 5000 && this.startTriggerThread != null && this.startTriggerThread.isAlive(); timeout += timeoutIncrement) {
            this.startTriggerThread.interrupt();
            try {
                Thread.sleep(timeoutIncrement);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot sleep waiting for the start thread to interrupt", (Throwable)e);
            }
        }
    }

    public boolean getEncounteredWarnings() {
        if (this.warningMessages != null && this.warningMessages.size() > 0) {
            return true;
        }
        return this.transientWarningMessages != null && this.transientWarningMessages.size() > 0;
    }

    public boolean getEncounteredSoftError() {
        return this.executionState == ExecutionState.SOFT_ERROR && this.errorMessage != null && this.errorMessage.trim().length() > 0;
    }

    public boolean getEncounteredError() {
        return this.errorMessage != null && this.errorMessage.trim().length() > 0;
    }

    public void setInitialWarnings(Collection<String> initialMessages) {
        if (this.warningMessages == null) {
            this.warningMessages = new ArrayList<String>();
        }
        if (this.uniqueWarningMessages == null) {
            this.uniqueWarningMessages = new HashSet<String>();
        }
        this.warningMessages.addAll(initialMessages);
        this.uniqueWarningMessages.addAll(initialMessages);
    }

    public LinkedHashSet<String> getWarningMessages() {
        LinkedHashSet<String> allWarningMessages = new LinkedHashSet<String>();
        if (this.transientWarningMessages != null) {
            allWarningMessages.addAll(this.transientWarningMessages);
        }
        if (this.warningMessages != null) {
            allWarningMessages.addAll(this.warningMessages);
        }
        return allWarningMessages;
    }

    public void clearWarningMessages() {
        this.addExecutionLog(this.iu.getFormattedString("WorkflowExecution.ClearedWarningMessages", new Object[]{this.executionPosition, this.getOperationName()}));
        this.transientWarningMessages.clear();
        this.warningMessages.clear();
    }

    protected void trackFinished() {
        if (this.skipRequested || this.stopRequested) {
            this.trackStopped();
        } else {
            this.executionState = ExecutionState.FINISHED;
        }
        this.call();
        this.fireExecutionFinished();
    }

    public void trackStopped() {
        if (this.executionState != ExecutionState.STOPPED) {
            this.executionState = ExecutionState.STOPPED;
            this.addWarning(this.iu.getFormattedString("Operation.Warning.ExecutionStopped", (Object)FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))));
            this.setFinishedDateTime();
        }
        this.executionState = ExecutionState.STOPPED;
    }

    public boolean areWarningsSuppressed() {
        boolean suppressWarnings;
        block3: {
            suppressWarnings = Boolean.TRUE.equals(this.suppressWarnings);
            try {
                String suppressWarningsParameterName = FormattingUtils.normalizeParameterName((String)("{suppress_warnings_" + this.getOperationName() + "}"));
                String suppressWarningsParameterValue = this.executionContext.evalParameters(suppressWarningsParameterName, this);
                if (!suppressWarningsParameterValue.equals(suppressWarningsParameterName)) {
                    suppressWarnings = Boolean.parseBoolean(suppressWarningsParameterValue);
                }
            }
            catch (ParameterException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Error evaluating operation suppress warning parameter", (Throwable)e);
            }
        }
        return suppressWarnings;
    }

    public void addWarning(String message) {
        boolean repeatedWarning = false;
        if (this.uniqueWarningMessages == null) {
            this.uniqueWarningMessages = new HashSet<String>();
        }
        if (this.uniqueWarningMessages.contains(message)) {
            repeatedWarning = true;
        }
        try {
            throw new OperationWarning(message);
        }
        catch (OperationWarning e) {
            if (repeatedWarning) {
                LOGGER.warn("Repeated Operation " + this.getOperationName() + " warning", (Throwable)e);
            } else {
                LOGGER.warn("Operation " + this.getOperationName() + " warning", (Throwable)e);
            }
            if (!repeatedWarning) {
                if (this.areWarningsSuppressed()) {
                    this.addExecutionLog("Suppressed warning: " + message);
                } else {
                    if (this.warningMessages == null) {
                        this.warningMessages = new ArrayList<String>();
                    }
                    if (!this.warningMessages.contains(message)) {
                        this.warningMessages.add(message);
                    }
                    this.fireWorkflowExecutionLogging(message, LogLevel.WARNING);
                }
            }
            return;
        }
    }

    public void addTransientWarning(String message, boolean resolved) {
        try {
            throw new OperationWarning(message);
        }
        catch (OperationWarning e) {
            LOGGER.warn("Operation " + this.getOperationName() + " transient warning " + (resolved ? "resolved" : "triggered"), (Throwable)e);
            if (resolved) {
                if (this.transientWarningMessages.contains(message)) {
                    this.transientWarningMessages.remove(message);
                    this.fireWorkflowExecutionLogging(message, LogLevel.TRANSIENT_WARNING_RESOLVED);
                }
            } else if (this.areWarningsSuppressed()) {
                this.addExecutionLog("Suppressed warning: " + message);
            } else {
                if (this.transientWarningMessages == null) {
                    this.transientWarningMessages = new LinkedHashSet<String>();
                }
                if (!this.transientWarningMessages.contains(message)) {
                    this.transientWarningMessages.add(message);
                    this.fireWorkflowExecutionLogging(message, LogLevel.TRANSIENT_WARNING_TRIGGERED);
                }
            }
            return;
        }
    }

    public void addExecutionLog(String message) {
        this.fireWorkflowExecutionLogging(message, LogLevel.EXECUTION);
    }

    public long getItemsProcessed() {
        return 0L;
    }

    public double getNormalizedPercentageComplete() {
        double currentPercentageComplete;
        block6: {
            if (this.executionState == ExecutionState.FINISHED) {
                this.previousPercentageComplete = 1.0;
                return this.previousPercentageComplete;
            }
            currentPercentageComplete = 0.0;
            try {
                currentPercentageComplete = this.getPercentageComplete();
            }
            catch (Throwable e) {
                if (e.getClass().getName().equals("nuix.LicenceException")) {
                    return this.previousPercentageComplete;
                }
                if (this.executionState != ExecutionState.RUNNING) break block6;
                LOGGER.warn("Cannot get percentage complete", e);
            }
        }
        if (this.executionState != ExecutionState.PENDING && this.executionState != ExecutionState.NOT_STARTED) {
            currentPercentageComplete = Math.max(currentPercentageComplete, 1.0E-4);
        }
        currentPercentageComplete = Math.min(currentPercentageComplete, 0.9999);
        if ((currentPercentageComplete = Math.max(currentPercentageComplete, this.previousPercentageComplete)) > 0.0) {
            this.previousPercentageComplete = currentPercentageComplete;
        }
        return currentPercentageComplete;
    }

    public String getPrintablePercentageComplete() {
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (percentageComplete > 0.0) {
            return String.format("%.2f%%", percentageComplete * 100.0);
        }
        return "n/a";
    }

    public boolean finishedRunning() {
        return this.executionState == ExecutionState.ERROR || this.executionState == ExecutionState.SOFT_ERROR || this.executionState == ExecutionState.FINISHED || this.executionState == ExecutionState.STOPPED;
    }

    public void beforeStart(ExecutionContext executionContext, int workflowPosition, int executionPosition) {
        this.workflowPosition = workflowPosition;
        this.executionPosition = executionPosition;
        if (!this.disabled) {
            this.startDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        }
    }

    public void start(ExecutionContext executionContext, int workflowPosition, int executionPosition) throws UserCancelledException {
        try {
            this.previousPercentageComplete = 0.0;
            if (this.operationMimeTypeStats == null) {
                this.operationMimeTypeStats = new OperationMimeTypeStats();
                this.operationMimeTypeStats.setOperationIndex(this.workflowPosition);
            }
            if (executionContext != null) {
                executionContext.workflowExecution.checkMemoryUsage("Starting operation");
                this.executionContext = executionContext;
            }
            if (!this.disabled) {
                if (this.requiresCase && this.executionContext.nuixCase == null) {
                    LOGGER.info("Operation was started with an empty case");
                    UseCaseOperationImplementation useCaseOperation = new UseCaseOperationImplementation();
                    for (OperationListener operationListener : this.operationListeners) {
                        useCaseOperation.addOperationListener(operationListener);
                    }
                    useCaseOperation.setExecutionContext(executionContext);
                    useCaseOperation.executionContext.workflowExecution.fireOnUseCasePrompt(useCaseOperation);
                    useCaseOperation.trackFirstCase();
                }
                if (this.executionState == ExecutionState.NOT_STARTED) {
                    LOGGER.info("Request to start operation [" + this.toString() + "]");
                    this.wasStartTriggered = true;
                    this.executionState = ExecutionState.RUNNING;
                    this.timerTask = new TimerTask((TimerTask.Callback)this);
                    this.operationExecutionTimer = new Timer();
                    this.operationExecutionTimer.scheduleAtFixedRate((java.util.TimerTask)this.timerTask, 100L, 100L);
                    this.checkExecutionMode();
                    this.trackVolumeStart();
                    executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_operation_position}", executionContext.evalParameters("{operation_position}", this))));
                    executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_operation_name}", this.getOperationName())));
                    this.startTriggered();
                } else if (this.executionState == ExecutionState.STOPPING) {
                    LOGGER.info("Request to stop operation before starting [" + this.toString() + "]");
                    this.executionState = ExecutionState.STOPPED;
                }
            } else {
                LOGGER.info("Skipping disabled operation [" + this.toString() + "]");
                this.timerTask = new TimerTask((TimerTask.Callback)this);
                this.operationExecutionTimer = new Timer();
                this.operationExecutionTimer.scheduleAtFixedRate((java.util.TimerTask)this.timerTask, 100L, 100L);
                this.trackFinished();
            }
        }
        catch (UserCancelledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.exception = e;
            this.executionState = ExecutionState.ERROR;
        }
    }

    public void resume() throws Exception {
        LOGGER.info("Request to resume operation [" + this.toString() + "]");
        if (!this.wasStartTriggered) {
            this.executionState = ExecutionState.NOT_STARTED;
            this.start(null, this.workflowPosition, this.executionPosition);
        } else {
            this.executionState = ExecutionState.RUNNING;
            this.resumeTriggered();
        }
    }

    public void pause() {
        LOGGER.info("Request to pause operation [" + this.toString() + "]");
        if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.NOT_STARTED) {
            this.executionState = ExecutionState.PAUSING;
        }
    }

    public void stop() {
        if (!this.wasStartTriggered) {
            LOGGER.info("Request to stop operation [" + this.toString() + "] before starting");
            this.trackStopped();
        } else {
            LOGGER.info("Request to stop operation [" + this.toString() + "]");
            if (this.executionState == ExecutionState.FINISHED) {
                this.trackStopped();
            } else {
                if (this.executionState == ExecutionState.STOPPING && this.skipRequested) {
                    this.skipRequested = false;
                }
                if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.PAUSING || this.executionState == ExecutionState.PAUSED || this.executionState == ExecutionState.NOT_STARTED) {
                    this.executionState = ExecutionState.STOPPING;
                    this.stopRequested = true;
                    this.stopTriggered();
                }
            }
        }
    }

    public void call() {
        block15: {
            Thread.currentThread().setName("Automate - Operation #" + this.workflowPosition + " " + this.getOperationName() + " - Timer");
            switch (this.executionState) {
                case ERROR: {
                    this.operationExecutionTimer.cancel();
                    this.timerTask.cancel();
                    break;
                }
                case FINISHED: {
                    this.operationExecutionTimer.cancel();
                    this.timerTask.cancel();
                    break;
                }
                case STOPPED: {
                    this.operationExecutionTimer.cancel();
                    this.timerTask.cancel();
                    break;
                }
            }
            try {
                this.updateState();
                boolean thrownBefore = this.transientWarningMessages.contains(this.iu.getString("General.NuixLicenceBecameInvalid"));
                if (thrownBefore) {
                    this.addTransientWarning(this.iu.getString("General.NuixLicenceBecameInvalid"), true);
                }
                this.updateStateErrorCount = 0L;
            }
            catch (IllegalStateException e) {
                if (this.executionContext.jobBrokerIp != null) {
                    this.abort();
                    LOGGER.error("Error while cleaning up", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("nuix.LicenceException")) {
                    boolean thrownBefore = this.transientWarningMessages.contains(this.iu.getString("General.NuixLicenceBecameInvalid"));
                    if (!thrownBefore) {
                        this.licenceInvalidStartTime = System.currentTimeMillis();
                        this.addTransientWarning(this.iu.getString("General.NuixLicenceBecameInvalid"), false);
                    } else {
                        long timeElapsed = (System.currentTimeMillis() - this.licenceInvalidStartTime) / 1000L;
                        if (timeElapsed > 3600L) {
                            LOGGER.info("Timeout of 3600 seconds has passed since Engine Licence became invalid. Throwing error.");
                            this.exception = e;
                            this.executionState = ExecutionState.ERROR;
                        }
                    }
                }
                throw e;
            }
            catch (Throwable e) {
                ++this.updateStateErrorCount;
                LOGGER.error("Error updating operation state", e);
                if (this.updateStateErrorCount <= this.updateStateAllowedErrorCount) break block15;
                LOGGER.error("Detected " + this.updateStateErrorCount + " operation state errors", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        }
    }

    public void updateState() {
    }

    public String getPrintableStatus() {
        if (this.executionState == null) {
            return "";
        }
        Object result = this.executionState.getLocalizedString();
        if (this.executionState != ExecutionState.NOT_STARTED && this.executionState != ExecutionState.FINISHED && this.executionState != ExecutionState.PAUSED && this.executionState != ExecutionState.ERROR && this.executionState != ExecutionState.SOFT_ERROR && this.executionState != ExecutionState.STOPPED) {
            result = (String)result + "... " + this.getPrintablePercentageComplete();
        }
        return result;
    }

    public void setFinishedDateTime() {
        this.finishedDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }

    public DateTime getEta() {
        if (this.finishedDateTime != null) {
            return this.finishedDateTime;
        }
        if (this.startDateTime != null) {
            double percentageComplete;
            if (this.historicalProgress == null) {
                this.historicalProgress = new ArrayList<OperationProgress>();
                this.historicalProgress.add(new OperationProgress(0.0, this.startDateTime));
            }
            if ((percentageComplete = this.getNormalizedPercentageComplete()) > 1.0E-4) {
                OperationProgress earliestProgress;
                int earliestProgressAgeInSeconds;
                long operationRunningSeconds = (DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.startDateTime.getMillis()) / 1000L;
                long linearEstimatedTotalSeconds = (long)((double)operationRunningSeconds / percentageComplete);
                long linearEstimatedRemainingSeconds = linearEstimatedTotalSeconds - operationRunningSeconds;
                long etaMovingAverageSeconds = linearEstimatedRemainingSeconds / 3L;
                etaMovingAverageSeconds = Math.min(etaMovingAverageSeconds, (long)this.maxEtaSeconds);
                etaMovingAverageSeconds = Math.max(etaMovingAverageSeconds, (long)this.minEtaSeconds);
                this.historicalProgress.add(new OperationProgress(percentageComplete, DateTime.now((DateTimeZone)DateTimeZone.UTC)));
                while (this.historicalProgress.size() > 2 && (long)(earliestProgressAgeInSeconds = Seconds.secondsBetween((ReadableInstant)(earliestProgress = this.historicalProgress.get(0)).getTimestamp(), (ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC)).getSeconds()) > etaMovingAverageSeconds) {
                    this.historicalProgress.remove(0);
                }
                earliestProgress = this.historicalProgress.get(0);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("At " + DateTimeFormat.forPattern((String)"HH:mm:ss").print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + " progress " + percentageComplete);
                }
                earliestProgressAgeInSeconds = Seconds.secondsBetween((ReadableInstant)earliestProgress.getTimestamp(), (ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC)).getSeconds();
                double deltaPercentage = percentageComplete - earliestProgress.getPercentage();
                if (deltaPercentage < 1.0E-4) {
                    return null;
                }
                double remainingPercentage = 1.0 - percentageComplete;
                int estimatedRemainingSeconds = (int)((double)earliestProgressAgeInSeconds / deltaPercentage * remainingPercentage);
                DateTime estimatedCompletionDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(estimatedRemainingSeconds);
                return estimatedCompletionDateTime;
            }
            return null;
        }
        return null;
    }

    protected double getPercentageComplete() {
        return 0.0;
    }

    @JsonIgnore
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @JsonIgnore
    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public String getOptionsText() {
        if (this.disabled) {
            return this.iu.getString("Options.Disabled");
        }
        StringBuilder optionsText = new StringBuilder();
        if (this.skippable) {
            optionsText.append(this.iu.getString("Options.Skippable")).append(this.iu.getString("General.MultiValueSeparator"));
        }
        if (Boolean.TRUE.equals(this.softFail)) {
            optionsText.append(this.iu.getString("Options.SoftFail")).append(this.iu.getString("General.MultiValueSeparator"));
        }
        if (Boolean.TRUE.equals(this.suppressWarnings)) {
            optionsText.append(this.iu.getString("Options.SuppressWarnings")).append(this.iu.getString("General.MultiValueSeparator"));
        }
        if (Boolean.TRUE.equals(this.enableFieldOverwrite)) {
            optionsText.append(this.iu.getString("Options.EnableFieldOverwrite")).append(this.iu.getString("General.MultiValueSeparator"));
        }
        optionsText.append(this.getOptionsPrintableText());
        return optionsText.toString();
    }

    public String getOptionsPrintableText() {
        ArrayList<String> options = new ArrayList<String>();
        for (Field field : this.getClass().getFields()) {
            try {
                Object fieldValue;
                String fieldName;
                String localizedFieldName;
                int fieldModifiers = field.getModifiers();
                if (field.getAnnotation(ExcludeFromPrintableOptions.class) != null || Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isPrivate(fieldModifiers) || Modifier.isProtected(fieldModifiers) || (localizedFieldName = this.iu.getString("Options." + (fieldName = field.getName()))).trim().length() == 0 || (fieldValue = field.get(this)) == null || fieldValue.equals(false) || fieldValue.toString().equals("")) continue;
                if (fieldValue instanceof Collection) {
                    int size = ((Collection)fieldValue).size();
                    if (size == 0) continue;
                    options.add(this.iu.getFormattedString("Options.ListSize", new Object[]{localizedFieldName, size}));
                    continue;
                }
                if (fieldValue.equals(true)) {
                    options.add(localizedFieldName);
                    continue;
                }
                String fieldValueString = fieldValue.toString();
                fieldValueString = fieldValueString.replaceAll("\\n+", ", ");
                fieldValueString = fieldValueString.replaceAll("\\s+", " ");
                fieldValueString = fieldValueString.trim();
                options.add(this.iu.getFormattedString("Options.NameValue", new Object[]{localizedFieldName, fieldValueString}));
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unexpected error", (Throwable)e);
            }
        }
        Collator collator = Collator.getInstance(this.iu.getLocale());
        collator.setStrength(0);
        Collections.sort(options, collator);
        String optionsString = String.join((CharSequence)this.iu.getString("General.MultiValueSeparator"), options);
        if (optionsString.length() > 256) {
            return optionsString.substring(0, 253) + "...";
        }
        return optionsString;
    }

    public String getOperationName() {
        throw new NotImplementedException("Generic Operation");
    }

    public OperationAlias getOperationAlias() {
        OperationMetadata operationMetadata = this.getClass().getAnnotation(OperationMetadata.class);
        if (operationMetadata != null) {
            return operationMetadata.alias();
        }
        operationMetadata = this.getClass().getSuperclass().getAnnotation(OperationMetadata.class);
        if (operationMetadata != null) {
            return operationMetadata.alias();
        }
        throw new NotImplementedException("OperationMetadata not implemented for operation " + this.getClass().getSimpleName());
    }

    public IconType getIconType() {
        String aliasName = this.getOperationAlias().name();
        IconType icon = (IconType)Icons.getInstance().getOperationIcons().get(aliasName);
        if (icon != null) {
            return icon;
        }
        return IconType.UNKNOWN;
    }

    public void normalize() {
        this.progressWeight = Math.max(Math.min(this.progressWeight, 9999.0), 0.01);
        this.progressWeight = (double)Math.round(this.progressWeight * 100.0) / 100.0;
    }

    public List<String> getPrerequisites(PrerequisitesActivity activity) {
        ArrayList<String> prerequisites = new ArrayList<String>();
        if (activity == PrerequisitesActivity.RUN_INTERACTIVE || activity == PrerequisitesActivity.RUN_UNATTENDED) {
            try {
                Class<?> superClass;
                this.assertModuleLicensed(ModuleType.WORKFLOW_ENGINE);
                Class<?> c = this.getClass();
                do {
                    OperationLicenseModule operationLicenseModule;
                    if ((operationLicenseModule = c.getAnnotation(OperationLicenseModule.class)) == null) continue;
                    this.assertModuleLicensed(operationLicenseModule.module());
                    break;
                } while ((c = (superClass = c.getSuperclass())) != null);
            }
            catch (LicenceValidationException e) {
                prerequisites.add(e.getMessage());
            }
        }
        return prerequisites;
    }

    public boolean getUsesWorkers() {
        return this instanceof RemoteWorkerBasedOperation;
    }

    @JsonIgnore
    public Consumption getOperationConsumption() {
        return null;
    }

    @JsonIgnore
    public com.nuix.automate.utils.utilization.Operation getOperationUtilization(String sessionId) {
        com.nuix.automate.utils.utilization.Operation operationUtilization = new com.nuix.automate.utils.utilization.Operation();
        operationUtilization.setOperationName(this.getOperationName());
        operationUtilization.setOperationId(sessionId + "-" + this.executionPosition);
        operationUtilization.setSessionId(sessionId);
        operationUtilization.setOperationWorkflowPosition(this.workflowPosition);
        operationUtilization.setOperationExecutionPosition(this.executionPosition);
        if (!this.executionState.equals((Object)ExecutionState.ERROR)) {
            operationUtilization.setMimeTypeVolumes(this.getMimeTypeVolumes());
            operationUtilization.setUtilizationRecords(this.getUtilizationRecords());
        }
        if (this.startDateTime != null) {
            operationUtilization.setOperationStartEpoch(this.startDateTime.getMillis());
        }
        if (this.finishedDateTime != null) {
            operationUtilization.setOperationEndEpoch(this.finishedDateTime.getMillis());
            operationUtilization.setOperationNextEventEpoch(this.finishedDateTime.getMillis() + 1L);
        }
        operationUtilization.setOperationType(this.getOperationType());
        operationUtilization.setOperationHasWarnings(this.getEncounteredWarnings());
        operationUtilization.setOperationHasError(this.executionState.equals((Object)ExecutionState.ERROR) || this.executionState.equals((Object)ExecutionState.STOPPED) || this.executionState == ExecutionState.SOFT_ERROR);
        operationUtilization.setOperationSettings(this.getOperationSettings(operationUtilization.getOperationId()));
        return operationUtilization;
    }

    private List<OperationSetting> getOperationSettings(String operationId) {
        ArrayList<OperationSetting> operationSettings = new ArrayList<OperationSetting>();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : this.getClass().getMethods()) {
            methods.put(method.getName(), method);
        }
        for (AccessibleObject accessibleObject : this.getClass().getFields()) {
            try {
                Object fieldValueRepresentation;
                Object fieldValue;
                Object fieldName;
                int fieldModifiers = ((Field)accessibleObject).getModifiers();
                if (Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isPrivate(fieldModifiers) || Modifier.isProtected(fieldModifiers) || ((String)(fieldName = ((Field)accessibleObject).getName())).equals("notes") || ((String)fieldName).equals("predefined")) continue;
                String getDisplayMethodName = "getDisplay" + ((String)fieldName).substring(0, 1).toUpperCase() + ((String)fieldName).substring(1);
                if (methods.containsKey(getDisplayMethodName)) {
                    Method getDisplayMethod = (Method)methods.get(getDisplayMethodName);
                    try {
                        Object result = getDisplayMethod.invoke((Object)this, new Object[0]);
                        if (result != null && result.equals(false)) {
                            continue;
                        }
                    }
                    catch (InvocationTargetException result) {
                        // empty catch block
                    }
                }
                if ((fieldValue = ((Field)accessibleObject).get(this)) == null) continue;
                if (fieldValue instanceof String) {
                    if (!(((String)fieldName).equals("sourceEncoding") || ((String)fieldName).equals("zipEncoding") || ((String)fieldName).equals("timeZoneId"))) {
                        fieldName = (String)fieldName + ".length";
                        int length = ((String)fieldValue).length();
                        if (length == 0) continue;
                        fieldValueRepresentation = "" + length;
                    } else {
                        fieldValueRepresentation = (String)fieldValue;
                    }
                } else if (fieldValue instanceof Object[]) {
                    fieldName = (String)fieldName + ".count";
                    int length = ((Object[])fieldValue).length;
                    if (length == 0) continue;
                    fieldValueRepresentation = "" + length;
                } else if (fieldValue instanceof Collection) {
                    fieldName = (String)fieldName + ".count";
                    int size = ((Collection)fieldValue).size();
                    if (size == 0) continue;
                    fieldValueRepresentation = "" + size;
                } else if (fieldValue instanceof Boolean) {
                    if (!((Boolean)fieldValue).booleanValue()) continue;
                    fieldValueRepresentation = String.valueOf(fieldValue);
                } else if (fieldValue instanceof DateTime) {
                    fieldValueRepresentation = FormattingUtils.dateTimeToGMTString((DateTime)((DateTime)fieldValue));
                } else if (fieldValue instanceof Enum) {
                    fieldValueRepresentation = fieldValue.toString();
                } else if (!(fieldValue instanceof Number) && !(fieldValue instanceof Integer) && !(fieldValue instanceof Long) && !(fieldValue instanceof Double) || ((String)(fieldValueRepresentation = fieldValue.toString())).equals("0") || ((String)fieldValueRepresentation).equals("0.0")) continue;
                if (((String)fieldValueRepresentation).equals("")) continue;
                OperationSetting operationSetting = new OperationSetting();
                operationSetting.setSettingName((String)fieldName);
                operationSetting.setSettingValue((String)fieldValueRepresentation);
                operationSetting.setOperationId(operationId);
                operationSettings.add(operationSetting);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unexpected error", (Throwable)e);
            }
        }
        return operationSettings;
    }

    @JsonIgnore
    public List<MimeTypeVolume> getMimeTypeVolumes() {
        return null;
    }

    @JsonIgnore
    public UtilizationRecords getUtilizationRecords() {
        return null;
    }

    public void setRunningLogMaxSize(int maxSize) {
        if (this.runningLog == null) {
            this.runningLog = new CircularBufferLog(maxSize);
        } else {
            this.runningLog.setMaxLines(maxSize);
        }
    }

    public void addOperationRunningLog(String log) {
        if (this.runningLog == null) {
            this.runningLog = new CircularBufferLog();
        }
        this.runningLog.addLog(log);
    }

    public void trackItemProcessedRegular(String mimeType, String stageName) {
        this.operationMimeTypeStats.trackItemProcessedRegular(mimeType, stageName);
    }

    public void trackItemProcessedStage(String stageName) {
        this.operationMimeTypeStats.trackItemProcessedStage(stageName);
    }

    public void trackItemProcessed(String mimeType, boolean failed) {
        this.operationMimeTypeStats.trackItemProcessed(mimeType, failed);
    }

    public void trackItemProcessedFailed(String mimeType, String stageName, boolean failed) {
        this.operationMimeTypeStats.trackItemProcessedFailed(mimeType, stageName, failed);
    }

    public void trackItemProcessedIrregular(String mimeType, boolean corrupted, boolean encrypted, boolean deleted) {
        this.operationMimeTypeStats.trackItemProcessedIrregular(mimeType, corrupted, encrypted, deleted);
    }

    public void trackVolumeStart() {
        if (this.operationMimeTypeStats.getVolumeStartEpoch() == 0L) {
            this.operationMimeTypeStats.setVolumeStartEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        }
    }

    public void trackIncrementVolumeProcessed(long volumeBytes) {
        this.operationMimeTypeStats.setVolumeLastEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        this.operationMimeTypeStats.incrementBytes(volumeBytes);
    }

    public void trackVolumeProcessed(long volumeBytes) {
        this.operationMimeTypeStats.setVolumeLastEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        this.operationMimeTypeStats.setVolumeBytes(volumeBytes);
    }

    public CircularBufferLog getRunningLog() {
        if (this.runningLog == null) {
            this.runningLog = new CircularBufferLog();
        }
        return this.runningLog;
    }

    public OperationMimeTypeStats getOperationStats() {
        return this.operationMimeTypeStats;
    }

    public Parameter trackParameter(Parameter parameter) {
        if (this.maxDisplayParameterLength == 0) {
            this.maxDisplayParameterLength = 1000;
            String maxDisplayParameterLengthProperty = System.getProperty("automate.maxDisplayParameterLength");
            if (maxDisplayParameterLengthProperty != null) {
                try {
                    this.maxDisplayParameterLength = Integer.parseInt(maxDisplayParameterLengthProperty);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.executionParameters.addParameter(new ExecutionParameter(parameter, this.maxDisplayParameterLength));
        return parameter;
    }

    public ExecutionParameters getExecutionParameters() {
        return this.executionParameters;
    }

    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        features.add(Feature.NUIX);
        return features;
    }

    public boolean getModifiesNuixCase() {
        return this.requiresCase && this.modifiesNuixCase;
    }

    public void assertModuleLicensed(ModuleType moduleType) throws LicenceValidationException {
        this.executionContext.assertModuleLicensed(moduleType);
    }

    protected List<String> getMissingRequiredOperations(Class<?> ... requiredOperations) {
        ArrayList requiredClasses = new ArrayList(Arrays.asList(requiredOperations));
        for (Operation operation : this.executionContext.workflowExecution.getWorkflow().getOperations()) {
            requiredClasses.removeIf(clazz -> clazz.isAssignableFrom(operation.getClass()) && !operation.disabled);
            if (operation != this && !requiredClasses.isEmpty()) continue;
            break;
        }
        return requiredClasses.stream().map(clazz -> this.iu.getString(this.getOperationSimpleName() + ".Prerequisites.Missing" + clazz.getSimpleName())).collect(Collectors.toList());
    }

    protected void logDownloadSpeed(long startMillis, long totalSizeWritten) {
        long duration = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - startMillis;
        long durationSeconds = duration / 1000L;
        if (durationSeconds == 0L) {
            durationSeconds = 1L;
        }
        long uploadSpeed = totalSizeWritten / durationSeconds / 1000L;
        LOGGER.info("Downloaded " + totalSizeWritten + " bytes during " + durationSeconds + " s at " + Math.floor(uploadSpeed) + " KB/s");
        this.addExecutionLog(this.iu.getFormattedString("PurviewDownloadExportOperation.Log.DownloadSpeed", (Object)(FormattingUtils.sizeToDisplaySize((long)(totalSizeWritten / durationSeconds)) + "/s")));
    }

    public void overwriteOperationFields(Parameters sessionConfigParameters) {
        if (!this.enableFieldOverwrite) {
            return;
        }
        try {
            Field field = this.getClass().getField("disabled");
            this.updateFieldValue(field, sessionConfigParameters);
        }
        catch (NoSuchFieldException e) {
            LOGGER.info("Could not update operation field: disabled", (Throwable)e);
        }
        if (this.disabled) {
            return;
        }
        for (Field field : ReflectionUtils.getAllDeclaredFields(this.getClass(), (boolean)true)) {
            int modifiers;
            if (fieldNameBlacklist.contains(field.getName()) || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers)) continue;
            this.updateFieldValue(field, sessionConfigParameters);
        }
    }

    private void updateFieldValue(Field field, Parameters sessionParameters) {
        String fieldParameterName = this.getFieldParameterName(field.getName());
        Parameter fieldParameter = sessionParameters.get(fieldParameterName);
        if (fieldParameter == null) {
            return;
        }
        try {
            String disabledValue;
            String fieldDisabledParameterName = fieldParameterName.substring(0, fieldParameterName.length() - 1) + "_disabled}";
            Parameter fieldDisabledParameter = sessionParameters.get(fieldDisabledParameterName);
            if (fieldDisabledParameter != null && Boolean.parseBoolean(disabledValue = fieldDisabledParameter.getValue())) {
                LOGGER.info("Skipping overwrite disabled operation field: " + field.getName());
                return;
            }
            String value = fieldParameter.getValue();
            if (value == null || value.trim().isEmpty()) {
                return;
            }
            LOGGER.info("Overwriting operation field: " + field.getName() + " with field parameter: " + fieldParameterName);
            Class<?> fieldClazz = field.getType();
            field.setAccessible(true);
            if (String.class.isAssignableFrom(fieldClazz)) {
                field.set(this, value);
            } else if (Date.class.isAssignableFrom(fieldClazz)) {
                field.set(this, ObjectMapperProvider.instance.readValue(value, Date.class));
            } else {
                Object val;
                Class collectionType = ReflectionUtils.getArrayOrCollectionType(fieldClazz, (Field)field);
                if (collectionType != null) {
                    Type fieldType = TypeToken.getParameterized(fieldClazz, (Type[])new Type[]{collectionType}).getType();
                    val = SerializationUtils.fromJson((String)value, (Type)fieldType);
                } else {
                    val = SerializationUtils.fromJson((String)value, fieldClazz);
                }
                field.set(this, val);
            }
        }
        catch (Exception e) {
            LOGGER.info("Could not update operation field: " + field.getName(), (Throwable)e);
        }
    }

    private String getFieldParameterName(String fieldName) {
        return "{" + this.getOperationAlias().name().toLowerCase() + "_" + FormattingUtils.camelCaseToSnakeCase((String)fieldName) + "}";
    }

    private String getOperationSimpleName() {
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.endsWith("Implementation")) {
            simpleName = simpleName.substring(0, simpleName.lastIndexOf("Implementation"));
        }
        return simpleName;
    }

    protected void concatenateToCollectionJson(String parameterName, Collection<String> collection) {
        Collection parameterCollection = collection;
        try {
            String collectionJson = this.executionContext.evalParameters(parameterName, this);
            if (!collectionJson.equals(parameterName)) {
                parameterCollection = (Collection)SerializationUtils.fromJson((String)collectionJson);
                parameterCollection.addAll(collection);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not concatenate values to parameter " + parameterName, (Throwable)e);
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter(parameterName, SerializationUtils.toJson((Object)parameterCollection))));
    }

    public String getPrintableProcessingSpeed() {
        long durationMs;
        if (this.operationMimeTypeStats.getVolumeBytes() > 0L && (durationMs = this.operationMimeTypeStats.getVolumeLastEpoch() - this.operationMimeTypeStats.getVolumeStartEpoch()) > 0L) {
            long bytesPerHour = (long)((double)this.operationMimeTypeStats.getVolumeBytes() * 1000.0 * 3600.0 / (double)durationMs);
            return FormattingUtils.sizeToDisplaySize((long)bytesPerHour) + "/h";
        }
        return null;
    }

    public Long getAuditedSize() {
        if (this.operationMimeTypeStats.getVolumeBytes() > 0L) {
            return this.operationMimeTypeStats.getVolumeBytes();
        }
        return null;
    }

    protected void runStartTriggeredThread(OperationRunnable operationRunnable) {
        this.startTriggerThread = new Thread(() -> {
            try {
                operationRunnable.run();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public OperationType getOperationType() {
        return OperationType.OTHER_NON_WORKER;
    }

    public String toString() {
        return this.getOperationName();
    }

    public boolean getStopRequested() {
        return this.stopRequested;
    }

    public static enum PrerequisitesActivity {
        RUN_INTERACTIVE,
        RUN_UNATTENDED,
        SUBMIT_UNATTENDED;

    }

    protected class CheckUsableSpaceTask
    implements Runnable {
        private final Path location;
        private final AtomicLong sizeNeeded;
        private String warningMessage;

        public CheckUsableSpaceTask(Path location) {
            this(location, null);
        }

        public CheckUsableSpaceTask(Path location, Long sizeNeeded) {
            this.location = location;
            if (sizeNeeded == null) {
                String defaultUsableSpaceThreshold = System.getProperty("automate.defaultUsableSpaceThreshold");
                long defaultUsableSpace = 0x140000000L;
                try {
                    if (defaultUsableSpaceThreshold != null && !defaultUsableSpaceThreshold.trim().isEmpty()) {
                        defaultUsableSpace = Long.parseLong(defaultUsableSpaceThreshold);
                    }
                }
                catch (IllegalStateException e) {
                    LOGGER.error("Error parsing automate.defaultUsableSpaceThreshold value of " + defaultUsableSpaceThreshold + ", falling back to default value of " + defaultUsableSpace);
                }
                LOGGER.info("Using default usable space of " + defaultUsableSpace);
                this.sizeNeeded = new AtomicLong(defaultUsableSpace);
            } else {
                this.sizeNeeded = new AtomicLong(sizeNeeded);
            }
        }

        @Override
        public void run() {
            try {
                FileStore fileStore = Files.getFileStore(this.location);
                long usableSpace = fileStore.getUsableSpace();
                long sizeNeededLong = this.sizeNeeded.get();
                if (usableSpace <= sizeNeededLong) {
                    if (this.warningMessage == null) {
                        this.warningMessage = Operation.this.iu.getFormattedString("Operation.Warning.NotEnoughDiskSpace", new Object[]{FormattingUtils.sizeToDisplaySize((long)sizeNeededLong), FormattingUtils.sizeToDisplaySize((long)usableSpace)});
                        Operation.this.addTransientWarning(this.warningMessage, false);
                    }
                } else if (this.warningMessage != null) {
                    Operation.this.addTransientWarning(this.warningMessage, true);
                    this.warningMessage = null;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error computing disk usable space", (Throwable)e);
            }
        }

        public AtomicLong getSizeNeeded() {
            return this.sizeNeeded;
        }
    }
}

